// EditDoc.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "EditView.h"
#include <MAPI.h>	// MAPISendMail
#include "../../Manah/WaitCursor.h"
#include "../../Armaiti/ComBasic.h"
#include <algorithm>

using namespace Ascension;
using namespace Ascension::Private;
using namespace Ascension::Encodings;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Windows::IO;
using namespace Armaiti;
using namespace std;


namespace {
	class CUnconvertableCharCallback : virtual public IUnconvertableCharCallback {
	public:
		CUnconvertableCharCallback(IUnconvertableCharCallback* pImpl) : pCallback(pImpl), bCalledOnce(false) {
			assert(pImpl != 0);
		}
		bool OnFoundUnconvertableCharacter() {
			bCalledOnce = true;
			return pCallback->OnFoundUnconvertableCharacter();
		}
		bool IsCalledOnce() const {
			return bCalledOnce;
		}
	private:
		IUnconvertableCharCallback*	pCallback;
		bool						bCalledOnce;
	};
} // namespace `anonymous'


// CInsertOperation class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline CInsertOperation::CInsertOperation(
		const CCharPos& pos, const string_t& strText) : m_position(pos), m_strText(strText) {
}

/// }삪s\
inline bool CInsertOperation::CanExecute(CEditDoc& document) const {
	AssertValid();
	return !document.IsNarrowed()
		|| (m_position >= document.GetStartPoint() && m_position <= document.GetEndPoint());
}

/// }̍Đ
inline CCharPos CInsertOperation::Execute(CEditDoc& document) {
	AssertValid();
	return document.InsertText(m_position, m_strText);
}

/// 폜͏ɌłȂ
inline bool CInsertOperation::IsConcatenatable(CInsertOperation& postOperation, const CEditDoc& document) const {
	AssertValid();
	return false;
}

/// 폜͏ɌłȂ
inline bool CInsertOperation::IsConcatenatable(CDeleteOperation& postOperation, const CEditDoc& document) const {
	AssertValid();
	return false;
}


// CDeleteOperation class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline CDeleteOperation::CDeleteOperation(const CTextRange& range) : m_range(range) {
}

/// 폜삪s\
inline bool CDeleteOperation::CanExecute(CEditDoc& document) const {
	AssertValid();
	return !document.IsNarrowed()
		|| (m_range.GetTop() >= document.GetStartPoint() && m_range.GetBottom() <= document.GetEndPoint());
}

/// 폜̍Đ
inline CCharPos CDeleteOperation::Execute(CEditDoc& document) {
	AssertValid();
	return document.DeleteText(m_range);
}

/// ̑w肳ꂽPʂɌ
inline bool CDeleteOperation::IsConcatenatable(CInsertOperation& postOperation, const CEditDoc& document) const {
	AssertValid();
	return false;
}

/// ̑w肳ꂽPʂɌ
inline bool CDeleteOperation::IsConcatenatable(CDeleteOperation& postOperation, const CEditDoc& document) const {
	AssertValid();

	const CCharPos&	bottom = m_range.GetBottom();
	if(bottom.m_iChar == 0 || bottom != postOperation.m_range.GetTop())
		return false;
	else {
/*		const CEditView*	pView = reinterpret_cast<CEditView*>(*document.GetFirstViewPosition());
		const CLexer*		pView->GetLexer();
		const string_t&		strLine = document.GetLine(bottom.m_iLine);
		const CodePoint		cp = (bottom.m_iChar == 1
				|| !IsUTF16LowSurrogate(strLine[bottom.m_iChar])
				|| !IsUTF16LowSurrogate(strLine[bottom.m_iChar - 1])) ? strLine[bottom.m_iChar]
				: DecodeUTF16SurrogatePairToCodePoint(strLine.c_str() + bottom.m_iChar - 1, 2);
		const CodePoint		cp = DecodeUTF16SurrogatePairToCodePoint(
				strLine.c_str() + bottom.m_iChar, strLine.length() - bottom.m_iChar);
*/
		// Ō̑Pʂ̍Ō̑Ɍ (폜͈͂g)
		const_cast<CDeleteOperation*>(this)->m_range.GetBottom() = postOperation.m_range.GetBottom();
		return true;
	}
}


// COperationUnit class implementation
/////////////////////////////////////////////////////////////////////////////

/// fXgN^
inline COperationUnit::~COperationUnit() {
	while(!m_operations.empty()) {
		delete m_operations.top();
		m_operations.pop();
	}
}

/**
 *	@brief	Pʂ̎sB\bhďoケ̃IuWFNg͖ɂȂ
 *
 *	SsłƂÃ\bh true ԂAIuWFNg͖ɂȂB
 *	i[COȂǂŎsłȂ삪ƁȂ܂łsA
 *	̃IuWFNg͎słȂc̑ێB
 *	ł̑삪s\ɂȂōēx\bhĂяoƎc̑삪s
 *	@param document		ΏۃhLg
 *	@param posResult	[out] IɃLbguׂʒu
 *	@return				SĂ̑słƂ true
 */
inline bool COperationUnit::Execute(CEditDoc& document, CCharPos& posResult) {
	AssertValid();

	posResult.m_iLine = posResult.m_iChar = -1;
	while(!m_operations.empty()) {	// SĂ̑s
		if(!m_operations.top()->CanExecute(document))
			return false;
		posResult = m_operations.top()->Execute(document);
		delete m_operations.top();
		m_operations.pop();
	}
	return true;
}

/// 1̑|bv
inline IOperation& COperationUnit::Pop() {
	AssertValid();
	IOperation*	p = m_operations.top();
	m_operations.pop();
	return *p;
}

/// 1̑vbV
inline void COperationUnit::Push(CInsertOperation& operation, const CEditDoc& document) {
	AssertValid();
	m_operations.push(&operation);
}

///	1̑vbV (<var>operation</var> ͂̃\bhj󂷂\̂Ōďo̓ANZX֎~)
inline void COperationUnit::Push(CDeleteOperation& operation, const CEditDoc& document) {
	AssertValid();

	// Ȏ폜ł΁A͈͂g傷邱Ƃ1ɂ܂Ƃ߂悤Ƃ
	if(!m_operations.empty() && m_operations.top()->IsConcatenatable(operation, document)) {
		delete &operation;
		return;
	}
	m_operations.push(&operation);
}

/// 擪̑擾
inline IOperation& COperationUnit::Top() const {
	AssertValid();
	return *m_operations.top();
}


// _CUndoManager class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline CEditDoc::_CUndoManager::_CUndoManager(CEditDoc& document)
		: m_document(document), m_bVirtual(false), m_pVirtualUnit(0), m_pLastUnit(0), m_pSavedOperation(0) {
}

/// fXgN^
inline CEditDoc::_CUndoManager::~_CUndoManager() {
	Clear();
}

/// AhD/hDX^bNɂ
inline void CEditDoc::_CUndoManager::Clear() {
	m_pLastUnit = 0;
	m_pSavedOperation = 0;
	while(!m_undoStack.empty()) {
		delete m_undoStack.top();
		m_undoStack.pop();
	}
	while(!m_redoStack.empty()) {
		delete m_redoStack.top();
		m_redoStack.pop();
	}
}

/// hD\ȉ񐔂Ԃ
size_t CEditDoc::_CUndoManager::GetRedoBufferLength() const {
	return m_redoStack.size();
}

/// AhD\ȉ񐔂Ԃ
size_t CEditDoc::_CUndoManager::GetUndoBufferLength() const {
	return m_undoStack.size();
}

/// Oۑ瑀삪ǉA폜ꂽԂ
inline bool CEditDoc::_CUndoManager::IsModifiedSinceLastSave() const {
	if(m_undoStack.empty())
		return m_pSavedOperation != 0;
	return m_pSavedOperation != &m_undoStack.top()->Top();
}

/// ۑꂽƂʒm
inline void CEditDoc::_CUndoManager::OnSave() {
	m_pSavedOperation = !m_undoStack.empty() ? &m_undoStack.top()->Top() : 0;
}

/**
 *	1̑AhDX^bNɒǉ
 *	@param operation	ǉ鑀
 *	@param bConcatPrev	Ȏƌ邩ǂ
 */
template<class Operation>
inline void CEditDoc::_CUndoManager::PushUndoBuffer(Operation& operation, bool bConcatPrev) {
	// hDX^bNɂ
	if(!m_bVirtual) {
		while(!m_redoStack.empty()) {
			delete m_redoStack.top();
			m_redoStack.pop();
		}
	}

	if(m_bVirtual) {	// z쎞̓X^bNւ̒ǉx
		if(m_pVirtualUnit == 0)	// 
			m_pVirtualUnit = new COperationUnit();
		m_pVirtualUnit->Push(operation, m_document);
	} else if(bConcatPrev && m_pLastUnit != 0)	// Ō̑PʂɌ
		m_pLastUnit->Push(operation, m_document);
	else {
		COperationUnit*	pUnit = new COperationUnit();
		pUnit->Push(operation, m_document);
		m_undoStack.push(pUnit);
		m_pLastUnit = pUnit;
	}
}

/// hD1s
inline bool CEditDoc::_CUndoManager::Redo(CCharPos& posResult) {
	if(m_redoStack.empty())
		return false;

	COperationUnit*	pUnit = m_redoStack.top();
	m_bVirtual = true;				// zJn
	const bool	bSucceeded = pUnit->Execute(m_document, posResult);
	if(bSucceeded)
		m_redoStack.pop();
	if(m_pVirtualUnit != 0)
		m_undoStack.push(m_pVirtualUnit);	// zPʂAhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	if(bSucceeded)
		delete pUnit;
	return bSucceeded;
}

/// AhD1s
inline bool CEditDoc::_CUndoManager::Undo(CCharPos& posResult) {
	if(m_undoStack.empty())
		return false;

	COperationUnit*	pUnit = m_undoStack.top();
	m_bVirtual = true;				// zJn
	const bool	bSucceeded = pUnit->Execute(m_document, posResult);
	if(bSucceeded)
		m_undoStack.pop();
	if(m_pVirtualUnit != 0)
		m_redoStack.push(m_pVirtualUnit);	// zPʂhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	if(bSucceeded)
		delete pUnit;
	return bSucceeded;
}


// CEditDoc class implementation
/////////////////////////////////////////////////////////////////////////////

const char_t CEditDoc::m_wszBreakChars[6] = {		// U+0085 Ƀeg VC6 ŃG[ɂȂ
	0x000A, 0x000D, 0x0085, 0x2028, 0x2029, 0x0000	// (C99 ł 0x00A0 ȉ̕ \uxxxx `Ŏw肷邱Ƃ
};													// oȂ炵 C++ Ƃ̊֘A͕s)

CodePage	CEditDoc::m_defaultCodePage = ::GetACP();
LineBreak	CEditDoc::m_defaultLineBreak = LB_CRLF;
map<timerid_t, CEditDoc*> CEditDoc::m_documents;

/// RXgN^
CEditDoc::CEditDoc() : m_bIgnoreViews(false), m_bReadOnly(false),
		m_fileOpenMode(FOM_DENY_NONE), m_codePage(m_defaultCodePage), m_lineBreak(m_defaultLineBreak),
		m_groupingState(UGS_NONE), m_bOnceUndoBufferCleared(false), m_bRecordingOperations(true), m_bVirtualOperating(false),
		m_pAccessibleArea(0), m_itCache_(m_lines.end()), m_itCache(m_lines.end()) {
	m_lines.push_back(CLine());
	m_pUndoManager = new _CUndoManager(*this);
	m_nTimerId = ::SetTimer(0, 0, 1000, CEditDoc::_TimerProc);
	CEditDoc::m_documents[m_nTimerId] = this;
}

/// fXgN^
CEditDoc::~CEditDoc() {
	Close();
	delete m_pUndoManager;
	delete m_pAccessibleArea;
	::KillTimer(0, m_nTimerId);
	CEditDoc::m_documents.erase(m_nTimerId);
}

/// t@C̍ŏIXV`FbN
void CEditDoc::_CheckTimeStamp() {
	AssertValid();

	static bool	bChecking = false;

	if(GetPathName() == 0 || bChecking)
		return;
	bChecking = true;

	HANDLE				hFind;
	WIN32_FIND_DATAW	wfd;

	hFind = ::FindFirstFileW(GetPathName(), &wfd);
	if(hFind == INVALID_HANDLE_VALUE) {
		return;
		bChecking = false;
	}
	if(::CompareFileTime(&m_lastWriteTime, &wfd.ftLastWriteTime) == -1) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		for(set<IEditDocEventListener*>::iterator it
				= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
			(*it)->OnDocumentOverwrittenByOtherProcess(*this);
		// ʒmɃt@CXV邩Ȃ̂ŁA1xŐṼf[^
		::FindClose(hFind);
		hFind = ::FindFirstFileW(GetPathName(), &wfd);
		m_lastWriteTime = wfd.ftLastWriteTime;
	}
	::FindClose(hFind);
	bChecking = false;
}

/**
 *	hLg
 *	@param bReinitialize	̃hLgIuWFNgōėpꍇ true
 */
void CEditDoc::Close(bool bReinitialize /* = false */) {
	AssertValid();
	m_file.Close();
	for(set<CSynchronizablePoint*>::iterator it = m_points.begin(); it != m_points.end(); ++it)
		(*it)->OnDocumentDestroyed();
	m_points.clear();
	if(m_pAccessibleArea != 0) {
		delete m_pAccessibleArea->second;
		delete m_pAccessibleArea;
		m_pAccessibleArea = 0;
	}
	UpdateAllViews(TDocumentUpdate(TDocumentUpdate::CLOSED));
	if(bReinitialize)
		Initiate();
}

/**
 *	݊JĂt@CRs[
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
CEditDoc::FileOperationResult CEditDoc::Copy(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	if(GetPathName() == 0)
		return FOR_HAS_NO_INSTANCE;
	else if(toBoolean(::PathFileExistsW(pwszDestination)))
		return FOR_ALREADY_EXISTS;

	FileOperationResult	result = FOR_OK;
	FileOpenFlag		reopenMode = modeNoTruncate;

	switch(static_cast<int>(m_fileOpenMode)) {
		case FOM_DENY_WRITE:	reopenMode |= modeRead | shareDenyWrite;		break;
		case FOM_DENY_READ:		reopenMode |= modeReadWrite | shareDenyRead;	break;
		case FOM_DENY_NONE:
		case FOM_AS_READONLY:	reopenMode |= modeRead | shareDenyNone;			break;
	}

	m_file.Close();
	if(!toBoolean(::CopyFileW(GetPathName(), pwszDestination, true)))
		result = FOR_UNKNOWN_ERROR;

	// t@CJ
	if(m_bReadOnly) {
		if(m_file.Open(GetPathName(), modeRead | modeNoTruncate))
			m_fileOpenMode = FOM_AS_READONLY;
		else
			return FOR_CANNOT_REOPEN;
	} else if(!m_file.Open(GetPathName(), reopenMode)) {
		if(m_file.Open(GetPathName(), modeRead | modeNoTruncate)) {
			m_fileOpenMode = FOM_AS_READONLY;
			if(!m_bReadOnly) {
				result = FOR_REOPENED_AS_READONLY;
				m_bReadOnly = true;
			}
		} else
			return FOR_CANNOT_REOPEN;
	}
	return result;
}

/**
 *	̕ҏW_𕡐
 *	@param point	ҏW_
 *	@return			ҏW_BĂяo폜
 *	@see			CVisualPoint, CEditDoc::CreateEditPoint, CEditDoc::CopySynchronizablePoint
 */
CVisualPoint* CEditDoc::CopyEditPoint(const CVisualPoint& point) {
	CVisualPoint*	pCopiedPoint = new CVisualPoint(point);
	m_points.insert(pCopiedPoint);
	return pCopiedPoint;
}

/**
 *	̓_𕡐
 *	@param point	铯_
 *	@return			_BĂяo폜
 *	@see			CSynchronizablePoint, CEditDoc::CopyEditPoint, CEditDoc::CreateSynchronizablePoint
 */
CSynchronizablePoint* CEditDoc::CopySynchronizablePoint(const CSynchronizablePoint& point) {
	CSynchronizablePoint*	pCopiedPoint = new CSynchronizablePoint(point);
	m_points.insert(pCopiedPoint);
	return pCopiedPoint;
}

/**
 *	ҏW_쐬
 *	@param pEventListener	ҏW_̃CxgXi (null ł悢)
 *	@return					ҏW_BĂяo폜
 *	@see					CVisualPoint, CEditDoc::CopyEditPoint, CreateSynchronizablePoint
 */
CVisualPoint* CEditDoc::CreateEditPoint(CEditPoint::IEventListener* pEventListener /* = 0 */) {
	CVisualPoint*	pNewPoint = new CVisualPoint(*this, pEventListener);
	pNewPoint->m_releaser = &_ReleaseEditPoint;
	m_points.insert(pNewPoint);
	return pNewPoint;
}

/**
 *	_쐬
 *	@return	_BĂяo폜
 *	@see	CSynchronizablePoint, CEditDoc::CopySynchronizablePoint, CEditDoc::CreateEditPoint
 */
CSynchronizablePoint* CEditDoc::CreateSynchronizablePoint() {
	CSynchronizablePoint*	pNewPoint = new CSynchronizablePoint(*this);
	pNewPoint->m_releaser = &_ReleaseEditPoint;
	m_points.insert(pNewPoint);
	return pNewPoint;
}

/**
 *	݊JĂt@CݔɈړ
 *
 *	̃\bhsƃt@C͕
 *	@return	
 */
CEditDoc::FileOperationResult CEditDoc::Delete() {
	AssertValid();

	if(GetPathName() == 0)
		return FOR_HAS_NO_INSTANCE;
	else if(m_bReadOnly)
		return FOR_FILE_IS_READONLY;

	FileOperationResult	result = FOR_OK;
	FileOpenFlag		shareMode = 0;
	wchar_t				wszPath[MAX_PATH];
	SHFILEOPSTRUCTW		shfos = {::GetDesktopWindow(), FO_DELETE, wszPath, 0, FOF_ALLOWUNDO, 0, 0, 0};

	switch(static_cast<int>(m_fileOpenMode)) {
		case FOM_DENY_WRITE:	shareMode = shareDenyWrite;	break;
		case FOM_DENY_READ:		shareMode = shareDenyRead;	break;
		case FOM_DENY_NONE:
		case FOM_AS_READONLY:	shareMode = shareDenyNone;	break;
	}

	wcscpy(wszPath, GetPathName());
	*(wszPath + wcslen(wszPath) + 1) = 0;

	m_file.Close();
	::SHFileOperationW(&shfos);
	if(toBoolean(::PathFileExistsW(wszPath))) {	// s (SHFileExistsW ̖߂l͂ǂMpł)
		if(shfos.fAnyOperationsAborted)
			result = FOR_ABORTED;

		// t@CJ
		if(!m_file.Open(GetPathName(), shareMode | modeReadWrite | modeNoTruncate)) {
			if(m_file.Open(GetPathName(), modeRead | modeNoTruncate)) {
				m_fileOpenMode = FOM_AS_READONLY;
				if(!m_bReadOnly) {
					result = FOR_REOPENED_AS_READONLY;
					m_bReadOnly = true;
				}
			} else
				result = FOR_CANNOT_REOPEN;
		}
	}

	return result;
}

/**
 *	@brief	hLgeLXg̎w͈͂폜
 *
 *	̃\bhĂяoƍXVtOZbgB
 *	폜͈͂ANZXs\̈ƏdȂĂ΁Aʗ̈̃eLXg͍폜ȂB
 *	폜͈͂SɃANZXs\̈Ɋ܂܂Ăꍇ́A
 *	eLXg̍폜͈؍sꂸAXVtOωȂ
 *
 *	̃\bhĂяoƃr[ OnUpdate ĂяoÅTv TDocumentUpdate::DELETE_OPERATION ɂȂ
 *	@param range	폜͈
 *	@return			IɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::DeleteText(const CTextRange& range) throw(EDocumentIsReadOnly) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	else if(IsNarrowed()) {
		if(range.GetBottom() <= GetStartPoint())
			return range.GetBottom();
		else if(range.GetTop() >= GetEndPoint())
			return range.GetTop();
	}

	const CCharPos	posBegin = IsNarrowed() ? max(range.GetTop(), GetStartPoint()) : range.GetTop();
	const CCharPos	posEnd = IsNarrowed() ? min(range.GetBottom(), GetEndPoint()) : range.GetBottom();

	string_t	strDeleted;	// 폜 (sɂȂƂ݂͌̉s})

	if(posBegin.m_iLine == posEnd.m_iLine) {	// Ώۂ1sȓ
		const CLine&	line = GetLineInfo(posEnd.m_iLine);
		string_t&		strLine = const_cast<string_t&>(GetLine(posEnd.m_iLine));

		++const_cast<CLine&>(line).m_cOperationHistory;
		strDeleted = strLine.substr(posBegin.m_iChar, posEnd.m_iChar - posBegin.m_iChar);
		strLine.erase(posBegin.m_iChar, posEnd.m_iChar - posBegin.m_iChar);
	} else {							// Ώۂs
		string_t&	strLine = const_cast<string_t&>(GetLine(posBegin.m_iLine));
		string_t	strTail;
		strDeleted = strLine.substr(posBegin.m_iChar);
		strLine.erase(posBegin.m_iChar);

		// 폜镔ۑ폜
		_LineIterator	it = _GetLineIterator(posBegin.m_iLine), itNext;
		_LineIterator	itFirstLine = it;
		LineBreak		lastLineBreak;
		strDeleted += CEditDoc::GetLineBreakString(it->m_lineBreak);
		itNext = ++it;
		for(length_t iLine = posBegin.m_iLine + 1; iLine < posEnd.m_iLine + 1; ++iLine) {
			strDeleted +=
				((iLine != posEnd.m_iLine) ? it->m_strLine : it->m_strLine.substr(0, posEnd.m_iChar));
			if(iLine != posEnd.m_iLine)
				strDeleted += GetLineBreakString(it->m_lineBreak);
			++itNext;
			assert(itNext != 0);
			if(iLine == posEnd.m_iLine) {	// 폜Is
				strTail = it->m_strLine.substr(posEnd.m_iChar);
				lastLineBreak = it->m_lineBreak;
			}
			m_lines.erase(it);
			it = itNext;
		}

		// 폜̑Oq
		itFirstLine->m_lineBreak = lastLineBreak;
		++itFirstLine->m_cOperationHistory;
		if(!strTail.empty())
			strLine += strTail;
	}

	m_itCache_ = m_lines.end();	// ŃLbV𖳌ɂĂ
	m_itCache = m_lines.end();

	CInsertOperation*	pNewOperation = new CInsertOperation(posBegin, strDeleted);
	SetModified();
	if(m_bRecordingOperations) {
		m_pUndoManager->PushUndoBuffer(*pNewOperation, m_groupingState == UGS_WAIT_FOR_CONTINUE_EDIT);
		if(m_groupingState == UGS_WAIT_FOR_FIRST_EDIT)
			m_groupingState = UGS_WAIT_FOR_CONTINUE_EDIT;
	}

	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		TDocumentUpdate	update(TDocumentUpdate::DELETE_OPERATION);
		update.posBegin = posBegin;
		update.posEnd = posEnd;
		update.posResult = posBegin;
		UpdateAllViews(update);
		for(set<CSynchronizablePoint*>::iterator it = m_points.begin(); it != m_points.end(); ++it) {
			if((*it)->IsSynchronousWithDocumentUpdate())
				(*it)->OnUpdateDocument(update);
		}
	}
	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnDocumentModified();

	return posBegin;
}

/**
 *	Ss (hLgS) 擾
 *	@param os	o̓Xg[
 */
void CEditDoc::GetAllLines(basic_ostream<char_t>& os) const {
	AssertValid();
	for(LineIterator it = m_lines.begin(); it != m_lines.end(); ++it) {
		os << it->m_strLine;
		if(&*it != &m_lines.back())
			os << CEditDoc::GetLineBreakString(it->m_lineBreak);
	}
}

/// hLg̕ҏW̕Ԃ
length_t CEditDoc::GetDocumentLength() const {
	AssertValid();
	length_t	cch = 0;
	for(LineIterator it = m_lines.begin(); it != m_lines.end(); ++it) {
		cch += it->m_strLine.length();
		if(&*it != &m_lines.back())
			cch += CEditDoc::GetLineBreakString(it->m_lineBreak).length();
	}
	return cch;
}

/**
 *	ws牽ڂԂ
 *	@param iLine				ׂs
 *	@param bIncludeLineBreak	s𕶎ƂĐ邩ǂ
 *	@throw std::out_of_range	<var>iLine</var> ȂꍇX[
 */
length_t CEditDoc::GetLineIndex(length_t iLine, bool bIncludeLineBreak) const throw(out_of_range) {
	AssertValid();

	if(iLine >= m_lines.size())
		throw out_of_range("Specified line not found.");

	length_t		iOffset = 0;
	LineIterator	it = m_lines.begin();
	for(length_t i = 0; i < iLine; ++it, ++i) {
		iOffset += it->m_strLine.length();
		iOffset += bIncludeLineBreak ? CEditDoc::GetLineBreakString(it->m_lineBreak).length() : 0;
	}
	return iOffset;
}

/// ҏW\ȓpsCe[^̎擾
CEditDoc::_LineIterator CEditDoc::_GetLineIterator(length_t iLine) const throw(out_of_range) {
	AssertValid();

	LineList&		lines = const_cast<CEditDoc*>(this)->m_lines;
	length_t		i, cch = m_lines.size();
	_LineIterator	it;

	if(iLine >= cch)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache_ == lines.end()) {	// LbVgȂꍇ
		if(iLine <= cch / 2)
			for(i = 0, it = lines.begin(); i < iLine; ++i, ++it);
		else
			for(i = cch, it = lines.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache_, iLine))
			for(i = 0, it = lines.begin(); i < iLine; ++i, ++it);
		else if(cch - iLine < dif(m_iLineCache_, iLine))
			for(i = cch, it = lines.end(); i > iLine; --i, --it);
		else if(m_iLineCache_ < iLine)
			for(i = m_iLineCache_, it = m_itCache_; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache_, it = m_itCache_; i > iLine; --i, --it);
	}

	m_iLineCache_ = iLine;
	m_itCache_ = it;
	return it;
}

/// sCe[^̎擾
CEditDoc::LineIterator CEditDoc::GetLineIterator(length_t iLine) const throw(out_of_range) {
	AssertValid();

	length_t		i, cch = m_lines.size();
	LineIterator	it;

	if(iLine >= cch)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache == m_lines.end()) {	// LbVgȂꍇ
		if(iLine <= cch / 2)
			for(i = 0, it = m_lines.begin(); i < iLine; ++i, ++it);
		else
			for(i = cch, it = m_lines.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache, iLine))
			for(i = 0, it = m_lines.begin(); i < iLine; ++i, ++it);
		else if(cch - iLine < dif(m_iLineCache, iLine))
			for(i = cch, it = m_lines.end(); i > iLine; --i, --it);
		else if(m_iLineCache < iLine)
			for(i = m_iLineCache, it = m_itCache; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache, it = m_itCache; i > iLine; --i, --it);
	}

	m_iLineCache = iLine;
	m_itCache = it;
	return it;
}

/// hLg
void CEditDoc::Initiate() {
	AssertValid();

	m_lines.clear();
	m_lines.push_back(CLine());
	m_itCache_ = m_lines.end();
	m_itCache = m_lines.end();
	m_bReadOnly = false;
	m_codePage = CEditDoc::m_defaultCodePage;
	m_lineBreak = CEditDoc::m_defaultLineBreak;
	SetPathName(0);
	SetModified(false);
	ClearUndoBuffer();
	m_groupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;

	SetupAllViews();
	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
}

/**
 *	@brief	wʒuɕ}
 *
 *	ڍׂ2o[WQ
 *	@param pos			}ʒu
 *	@param first, last	}镶̊JnƏI
 *	@return				ɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::InsertText(const CCharPos& pos, const char_t* first, const char_t* last) throw(EDocumentIsReadOnly, invalid_argument) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	else if(first == 0 || last == 0 || first > last)
		throw invalid_argument("Argument begin or end is invalid.");
	else if(IsNarrowed() && (pos < GetStartPoint() || pos > GetEndPoint()))
		return pos;
	else if(first == last)
		return pos;

	CCharPos		posResult(pos.m_iLine, 0);
	const char_t*	pBreak = find_first_of(first, last, CEditDoc::m_wszBreakChars, _endof(CEditDoc::m_wszBreakChars));

	if(pBreak == last) {	// ͂ɉsꍇ
		CLine&	line = const_cast<CLine&>(GetLineInfo(pos.m_iLine));
		line.m_strLine.insert(pos.m_iChar, first, last - first);
		++line.m_cOperationHistory;
		posResult.m_iChar = pos.m_iChar + (last - first);
	} else {	// ͂s̏ꍇ
		_LineIterator	it = _GetLineIterator(pos.m_iLine);
		const char_t*	pLastBreak;
		const LineBreak	firstLineBreak = it->m_lineBreak;	// 擪s̉s (}AԌɕt)

		// Ō̉sʒuTAposResult ̕ʒu肷
		for(pLastBreak = last - 1; ; --pLastBreak) {
			if(binary_search(CEditDoc::m_wszBreakChars, _endof(CEditDoc::m_wszBreakChars), *pLastBreak))
				break;
		}
		posResult.m_iChar = (last - first) - (pLastBreak - first) - 1;
		if(*pLastBreak == L'\n' && pLastBreak != pBreak && *(pLastBreak - 1) == L'\r')
			--pLastBreak;

		// 擪s̒u
		const string_t	strFirstLineRest = it->m_strLine.substr(pos.m_iChar, it->m_strLine.length() - pos.m_iChar);
		it->m_strLine.replace(pos.m_iChar, strFirstLineRest.length(), first, pBreak - first);
		it->m_lineBreak = EatLineBreak(pBreak, last - pBreak);
		pBreak += (it->m_lineBreak != LB_CRLF) ? 1 : 2;
		++it->m_cOperationHistory;
		++it;
		++posResult.m_iLine;

		// sƂɍsɋ؂Ă
		while(true) {
			if(pBreak < pLastBreak) {
				const char_t* const	pNextBreak =
					find_first_of(pBreak, last, CEditDoc::m_wszBreakChars, _endof(CEditDoc::m_wszBreakChars));
				assert(pNextBreak != last);
				const LineBreak		lineBreak = EatLineBreak(pNextBreak, last - pNextBreak);

				it = m_lines.insert(it, CLine(string_t(pBreak, pNextBreak), lineBreak, true));
				++it;
				++posResult.m_iLine;
				pBreak = pNextBreak + ((lineBreak != LB_CRLF) ? 1 : 2);
			} else {	// ŏIs
				it = m_lines.insert(it, CLine(string_t(pBreak, last) + strFirstLineRest, firstLineBreak, true));
				break;
			}
		}

		m_itCache_ = m_lines.end();	// ŃLbV𖳌ɂĂ
		m_itCache = m_lines.end();
	}

	CDeleteOperation* const	pNewOperation = new CDeleteOperation(CTextRange(pos, posResult));
	SetModified();
	if(m_bRecordingOperations) {
		m_pUndoManager->PushUndoBuffer(*pNewOperation, m_groupingState == UGS_WAIT_FOR_CONTINUE_EDIT);
		if(m_groupingState == UGS_WAIT_FOR_FIRST_EDIT)
			m_groupingState = UGS_WAIT_FOR_CONTINUE_EDIT;
	}

	// CxgXi֒ʒm
	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		TDocumentUpdate	update(TDocumentUpdate::INSERT_OPERATION);
		update.posBegin = pos;
		update.posEnd = pos;
		update.posResult = posResult;
		UpdateAllViews(update);
		for(set<CSynchronizablePoint*>::iterator it = m_points.begin(); it != m_points.end(); ++it) {
			if((*it)->IsSynchronousWithDocumentUpdate())
				(*it)->OnUpdateDocument(update);
		}
	}

	return posResult;

}

/**
 *	@brief	wʒuɃeLXg}
 *
 *	̃\bhĂяoƍXVtOZbgB
 *	}ʒuANZXs\̈ł΁AeLXg̑}͍sꂸAXVtOωȂ
 *
 *	̃\bhĂяoƃr[ OnUpdate ĂяoÅTv TDocumentUpdate::INSERT_OPERATION ɂȂ
 *	@param pos	}ʒu
 *	@param text	}镶
 *	@return		ɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::InsertText(const CCharPos& pos, const string_t& text) throw(EDocumentIsReadOnly) {
	AssertValid();
	return InsertText(pos, text.data(), text.data() + text.length());
}

/**
 *	@brief	t@ChLgǂݍ
 *
 *	̃\bh̓V[gJbgȂ
 *
 *	@param strPathName	t@CpX
 *	@param fileOpenMode	r[hȂ
 *	@param codePage		R[hy[W (ȗƎ)
 *	@param pCallback	R[obNBnull ł悢
 *	@return				ہBCEditDoc::FileIoResult Q
 */
CEditDoc::FileIoResult CEditDoc::Load(const wstring& strPathName,
		FileOpenMode fileOpenMode, CodePage codePage, IFileIoCallback* pCallback) {
//	CTimer tm(L"LoadDocument");	// 2.86s / 1MB
	AssertValid();

	CEncoderFactory&	encoderFactory = CEncoderFactory::GetInstance();

	if(!encoderFactory.IsValidCodePage(codePage))
		return FIR_INVALID_CODEPAGE;

	CWaitCursor		wc;
	FileIoResult	result = FIR_OK;
	HGLOBAL			hNativeBuffer = 0, hUcsBuffer = 0;
	uchar*			pszNativeBuffer = 0;		// obt@
	char_t*			pwszUcsBuffer = 0;
	char_t*			pwszFirstBreak = 0;	// ŏɌꂽs
	DWORD			dwRead;				// ۂɓǂݎf[^
	CCharPos		posLast(0, 0);		// ɕǉʒu

	m_file.Close();
	m_bReadOnly = false;
	m_fileOpenMode = fileOpenMode;
	if(fileOpenMode == FOM_AS_READONLY || toBoolean(::GetFileAttributesW(strPathName.c_str()) & FILE_ATTRIBUTE_READONLY)) {
		if(!m_file.Open(strPathName.c_str(), modeRead | shareDenyNone))
			return FIR_READ_NOT_EXIST;
		m_bReadOnly = true;
		if(fileOpenMode != FOM_AS_READONLY)
			result = FIR_READ_READONLY;
	} else if(!m_file.Open(strPathName.c_str(), modeReadWrite | shareDenyNone)) {
		if(!m_file.Open(strPathName.c_str(), modeRead | shareDenyNone))
			return FIR_UNKNOWN_ERROR;
		result = FIR_READ_USED_BY_OTHER_PROCESS;
		m_bReadOnly = true;
	}

	DWORD	dwFileSizeLow, dwFileSizeHigh;

	m_file.GetFileTime(0, 0, &m_lastWriteTime);
	dwFileSizeLow = m_file.GetFileSize(&dwFileSizeHigh);
	if(dwFileSizeHigh != 0) {
		m_file.Close();
		return FIR_READ_HUGE_FILE;
	}
	hNativeBuffer = ::GlobalAlloc(GMEM_MOVEABLE, dwFileSizeLow);
	pszNativeBuffer = static_cast<uchar*>(::GlobalLock(hNativeBuffer));
	if(dwFileSizeLow) {
		if(!m_file.Read(pszNativeBuffer, dwFileSizeLow, &dwRead)) {
			::GlobalUnlock(hNativeBuffer);
			::GlobalFree(hNativeBuffer);
			m_file.Close();
			return FIR_UNKNOWN_ERROR;
		}
	} else
		dwRead = 0;
	m_file.Close();

	// R[hϊ
	if(dwRead != 0) {
		codePage = encoderFactory.DetectCodePage(pszNativeBuffer, min(dwRead, 4UL * 1024), codePage);

		CEncoder*	pEncoder = encoderFactory.CreateEncoder(codePage);

		assert(pEncoder != 0);

		size_t			cchDest = pEncoder->GetMaxUcsCharLength() * dwRead;
		const uchar*	pszBom;
		size_t			cbBom;

		switch(codePage) {
		case CP_UTF8:				pszBom = Encodings::UTF8_BOM; cbBom = 3; break;
		case CPEX_UNICODE_UTF16LE:	pszBom = Encodings::UTF16LE_BOM; cbBom = 2; break;
		case CPEX_UNICODE_UTF16BE:	pszBom = Encodings::UTF16BE_BOM; cbBom = 2; break;
		case CPEX_UNICODE_UTF32LE:	pszBom = Encodings::UTF32LE_BOM; cbBom = 4; break;
		case CPEX_UNICODE_UTF32BE:	pszBom = Encodings::UTF32BE_BOM; cbBom = 4; break;
		default:					pszBom = 0; cbBom = 0; break;
		}

		hUcsBuffer = ::GlobalAlloc(GMEM_MOVEABLE, (cchDest + 1) * sizeof(char_t));
		pwszUcsBuffer = static_cast<wchar_t*>(::GlobalLock(hUcsBuffer));
		if(cbBom != 0 && dwRead >= cbBom && memcmp(pszNativeBuffer, pszBom, cbBom) == 0)
			cchDest = pEncoder->ConvertToUnicode(pwszUcsBuffer, cchDest, pszNativeBuffer + cbBom, dwRead - cbBom, pCallback);
		else
			cchDest = pEncoder->ConvertToUnicode(pwszUcsBuffer, cchDest, pszNativeBuffer, dwRead, pCallback);
		delete pEncoder;

		if(cchDest == 0) {	// ϊłȂ߁ANCAg𒆎~邱ƂɌ߂
			::GlobalUnlock(hUcsBuffer);
			::GlobalFree(hUcsBuffer);
			::GlobalUnlock(hNativeBuffer);
			::GlobalFree(hNativeBuffer);
			return FIR_ABORTED_FOR_UNCONVERTABLE;
		}

		pwszUcsBuffer[cchDest] = 0;

		// sƂɋ؂AXgɒǉĂ
		length_t	iNext, iLast = 0;
		LineBreak	lineBreak;
		m_lines.clear();
		m_lineBreak = LB_AUTO;
		while(true) {
			for(size_t i = iLast; ; ++i) {	// sT
				if(i == cchDest) {
					iNext = -1;
					break;
				} else if(binary_search(CEditDoc::m_wszBreakChars,
						_endof(CEditDoc::m_wszBreakChars) - 1, pwszUcsBuffer[i])) {
					iNext = i;
					break;
				}
			}
			if(iNext != -1) {
				// s̔
				switch(pwszUcsBuffer[iNext]) {
				case L'\n':	lineBreak = LB_LF;	break;
				case L'\r':
					lineBreak = (iNext + 1 < cchDest && *(pwszUcsBuffer + iNext + 1) == L'\n') ? LB_CRLF : LB_CR;
					break;
				case 0x0085:	lineBreak = LB_NEL;	break;
				case L'\x2028':	lineBreak = LB_LS;	break;
				case L'\x2029':	lineBreak = LB_PS;	break;
				}
				m_lines.push_back(CLine(wstring(pwszUcsBuffer + iLast, iNext - iLast), lineBreak));
				iLast = iNext + ((lineBreak != LB_CRLF) ? 1 : 2);
				if(m_lineBreak == LB_AUTO)	// ŏɌꂽs̉sƂ
					m_lineBreak = lineBreak;
			} else {	// ŏIs
				m_lines.push_back(CLine(string_t(pwszUcsBuffer + iLast, cchDest - iLast)));
				break;
			}
		}
	} else {	// ̃t@C
		codePage = ::GetACP();
		m_lines.clear();
		m_lines.push_back(CLine());
		InsertText(CCharPos(0, 0), L"");
		m_lines.begin()->m_cOperationHistory = 0;
	}

	if(m_lineBreak == LB_AUTO)
		m_lineBreak = CEditDoc::m_defaultLineBreak;

	m_itCache_ = m_lines.end();
	m_itCache = m_lines.end();

	::GlobalUnlock(hUcsBuffer);
	::GlobalFree(hUcsBuffer);
	::GlobalUnlock(hNativeBuffer);
	::GlobalFree(hNativeBuffer);

	// t@C̃bN
	if(fileOpenMode == FOM_DENY_NONE || fileOpenMode == FOM_AS_READONLY) {
		if(!m_file.Open(strPathName.c_str(), modeRead | shareDenyNone))
			result = FIR_LOCK_DENIED;
	} else if(fileOpenMode == FOM_DENY_WRITE) {
		if(!m_file.Open(strPathName.c_str(), modeRead | shareDenyWrite))
			result = FIR_LOCK_DENIED;
	} else	/* if(fom == FOM_DENY_READ) */ {
		if(!m_file.Open(strPathName.c_str(), modeRead | modeWrite | shareDenyRead | shareDenyWrite))
			result = FIR_LOCK_DENIED;
	}

	m_codePage = codePage;
	ClearUndoBuffer();
	SetModified(false);
	m_groupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;
	SetPathName(strPathName.c_str());

	SetupAllViews();	// r[ɒʒm

	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentLoaded));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentLoaded();
	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();

	return result;
}

/**
 *	݂̊JĂt@Cw肵@ŃbNBǂݎp͖
 *	@param fom	r[hBFOM_DENYWRITE AFOM_DENYREAD ̂ݗL
 *	@return		bNɐ true
 *	@see		CEditDoc::UnlockCurrentFile
 */
bool CEditDoc::Lock(FileOpenMode fom) {
	AssertValid();

	if(fom != FOM_DENY_WRITE && fom != FOM_DENY_READ)
		return false;
	if(GetPathName() == 0 || m_bReadOnly)
		return false;

	m_file.Close();
	if(m_file.Open(GetPathName(),
			modeReadWrite | ((fom == FOM_DENY_WRITE) ? shareDenyWrite : shareDenyRead))) {
		m_fileOpenMode = fom;
		return true;
	} else
		return false;
}

/**
 *	݊JĂt@Cړ
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
CEditDoc::FileOperationResult CEditDoc::Move(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	if(GetPathName() == 0)
		return FOR_HAS_NO_INSTANCE;
	else if(toBoolean(::PathFileExistsW(pwszDestination)))
		return FOR_ALREADY_EXISTS;
	else if(m_bReadOnly)
		return FOR_FILE_IS_READONLY;

	FileOperationResult	result = FOR_OK;
	FileOpenFlag		reopenMode = modeNoTruncate;

	switch(static_cast<int>(m_fileOpenMode)) {
		case FOM_DENY_WRITE:	reopenMode |= modeRead | shareDenyWrite;		break;
		case FOM_DENY_READ:		reopenMode |= modeReadWrite | shareDenyRead;	break;
		case FOM_DENY_NONE:
		case FOM_AS_READONLY:	reopenMode |= modeRead | shareDenyNone;			break;
	}

	m_file.Close();
	if(!toBoolean(::MoveFileW(GetPathName(), pwszDestination)))
		result = FOR_UNKNOWN_ERROR;
	else
		SetPathName(pwszDestination);

	// bN悤Ƃ
	if(!m_file.Open(GetPathName(), reopenMode)) {
		if(m_file.Open(GetPathName(), modeRead | modeNoTruncate)) {
			m_fileOpenMode = FOM_AS_READONLY;
			if(!m_bReadOnly) {
				result = FOR_REOPENED_AS_READONLY;
				m_bReadOnly = true;
			}
		} else
			return FOR_CANNOT_REOPEN;
	}
	return result;
}

/**
 *	i[CO̎s
 *	@param range	ANZX\̈
 *	@see			CEditDoc::IsNarrowed, CEditDoc::Widen
 */
void CEditDoc::Narrow(const CTextRange& range) {
	AssertValid();
	if(m_pAccessibleArea == 0)
		m_pAccessibleArea = new pair<CCharPos, CSynchronizablePoint*>;
	m_pAccessibleArea->first = range.GetTop();
	m_pAccessibleArea->second = CreateSynchronizablePoint();
	m_pAccessibleArea->second->MoveTo(range.GetBottom());
	m_pAccessibleArea->second->SynchronizeWithDocumentUpdate(true);
	for(set<CSynchronizablePoint*>::iterator it = m_points.begin(); it != m_points.end(); ++it) {
		if((*it)->IsExcludedFromRestriction())
			(*it)->Normalize();
	}
	UpdateAllViews(TDocumentUpdate(TDocumentUpdate::CHANGED_NARROWING));
}

/**
 *	@brief	AhDAhD̂߂ɕҏWL^邩ǂݒ肷
 *
 *	ݒύXƋL^̓e͔j
 *	@param bRecord	L^ꍇ true
 *	@see			CEditDoc::IsRecordingOperations, CEditDoc::Undo, CEditDoc::Redo
 */
void CEditDoc::RecordOperations(bool bRecord) {
	AssertValid();
	if(!(m_bRecordingOperations = bRecord))
		ClearUndoBuffer();
}

/**
 *	hD̎s
 *	@return						SɃhDłȂꍇ false Ԃ
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 *	@see						CEditDoc::Undo
 */
bool CEditDoc::Redo() throw(EDocumentIsReadOnly) {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	else if(GetUndoHistoryLength(true) == 0)
		return false;

	BeginEditCollection();
	TDocumentUpdate	update(TDocumentUpdate::BEGIN_UNDO_OPERATION);
	UpdateAllViews(update);
	update.summary = TDocumentUpdate::END_UNDO_OPERATION;
	const bool	bSucceeded = m_pUndoManager->Redo(update.posResult);
	EndEditCollection();
	UpdateAllViews(update);

	if(!m_pUndoManager->IsModifiedSinceLastSave()) {
		SetModified(false);
		for_each(m_eventListeners.begin(),
			m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//		for(set<IEditDocEventListener*>::iterator it
//				= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//			(*it)->OnDocumentModified();
	}
	return bSucceeded;
}

void CEditDoc::_ReleaseEditPoint(CEditDoc& document, CSynchronizablePoint& point) {
	document.m_points.erase(&point);
}

/**
 *	hLg̕ۑ
 *	@param strPathName	t@C̃pX
 *	@param options		IvV
 *	@param lineBreak	ꂷsR[hBLB_AUTO w肷ƓꂵȂ
 *	@param codePage		R[hy[WBCPEX_AUTODETECT w肷ƌ݂̃R[hy[Wgp
 *	@param pCallback	R[obNBnull ł悢
 *	@return				݌ʁB FIR_OK
 */
CEditDoc::FileIoResult CEditDoc::Save(const wstring& strPathName,
		SaveDocumentOption options, LineBreak lineBreak, CodePage codePage, IFileIoCallback* pCallback) {
	AssertValid();

	CEncoderFactory&	encoderFactory = CEncoderFactory::GetInstance();

	if(!encoderFactory.IsValidCodePage(codePage)				// R[hy[WCXg[Ă邩
			|| encoderFactory.IsCodePageForReadOnly(codePage))	// ǂݎp̃R[hy[W
		return FIR_INVALID_CODEPAGE;
	if(encoderFactory.IsCodePageForAutoDetection(codePage))	// ݂̃R[hy[Wg
		codePage = m_codePage;

	// Unicode R[hy[WłgȂsR[h
	if((lineBreak == LB_NEL || lineBreak == LB_LS || lineBreak == LB_PS)
			&& codePage != CPEX_UNICODE_UTF5 && codePage != CP_UTF7 && codePage != CP_UTF8
			&& codePage != CPEX_UNICODE_UTF16LE && codePage != CPEX_UNICODE_UTF16BE
			&& codePage != CPEX_UNICODE_UTF32LE && codePage != CPEX_UNICODE_UTF32BE)
		return FIR_WRITE_INVALID_LINEBREAK;

	CWaitCursor		wc;
	FileIoResult	result = FIR_OK;

	// fobOo[W͏ɃobNAbv (㏑̏ꍇ̂)
#ifdef _DEBUG
	options |= SDO_CREATE_BACKUP;
#endif /* _DEBUG */
	if(toBoolean(options & SDO_CREATE_BACKUP) && toBoolean(::PathFileExistsW(strPathName.c_str()))) {
		wchar_t	wszBackupPath[MAX_PATH + 1];
		SHFILEOPSTRUCTW	shfos = {
			0, FO_DELETE, wszBackupPath, 0, FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT, false, 0
		};
		wcscpy(wszBackupPath, strPathName.c_str());
		wcscat(wszBackupPath, L".bak");
		wszBackupPath[wcslen(wszBackupPath) + 1] = 0;
		::CopyFileW(strPathName.c_str(), wszBackupPath, false);
		::SHFileOperationW(&shfos);	// ݔɎĂ
	}

	// 1sϊăobt@ɏ݁AňxɃt@Cɏ
	CEncoder*					pEncoder = encoderFactory.CreateEncoder(codePage);
	CUnconvertableCharCallback*	pInternalCallback = (pCallback != 0) ? new CUnconvertableCharCallback(pCallback) : 0;
	_LineIterator				it = m_lines.begin();
	const length_t				cLines = GetLineCount();	// s
	const size_t				cbNativeBuffer = (GetDocumentLength() + cLines) * pEncoder->GetMaxNativeCharLength() + 4;
	HGLOBAL						hNativeBuffer = ::GlobalAlloc(GHND, cbNativeBuffer);
	uchar*						pszNativeBuffer = static_cast<uchar*>(::GlobalLock(hNativeBuffer));
	size_t						cbOffset = 0;

	// BOM
	if(toBoolean(options & SDO_WRITE_BOM)) {
		size_t	cchSignature;
		switch(codePage) {
		case CP_UTF8:
			cchSignature = _countof(Encodings::UTF8_BOM) - 1;
			memcpy(pszNativeBuffer, Encodings::UTF8_BOM, cchSignature);
			break;
		case CPEX_UNICODE_UTF16LE:
			cchSignature = _countof(Encodings::UTF16LE_BOM) - 1;
			memcpy(pszNativeBuffer, Encodings::UTF16LE_BOM, cchSignature);
			break;
		case CPEX_UNICODE_UTF16BE:
			cchSignature = _countof(Encodings::UTF16BE_BOM) - 1;
			memcpy(pszNativeBuffer, Encodings::UTF16BE_BOM, cchSignature);
			break;
		case CPEX_UNICODE_UTF32LE:
			cchSignature = _countof(Encodings::UTF32LE_BOM) - 1;
			memcpy(pszNativeBuffer, Encodings::UTF32LE_BOM, cchSignature);
			break;
		case CPEX_UNICODE_UTF32BE:
			cchSignature = _countof(Encodings::UTF32BE_BOM) - 1;
			memcpy(pszNativeBuffer, Encodings::UTF32BE_BOM, cchSignature);
			break;
		}
		cbOffset += sizeof(uchar) * cchSignature;
	}

	for(length_t iLine = 0; iLine < cLines; ++iLine, ++it) {
		if(iLine == cLines - 1) {	// ŏIs
			if(it->m_strLine.empty())
				break;
		}
		size_t	cbConverted;

		if(!it->m_strLine.empty()) {
			cbConverted = pEncoder->ConvertFromUnicode(pszNativeBuffer + cbOffset, cbNativeBuffer - cbOffset,
							it->m_strLine.data(), it->m_strLine.length(),
							(pInternalCallback != 0 && !pInternalCallback->IsCalledOnce()) ? pInternalCallback : 0);
			if(cbConverted == 0)
				goto CLIENT_ABORTED;
			cbOffset += cbConverted;
		}
		if(iLine != cLines - 1) {
			const string_t	strBreak = GetLineBreakString((lineBreak != LB_AUTO) ? lineBreak : it->m_lineBreak);
			cbConverted = pEncoder->ConvertFromUnicode(pszNativeBuffer + cbOffset,
				cbNativeBuffer - cbOffset, strBreak.data(), strBreak.length(),
				(pInternalCallback != 0 && !pInternalCallback->IsCalledOnce()) ? pInternalCallback : 0);
			if(cbConverted == 0)
				goto CLIENT_ABORTED;
			cbOffset += cbConverted;
		}
		continue;
CLIENT_ABORTED:
		::GlobalUnlock(hNativeBuffer);
		::GlobalFree(hNativeBuffer);
		delete pEncoder;
		delete pInternalCallback;
		return FIR_ABORTED_FOR_UNCONVERTABLE;
	}

	// Vt@CJ
	if(m_file.IsOpened())
		m_file.Close();
	if(!m_file.Open(strPathName.c_str(), modeReadWrite | shareDenyWrite | modeCreate)) {
		// ߂Ȃꍇ͈ȑÕt@CJȂ
		m_file.Open(GetPathName(),
			(m_bReadOnly ? modeRead : modeReadWrite) | shareDenyWrite | modeCreate | modeNoTruncate);
		return FIR_UNKNOWN_ERROR;
	}
	m_file.Write(pszNativeBuffer, cbOffset);
	m_file.Close();
	::GlobalUnlock(hNativeBuffer);
	::GlobalFree(hNativeBuffer);
	delete pEncoder;
	delete pInternalCallback;

	// t@C̃bN
	if(m_fileOpenMode == FOM_DENY_WRITE || m_fileOpenMode == FOM_DENY_READ) {
		if(!Lock(m_fileOpenMode))
			result = FIR_LOCK_DENIED;
	}

	if(lineBreak != LB_AUTO) {
		m_lineBreak = lineBreak;	// sR[ȟ
		for(it = m_lines.begin(); it != m_lines.end(); ++it) {
			it->m_cOperationHistory = 0;	// 엚
			it->m_lineBreak = lineBreak;	// sR[h㏑
		}
	} else {
		for(it = m_lines.begin(); it != m_lines.end(); ++it)
			it->m_cOperationHistory = 0;
	}
	m_pUndoManager->OnSave();
	SetModified(false);
	m_bReadOnly = false;
	m_codePage = codePage;
	SetPathName(strPathName.c_str());

	// ŏIXV̍XV
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind = ::FindFirstFileW(GetPathName(), &wfd);
	if(hFind != INVALID_HANDLE_VALUE) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		::FindClose(hFind);
	}

	// r[ɒʒm
	UpdateAllViews(TDocumentUpdate(TDocumentUpdate::SAVED));

	for_each(m_eventListeners.begin(), m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
	return result;
}

/**
 *	݂̃t@C[֑M
 *	@param bAsAttachment	Ytt@CƂđM邩ǂBYtt@Cɂꍇ
 *							݂̕ύX͔fȂB{ƂđMꍇ݂͌̃hLggp
 *	@param bShowDialog		[UI_CAO\邩ǂ
 *	@return					
 */
bool CEditDoc::Send(bool bAsAttachment, bool bShowDialog /* = true */) {
	AssertValid();

	if(bAsAttachment && GetPathName() == 0)
		return false;

	CWaitCursor	wc;
	HMODULE		hDll = ::LoadLibraryW(L"MAPI32.DLL");
	if(hDll == 0)
		return false;

	MAPISENDMAIL*	MAPISendMail = reinterpret_cast<MAPISENDMAIL*>(::GetProcAddress(hDll, "MAPISendMail"));
	if(MAPISendMail == 0) {
		::FreeLibrary(hDll);
		return false;
	}

	MapiMessage	message;
	ulong		nErr;

	memset(&message, 0, sizeof(MapiMessage));
	message.flFlags = MAPI_RECEIPT_REQUESTED;

	if(bAsAttachment) {	// Ytt@CɂƂ
		MapiFileDesc	fileDesc;
		const int		cb = ::WideCharToMultiByte(CP_ACP, 0,
								GetPathName(), wcslen(GetPathName()), 0, 0, 0, 0);
		char* const		pszFilePath = new char[cb + 1];

		::WideCharToMultiByte(CP_ACP, 0, GetPathName(), wcslen(GetPathName()), pszFilePath, cb, 0, 0);
		pszFilePath[cb] = 0;
		message.nFileCount = 1;
		message.lpFiles = &fileDesc;

		memset(&fileDesc, 0, sizeof(MapiFileDesc));
		fileDesc.lpszPathName = pszFilePath;
		fileDesc.nPosition = static_cast<ulong>(-1);
		nErr = MAPISendMail(0, 0, &message, MAPI_LOGON_UI | (bShowDialog ? MAPI_DIALOG : 0), 0);
		delete[] pszFilePath;
	} else {	// {ƂđMƂ
		const size_t	cchDocument = GetDocumentLength();
		wchar_t* const	pwszContent = new wchar_t[cchDocument + 1];

		length_t	i = 0, iLine = 0;
		for(LineIterator it = m_lines.begin(); ; ++it, ++iLine) {
			const CLine&	line = *it;
			wcsncpy(pwszContent + i, line.m_strLine.data(), line.m_strLine.length());
			i += line.m_strLine.length();
			if(iLine != m_lines.size() - 1) {
				wcscpy(pwszContent + i, GetLineBreakString(line.m_lineBreak).c_str());
				i += GetLineBreakString(line.m_lineBreak).length();
			} else
				break;
		}
		pwszContent[cchDocument] = 0;

		// [Ũ}`oCgɕϊ
		const int	cbContent = ::WideCharToMultiByte(CP_ACP, 0, pwszContent, cchDocument, 0, 0, 0, 0);
		char* const	pszContent = new char[cbContent + 1];
		::WideCharToMultiByte(CP_ACP, 0, pwszContent, cchDocument, pszContent, cbContent, 0, 0);
		pszContent[cbContent] = 0;
		message.lpszNoteText = pszContent;
		delete[] pwszContent;
		nErr = MAPISendMail(0, 0, &message, MAPI_LOGON_UI | (bShowDialog ? MAPI_DIALOG : 0), 0);
		delete[] pszContent;
	}

	::FreeLibrary(hDll);
	return nErr == SUCCESS_SUCCESS || nErr == MAPI_USER_ABORT || nErr == MAPI_E_LOGIN_FAILURE;
}

/**
 *	̃R[hy[WƉsR[h̐ݒ
 *	@param cp				R[hy[W
 *	@param lineBreak		sR[h
 *	throw invalid_argument	R[hy[WAsR[hȂƂX[
 */
void CEditDoc::SetDefaultCode(CodePage cp, LineBreak lineBreak) throw(invalid_argument) {
	cp = _TranslateSpecialCodePage(cp);
	if(!CEncoderFactory::GetInstance().IsValidCodePage(cp)
			|| CEncoderFactory::GetInstance().IsCodePageForAutoDetection(cp))
		throw invalid_argument("Specified code page is not available.");
	switch(lineBreak) {
	case LB_LF:		case LB_CR:		case LB_CRLF:
	case LB_NEL:	case LB_LS:		case LB_PS:
		break;
	default:
		throw invalid_argument("Specified line break type is invalid.");
	}
	m_defaultCodePage = cp;
	m_defaultLineBreak = lineBreak;
}

/// ::SetTimer ̃R[obN֐B1000~bƂɌĂяoA
/// t@CvZXŕύXĂȂĎ
void CALLBACK CEditDoc::_TimerProc(HWND hWnd, UINT nMsg, timerid_t idEvent, DWORD dwTime) {
	map<timerid_t, CEditDoc*>::iterator	it = CEditDoc::m_documents.find(idEvent);
	if(it != CEditDoc::m_documents.end())
		it->second->_CheckTimeStamp();
}

/**
 *	@brief	AhD̎s
 *
 *	ΏۂANZXs\ł΃hD͍sȂ
 *	@return						AhDłȂꍇ false Ԃ
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 *	@see						CEditDoc::Redo
 */
bool CEditDoc::Undo() throw(EDocumentIsReadOnly) {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	else if(GetUndoHistoryLength(false) == 0)
		return false;

	BeginEditCollection();
	TDocumentUpdate	update(TDocumentUpdate::BEGIN_UNDO_OPERATION);
	UpdateAllViews(update);
	update.summary = TDocumentUpdate::END_UNDO_OPERATION;
	const bool	bSucceeded = m_pUndoManager->Undo(update.posResult);
	EndEditCollection();
	UpdateAllViews(update);

	if(!m_pUndoManager->IsModifiedSinceLastSave()) {
		SetModified(false);
		for_each(m_eventListeners.begin(),
			m_eventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//		for(set<IEditDocEventListener*>::iterator it
//				= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
//			(*it)->OnDocumentModified();
	}
	return bSucceeded;
}

/// i[CO
/// @see	CEditDoc::IsNarrowed, CEditDoc::Narrow
void CEditDoc::Widen() {
	if(m_pAccessibleArea != 0) {
		delete m_pAccessibleArea->second;
		delete m_pAccessibleArea;
		m_pAccessibleArea = 0;
		UpdateAllViews(TDocumentUpdate(TDocumentUpdate::CHANGED_NARROWING));
	}
}

/* [EOF] */