// AscensionCommon.h
// (c) 2004-2005 exeal

#ifndef _ASCENSION_COMMON_H_
#define _ASCENSION_COMMON_H_

///	ǐՒ Unicode ̃o[W
#define ASCENSION_UNICODE_VERSION	0x0410	// 4.1.0

#include "Config.h"
#include <string>
#include <sstream>
#include "../../Manah/Object.h"

#ifdef _DEBUG
#include "../../Manah/Timer.h"
using Manah::Windows::dout;
using Manah::Windows::CTimer;
template<typename T> void Alert(const T& t) {
	std::wostringstream	ss;
	ss << t;
	::MessageBoxW(0, ss.str().c_str(), L"alert", MB_OK);
}
#endif /* _DEBUG */

namespace Ascension {

	namespace Private {
		// ^ signed ɂ邾
		template<typename T>
		class ToSigned {
		private:
			template<typename U>	struct _ToSigned;
			template<>	struct _ToSigned<unsigned char>		{typedef char	Result;};
			template<>	struct _ToSigned<unsigned short>	{typedef short	Result;};
			template<>	struct _ToSigned<unsigned int>		{typedef int	Result;};
			template<>	struct _ToSigned<unsigned long>		{typedef long	Result;};
			template<>	struct _ToSigned<unsigned _int64>	{typedef _int64	Result;};
		public:
			typedef typename _ToSigned<T>::Result	Result;
		};
	} // namespace Private

	// ^`BWin32 API  wchar_t ł͂Ȃ WCHAR gƂB
	// Ƃ͂ۂɂ wcs*** ĝ WCHAR == wchar_t łȂƍ̂
	// (X OLECHAR == wchar_t łȂƂ܂)
	typedef WCHAR											char_t;
	typedef std::basic_string<char_t>						string_t;
	typedef string_t::size_type								length_t;
	typedef Private::ToSigned<length_t>::Result				signed_length_t;
	typedef std::basic_stringstream<string_t::value_type>	stringstream_t;
	typedef std::basic_istringstream<string_t::value_type>	istringstream_t;
	typedef std::basic_ostringstream<string_t::value_type>	ostringstream_t;

	/// R[h|Cg^
	typedef unsigned long	CodePoint;	// uint32_t

#if ASCENSION_UNICODE_VERSION != 0x0410
#error These arrays are based on old version of Unicode.
#endif
	/// Unicode XNvg (Scripts.txt)
	enum UnicodeScript {
		// Unicode 4.0
		US_LATIN, US_GREEK, US_CYRILLIC, US_ARMENIAN, US_HEBREW, US_ARABIC, US_SYRIAC, US_THAANA,
		US_DEVANAGARI, US_BENGALI, US_GURMUKHI, US_GUJARATI, US_ORIYA, US_TAMIL, US_TELUGU, US_KANNADA,
		US_MALAYALAM, US_SINHARA, US_THAI, US_LAO, US_TIBETAN, US_MYANMAR, US_GEORGIAN, US_HANGUL,
		US_ETHIOPIC, US_CHEROKEE, US_CANADIAN_ABORIGINAL, US_OGHAM, US_RUNIC, US_KHMER, US_MONGOLIAN,
		US_HIRAGANA, US_KATAKANA, US_BOPOMOFO, US_HAN, US_YI, US_OLD_ITALIC, US_GOTHIC, US_DESERET,
		US_INHERITED, US_TAGALOG, US_HANUNOO, US_BUHID, US_TAGBANWA, US_LIMBU, US_TAI_LE,
		US_LINEAR_B, US_UGARITIC, US_SHAVIAN, US_OSMANYA, US_CYPRIOT, US_BRAILLE,
		// Unicode 4.1
		US_BUGINESE, US_COPTIC, US_NEW_TAI_LUE, US_GLAGOLITIC, US_TIFINAGH, US_SYLOTI_NAGRI,
		US_OLD_PERSIAN, US_KHAROSHTHI,
		US_COUNT
	};

	/// Unicode R[hubN (Blocks.txt)
	enum UnicodeBlock {
		UB_BASIC_LATIN, UB_LATIN1_SUPPLEMENT, UB_LATIN_EXTENDED_A, UB_LATIN_EXTENDED_B,
		UB_IPA_EXTENSIONS, UB_SPACING_MODIFIER_LETTERS, UB_COMBINING_DIACRITICAL_MARKS,
		UB_GREEK, UB_CYRILLIC, UB_CYRILLIC_SUPPLEMENTARY, UB_ARMENIAN, UB_HEBREW, UB_ARABIC,
		UB_SYRIAC, UB_ARABIC_SUPPLEMENT, UB_THAANA, UB_DEVANAGARI, UB_BENGALI, UB_GURMUKHI, UB_GUJARATI,
		UB_ORIYA, UB_TAMIL, UB_TELUGU, UB_KANNADA, UB_MALAYALAM, UB_SINHALA, UB_THAI, UB_LAO, UB_TIBETAN,
		UB_MYANMAR, UB_GEORGIAN, UB_HANGUL_JAMO, UB_ETHIOPIC, UB_ETHIOPIC_SUPPLEMENT, UB_CHEROKEE,
		UB_UNIFIED_CANADIAN_ABORIGINAL_SYLLABIC, UB_OGHAM, UB_RUNIC, UB_TAGALOG, UB_HANUNOO,
		UB_BUHID, UB_TAGBANWA, UB_KHMER, UB_MONGOLIAN, UB_LIMBU, UB_TAI_LE, UB_NEW_TAI_LUE, UB_KHMER_SYMBOLS,
		UB_BUGINESE, UB_PHONETIC_EXTENSIONS, UB_PHONETIC_EXTENSION_SUPPLEMENT,
		UB_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT, UB_LATIN_EXTENDED_ADDITIONAL, UB_GREEK_EXTENDED,
		UB_GENERAL_PUNCTUATION, UB_SUPERSCRIPTS_AND_SUBSCRIPTS, UB_CURRENCY_SYMBOLS, UB_COMBINING_MARKS_FOR_SYMBOLS,
		UB_LETTERLIKE_SYMBOLS, UB_NUMBER_FORMS, UB_ARROWS, UB_MATHEMATICAL_OPERATORS,
		UB_MISCELLANEOUB_TECHNICAL, UB_CONTROL_PICTURES, UB_OPTICAL_CHARACTER_RECOGNITION,
		UB_ENCLOSED_ALPHANUMERICS, UB_BOX_DRAWING, UB_BLOCK_ELEMENTS, UB_GEOMETRIC_SHAPES,
		UB_MISCELLANEOUB_SYMBOLS, UB_DINGBATS, UB_MISCELLANEOUB_MATHEMATICAL_SYMBOLS_A,
		UB_SUPPLEMENTAL_ARROWS_A, UB_BRAILLE_PATTERNS, UB_SUPPLEMENTAL_ARROWS_B,
		UB_MISCELLANEOUB_MATHEMATICAL_SYMBOLS_B, UB_SUPPLEMENTAL_MATHEMATICAL_OPERATORS,
		UB_MISCELLANEOUB_SYMBOLS_AND_ARROWS, UB_COPTIC, UB_GEORGIAN_SUPPLEMENT, UB_TIFINAGH, UB_ETHIOPIC_EXTENDED,
		UB_SUPPLEMENTAL_PUNCTUATION, UB_CJK_RADICALS_SUPPLEMENT, UB_KANGXI_RADICALS,
		UB_IDEOGRAPHIC_DESCRIPTION_CHARACTERS, UB_CJK_SYMBOLS_AND_PUNCTUATION, UB_HIRAGANA, UB_KATAKANA,
		UB_BOPOMOFO, UB_HANGUL_COMPATIBILITY_JAMO, UB_KANBUN, UB_BOPOMOFO_EXTENDED,
		UB_KATAKANA_PHONETIC_EXTENSIONS, UB_ENCLOSED_CJK_LETTERS_AND_MONTHS, UB_CJK_COMPATIBILITY,
		UB_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, UB_YIJING_HEXAGRAM_SYMBOLS, UB_CJK_UNIFIED_IDEOGRAPHS,
		UB_YI_SYLLABLES, UB_YI_RADICALS, UB_MODIFIER_TONE_LETTERS, UB_SYLOTI_NAGRI, UB_HANGUL_SYLLABLES,
		UB_HIGH_SURROGATES, UB_HIGH_PRIVATE_USE_SURROGATES, UB_LOW_SURROGATES, UB_PRIVATE_USE_AREA,
		UB_CJK_COMPATIBILITY_IDEOGRAPHS, UB_ALPHABETIC_PRESENTATION_FORMS, UB_ARABIC_PRESENTATION_FORMS_A,
		UB_VARIATION_SELECTORS, UB_COMBINING_HALF_MARKS, UB_CJK_COMPATIBILITY_FORMS, UB_SMALL_FORM_VARIANTS,
		UB_ARABIC_PRESENTATION_FORMS_B, UB_HALFWIDTH_AND_FULLWIDTH_FORMS, UB_SPECIALS, UB_LINEAR_B_SYLLABARY,
		UB_LINEAR_B_IDEOGRAMS, UB_AEGEAN_NUMBERS, UB_ACIENT_GREEK_NUMBERS, UB_OLD_ITALIC, UB_GOTHIC, UB_UGARITIC,
		UB_OLD_PERSIAN, UB_DESERET, UB_SHAVIAN, UB_OSMANYA, UB_CYPRIOT_SYLLABARY, UB_KHAROSHTHI,
		UB_BYZANTINE_MUSICAL_SYMBOLS, UB_MUSICAL_SYMBOLS, UB_ACIENT_GREEK_MUSICAL_NOTATION,
		UB_TAI_XUAN_JING_SYMBOLS, UB_MATHEMATICAL_ALPHANUMERIC_SYMBOLS, UB_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B,
		UB_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, UB_TAGS, UB_VARIATION_SELECTORS_SUPPLEMENT,
		UB_SUPPLEMENTARY_PRIVATE_USE_AREA_A, UB_SUPPLEMENTARY_PRIVATE_USE_AREA_B, UB_COUNT
	};

	// O錾
	class CEditDoc;
	class CEditView;

	/// sƕʒui[
	/// @see	CSynchronizablePoint, CEditPoint, CVisualPoint
	class CCharPos : Manah::CUseMemoryPool<CCharPos> {
	public:
		length_t	m_iLine;	///< s
		length_t	m_iChar;	///< ʒu
	public:
		/// RXgN^
		explicit CCharPos(std::size_t iLine = 0, std::size_t iChar = 0) : m_iLine(iLine), m_iChar(iChar) {}
	};

	// CCharPos ̔rZq
	inline bool operator ==(const CCharPos& lhs, const CCharPos& rhs)
	{return lhs.m_iLine == rhs.m_iLine && lhs.m_iChar == rhs.m_iChar;}
	inline bool operator !=(const CCharPos& lhs, const CCharPos& rhs)
	{return lhs.m_iLine != rhs.m_iLine || lhs.m_iChar != rhs.m_iChar;}
	inline bool operator <(const CCharPos& lhs, const CCharPos& rhs)
	{return lhs.m_iLine < rhs.m_iLine || (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar < rhs.m_iChar);}
	inline bool operator <=(const CCharPos& lhs, const CCharPos& rhs)
	{return lhs < rhs || lhs == rhs;}
	inline bool operator >(const CCharPos& lhs, const CCharPos& rhs)
	{return lhs.m_iLine > rhs.m_iLine || (lhs.m_iLine == rhs.m_iLine && lhs.m_iChar > rhs.m_iChar);}
	inline bool operator >=(const CCharPos& lhs, const CCharPos& rhs)
	{return lhs > rhs || lhs == rhs;}

	/// 2_ō\͈
	class CTextRange : public Manah::CUseMemoryPool<CTextRange> {
	public:
		CCharPos	m_pos1, m_pos2;	///< 2_
	public:
		/// RXgN^
		CTextRange() {}
		/// RXgN^
		CTextRange(const CCharPos& pos1, const CCharPos& pos2) : m_pos1(pos1), m_pos2(pos2) {}
		/// Zq
		bool operator ==(const CTextRange& rhs) const {
			return (m_pos1 == rhs.m_pos1 && m_pos2 == rhs.m_pos2)
				|| (m_pos1 == rhs.m_pos2 && m_pos2 == rhs.m_pos1);
		}
		/// 񓙉Zq
		bool operator !=(const CTextRange& rhs) const {return !operator ==(rhs);}
		/// Ԃ
		CCharPos& GetTop() const {return const_cast<CCharPos&>(std::min(m_pos1, m_pos2));}
		/// 傫Ԃ
		CCharPos& GetBottom() const {return const_cast<CCharPos&>(std::max(m_pos1, m_pos2));}
		/// ͈͂
		bool IsEmpty() const {return m_pos1 == m_pos2;}
	};

	/// () ̐ΒlԂ
	template<typename T>
	ulong dif(T i0, T i1) {return (i0 > i1) ? i0 - i1 : i1 - i0;}

	///  UTF-16 ʃTQ[głΐ^Ԃ
	inline bool IsUtf16HighSurrogate(wchar_t ch) {return ch >= 0xD800 && ch < 0xDC00;}

	///  UTF-16 ʃTQ[głΐ^Ԃ
	inline bool IsUtf16LowSurrogate(wchar_t ch) {return ch >= 0xDC00 && ch < 0xE000;}

	/**
	 *	UTF-16 TQ[gyAR[h|Cg쐬
	 *	@param pwsz	TQ[gyA
	 *	@param cch	<var>pwsz</var> ̒
	 *	@return		R[h|Cg
	 */
	inline CodePoint DecodeUtf16SurrogatesToCodePoint(const char_t* pwsz, std::size_t cch) {
		assert(pwsz != 0 && cch != 0);
		return (cch > 1 && IsUtf16HighSurrogate(pwsz[0]) && IsUtf16LowSurrogate(pwsz[1])) ? 
					0x10000 + (pwsz[0] - 0xD800) * 0x400 + pwsz[1] - 0xDC00 : pwsz[0];
	}

	/**
	 *	R[h|Cg UTF-16 TQ[gyA쐬
	 *	@param cp		R[h|Cg
	 *	@param pwszDest	TQ[gyA
	 *	@return			TQ[gyAƂ^
	 */
	inline bool EncodeCodePointToUtf16Surrogates(CodePoint cp, char_t* pwszDest) {
		assert(pwszDest != 0);

		if(cp < 0x00010000) {
			pwszDest[0] = static_cast<char_t>(cp);
			return false;
		} else if(cp <= 0x0010FFFF) {
			cp -= 0x00010000;
			pwszDest[0] = 0xD800 | static_cast<char_t>((cp & 0x001FFC00) >> 10);
			pwszDest[1] = 0xDC00 | static_cast<char_t>((cp & 0x000003FF) >> 0);
			return true;
		}
		return false;
	}

	/// UTF-16  UTF-32 PʂőCe[^
	class Utf16ToUtf32Iterator : public std::iterator<std::bidirectional_iterator_tag, CodePoint> {
	public:
		Utf16ToUtf32Iterator(const char_t* p) : m_p(p) {}
		Utf16ToUtf32Iterator& operator ++() {++m_p; if(IsUtf16LowSurrogate(*m_p)) ++m_p; return *this;}
		const Utf16ToUtf32Iterator operator ++(int) {Utf16ToUtf32Iterator tmp(*this); ++(*this); return tmp;}
		Utf16ToUtf32Iterator& operator --() {--m_p; if(IsUtf16HighSurrogate(*m_p)) --m_p; return *this;}
		const Utf16ToUtf32Iterator operator --(int) {Utf16ToUtf32Iterator tmp(*this); --(*this); return tmp;}
		CodePoint operator *() const {return DecodeUtf16SurrogatesToCodePoint(m_p, 2);}
		bool operator ==(const Utf16ToUtf32Iterator& rhs) const {return m_p == rhs.m_p;}
		bool operator !=(const Utf16ToUtf32Iterator& rhs) const {return !(*this == rhs);}
	private:
		const char_t*	m_p;
	};

	/// UTF-32  UTF-16 PʂőCe[^
	class Utf32ToUtf16Iterator : public std::iterator<std::bidirectional_iterator_tag, char_t> {
	public:
		Utf32ToUtf16Iterator(const CodePoint* p) : m_p(p), m_bHigh(true) {}
		Utf32ToUtf16Iterator& operator ++() {
			if(*m_p < 0x10000) ++m_p;
			else {m_bHigh = !m_bHigh; if(m_bHigh) ++m_p;}
			return *this;
		}
		const Utf32ToUtf16Iterator operator ++(int) {Utf32ToUtf16Iterator tmp(*this); ++(*this); return tmp;}
		Utf32ToUtf16Iterator& operator --() {
			if(*m_p < 0x10000) --m_p;
			else {m_bHigh = !m_bHigh; if(!m_bHigh) --m_p;}
			return *this;
		}
		const Utf32ToUtf16Iterator operator --(int) {Utf32ToUtf16Iterator tmp(*this); --(*this); return tmp;}
		char_t operator *() const {
			if(*m_p < 0x10000) return static_cast<char_t>(*m_p);
			else {
				char_t wsz[2];
				EncodeCodePointToUtf16Surrogates(*m_p, wsz);
				return m_bHigh ? wsz[0] : wsz[1];
			}
		}
		bool operator ==(const Utf32ToUtf16Iterator& rhs) const {return m_p == rhs.m_p;}
		bool operator !=(const Utf32ToUtf16Iterator& rhs) const {return !(*this == rhs);}
	private:
		const CodePoint*	m_p;
		bool				m_bHigh;
	};

	/// R[h|Cg̃XNvgԂ
	inline UnicodeScript GetScript(CodePoint cp);

	/// R[h|Cg̑ubN𒲂ׂ
	inline UnicodeBlock GetBlock(CodePoint cp);

	///	ArA 0-9 ɕϊ (: FoldStringW(MAP_FOLDDIGITS))
	inline CodePoint FoldDigit(CodePoint cp) {
#if ASCENSION_UNICODE_VERSION != 0x0410
#error This code is based on old version of Unicode.
#endif
#define FOLD_DIGIT(lo, up)	if(cp >= lo && cp <= up) return cp - up + L'9'
		// Unicode 4.0  'Nd' ɊÂ
		FOLD_DIGIT(0x0030, 0x0039);		// C0
		FOLD_DIGIT(0x0660, 0x0669);		// Arabic-Indic
		FOLD_DIGIT(0x06F0, 0x06F9);		// Extended Arabic-Indic
		FOLD_DIGIT(0x0966, 0x096F);		// Devanagari
		FOLD_DIGIT(0x09E6, 0x09EF);		// Bengali
		FOLD_DIGIT(0x0A66, 0x0A6F);		// Gurmukhi
		FOLD_DIGIT(0x0AE6, 0x0AEF);		// Gujarati
		FOLD_DIGIT(0x0B66, 0x0B6F);		// Oriya
		FOLD_DIGIT(0x0BE6, 0x0BEF);		// Tamil (zero was introduced in Unicode 4.1)
		FOLD_DIGIT(0x0C66, 0x0C6F);		// Telugu
		FOLD_DIGIT(0x0CE6, 0x0CEF);		// Kannada
		FOLD_DIGIT(0x0D66, 0x0D6F);		// Malayalam
		FOLD_DIGIT(0x0E50, 0x0E59);		// Thai
		FOLD_DIGIT(0x0ED0, 0x0ED9);		// Lao
		FOLD_DIGIT(0x0F20, 0x0F29);		// Tibetan
		FOLD_DIGIT(0x1040, 0x1049);		// Myanmar
//		FOLD_DIGIT(0x1369, 0x1371);		// Ethiopic (0 not found) (removed in Unicode 4.1)
		FOLD_DIGIT(0x17E0, 0x17E9);		// Khmer
		FOLD_DIGIT(0x1810, 0x1819);		// Mongolian
		FOLD_DIGIT(0x1946, 0x194F);		// Limbu
		FOLD_DIGIT(0x19D0, 0x19D9);		// New Tai Lue (Unicode 4.1)
		FOLD_DIGIT(0xFF10, 0xFF19);		// Fullwidth
		FOLD_DIGIT(0x0104A0, 0x0104A9);	// Osmanya
		FOLD_DIGIT(0x01D7CE, 0x01D7D7);	// Mathematical bold
		FOLD_DIGIT(0x01D7D8, 0x01D7E1);	// Mathematical double-struck
		FOLD_DIGIT(0x01D7E2, 0x01D7EB);	// Mathematical sans-serif
		FOLD_DIGIT(0x01D7EC, 0x01D7F5);	// Mathematical sans-serif bold
		FOLD_DIGIT(0x01D7F6, 0x01D7FF);	// Mathematical monospace
		return cp;
	#undef FOLD_DIGIT
	}
} // namespace Ascension

#endif /* _ASCENSION_COMMON_H_ */

/* [EOF] */