// Ambient.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "resource.h"
#include "Ambient.h"
#include "AmbientIdl_i.c"	// IID, LIBID
#include "AlphaScriptHost.h"
#include "AlphaView.h"
#include "CommandManager.h"
#include "Ascension\EditPoint.h"
#include <limits>
#include "../Armaiti/OleTypeWrapper.h"
#include "../Armaiti/EnumImpl.h"

#pragma warning(disable : 4390)	// u䂪̕܂B...v

using namespace Alpha;
using namespace Alpha::Ambient;
using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Ascension::StandardCommands;
using namespace Manah::Windows::Controls;
using namespace Armaiti;
using namespace Armaiti::OLE;
using namespace std;


// IDispatch::Invoke Ɏg}NA֐A
/////////////////////////////////////////////////////////////////////////////

// IDispatch::Invoke ̈Xg
#define INVOKE_ARGLIST											\
	DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,	\
	DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr

// ̐`FbNAȂ DISP_E_BADPARAMCOUNT ԂƂ
#define VERIFY_ARGUMENTS_COUNT(c)	\
	if(pDispParams->cArgs != (c))	\
		return DISP_E_BADPARAMCOUNT

// ߂ľ^ type ɐݒ肷
// ([Jϐ pVarResult 邱ƂO)
#define COERCE_RETURN(type)	\
	if(pVarResult != 0)		\
		pVarResult->vt = type

// iArg Ԗڂ̌^ type ɕϊBϊłȂ΃G[R[hԂƂ
// ([Jϐ pDispParams AwFlags Ahr ApuArgErr Aargs[] 邱ƂO)
#define COERCE_ARGUMENT_AT(iArg, type)										\
	do {																	\
		if(type == VT_VARIANT) {											\
			if(pDispParams->rgvarg[iArg].vt == (VT_VARIANT | VT_BYREF))		\
				args[iArg] = *pDispParams->rgvarg[iArg].pvarVal;			\
			else															\
				args[iArg] = pDispParams->rgvarg[iArg];						\
			hr = (args[iArg].vt != VT_ERROR) ? S_OK : args[iArg].scode;		\
		} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT) && iArg == 0)	\
			hr = ::DispGetParam(pDispParams,								\
					DISPID_PROPERTYPUT, type,								\
					&args[iArg], puArgErr);									\
		else																\
			hr = ::DispGetParam(pDispParams,								\
					pDispParams->cArgs - iArg - 1, type,					\
					&args[iArg], puArgErr);									\
		if(FAILED(hr))														\
			return hr;														\
	} while(false)

namespace {
	template<VARTYPE varType> struct VarType2CppType;
	template<> struct VarType2CppType<VT_BOOL> {typedef VARIANT_BOOL CppType;};
	template<> struct VarType2CppType<VT_BSTR> {typedef BSTR CppType;};
	template<> struct VarType2CppType<VT_I2> {typedef short CppType;};
	template<> struct VarType2CppType<VT_I4> {typedef long CppType;};
	template<> struct VarType2CppType<VT_UI2> {typedef ushort CppType;};
	template<> struct VarType2CppType<VT_UI4> {typedef ulong CppType;};
	template<> struct VarType2CppType<VT_INT> {typedef int CppType;};
	template<> struct VarType2CppType<VT_UNKNOWN> {typedef IUnknown* CppType;};
	template<> struct VarType2CppType<VT_DISPATCH> {typedef IDispatch* CppType;};
	template<> struct VarType2CppType<VT_VARIANT> {typedef VARIANT CppType;};

	template<VARTYPE type> struct VariantTypeDescriminator {
		typedef typename VarType2CppType<type>::CppType CppType;
		typedef CppType(VARIANT::*MemberType);
		static MemberType member;
		static CppType& Value(VARIANT& var);
	};
	template<VARTYPE type> typename VariantTypeDescriminator<type>::MemberType VariantTypeDescriminator<type>::member = 0;
	template<> inline VariantTypeDescriminator<VT_BOOL>::CppType& VariantTypeDescriminator<VT_BOOL>::Value(VARIANT& var) {
		return (member = &VARIANT::boolVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_BSTR>::CppType& VariantTypeDescriminator<VT_BSTR>::Value(VARIANT& var) {
		return (member = &VARIANT::bstrVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_I2>::CppType& VariantTypeDescriminator<VT_I2>::Value(VARIANT& var) {
		return (member = &VARIANT::iVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_I4>::CppType& VariantTypeDescriminator<VT_I4>::Value(VARIANT& var) {
		return (member = &VARIANT::lVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_UI2>::CppType& VariantTypeDescriminator<VT_UI2>::Value(VARIANT& var) {
		return (member = &VARIANT::uiVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_UI4>::CppType& VariantTypeDescriminator<VT_UI4>::Value(VARIANT& var) {
		return (member = &VARIANT::ulVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_INT>::CppType& VariantTypeDescriminator<VT_INT>::Value(VARIANT& var) {
		return (member = &VARIANT::intVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_UNKNOWN>::CppType& VariantTypeDescriminator<VT_UNKNOWN>::Value(VARIANT& var) {
		return (member = &VARIANT::punkVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_DISPATCH>::CppType& VariantTypeDescriminator<VT_DISPATCH>::Value(VARIANT& var) {
		return (member = &VARIANT::pdispVal), var.*member;
	}
	template<> inline VariantTypeDescriminator<VT_VARIANT>::CppType& VariantTypeDescriminator<VT_VARIANT>::Value(VARIANT& var) {
		return var;
	}
} // namespace `anonymous'

// Qb^Ăяo̎
#define CALL_GETTER(name, type)	\
	VERIFY_ARGUMENTS_COUNT(0);	\
	pVarResult->vt = type;		\
	return get_##name(&VariantTypeDescriminator<type>::Value(*pVarResult))
#define CALL_GETTER_1(name, type, type0)								\
	VERIFY_ARGUMENTS_COUNT(1);											\
	COERCE_ARGUMENT_AT(0, type0);										\
	pVarResult->vt = type;												\
	return get_##name(VariantTypeDescriminator<type0>::Value(args[0]),	\
		&VariantTypeDescriminator<type>::Value(*pVarResult))
#define CALL_GETTER_ACTX(name, itf)	\
	VERIFY_ARGUMENTS_COUNT(0);		\
	pVarResult->vt = VT_DISPATCH;	\
	return get_##name(reinterpret_cast<itf**>(&pVarResult->pdispVal))
#define CALL_GETTER_ACTX_1(name, type0, itf)							\
	VERIFY_ARGUMENTS_COUNT(1);											\
	COERCE_ARGUMENT_AT(0, type0);										\
	pVarResult->vt = VT_DISPATCH;										\
	return get_##name(VariantTypeDescriminator<type0>::Value(args[0]),	\
		reinterpret_cast<itf**>(&pVarResult->pdispVal))
#define CALL_GETTER_ENUM(name, type)	\
	pVarResult->vt = VT_I4;			\
	return get_##name(reinterpret_cast<type*>(&pVarResult->lVal))

// vb^Ăяo̎
#define CALL_PUTTER(name, type)		\
	VERIFY_ARGUMENTS_COUNT(1);		\
	COERCE_ARGUMENT_AT(0, type);	\
	return put_##name(VariantTypeDescriminator<type>::Value(args[0]))
#define CALL_PUTTER_1(name, type, type0)								\
	VERIFY_ARGUMENTS_COUNT(2);											\
	COERCE_ARGUMENT_AT(1, type0);										\
	COERCE_ARGUMENT_AT(0, type);										\
	return put_##name(VariantTypeDescriminator<type0>::Value(args[1]),	\
		VariantTypeDescriminator<type>::Value(args[0]))
#define CALL_PUTTER_ACTX(name, itf)		\
	VERIFY_ARGUMENTS_COUNT(1);			\
	COERCE_ARGUMENT_AT(0, VT_DISPATCH);	\
	return put_##name(reinterpret_cast<itf*>(args[0].pdispVal))
#define CALL_PUTTER_ENUM(name, type)	\
	VERIFY_ARGUMENTS_COUNT(1);			\
	COERCE_ARGUMENT_AT(0, VT_I4);		\
	return put_##name(static_cast<type>(args[0].lVal))

// \bhĂяo̎
#define CALL_METHOD_0(name)		\
	VERIFY_ARGUMENTS_COUNT(0);	\
	return name()
#define CALL_METHOD_1(name, type0)	\
	VERIFY_ARGUMENTS_COUNT(1);				\
	COERCE_ARGUMENT_AT(0, type0);			\
	return name(VariantTypeDescriminator<type0>::Value(args[0]))
#define CALL_METHOD_2(name, type0, type1)							\
	VERIFY_ARGUMENTS_COUNT(2);										\
	COERCE_ARGUMENT_AT(1, type0);									\
	COERCE_ARGUMENT_AT(0, type1);									\
	return name(VariantTypeDescriminator<type0>::Value(args[1]),	\
		VariantTypeDescriminator<type1>::Value(args[0]))
#define CALL_METHOD_3(name, type0, type1, type2)					\
	VERIFY_ARGUMENTS_COUNT(3);										\
	COERCE_ARGUMENT_AT(2, type0);									\
	COERCE_ARGUMENT_AT(1, type1);									\
	COERCE_ARGUMENT_AT(0, type2);									\
	return name(VariantTypeDescriminator<type0>::Value(args[2]),	\
		VariantTypeDescriminator<type1>::Value(args[1]),			\
		VariantTypeDescriminator<type2>::Value(args[0]))
#define CALL_METHOD_4(name, type0, type1, type2, type3)				\
	VERIFY_ARGUMENTS_COUNT(4);										\
	COERCE_ARGUMENT_AT(3, type0);									\
	COERCE_ARGUMENT_AT(2, type1);									\
	COERCE_ARGUMENT_AT(1, type2);									\
	COERCE_ARGUMENT_AT(0, type3);									\
	return name(VariantTypeDescriminator<type0>::Value(args[3]),	\
		VariantTypeDescriminator<type1>::Value(args[2]),			\
		VariantTypeDescriminator<type2>::Value(args[1]),			\
		VariantTypeDescriminator<type3>::Value(args[0]))
#define CALL_METHOD_RET_0(name, retType)	\
	VERIFY_ARGUMENTS_COUNT(0);				\
	COERCE_RETURN(retType);					\
	return name((pVarResult != 0) ? &VariantTypeDescriminator<retType>::Value(*pVarResult) : 0)
#define CALL_METHOD_RET_1(name, retType, type0)						\
	VERIFY_ARGUMENTS_COUNT(1);										\
	COERCE_ARGUMENT_AT(0, type0);									\
	COERCE_RETURN(retType);											\
	return name(VariantTypeDescriminator<type0>::Value(args[0]),	\
		(pVarResult != 0) ? &VariantTypeDescriminator<retType>::Value(*pVarResult) : 0)
#define CALL_METHOD_RET_2(name, retType, type0, type1)				\
	VERIFY_ARGUMENTS_COUNT(2);										\
	COERCE_ARGUMENT_AT(1, type0);									\
	COERCE_ARGUMENT_AT(0, type1);									\
	COERCE_RETURN(retType);											\
	return name(VariantTypeDescriminator<type0>::Value(args[1]),	\
		VariantTypeDescriminator<type1>::Value(args[0]),			\
		(pVarResult != 0) ? &VariantTypeDescriminator<retType>::Value(*pVarResult) : 0)

// S}[N
#define SAFE_MARK	\
	IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(INTERFACESAFE_FOR_UNTRUSTED_CALLER)

// 댯}[N
#define UNSAFE_MARK	\
	IObjectSafetyImpl<INTERFACESAFE_FOR_UNTRUSTED_CALLER>(0)

// ȂȂ
#define VERIFY_SAFETY()														\
	if(toBoolean(m_dwEnabledSafety & INTERFACESAFE_FOR_UNTRUSTED_CALLER))	\
		return E_ACCESSDENIED

// 񂾎IuWFNgwĂȂ𒲂ׂ
#define CHECK_IF_DISPOSED()	if(IsDisposed()) return E_UNEXPECTED;

// _Xbhx̃G[ pExcepInfo ɃZbgA
// DISP_E_EXCEPTION ԂB
// (ʎq pException Ahr Lł邱ƂO)
#define RETURN_WITH_EXCEPTION()										\
	do {															\
		IErrorInfo*	pErrorInfo = 0;									\
		assert(SUCCEEDED(::GetErrorInfo(0, &pErrorInfo)));			\
		pExcepInfo->wCode = 0;										\
		pExcepInfo->scode = hr;										\
		pErrorInfo->GetSource(&pExcepInfo->bstrSource);				\
		pErrorInfo->GetDescription(&pExcepInfo->bstrDescription);	\
		pErrorInfo->GetHelpFile(&pExcepInfo->bstrHelpFile);			\
		pErrorInfo->GetHelpContext(&pExcepInfo->dwHelpContext);		\
		pExcepInfo->pvReserved = 0;									\
		pExcepInfo->pfnDeferredFillIn = 0;							\
		::SetErrorInfo(0, pErrorInfo);								\
		pErrorInfo->Release();										\
		return DISP_E_EXCEPTION;									\
	} while(false)

// CTextPoint ̊̃\bhɎgp
#define GENERATE_CHARPOS_FROM_TEXTPOINT()			\
	CComPtr<ITextPoint>	pTextPoint;					\
	long				iLine, iChar;				\
	var = varOther;									\
	if(FAILED(var.pdispVal->QueryInterface(			\
			IID_ITextPoint,							\
			reinterpret_cast<void**>(&pTextPoint))))\
		return DISP_E_TYPEMISMATCH;					\
	pTextPoint->get_Line(&iLine);					\
	pTextPoint->get_Char(&iChar);					\
	CCharPos	pos = CCharPos(iLine, iChar);

namespace {
	// Cӂ̃\bhĂяo GUI XbhɈϏ
	template<class Class, typename Result = void>
	struct GuiThreadDelegator0 : virtual public Alpha::_ICallable {
		GuiThreadDelegator0(Class& object, Result(Class::*method)()) : m_object(object), m_method(method) {}
		void Call() {(m_object.*m_method)();}
		Class&	m_object;
		Result(Class::*m_method)();
	};
	template<class Class, typename Argument, typename Result = void>
	struct GuiThreadDelegator1 : virtual public Alpha::_ICallable {
		GuiThreadDelegator1(Class& object, Result(Class::*method)(Argument&), Argument& argument)
				: m_object(object), m_method(method), m_argument(argument) {}
		void Call() {(m_object.*m_method)(m_argument);}
		Class&	m_object;
		Result(Class::*m_method)(Argument&);
		Argument&	m_argument;
	};
	// 󔒂ŋ؂ăXgɂ
	template <class T>
	inline void SplitBySpace(const wchar_t* pwsz, T& dest) {
		assert(pwsz != 0);

		const wchar_t*	pwszSpace;
		const wchar_t*	pwszLast = pwsz;
		while(true) {
			pwszSpace = wcschr(pwszLast, L' ');
			if(pwszSpace != 0) {
				dest.push_back(wstring(pwszLast, pwszSpace - pwszLast));
				pwszLast = pwszSpace + 1;
			} else {
				dest.push_back(wstring(pwszLast));
				break;
			}
		}
	}
	// K\Ȃ
	const HRESULT	SCRIPT_E_BADREGEXP = 0x800A1399;
	// EditorPreferences::CheckInputSequence vpeB̎ɎgꃊXg
	const pair<const wchar_t*, InputSequenceCheckLanguage>	ISCLanguages[] = {
		make_pair(L"ainu", ISCL_AINU),
		make_pair(L"thai", ISCL_THAI),
		make_pair(L"vietnamese", ISCL_VIETNAMESE),
	};
} // namespace `anonymous'


// CApplication class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CApplication::CApplication(Alpha::CAlphaApp& app, const vector<wstring>* pArguments /* = 0 */) : SAFE_MARK, m_app(app) {
}

/// fXgN^
CApplication::~CApplication() {
}

/// @see	IApplication::ClearOutput
STDMETHODIMP CApplication::ClearOutput() {
//	m_pApp->m_wndOutput.Clear(OTT_GENERAL, false);
	return S_OK;
}

/// @see	IApplication::get_Abbreviations
STDMETHODIMP CApplication::get_Abbreviations(IAbbreviations** ppAbbreviations) {
	VERIFY_POINTER(ppAbbreviations);

	if(0 == (*ppAbbreviations = new Ambient::CAbbreviations))
		return E_OUTOFMEMORY;
	(*ppAbbreviations)->AddRef();
	return S_OK;
}

/// @see	IApplication::get_Active
STDMETHODIMP CApplication::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	*pbActive = m_app.GetMainWindow() == CWindow::GetActiveWindow();
	return S_OK;
}

/// @see	IApplication::get_ActiveBuffer
STDMETHODIMP CApplication::get_ActiveBuffer(IBuffer** ppActiveBuffer) {
	VERIFY_POINTER(ppActiveBuffer);
	return m_app.GetActiveBuffer().GetAutomation(m_app, ppActiveBuffer);
}

/// @see	IApplication::get_Buffers
STDMETHODIMP CApplication::get_Buffers(IBuffers** ppBuffers) {
	VERIFY_POINTER(ppBuffers);

	CBuffers*	pBuffers;
	m_app.GetAutomation(0, &pBuffers);
	*ppBuffers = pBuffers;
	return S_OK;
}

/// @see	IApplication::get_Configurations
STDMETHODIMP CApplication::get_Configurations(IConfigurations** ppConfigurations) {
	VERIFY_POINTER(ppConfigurations);

	if(0 == (*ppConfigurations = new CConfigurations(m_app)))
		return E_OUTOFMEMORY;
	(*ppConfigurations)->AddRef();
	return S_OK;
}

/// @see	IApplication::get_CurrentDirectory
STDMETHODIMP CApplication::get_CurrentDirectory(BSTR* pbstrDirectory) {
	VERIFY_POINTER(pbstrDirectory);
	OLECHAR	wszPath[MAX_PATH];
	::GetCurrentDirectoryW(MAX_PATH, wszPath);
	*pbstrDirectory = ::SysAllocString(wszPath);
	return (*pbstrDirectory != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IApplication::get_EditorPanes
STDMETHODIMP CApplication::get_EditorPanes(IEditorPanes** ppPanes) {
	VERIFY_POINTER(ppPanes);
	if(*ppPanes = new CEditorPanes(m_app.GetEditorPane())) {
		(*ppPanes)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/*
/// @see	IApplication::get_Debugger
STDMETHODIMP CApplication::get_Debugger(IDebugger** ppDebugger) {
	VERIFY_POINTER(ppDebugger);
	*ppDebugger = 0;
	return E_NOTIMPL;
}*/

/// @see	IApplication::get_FullName
STDMETHODIMP CApplication::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszFileName[MAX_PATH];

	::GetModuleFileName(0, wszFileName, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszFileName);
	return (*pbstrFullName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IApplication::get_Height
STDMETHODIMP CApplication::get_Height(long* pnHeight) {
	VERIFY_POINTER(pnHeight);

	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	*pnHeight = rect.bottom - rect.top;
	return S_OK;
}

/// @see	IApplication::get_Interactive
STDMETHODIMP CApplication::get_Interactive(VARIANT_BOOL* pbInteractive) {
	VERIFY_POINTER(pbInteractive);
	*pbInteractive = VARIANT_TRUE;
	return S_OK;
}

/// @see	IApplication::get_Left
STDMETHODIMP CApplication::get_Left(long* pnLeft) {
	VERIFY_POINTER(pnLeft);

	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	*pnLeft = rect.left;
	return S_OK;
}

/// @see	IApplication::get_Name
STDMETHODIMP CApplication::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);
	*pbstrName = ::SysAllocString(IDS_APPNAME OLESTR(" ") IDS_APPVERSION OLESTR(" ") IDS_APPVERSIONINFO);
	return (*pbstrName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IApplication::get_Top
STDMETHODIMP CApplication::get_Top(long* pnTop) {
	VERIFY_POINTER(pnTop);

	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	*pnTop = rect.top;
	return S_OK;
}

/// @see	IApplication::get_Version
STDMETHODIMP CApplication::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);
	*pbstrVersion = ::SysAllocString(IDS_APPVERSION);
	return (*pbstrVersion != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IApplication::get_Visible
STDMETHODIMP CApplication::get_Visible(VARIANT_BOOL* pbVisible) {
	VERIFY_POINTER(pbVisible);
	*pbVisible = m_app.GetMainWindow().IsWindowVisible();
	return S_OK;
}

/// @see	IApplication::get_Width
STDMETHODIMP CApplication::get_Width(long* pnWidth) {
	VERIFY_POINTER(pnWidth);

	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	*pnWidth = rect.right - rect.left;
	return S_OK;
}

/// @see	IApplication::get_WindowState
STDMETHODIMP CApplication::get_WindowState(WindowState* pWindowState) {
	VERIFY_POINTER(pWindowState);

	if(m_app.GetMainWindow().IsIconic())		*pWindowState = Minimized;
	else if(m_app.GetMainWindow().IsZoomed())	*pWindowState = Maximized;
	else										*pWindowState = Normal;
	return S_OK;
}

/// @see	IApplication::GetCommandById
STDMETHODIMP CApplication::GetCommandById(long nCommandId, ICommand** ppCommand) {
	if(ppCommand != 0) {
		if(0 == (*ppCommand = new Ambient::CCommand(m_app, static_cast<CommandId>(nCommandId))))
			return E_OUTOFMEMORY;
		(*ppCommand)->AddRef();
	}
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CApplication::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ABBREVIATIONS:		CALL_GETTER_ACTX(Abbreviations, IAbbreviations);
		case DISPID_APPLICATION_ACTIVE:				CALL_GETTER(Active, VT_BOOL);
		case DISPID_APPLICATION_ACTIVEBUFFER:		CALL_GETTER_ACTX(ActiveBuffer, IBuffer);
		case DISPID_APPLICATION_BUFFERS: {
			IBuffers*	pBuffers;
			pVarResult->vt = VT_DISPATCH;
			hr = get_Buffers(&pBuffers);
			if(SUCCEEDED(hr) && pDispParams->cArgs != 0) {	// "Ambient.Buffers(i)" ̂悤ȏꍇ
				hr = pBuffers->Invoke(DISPID_VALUE, IID_NULL,
						LOCALE_USER_DEFAULT, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
				pBuffers->Release();
				return hr;
			} else {	// "Ambient.Buffers" ̂悤ȏꍇ
				pVarResult->pdispVal = pBuffers;
				return hr;
			}
		}
		case DISPID_APPLICATION_CONFIGURATIONS:		CALL_GETTER_ACTX(Configurations, IConfigurations);
		case DISPID_APPLICATION_CURRENTDIRECTORY:	CALL_GETTER(CurrentDirectory, VT_BSTR);
		case DISPID_APPLICATION_EDITORPANES:	CALL_GETTER_ACTX(EditorPanes, IEditorPanes);
		case DISPID_APPLICATION_FULLNAME:		CALL_GETTER(FullName, VT_BSTR);
		case DISPID_APPLICATION_HEIGHT:			CALL_GETTER(Height, VT_I4);
		case DISPID_APPLICATION_INTERACTIVE:	CALL_GETTER(Interactive, VT_BOOL);
		case DISPID_APPLICATION_LEFT:			CALL_GETTER(Left, VT_I4);
		case DISPID_APPLICATION_NAME:			CALL_GETTER(Name, VT_BSTR);
		case DISPID_APPLICATION_TOP:			CALL_GETTER(Top, VT_I4);
		case DISPID_APPLICATION_VERSION:		CALL_GETTER(Version, VT_BSTR);
		case DISPID_APPLICATION_VISIBLE:		CALL_GETTER(Visible, VT_BOOL);
		case DISPID_APPLICATION_WIDTH:			CALL_GETTER(Width, VT_I4);
		case DISPID_APPLICATION_WINDOWSTATE:	CALL_GETTER_ENUM(WindowState, WindowState);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ACTIVE:				CALL_PUTTER(Active, VT_BOOL);
		case DISPID_APPLICATION_CURRENTDIRECTORY:	CALL_PUTTER(CurrentDirectory, VT_BSTR);
		case DISPID_APPLICATION_HEIGHT:				CALL_PUTTER(Height, VT_I4);
		case DISPID_APPLICATION_INTERACTIVE:		CALL_PUTTER(Interactive, VT_BOOL);
		case DISPID_APPLICATION_LEFT:				CALL_PUTTER(Left, VT_I4);
		case DISPID_APPLICATION_TOP:				CALL_PUTTER(Top, VT_I4);
		case DISPID_APPLICATION_VISIBLE:			CALL_PUTTER(Visible, VT_BOOL);
		case DISPID_APPLICATION_WIDTH:				CALL_PUTTER(Width, VT_I4);
		case DISPID_APPLICATION_WINDOWSTATE:		CALL_PUTTER_ENUM(WindowState, WindowState);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF) {	// Zb^
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_APPLICATION_CLEAROUTPUT:	CALL_METHOD_0(ClearOutput);
		case DISPID_APPLICATION_GETCOMMANDBYID:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_DISPATCH);
			return GetCommandById(args[0].lVal,
				(pVarResult != 0) ? reinterpret_cast<ICommand**>(&pVarResult->pdispVal) : 0);
		case DISPID_APPLICATION_QUIT:
			if(pDispParams->cArgs == 1) {
				CALL_METHOD_1(Quit, VT_I2);
			} else if(pDispParams->cArgs == 0)
				return Quit();
			else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_APPLICATION_WRITETOOUTPUT:		CALL_METHOD_2(WriteToOutput, VT_BSTR, VT_BOOL);
		case DISPID_APPLICATION_WRITELINETOOUTPUT:	CALL_METHOD_2(WriteLineToOutput, VT_BSTR, VT_BOOL);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

void CApplication::_CallHook(DISPID idHook, const DISPPARAMS* pArguments) {
/*	if(m_pHook == 0)
		return;

	CComPtr<IDispatchEx>	px;
	DISPPARAMS				params = {0, 0, 0, 0};
	EXCEPINFO				exception;
	HRESULT					hr;

	if(S_OK == m_pHook->QueryInterface(IID_IDispatchEx, reinterpret_cast<void**>(&px))) {
		VARIANTARG	arg;
		DISPID		id = DISPID_THIS;

		params.cArgs = params.cNamedArgs = 1;
		arg.vt = VT_DISPATCH;
		hr = QueryInterface(IID_IDispatch, reinterpret_cast<void**>(&arg.pdispVal));
		params.rgdispidNamedArgs = &id;
		hr = px->InvokeEx(DISPID_VALUE, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, 0);
	} else {
		unsigned int	iArgErr;
		hr = m_pHook->Invoke(DISPID_VALUE, IID_NULL,
			LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, &iArgErr);
	}*/
}

/// @see	IApplication::put_Active
STDMETHODIMP CApplication::put_Active(VARIANT_BOOL bActive) {
	if(bActive)
		m_app.GetMainWindow().SetActiveWindow();
	else
		::SetActiveWindow(::GetDesktopWindow());
	return S_OK;
}

/// @see	IApplication::put_CurrentDirectory
STDMETHODIMP CApplication::put_CurrentDirectory(BSTR bstrDirectory) {
	::SetCurrentDirectoryW((bstrDirectory != 0) ? bstrDirectory : L"");
	return S_OK;
}

/// @see	IApplication::put_Height
STDMETHODIMP CApplication::put_Height(long nHeight) {
	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	m_app.GetMainWindow().SetWindowPos(0, 0, 0,
		rect.right - rect.left, nHeight, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_Interactive
STDMETHODIMP CApplication::put_Interactive(VARIANT_BOOL bInteractive) {
	return S_OK;
}

/// @see	IApplication::put_Left
STDMETHODIMP CApplication::put_Left(long nLeft) {
	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	m_app.GetMainWindow().SetWindowPos(0, nLeft, rect.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_Top
STDMETHODIMP CApplication::put_Top(long nTop) {
	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	m_app.GetMainWindow().SetWindowPos(0, rect.left, nTop, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_Visible
STDMETHODIMP CApplication::put_Visible(VARIANT_BOOL bVisible) {
	m_app.GetMainWindow().ShowWindow(bVisible ? SW_SHOW : SW_HIDE);
	return S_OK;
}

/// @see	IApplication::put_Width
STDMETHODIMP CApplication::put_Width(long nWidth) {
	RECT	rect;
	m_app.GetMainWindow().GetWindowRect(rect);
	m_app.GetMainWindow().SetWindowPos(0, 0, 0, nWidth, rect.bottom - rect.top, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

/// @see	IApplication::put_WindowState
STDMETHODIMP CApplication::put_WindowState(WindowState windowState) {
	switch(windowState) {
	case Minimized:
		m_app.GetMainWindow().ShowWindow(SW_MINIMIZE);
		break;
	case Maximized:
		m_app.GetMainWindow().ShowWindow(SW_MAXIMIZE);
		break;
	case Normal:
		m_app.GetMainWindow().ShowWindow(SW_RESTORE);
		break;
	default:
		return E_INVALIDARG;
		break;
	}
	return S_OK;
}

/// @see	IApplication::Quit
STDMETHODIMP CApplication::Quit(short nErrorCode) {
	m_app.GetMainWindow().SendMessage(WM_CLOSE);
	return S_OK;
}

/// @see	IApplication::WriteToOutput
STDMETHODIMP CApplication::WriteToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_app.m_wndOutput.Write(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}

/// @see	IApplication::WriteLineToOutput
STDMETHODIMP CApplication::WriteLineToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_app.m_wndOutput.WriteLine(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}


// CDocuments class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CBuffers::CBuffers(Alpha::CAlphaApp& app) : UNSAFE_MARK, m_app(app) {
}

/// @see	IBuffers::AddNew
STDMETHODIMP CBuffers::AddNew(IBuffer** ppNewBuffer) {
	m_app.GetMainWindow().SendMessage(WM_COMMAND, CMD_FILE_NEW);
	if(ppNewBuffer != 0)
		m_app.GetActiveBuffer().GetAutomation(m_app, ppNewBuffer);
	return S_OK;
}

/// @see	IBuffers::CloseAll
STDMETHODIMP CBuffers::CloseAll() {
	m_app.GetMainWindow().SendMessage(WM_COMMAND, CMD_FILE_CLOSEALL);
	return S_OK;
}

/// @see	IBuffers::get__NewEnum
STDMETHODIMP CBuffers::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);

	const CBufferList&	buffers = m_app.GetBufferList();
	VARIANT* const		pBuffers = new VARIANT[buffers.GetCount()];

	try {
		for(size_t i = 0; i < buffers.GetCount(); ++i) {
			::VariantInit(&pBuffers[i]);
			pBuffers[i].vt = VT_DISPATCH;
			buffers.GetAt(i).GetAutomation(m_app, reinterpret_cast<IBuffer**>(&pBuffers[i].pdispVal));
		}
	} catch(out_of_range& /* e */) {
		for(size_t i = 0; i < buffers.GetCount(); ++i)
			::VariantClear(&pBuffers[i]);
		delete[] pBuffers;
		*ppEnum = 0;
		return E_FAIL;
	}
	*ppEnum = new IEnumVARIANTImpl(pBuffers, buffers.GetCount());
	if(*ppEnum != 0)
		(*ppEnum)->AddRef();
	for(size_t i = 0; i < buffers.GetCount(); ++i)
		::VariantClear(&pBuffers[i]);
	delete[] pBuffers;

	return (*ppEnum != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IBuffers::get_Count
STDMETHODIMP CBuffers::get_Count(long* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = m_app.GetBufferList().GetCount();
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CBuffers::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[4];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_BUFFERS_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		case DISPID_BUFFERS_COUNT:		CALL_GETTER(Count, VT_I4);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_BUFFERS_ADDNEW:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_DISPATCH);
			return AddNew((pVarResult != 0) ? reinterpret_cast<IBuffer**>(&pVarResult->pdispVal) : 0);
		case DISPID_BUFFERS_CLOSEALL:	CALL_METHOD_0(CloseAll);
		case DISPID_BUFFERS_ITEM:
//		case 0:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_DISPATCH);
			hr = Item(args[0].lVal, (pVarResult != 0) ?
					reinterpret_cast<IBuffer**>(&pVarResult->pdispVal) : 0);
			return hr;
		case DISPID_BUFFERS_OPEN:
			COERCE_RETURN(VT_DISPATCH);
			if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return Open(args[1].bstrVal, static_cast<FileShareMode>(args[0].lVal), 0, VARIANT_TRUE,
					(pVarResult != 0) ? reinterpret_cast<IBuffer**>(&pVarResult->pdispVal) : 0);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I4);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return Open(args[2].bstrVal,
					static_cast<FileShareMode>(args[1].lVal), args[0].lVal, VARIANT_TRUE,
					(pVarResult != 0) ? reinterpret_cast<IBuffer**>(&pVarResult->pdispVal) : 0);
			} else if(pDispParams->cArgs == 4) {
				COERCE_ARGUMENT_AT(3, VT_BSTR);
				COERCE_ARGUMENT_AT(2, VT_I4);
				COERCE_ARGUMENT_AT(1, VT_I4);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Open(args[3].bstrVal,
					static_cast<FileShareMode>(args[2].lVal), args[1].lVal, args[0].boolVal,
					(pVarResult != 0) ? reinterpret_cast<IBuffer**>(&pVarResult->pdispVal) : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_BUFFERS_SAVEALL:	CALL_METHOD_0(SaveAll);
		}
	}

	return hr;
}

/// @see	IBuffers::Item
STDMETHODIMP CBuffers::Item(long index, IBuffer** ppBuffer) {
	VERIFY_POINTER(ppBuffer);
	try {
		m_app.GetBufferList().GetAt(index).GetAutomation(m_app, ppBuffer);
	} catch(out_of_range& /* e */) {
		*ppBuffer = 0;
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see	IBuffers::Open
STDMETHODIMP CBuffers::Open(BSTR bstrPathName,
		FileShareMode nShareMode, long nCodePage, VARIANT_BOOL bAddToMRU, IBuffer** ppNewBuffer) {
	VERIFY_SAFETY();
	if(bstrPathName == 0)
		return E_INVALIDARG;
	CComCriticalSection<>	cs;
	cs.Lock();
	if(ppNewBuffer != 0)
		*ppNewBuffer = 0;
	if(m_app.OpenFile(bstrPathName, (nCodePage != 0) ? nCodePage : ::GetACP(), false, toBoolean(bAddToMRU)) == OPENFILERESULT_SUCCEEDED) {
		if(ppNewBuffer != 0)
			m_app.GetActiveBuffer().GetAutomation(m_app, ppNewBuffer);
	}
	cs.Unlock();
	return S_OK;
}

/// @see	IBuffers::SaveAll
STDMETHODIMP CBuffers::SaveAll() {
	VERIFY_SAFETY();
	m_app.GetMainWindow().SendMessage(WM_COMMAND, CMD_FILE_SAVEALL);
	return S_OK;
}


// CEditorPanes class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CEditorPanes::CEditorPanes(EditorWindow& impl) : m_impl(impl) {
}

/// @see	IEditorPanes::ActivateNext
STDMETHODIMP CEditorPanes::ActivateNext() {
	CAlphaApp::GetInstance().CallFunctionOnGuiThread(
		GuiThreadDelegator0<EditorWindow>(m_impl, EditorWindow::ActivateNextPane));
	return S_OK;
}

/// @see	IEditorPanes::ActivatePrev
STDMETHODIMP CEditorPanes::ActivatePrev() {
	CAlphaApp::GetInstance().CallFunctionOnGuiThread(
		GuiThreadDelegator0<EditorWindow>(m_impl, EditorWindow::ActivatePreviousPane));
	return S_OK;
}

/// @see	IEditorPanes::get__NewEnum
STDMETHODIMP CEditorPanes::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);

	size_t	cPanes = 0;
	for(EditorWindow::Iterator it = m_impl.EnumeratePanes(); !it.IsEnd(); it.Next())
		++cPanes;
	VARIANT*	panes = new VARIANT[cPanes];
	VARIANT*	pPane = panes;
	for(EditorWindow::Iterator it = m_impl.EnumeratePanes(); !it.IsEnd(); it.Next(), ++pPane) {
		IEditorPane*	p;
		it.Get().GetAutomation(&p);
		::VariantInit(pPane);
		pPane->vt = VT_DISPATCH;
		pPane->pdispVal = p;
	}
	*ppEnum = new IEnumVARIANTImpl(panes, cPanes);
	for(size_t i = 0; i < cPanes; ++i)
		::VariantClear(panes + i);
	delete[] panes;
	if(*ppEnum != 0) {
		(*ppEnum)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see	IEditorPanes::get_ActivePane
STDMETHODIMP CEditorPanes::get_ActivePane(IEditorPane** ppActivePane) {
	return m_impl.GetActivePane().GetAutomation(ppActivePane);
}

/// @see	IEditorPanes::get_Count
STDMETHODIMP CEditorPanes::get_Count(long* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = 0;
	for(EditorWindow::Iterator it = m_impl.EnumeratePanes(); !it.IsEnd(); it.Next())
		++(*pnCount);
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CEditorPanes::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_EDITORPANES_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		case DISPID_EDITORPANES_ACTIVEPANE:	CALL_GETTER_ACTX(ActivePane, IEditorPane);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
	} else if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		switch(dispidMember) {
		case DISPID_EDITORPANES_ACTIVATENEXT:	CALL_METHOD_0(ActivateNext);
		case DISPID_EDITORPANES_ACTIVATEPREV:	CALL_METHOD_0(ActivatePrev);
		case DISPID_EDITORPANES_UNSPLITALL:		CALL_METHOD_0(UnsplitAll);
		}
	}
	return hr;
}

/// @see	IEditorPanes::UnsplitAll
STDMETHODIMP CEditorPanes::UnsplitAll() {
	CAlphaApp::GetInstance().CallFunctionOnGuiThread(
		GuiThreadDelegator0<EditorWindow>(m_impl, EditorWindow::RemoveInactivePanes));
	return S_OK;
}

// CEditorPane class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Ambient::CEditorPane::CEditorPane(EditorWindow& parent, Alpha::CEditorPane& pane) : m_parent(parent), m_pane(pane) {
}

///	@see	IEditorPane::Activate
STDMETHODIMP Ambient::CEditorPane::Activate() {
	CHECK_IF_DISPOSED();
	CAlphaApp::GetInstance().CallFunctionOnGuiThread(
		GuiThreadDelegator0<CAlphaView, CWindow>(m_pane.GetVisibleView(), CAlphaView::SetFocus));
	CAlphaApp::GetInstance().CallFunctionOnGuiThread(
		GuiThreadDelegator1<EditorWindow, Alpha::CEditorPane>(m_parent, EditorWindow::SetDefaultActivePane, m_pane));
	return S_OK;
}
/// @see	IEditorPane::Close
STDMETHODIMP Ambient::CEditorPane::Close() {
	CHECK_IF_DISPOSED();
	struct _ : virtual public Alpha::_ICallable {
		_(EditorWindow& panes, Alpha::CEditorPane& pane) : m_panes(panes), m_pane(pane) {}
		void Call() {m_panes.Unsplit(m_pane);}
		EditorWindow&		m_panes;
		Alpha::CEditorPane& m_pane;
	} delegator(m_parent, m_pane);
	CAlphaApp::GetInstance().GetMainWindow().SendMessage(
		MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(static_cast<Alpha::_ICallable*>(&delegator)));
	return S_OK;
}

/// @see	IEditorPane::get_Active
STDMETHODIMP Ambient::CEditorPane::get_Active(VARIANT_BOOL* pbActive) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(pbActive);
	*pbActive = &m_parent.GetActivePane() == &m_pane;
	return S_OK;
}

/// @see	IEditorPane::get_Buffer
STDMETHODIMP Ambient::CEditorPane::get_Buffer(IBuffer** ppBuffer) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(ppBuffer);
	m_pane.GetVisibleBuffer().GetAutomation(CAlphaApp::GetInstance(), ppBuffer);
	return S_OK;
}

/// @see	IEditorPane::get_Editor
STDMETHODIMP Ambient::CEditorPane::get_Editor(ITextEditor** ppEditor) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(ppEditor);
	return m_pane.GetVisibleView().GetAutomation(ppEditor);
}

/// @see	IEditorPane::get_Height
STDMETHODIMP Ambient::CEditorPane::get_Height(long* pnHeight) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(pnHeight);
	RECT	rc;
	m_pane.GetVisibleView().GetWindowRect(rc);
	*pnHeight = rc.bottom - rc.top;
	return S_OK;
}

///	@see	IEditorPane::get_Width
STDMETHODIMP Ambient::CEditorPane::get_Width(long* pnWidth) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(pnWidth);
	RECT	rc;
	m_pane.GetVisibleView().GetWindowRect(rc);
	*pnWidth = rc.right - rc.left;
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP Ambient::CEditorPane::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_EDITORPANE_ACTIVE:	CALL_GETTER(Active, VT_BOOL);
		case DISPID_EDITORPANE_BUFFER:	CALL_GETTER_ACTX(Buffer, IBuffer);
		case DISPID_EDITORPANE_EDITOR:	CALL_GETTER_ACTX(Editor, ITextEditor);
		case DISPID_EDITORPANE_HEIGHT:	CALL_GETTER(Height, VT_I4);
		case DISPID_EDITORPANE_WIDTH:	CALL_GETTER(Width, VT_I4);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_EDITORPANE_BUFFER:	CALL_PUTTER_ACTX(Buffer, IBuffer);
		case DISPID_EDITORPANE_HEIGHT:	CALL_PUTTER(Height, VT_I4);
		case DISPID_EDITORPANE_WIDTH:	CALL_PUTTER(Width, VT_I4);
		}
	} else if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		switch(dispidMember) {
		case DISPID_EDITORPANE_ACTIVATE:	CALL_METHOD_0(Activate);
		case DISPID_EDITORPANE_CLOSE:		CALL_METHOD_0(Close);
		case DISPID_EDITORPANE_SPLIT:		CALL_METHOD_1(Split, VT_BOOL);
		}
	}
	return hr;
}

/// @see	IEditorPane::put_Buffer
STDMETHODIMP Ambient::CEditorPane::put_Buffer(IBuffer* pBuffer) {
	CHECK_IF_DISPOSED();
	if(pBuffer == 0)
		return E_INVALIDARG;

	CBufferList&	buffers = CAlphaApp::GetInstance().GetBufferList();
	for(size_t i = 0; i < buffers.GetCount(); ++i) {
		IBuffer*	p;
		buffers.GetAt(i).GetAutomation(CAlphaApp::GetInstance(), &p);
		if(p == pBuffer) {
			m_pane.ShowBuffer(buffers.GetAt(i));
			p->Release();
			continue;
		}
		p->Release();
	}
	return S_OK;
}

/// @see	IEditorPane::put_Height
STDMETHODIMP Ambient::CEditorPane::put_Height(long nHeight) {
	CHECK_IF_DISPOSED();
	return S_OK;
}

/// @see	IEditorPane::put_Width
STDMETHODIMP Ambient::CEditorPane::put_Width(long nWidth) {
	CHECK_IF_DISPOSED();
	return S_OK;
}

/// @see	IEditorPane::Split
STDMETHODIMP Ambient::CEditorPane::Split(VARIANT_BOOL bNs) {
	CHECK_IF_DISPOSED();
	struct _ : virtual public Alpha::_ICallable {
		_(EditorWindow& panes, Alpha::CEditorPane& pane, bool ns) : m_panes(panes), m_pane(pane), m_ns(ns) {}
		void Call() {
			Alpha::CEditorPane*	p = new Alpha::CEditorPane(m_pane);
			if(m_ns)	m_panes.SplitNS(m_pane, *p);
			else		m_panes.SplitWE(m_pane, *p);
		}
		EditorWindow&		m_panes;
		Alpha::CEditorPane&	m_pane;
		bool				m_ns;
	} delegator(m_parent, m_pane, toBoolean(bNs));
	CAlphaApp::GetInstance().GetMainWindow().SendMessage(
		MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(static_cast<Alpha::_ICallable*>(&delegator)));
	return S_OK;
}


// CBuffer class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CBuffer::CBuffer(CAlphaApp& app, CAlphaDoc& document) : UNSAFE_MARK, m_app(app), m_buffer(document) {
}

/// @see	IBuffer::Activate
STDMETHODIMP CBuffer::Activate() {
	m_app.GetEditorPane().GetActivePane().ShowBuffer(m_buffer);
	return S_OK;
}

/// @see	IBuffer::Close
STDMETHODIMP CBuffer::Close() {
	m_app.CloseBuffer(_FindBuffer(), false);
	return S_OK;
}

/**
 *	AvP[VIuWFNg (CAlphaApp) 玩̃obt@ԍT
 *	@return	obt@ԍ
 */
size_t CBuffer::_FindBuffer() const {
	const CBufferList&	buffers = m_app.GetBufferList();
	for(size_t i = 0; i < buffers.GetCount(); ++i) {
		if(&buffers.GetAt(i) == &m_buffer)
			return i;
	}
	assert(false);	//tȂ͖͂
	return -1;
}

/// @see	IBuffer::get_Active
STDMETHODIMP CBuffer::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	*pbActive = toVariantBoolean(&m_app.GetActiveBuffer() == &m_buffer);
	return S_OK;
}

/// @see	IBuffer::get_CodePage
STDMETHODIMP CBuffer::get_CodePage(long* pnCodePage) {
	CHECK_IF_DISPOSED();
	VERIFY_POINTER(pnCodePage);
	*pnCodePage = m_buffer.GetCodePage();
	return S_OK;
}

/// @see	IBuffer::get_Editor
STDMETHODIMP CBuffer::get_Editor(ITextEditor** ppEditor) {
	return m_buffer.GetActiveView().GetAutomation(ppEditor);
}

/// @see	IBuffer::get_EndPoint
STDMETHODIMP CBuffer::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);

	CVisualPoint*	pEndPoint = m_buffer.CreateEditPoint();

	pEndPoint->MoveToEndOfDocument();
	if(*ppEndPoint = new CTextPoint(*pEndPoint, false)) {
		(*ppEndPoint)->AddRef();
		return S_OK;
	} else {
		delete pEndPoint;
		return E_OUTOFMEMORY;
	}
}

/// @see	IBuffer::get_FileName
STDMETHODIMP CBuffer::get_FileName(BSTR* pbstrFileName) {
	VERIFY_POINTER(pbstrFileName);
	*pbstrFileName = ::SysAllocString(m_buffer.GetFileName());
	return (*pbstrFileName != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IBuffer::get_FilePath
STDMETHODIMP CBuffer::get_FilePath(BSTR* pbstrFilePath) {
	VERIFY_POINTER(pbstrFilePath);
	*pbstrFilePath = ::SysAllocString((m_buffer.GetPathName() != 0) ? m_buffer.GetPathName() : OLESTR(""));
	return (*pbstrFilePath != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IBuffer::get_Line
STDMETHODIMP CBuffer::get_Line(long iLine, BSTR* pbstrLine) {
	VERIFY_POINTER(pbstrLine);
	try {
		*pbstrLine = ::SysAllocString(m_buffer.GetLine(iLine).c_str());
	} catch(out_of_range&) {
		*pbstrLine = 0;
		return E_INVALIDARG;
	}
	return (*pbstrLine != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	IBuffer::get_LineBreak
STDMETHODIMP CBuffer::get_LineBreak(::LineBreak* pLineBreak) {
	VERIFY_POINTER(pLineBreak);
	*pLineBreak = static_cast<::LineBreak>(m_buffer.GetLineBreak());
	return S_OK;
}

/// @see	IBuffer::get_LineCount
STDMETHODIMP CBuffer::get_LineCount(long* pcLines) {
	VERIFY_POINTER(pcLines);
	*pcLines = m_buffer.GetLineCount();
	return S_OK;
}

/// @see	IBuffer::get_Modified
STDMETHODIMP CBuffer::get_Modified(VARIANT_BOOL* pbModified) {
	VERIFY_POINTER(pbModified);
	*pbModified = m_buffer.IsModified();
	return S_OK;
}

/// @see	IBuffer::get_ReadOnly
STDMETHODIMP CBuffer::get_ReadOnly(VARIANT_BOOL* pbReadOnly) {
	VERIFY_POINTER(pbReadOnly);
	*pbReadOnly = m_buffer.IsReadOnly();
	return S_OK;
}

/// @see	IBuffer::get_StartPoint
STDMETHODIMP CBuffer::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
	CVisualPoint*	p = m_buffer.CreateEditPoint();
	if(*ppStartPoint = new CTextPoint(*p, false)) {
		(*ppStartPoint)->AddRef();
		return S_OK;
	} else {
		delete p;
		return E_OUTOFMEMORY;
	}
}

/// @see	IBuffer::Invoke
STDMETHODIMP CBuffer::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_BUFFER_ACTIVE:		CALL_GETTER(Active, VT_BOOL);
		case DISPID_BUFFER_CODEPAGE:	CALL_GETTER(CodePage, VT_I4);
		case DISPID_BUFFER_EDITOR:		CALL_GETTER_ACTX(Editor, ITextEditor);
		case DISPID_BUFFER_ENDPOINT:	CALL_GETTER_ACTX(EndPoint, ITextPoint);
		case DISPID_BUFFER_FILENAME:	CALL_GETTER(FileName, VT_BSTR);
		case DISPID_BUFFER_FILEPATH:	CALL_GETTER(FilePath, VT_BSTR);
		case DISPID_BUFFER_LINE:		CALL_GETTER_1(Line, VT_BSTR, VT_I4);
		case DISPID_BUFFER_LINEBREAK:	CALL_GETTER_ENUM(LineBreak, ::LineBreak);
		case DISPID_BUFFER_LINECOUNT:	CALL_GETTER(LineCount, VT_I4);
		case DISPID_BUFFER_MODIFIED:	CALL_GETTER(Modified, VT_BOOL);
		case DISPID_BUFFER_READONLY:	CALL_GETTER(ReadOnly, VT_BOOL);
		case DISPID_BUFFER_STARTPOINT:	CALL_GETTER_ACTX(StartPoint, ITextPoint);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_BUFFER_CODEPAGE:	CALL_PUTTER(CodePage, VT_I4);
		case DISPID_BUFFER_LINEBREAK:	CALL_PUTTER_ENUM(LineBreak, ::LineBreak);
		case DISPID_BUFFER_MODIFIED:	CALL_PUTTER(Modified, VT_BOOL);
		case DISPID_BUFFER_READONLY:	CALL_PUTTER(ReadOnly, VT_BOOL);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_BUFFER_ACTIVATE:	CALL_METHOD_0(Activate);
		case DISPID_BUFFER_CLOSE:		CALL_METHOD_0(Close);
		case DISPID_BUFFER_ISNARROWED:	CALL_METHOD_RET_0(IsNarrowed, VT_BOOL);
		case DISPID_BUFFER_NARROW:		CALL_METHOD_4(Narrow, VT_I4, VT_I4, VT_I4, VT_I4);
		case DISPID_BUFFER_SAVE:
			if(pDispParams->cArgs == 1) {
				CALL_METHOD_1(Save, VT_BSTR);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return Save(args[1].bstrVal, static_cast<::LineBreak>(args[0].lVal));
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I4);
				COERCE_ARGUMENT_AT(0, VT_UI2);
				return Save(args[2].bstrVal,
					static_cast<::LineBreak>(args[1].lVal), args[0].uiVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_BUFFER_WIDEN:		CALL_METHOD_0(Widen);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	IBuffer::IsNarrowed
STDMETHODIMP CBuffer::IsNarrowed(VARIANT_BOOL* pbNarrowed) {
	if(pbNarrowed != 0)
		*pbNarrowed = toVariantBoolean(m_buffer.IsNarrowed());
	return S_OK;
}

/// @see	IBuffer::Narrow
STDMETHODIMP CBuffer::Narrow(long iStartLine, long iStartChar, long iEndLine, long iEndChar) {
	m_buffer.Narrow(Ascension::CTextRange(CCharPos(iStartLine, iStartChar), CCharPos(iEndLine, iEndChar)));
	return S_OK;
}

/// @see	IBuffer::put_CodePage
STDMETHODIMP CBuffer::put_CodePage(long nCodePage) {
	try {
		m_buffer.SetCodePage(nCodePage);
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see	IBuffer::put_LineBreak
STDMETHODIMP CBuffer::put_LineBreak(::LineBreak lineBreak) {
	try {
		m_buffer.SetLineBreak(static_cast<Ascension::LineBreak>(lineBreak));
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see	IBuffer::put_Modified
STDMETHODIMP CBuffer::put_Modified(VARIANT_BOOL bModified) {
	m_buffer.SetModified(toBoolean(bModified));
	return S_OK;
}

/// @see	IBuffer::put_ReadOnly
STDMETHODIMP CBuffer::put_ReadOnly(VARIANT_BOOL bReadOnly) {
	m_buffer.SetReadOnly(toBoolean(bReadOnly));
	return S_OK;
}

/// @see	IBuffer::Save
STDMETHODIMP CBuffer::Save(BSTR bstrFileName,
		::LineBreak lineBreak /* = Auto */, long nCodePage /* = 0 */) {
	VERIFY_SAFETY();
	if(bstrFileName == 0)
		return E_INVALIDARG;
	return (CEditDoc::FIR_OK == m_buffer.Save(bstrFileName, 0,
		static_cast<Ascension::LineBreak>(lineBreak), nCodePage, 0)) ? S_OK : S_FALSE;
}

/// @see	IBuffer::Widen
STDMETHODIMP CBuffer::Widen() {
	m_buffer.Widen();
	return S_OK;
}


// CTextEditor class implementation
/////////////////////////////////////////////////////////////////////////////

#define GENERATE_NATIVE_SEARCH_OPTIONS()														\
	TSearchOptions	options;																	\
	if(pOptions != 0) {																			\
		pOptions->get_CaseSensitivity(															\
			reinterpret_cast<CaseFoldingType*>(&options.caseSensitivity));						\
		pOptions->get_CharacterSkipOption(														\
			reinterpret_cast<CharacterSkipType*>(&options.characterSkipOptions));				\
		pOptions->get_FoldingOption(reinterpret_cast<FoldingType*>(&options.foldingOptions));	\
		pOptions->get_MultigraphExpansionOption(												\
			reinterpret_cast<MultigraphExpansionType*>(&options.multigraphExpansionOptions));	\
		pOptions->get_SearchType(reinterpret_cast<::SearchType*>(&options.type));				\
		pOptions->get_WholeWord(reinterpret_cast<VARIANT_BOOL*>(&options.bWholeWord));			\
	}

/// RXgN^
CTextEditor::CTextEditor(CAlphaApp& app, CAlphaView& view) : SAFE_MARK, m_app(app), m_view(view) {
}

/// @see	ITextEditor::BackSpace
STDMETHODIMP CTextEditor::BackSpace() {
	CDeletionCommand(m_view, CDeletionCommand::PREVIOUS_CHARACTER).Execute();
	return S_OK;
}

/// @see	ITextEditor::BeginEditCollection
STDMETHODIMP CTextEditor::BeginEditCollection() {
	m_view.GetDocument().BeginEditCollection();
	return S_OK;
}

/// @see	ITextEditor::BookmarkAll
STDMETHODIMP CTextEditor::BookmarkAll(BSTR bstrPattern, ISearchOptions* pOptions /* = 0 */, long* pnCount /* = 0 */) {
	GENERATE_NATIVE_SEARCH_OPTIONS();
	m_view.GetTextSearcher().SetOptions(options);
	m_view.GetTextSearcher().SetSearchText(bstrPattern);
	const ulong	c = CFindAllCommand(m_view, CFindAllCommand::BOOKMARK, false).Execute();
	if(pnCount != 0)
		*pnCount = static_cast<long>(c);
	return S_OK;
}

/// @see	ITextEditor::ClearAllBookmarks
STDMETHODIMP CTextEditor::ClearAllBookmarks() {
	CBookmarkCommand(m_view, CBookmarkCommand::CLEAR_ALL).Execute();
	return S_OK;
}

/// @see	ITextEditor::ClearUndoBuffer
STDMETHODIMP CTextEditor::ClearUndoBuffer() {
	m_view.GetDocument().ClearUndoBuffer();
	return S_OK;
}

/// @see	ITextEditor::CreateEditPoint
STDMETHODIMP CTextEditor::CreateEditPoint(ITextPoint* pTextPoint, IEditPoint** ppEditPoint) {
	if(ppEditPoint != 0) {
		if(pTextPoint == 0)
			return E_INVALIDARG;

		CVisualPoint*	p = m_view.GetDocument().CreateEditPoint();
		if(*ppEditPoint = new CTextPoint(*p, true)) {
			long	iLine, iChar;
			(*ppEditPoint)->AddRef();
			pTextPoint->get_Line(&iLine);
			pTextPoint->get_Char(&iChar);
			(*ppEditPoint)->MoveTo(iLine, iChar);
		} else {
			delete p;
			return E_OUTOFMEMORY;
		}

	}
	return S_OK;
}

/// @see	ITextEditor::CreateSearchOptions
STDMETHODIMP CTextEditor::CreateSearchOptions(ISearchOptions** ppOptions) {
	if(ppOptions == 0)
		return S_OK;
	else if(*ppOptions = new CSearchOptions) {
		(*ppOptions)->AddRef();
		return S_OK;
	} else
		return E_OUTOFMEMORY;
}

/// @see	ITextEditor::Delete
STDMETHODIMP CTextEditor::Delete() {
	CDeletionCommand(m_view, CDeletionCommand::NEXT_CHARACTER).Execute();
	return S_OK;
}

/// @see	ITextEditor::EndEditCollection
STDMETHODIMP CTextEditor::EndEditCollection() {
	m_view.GetDocument().EndEditCollection();
	return S_OK;
}

/// @see	ITextEditor::FindNext
STDMETHODIMP CTextEditor::FindNext(BSTR bstrPattern, ISearchOptions* pOptions /* = 0 */, VARIANT_BOOL* pbFound /* = 0 */) {
	if(isEmptyBSTR(bstrPattern))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	m_view.GetTextSearcher().SetOptions(options);
	m_view.GetTextSearcher().SetSearchText(bstrPattern);

	CFindNextCommand	command(m_view, false, true);
	const bool	bFound = toBoolean(command.Execute());
	if(!bFound) {
		if(command.GetLastResult().IsBadRegexError()) {
			CComException	e(SCRIPT_E_BADREGEXP, IID_ITextEditor, OLESTR("Ambient.TextEditor.FindNext"));
			e.ThrowLogicalThreadError();
			return e.GetSCode();
		} else if(command.GetLastResult().GetCode() != CSearchError::MIGEMO_ERROR)
			return E_OUTOFMEMORY;
		else
			return E_FAIL;
	}
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

/// @see	ITextEditor::FindPrev
STDMETHODIMP CTextEditor::FindPrev(BSTR bstrPattern, ISearchOptions* pOptions /* = 0 */, VARIANT_BOOL* pbFound /* = 0 */) {
	if(isEmptyBSTR(bstrPattern))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	m_view.GetTextSearcher().SetOptions(options);
	m_view.GetTextSearcher().SetSearchText(bstrPattern);

	CFindNextCommand	command(m_view, false, false);
	const bool	bFound = toBoolean(command.Execute());
	if(!bFound) {
		if(command.GetLastResult().IsBadRegexError()) {
			CComException	e(SCRIPT_E_BADREGEXP, IID_ITextEditor, OLESTR("Ambient.TextEditor.FindPrev"));
			e.ThrowLogicalThreadError();
			return e.GetSCode();
		} else if(command.GetLastResult().GetCode() != CSearchError::MIGEMO_ERROR)
			return E_OUTOFMEMORY;
		else
			return E_FAIL;
	}
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

/// @see	ITextEditor::Freeze
STDMETHODIMP CTextEditor::Freeze() {
	m_view.Freeze();
	return S_OK;
}

/// @see	ITextEditor::get_Buffer
STDMETHODIMP CTextEditor::get_Buffer(IBuffer** ppBuffer) {
	return m_view.GetDocument().GetAutomation(m_app, ppBuffer);
}

/// @see	ITextEditor::get_ClipboardRing
STDMETHODIMP CTextEditor::get_ClipboardRing(IClipboardRing** ppClipboardRing) {
	VERIFY_POINTER(ppClipboardRing);

	if(0 == (*ppClipboardRing = new Ambient::CClipboardRing(CEditView::GetClipboardRing())))
		return E_OUTOFMEMORY;
	(*ppClipboardRing)->AddRef();
	return S_OK;
}

/// @see	ITextEditor::get_CollectingEdit
STDMETHODIMP CTextEditor::get_CollectingEdit(VARIANT_BOOL* pbCollecting) {
	VERIFY_POINTER(pbCollecting);
	*pbCollecting = toVariantBoolean(m_view.GetDocument().IsCollectingEdit());
	return S_OK;
}

/// @see	ITextEditor::get_Lexer
STDMETHODIMP CTextEditor::get_Lexer(ILexer** ppLexer) {
	return m_view.GetAutomation(ppLexer);
}

/// @see	ITextEditor::get_OvertypeMode
STDMETHODIMP CTextEditor::get_OvertypeMode(VARIANT_BOOL* pbOvertypeMode) {
	VERIFY_POINTER(pbOvertypeMode);
	*pbOvertypeMode = toVariantBoolean(m_view.IsOvertypeMode());
	return S_OK;
}

/// @see	ITextEditor::get_Preferences
STDMETHODIMP CTextEditor::get_Preferences(IEditorPreferences** ppPreferences) {
	return m_view.GetAutomation(ppPreferences);
}

/// @see	ITextEditor::get_Selection
STDMETHODIMP CTextEditor::get_Selection(ITextSelection** ppSelection) {
	return m_view.GetAutomation(ppSelection);
}

/// @see	ITextEditor::InputChar
STDMETHODIMP CTextEditor::InputChar(VARIANT ch, VARIANT_BOOL* pbSucceeded) {
	bool	bSucceeded = true;

	if(pbSucceeded != 0)
		*pbSucceeded = VARIANT_FALSE;
	if(ch.vt == VT_I4)	// R[h|Cgɂ
		bSucceeded = toBoolean(StandardCommands::CCharacterInputCommand(m_view, ch.lVal).Execute());
	else if(ch.vt == VT_BSTR) {	// UTF-16 ɂ
		if(ch.bstrVal == 0)
			return E_INVALIDARG;
		if(const UINT cch = ::SysStringLen(ch.bstrVal)) {
			size_t	i = 0;
			for(; i < cch; ++i) {
				const CodePoint	cp = DecodeUtf16SurrogatesToCodePoint(ch.bstrVal + i, cch - i);

				if(CBoundarySearcher::IsGraphemeBase(cp)) {
					if(i != 0)
						break;
				} else if(i == 0) {
					i += (cp < 0x010000) ? 1 : 2;
					break;
				}
				if(cp > 0xFFFF)
					++i;
			}
			for(size_t j = 0; j < i; ++j) {
				if(!toBoolean(StandardCommands::CCharacterInputCommand(m_view, ch.bstrVal[j]).Execute()))
					break;
			}
		} else
			return E_INVALIDARG;
	} else
		return E_INVALIDARG;
	if(pbSucceeded != 0 && bSucceeded)
		*pbSucceeded = toVariantBoolean(bSucceeded);
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CTextEditor::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTEDITOR_BUFFER:			CALL_GETTER_ACTX(Buffer, IBuffer);
		case DISPID_TEXTEDITOR_CLIPBOARDRING:	CALL_GETTER_ACTX(ClipboardRing, IClipboardRing);
		case DISPID_TEXTEDITOR_COLLECTINGEDIT:	CALL_GETTER(CollectingEdit, VT_BOOL);
		case DISPID_TEXTEDITOR_LEXER:			CALL_GETTER_ACTX(Lexer, ILexer);
		case DISPID_TEXTEDITOR_OVERTYPEMODE:	CALL_GETTER(OvertypeMode, VT_BOOL);
		case DISPID_TEXTEDITOR_PREFERENCES:		CALL_GETTER_ACTX(Preferences, IEditorPreferences);
		case DISPID_TEXTEDITOR_SELECTION:		CALL_GETTER_ACTX(Selection, ITextSelection);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_TEXTEDITOR_OVERTYPEMODE:	CALL_PUTTER(OvertypeMode, VT_BOOL);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTEDITOR_BACKSPACE:			CALL_METHOD_0(BackSpace);
		case DISPID_TEXTEDITOR_BEGINEDITCOLLECTION:	CALL_METHOD_0(BeginEditCollection);
		case DISPID_TEXTEDITOR_CLEARALLBOOKMARKS:	CALL_METHOD_0(ClearAllBookmarks);
		case DISPID_TEXTEDITOR_CLEARUNDOBUFFER:		CALL_METHOD_0(ClearUndoBuffer);
		case DISPID_TEXTEDITOR_CREATEEDITPOINT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_DISPATCH);
			return CreateEditPoint(
				reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? reinterpret_cast<IEditPoint**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTEDITOR_CREATESEARCHOPTIONS:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_DISPATCH);
			return CreateSearchOptions((pVarResult != 0) ? reinterpret_cast<ISearchOptions**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTEDITOR_DELETE:				CALL_METHOD_0(Delete);
		case DISPID_TEXTEDITOR_ENDEDITCOLLECTION:	CALL_METHOD_0(EndEditCollection);
		case DISPID_TEXTEDITOR_FINDNEXT:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = FindNext(args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_DISPATCH);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = FindNext(args[1].bstrVal,
						reinterpret_cast<ISearchOptions*>(args[0].pdispVal), (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTEDITOR_FINDPREV:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = FindPrev(args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_DISPATCH);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = FindPrev(args[1].bstrVal,
						reinterpret_cast<ISearchOptions*>(args[0].pdispVal), (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTEDITOR_FREEZE:					CALL_METHOD_0(Freeze);
		case DISPID_TEXTEDITOR_INPUTCHAR:				CALL_METHOD_RET_1(InputChar, VT_BOOL, VT_VARIANT);
		case DISPID_TEXTEDITOR_NEWLINE:					CALL_METHOD_0(NewLine);
		case DISPID_TEXTEDITOR_PASTE:					CALL_METHOD_0(Paste);
		case DISPID_TEXTEDITOR_PASTEFROMCLIPBOARDRING:	CALL_METHOD_0(PasteFromClipboardRing);
		case DISPID_TEXTEDITOR_REDO:					CALL_METHOD_0(Redo);
		case DISPID_TEXTEDITOR_REPLACEALL:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				if(FAILED(hr = ReplaceAll(args[0].bstrVal, 0, 0, (pVarResult != 0) ? &pVarResult->lVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				if(FAILED(hr = ReplaceAll(args[1].bstrVal, args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->lVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_DISPATCH);
				COERCE_RETURN(VT_I4);
				if(FAILED(hr = ReplaceAll(args[2].bstrVal, args[1].bstrVal,
						reinterpret_cast<ISearchOptions*>(args[0].pdispVal), (pVarResult != 0) ? &pVarResult->lVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			}
		case DISPID_TEXTEDITOR_REPLACEANDNEXT:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = ReplaceAndNext(args[0].bstrVal, 0, 0, (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = ReplaceAndNext(args[1].bstrVal, args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_DISPATCH);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = ReplaceAndNext(args[2].bstrVal, args[1].bstrVal,
						reinterpret_cast<ISearchOptions*>(args[0].pdispVal), (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			}
		case DISPID_TEXTEDITOR_REPLACEANDPREV:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = ReplaceAndPrev(args[0].bstrVal, 0, 0, (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = ReplaceAndPrev(args[1].bstrVal, args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_DISPATCH);
				COERCE_RETURN(VT_BOOL);
				if(FAILED(hr = ReplaceAndPrev(args[2].bstrVal, args[1].bstrVal,
						reinterpret_cast<ISearchOptions*>(args[0].pdispVal), (pVarResult != 0) ? &pVarResult->boolVal : 0)))
					RETURN_WITH_EXCEPTION();
				return hr;
			}
		case DISPID_TEXTEDITOR_UNDO:					CALL_METHOD_0(Undo);
		case DISPID_TEXTEDITOR_UNFREEZE:				CALL_METHOD_0(Unfreeze);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	ITextEditor::NewLine
STDMETHODIMP CTextEditor::NewLine() {
	CLineBreakCommand(m_view, false).Execute();
	return S_OK;
}

/// @see	ITextEditor::Paste
STDMETHODIMP CTextEditor::Paste() {
	CClipboardCommand(m_view, CClipboardCommand::PASTE, false).Execute();
	return S_OK;
}

/// @see	ITextEditor::PasteFromClipboardRing
STDMETHODIMP CTextEditor::PasteFromClipboardRing() {
	CClipboardCommand(m_view, CClipboardCommand::PASTE, true).Execute();
	return S_OK;
}

/// @see	ITextEditor::put_OvertypeMode
STDMETHODIMP CTextEditor::put_OvertypeMode(VARIANT_BOOL bOvertypeMode) {
	m_view.SetOvertypeMode(toBoolean(bOvertypeMode));
	return S_OK;
}

/// @see	ITextEditor::Redo
STDMETHODIMP CTextEditor::Redo() {
	CUndoCommand(m_view, false).Execute();
	return S_OK;
}

/// @see	ITextEditor::ReplaceAll
STDMETHODIMP CTextEditor::ReplaceAll(BSTR bstrFindWhat,
		BSTR bstrReplaceWith /* = 0 */, ISearchOptions* pOptions /* = 0 */, long* pnCount) {
	if(isEmptyBSTR(bstrFindWhat))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	m_view.GetTextSearcher().SetOptions(options);
	m_view.GetTextSearcher().SetSearchText(bstrFindWhat);
	m_view.GetTextSearcher().SetReplaceText(SAFE_BSTR(bstrReplaceWith));
	const ulong	c = CFindAllCommand(m_view, CFindAllCommand::REPLACE, false).Execute();
	if(pnCount != 0)
		*pnCount = static_cast<long>(c);
	return S_OK;
}

/// @see	ITextEditor::ReplaceAndNext
STDMETHODIMP CTextEditor::ReplaceAndNext(BSTR bstrFindWhat,
		BSTR bstrReplaceWith /* = 0 */, ISearchOptions* pOptions /* = 0 */, VARIANT_BOOL* pbFound /* = 0 */) {
	if(isEmptyBSTR(bstrFindWhat))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	m_view.GetTextSearcher().SetOptions(options);
	m_view.GetTextSearcher().SetSearchText(bstrFindWhat);
	m_view.GetTextSearcher().SetReplaceText(SAFE_BSTR(bstrReplaceWith));
	const bool	bFound = toBoolean(CFindNextCommand(m_view, true, true).Execute());
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

/// @see	ITextEditor::ReplaceAndPrev
STDMETHODIMP CTextEditor::ReplaceAndPrev(BSTR bstrFindWhat,
		BSTR bstrReplaceWith /* = 0 */, ISearchOptions* pOptions /* = 0 */, VARIANT_BOOL* pbFound /* = 0 */) {
	if(isEmptyBSTR(bstrFindWhat))
		return E_INVALIDARG;

	GENERATE_NATIVE_SEARCH_OPTIONS();
	m_view.GetTextSearcher().SetOptions(options);
	m_view.GetTextSearcher().SetSearchText(bstrFindWhat);
	m_view.GetTextSearcher().SetReplaceText(SAFE_BSTR(bstrReplaceWith));
	const bool	bFound = toBoolean(CFindNextCommand(m_view, true, false).Execute());
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

/// @see	ITextEditor::Undo
STDMETHODIMP CTextEditor::Undo() {
	m_view.GetDocument().Undo();
	return S_OK;
}

/// @see	ITextEditor::Unfreeze
STDMETHODIMP CTextEditor::Unfreeze() {
	m_view.Unfreeze();
	return S_OK;
}


// CTextSelection class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextSelection::CTextSelection(CAlphaView& view) : SAFE_MARK, m_view(view) {
}

/// @see	ITextSelection::Cancel
STDMETHODIMP CTextSelection::Cancel() {
	CCancelCommand(m_view).Execute();
	return S_OK;
}

/// @see	ITextSelection::CharNext
STDMETHODIMP CTextSelection::CharNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return CharPrev(bExtend, -cOffset);
	CCaretMovementCommand(m_view, CCaretMovementCommand::NEXT_CHARACTER, toBoolean(bExtend), cOffset);
	return S_OK;
}

/// @see	ITextSelection::CharPrev
STDMETHODIMP CTextSelection::CharPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return CharNext(bExtend, -cOffset);
	CCaretMovementCommand(m_view, CCaretMovementCommand::PREVIOUS_CHARACTER, toBoolean(bExtend), cOffset);
	return S_OK;
}

/// @see	ITextSelection::Convert
STDMETHODIMP CTextSelection::Convert(ConvertType ct) {
	return E_NOTIMPL;
}

/// @see	ITextSelection::Copy
STDMETHODIMP CTextSelection::Copy(VARIANT_BOOL bAlsoSendToClipboardRing /* = VARIANT_TRUE */) {
	CClipboardCommand(m_view, CClipboardCommand::COPY, toBoolean(bAlsoSendToClipboardRing));
	return S_OK;
}

/// @see	ITextSelection::Cut
STDMETHODIMP CTextSelection::Cut(VARIANT_BOOL bAlsoSendToClipboardRing /* = VARIANT_TRUE */) {
	CClipboardCommand(m_view, CClipboardCommand::CUT, toBoolean(bAlsoSendToClipboardRing));
	return S_OK;
}

/// @see	ITextSelection::get_ActiveEndGreater
STDMETHODIMP CTextSelection::get_ActiveEndGreater(VARIANT_BOOL* pbActiveEndGreater) {
	VERIFY_POINTER(pbActiveEndGreater);
	*pbActiveEndGreater =
		toVariantBoolean(m_view.GetSelection().GetAnchorPoint() < m_view.GetSelection().GetActivePoint());
	return S_OK;
}

/// @see	ITextSelection::get_ActivePoint
STDMETHODIMP CTextSelection::get_ActivePoint(ITextPoint** ppActivePoint) {
	VERIFY_POINTER(ppActivePoint);

	CVisualPoint*	p = m_view.GetDocument().CreateEditPoint();

	p->MoveTo(m_view.GetSelection().GetActivePoint());
	if(*ppActivePoint = new CTextPoint(*p, false)) {
		(*ppActivePoint)->AddRef();
		return S_OK;
	} else {
		delete p;
		return E_OUTOFMEMORY;
	}
}

/// @see	ITextSelection::get_AnchorPoint
STDMETHODIMP CTextSelection::get_AnchorPoint(ITextPoint** ppAnchorPoint) {
	VERIFY_POINTER(ppAnchorPoint);

	CVisualPoint*	p = m_view.GetDocument().CreateEditPoint();

	p->MoveTo(m_view.GetSelection().GetAnchorPoint());
	if(*ppAnchorPoint = new CTextPoint(*p, false)) {
		(*ppAnchorPoint)->AddRef();
		return S_OK;
	} else {
		delete p;
		return E_OUTOFMEMORY;
	}
}

/// @see	ITextSelection::get_BottomPoint
STDMETHODIMP CTextSelection::get_BottomPoint(ITextPoint** ppBottomPoint) {
	VERIFY_POINTER(ppBottomPoint);

	CVisualPoint*	p = m_view.GetDocument().CreateEditPoint();

	p->MoveTo(m_view.GetSelection().GetEndPoint());
	if(*ppBottomPoint = new CTextPoint(*p, false)) {
		(*ppBottomPoint)->AddRef();
		return S_OK;
	} else {
		delete p;
		return E_OUTOFMEMORY;
	}
}

/// @see	ITextSelection::get_Empty
STDMETHODIMP CTextSelection::get_Empty(VARIANT_BOOL* pbEmpty) {
	VERIFY_POINTER(pbEmpty);
	*pbEmpty = toVariantBoolean(m_view.GetSelection().IsEmpty());
	return S_OK;
}

/// @see	ITextSelection::get_Text
STDMETHODIMP CTextSelection::get_Text(BSTR* pbstrText) {
	VERIFY_POINTER(pbstrText);
	*pbstrText = ::SysAllocString(m_view.GetSelection().GetText().c_str());
	return (*pbstrText != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	ITextSelection::get_TextRanges
STDMETHODIMP CTextSelection::get_TextRanges(ITextRanges** ppTextRanges) {
	VERIFY_POINTER(ppTextRanges);
	*ppTextRanges = 0;
	return E_NOTIMPL;
}

/// @see	ITextSelection::get_TopPoint
STDMETHODIMP CTextSelection::get_TopPoint(ITextPoint** ppTopPoint) {
	VERIFY_POINTER(ppTopPoint);

	CVisualPoint*	p = m_view.GetDocument().CreateEditPoint();

	p->MoveTo(m_view.GetSelection().GetStartPoint());
	if(*ppTopPoint = new CTextPoint(*p, false)) {
		(*ppTopPoint)->AddRef();
		return S_OK;
	} else {
		delete p;
		return E_OUTOFMEMORY;
	}
}

/// @see	ITextSelection::Indent
STDMETHODIMP CTextSelection::Indent() {
	CIndentationCommand(m_view, true, true, 1).Execute();
	return S_OK;
}

/// @see	IDispatch::Invoke
STDMETHODIMP CTextSelection::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_ACTIVEENDGREATER:	CALL_GETTER(ActiveEndGreater, VT_BOOL);
		case DISPID_TEXTSELECTION_ACTIVEPOINT:		CALL_GETTER_ACTX(ActivePoint, ITextPoint);
		case DISPID_TEXTSELECTION_ANCHORPOINT:		CALL_GETTER_ACTX(AnchorPoint, ITextPoint);
		case DISPID_TEXTSELECTION_BOTTOMPOINT:		CALL_GETTER_ACTX(BottomPoint, ITextPoint);
		case DISPID_TEXTSELECTION_EMPTY:			CALL_GETTER(Empty, VT_BOOL);
		case DISPID_TEXTSELECTION_TEXT:				CALL_GETTER(Text, VT_BSTR);
		case DISPID_TEXTSELECTION_TEXTRANGES:		CALL_GETTER_ACTX(TextRanges, ITextRanges);
		case DISPID_TEXTSELECTION_TOPPOINT:			CALL_GETTER_ACTX(TopPoint, ITextPoint);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_CANCEL:		CALL_METHOD_0(Cancel);
		case DISPID_TEXTSELECTION_CHARNEXT:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(CharNext);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(CharNext, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(CharNext, VT_BOOL, VT_I4);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CHARPREV:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(CharPrev);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(CharPrev, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(CharPrev, VT_BOOL, VT_I4);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CONVERT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return Convert(static_cast<ConvertType>(args[0].lVal));
		case DISPID_TEXTSELECTION_COPY:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(Copy);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(Copy, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CUT:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(Cut);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(Cut, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_INDENT:		CALL_METHOD_0(Indent);
		case DISPID_TEXTSELECTION_LINEDOWN:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(LineDown);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(LineDown, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(LineDown, VT_BOOL, VT_I4);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_LINEUP:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(LineUp);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(LineUp, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(LineUp, VT_BOOL, VT_I4);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETO:
			if(pDispParams->cArgs == 2) {		CALL_METHOD_2(MoveTo, VT_UI4, VT_UI4);}
			else if(pDispParams->cArgs == 3) {	CALL_METHOD_3(MoveTo, VT_UI4, VT_UI4, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOENDOFDOCUMENT:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToEndOfDocument);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToEndOfDocument, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOENDOFLINE:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToEndOfLine);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToEndOfLine, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOFIRSTCHAROFLINE:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToFirstCharOfLine);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToFirstCharOfLine, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOLASTCHAROFLINE:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToLastCharOfLine);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToLastCharOfLine, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOMATCHBRACKET:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToMatchBracket);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToMatchBracket, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETONEXTBOOKMARK:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToNextBookmark);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToNextBookmark, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOPREVIOUSBOOKMARK:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToPreviousBookmark);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToPreviousBookmark, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOSTARTOFDOCUMENT:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToStartOfDocument);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToStartOfDocument, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOSTARTOFLINE:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(MoveToStartOfLine);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(MoveToStartOfLine, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(MoveToStartOfLine, VT_BOOL, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEDOWN:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(PageDown);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(PageDown, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(PageDown, VT_BOOL, VT_I4);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEUP:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(PageUp);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(PageUp, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(PageUp, VT_BOOL, VT_I4);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PASTE:					CALL_METHOD_0(Paste);
		case DISPID_TEXTSELECTION_PASTEFROMCLIPBOARDRING:	CALL_METHOD_0(PasteFromClipboardRing);
		case DISPID_TEXTSELECTION_REPLACE:					CALL_METHOD_1(Replace, VT_BSTR);
		case DISPID_TEXTSELECTION_SELECTALL:				CALL_METHOD_0(SelectAll);
		case DISPID_TEXTSELECTION_SELECTLINE:				CALL_METHOD_1(SelectLine, VT_I4);
		case DISPID_TEXTSELECTION_SETBOOKMARK:
			if(pDispParams->cArgs == 0)	{			CALL_METHOD_0(SetBookmark);}
			else if(pDispParams->cArgs == 1)	{	CALL_METHOD_1(SetBookmark, VT_BOOL);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_SWAPANCHOR:				CALL_METHOD_0(SwapAnchor);
		case DISPID_TEXTSELECTION_UNINDENT:					CALL_METHOD_0(Unindent);
		case DISPID_TEXTSELECTION_WORDENDNEXT:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(WordEndNext);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(WordEndNext, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(WordEndNext, VT_BOOL, VT_I4);}
			else return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDENDPREV:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(WordEndPrev);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(WordEndPrev, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(WordEndPrev, VT_BOOL, VT_I4);}
		case DISPID_TEXTSELECTION_WORDNEXT:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(WordNext);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(WordNext, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(WordNext, VT_BOOL, VT_I4);}
		case DISPID_TEXTSELECTION_WORDPREV:
			if(pDispParams->cArgs == 0) {		CALL_METHOD_0(WordPrev);}
			else if(pDispParams->cArgs == 1) {	CALL_METHOD_1(WordPrev, VT_BOOL);}
			else if(pDispParams->cArgs == 2) {	CALL_METHOD_2(WordPrev, VT_BOOL, VT_I4);}
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	ITextSelection::LineDown
STDMETHODIMP CTextSelection::LineDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineUp(bExtend, -cLines);
	CCaretMovementCommand(m_view, CCaretMovementCommand::NEXT_LINE, toBoolean(bExtend), cLines).Execute();
	return S_OK;
}

/// @see	ITextSelection::LineUp
STDMETHODIMP CTextSelection::LineUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineDown(bExtend, -cLines);
	CCaretMovementCommand(m_view, CCaretMovementCommand::PREVIOUS_LINE, toBoolean(bExtend), cLines).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveTo
STDMETHODIMP CTextSelection::MoveTo(long iLine, long iChar, VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	if(toBoolean(bExtend))
		m_view.GetSelection().GetActivePoint().MoveTo(CCharPos(iLine, iChar));
	else
		m_view.GetSelection().MoveTo(CCharPos(iLine, iChar), false);
	return S_OK;
}

/// @see	ITextSelection::MoveToEndOfDocument
STDMETHODIMP CTextSelection::MoveToEndOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::END_OF_DOCUMENT, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToEndOfLine
STDMETHODIMP CTextSelection::MoveToEndOfLine(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::END_OF_LINE, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToFirstCharOfLine
STDMETHODIMP CTextSelection::MoveToFirstCharOfLine(VARIANT_BOOL bExtend /* VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::FIRST_CHAR_OF_LINE, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToLastCharOfLine
STDMETHODIMP CTextSelection::MoveToLastCharOfLine(VARIANT_BOOL bExtend /* VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::LAST_CHAR_OF_LINE, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToMatchBracket
STDMETHODIMP CTextSelection::MoveToMatchBracket(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::MATCH_BRACKET, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToNextBookmark
STDMETHODIMP CTextSelection::MoveToNextBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::NEXT_BOOKMARK, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToPreviousBookmark
STDMETHODIMP CTextSelection::MoveToPreviousBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::PREVIOUS_BOOKMARK, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToStartOfDocument
STDMETHODIMP CTextSelection::MoveToStartOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::START_OF_DOCUMENT, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::MoveToStartOfLine
STDMETHODIMP CTextSelection::MoveToStartOfLine(
		VARIANT_BOOL bToFirstText /* = VARIANT_FALSE */, VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	CCaretMovementCommand(m_view, CCaretMovementCommand::START_OF_LINE, toBoolean(bExtend)).Execute();
	return S_OK;
}

/// @see	ITextSelection::PageDown
STDMETHODIMP CTextSelection::PageDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageUp(bExtend, cPages);
	CCaretMovementCommand(m_view, CCaretMovementCommand::NEXT_PAGE, toBoolean(bExtend), cPages).Execute();
	return S_OK;
}

/// @see	ITextSelection::PageUp
STDMETHODIMP CTextSelection::PageUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageDown(bExtend, cPages);
	CCaretMovementCommand(m_view, CCaretMovementCommand::PREVIOUS_PAGE, toBoolean(bExtend), cPages).Execute();
	return S_OK;
}

/// @see	ITextSelection::Paste
STDMETHODIMP CTextSelection::Paste() {
	CClipboardCommand(m_view, CClipboardCommand::PASTE, false).Execute();
	return S_OK;
}

/// @see	ITextSelection::PasteFromClipboardRing
STDMETHODIMP CTextSelection::PasteFromClipboardRing() {
	CClipboardCommand(m_view, CClipboardCommand::PASTE, true).Execute();
	return S_OK;
}

/// @see	ITextSelection::Replace
STDMETHODIMP CTextSelection::Replace(BSTR bstrText) {
	m_view.GetSelection().Replace((bstrText != 0) ? bstrText : L"");
	return S_OK;
}

/// @see	ITextSelection::SelectAll
STDMETHODIMP CTextSelection::SelectAll() {
	CSelectionCreationCommand(m_view, CSelectionCreationCommand::ALL).Execute();
	return S_OK;
}

/// @see	ITextSelection::SelectLine
STDMETHODIMP CTextSelection::SelectLine(long iLine) {
	m_view.GetSelection().Select(CCharPos(iLine, 0), CCharPos(iLine, -1), false, true);
	return S_OK;
}

/// @see	ITextSelection::SetBookmark
STDMETHODIMP CTextSelection::SetBookmark(VARIANT_BOOL bSet /* = VARIANT_TRUE */) {
	m_view.GetBookmarker().SetBookmark(m_view.GetSelection().GetActivePoint().GetLineNumber(), toBoolean(bSet));
	return S_OK;
}

/// @see	ITextSelection::SwapAnchor
STDMETHODIMP CTextSelection::SwapAnchor() {
	CSelection&	selection = m_view.GetSelection();
	selection.Select(selection.GetActivePoint(), selection.GetAnchorPoint(), selection.IsRectangle(), true);
	return S_OK;
}

/// @see	ITextSelection::Tabify
STDMETHODIMP CTextSelection::Tabify() {
	CTabifyCommand(m_view, true).Execute();
	return S_OK;
}

/// @see	ITextSelection::Unindent
STDMETHODIMP CTextSelection::Unindent() {
	CIndentationCommand(m_view, false, true, 1).Execute();
	return S_OK;
}

/// @see	ITextSelection::Untabify
STDMETHODIMP CTextSelection::Untabify() {
	CTabifyCommand(m_view, false).Execute();
	return S_OK;
}

/// @see	ITextSelection::WordEndNext
STDMETHODIMP CTextSelection::WordEndNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndPrev(bExtend, -cWords);
	CCaretMovementCommand(m_view, CCaretMovementCommand::NEXT_WORDEND, toBoolean(bExtend), cWords);
	return S_OK;
}

/// @see	ITextSelection::WordEndPrev
STDMETHODIMP CTextSelection::WordEndPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndNext(bExtend, -cWords);
	CCaretMovementCommand(m_view, CCaretMovementCommand::PREVIOUS_WORDEND, toBoolean(bExtend), cWords);
	return S_OK;
}

/// @see	ITextSelection::WordNext
STDMETHODIMP CTextSelection::WordNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordPrev(bExtend, -cWords);
	CCaretMovementCommand(m_view, CCaretMovementCommand::NEXT_WORD, toBoolean(bExtend), cWords);
	return S_OK;
}

/// @see	ITextSelection::WordPrev
STDMETHODIMP CTextSelection::WordPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordNext(bExtend, -cWords);
	CCaretMovementCommand(m_view, CCaretMovementCommand::PREVIOUS_WORD, toBoolean(bExtend), cWords);
	return S_OK;
}


// CTextPoint class implementation
/////////////////////////////////////////////////////////////////////////////

#define VERIFY_IMPL()				\
	if(m_pos.IsDocumentDisposed())	\
		return E_UNEXPECTED

/**
 *	RXgN^
 *	@param pos			ɂȂҏW_B̕ҏW_̓fXgN^Ŕj󂷂
 *	@param bIsEditPoint	IEditPoint ̏ꍇ trueBITextPoint ̏ꍇ false
 */
CTextPoint::CTextPoint(CVisualPoint& pos, bool bIsEditPoint) : SAFE_MARK, m_pos(pos), m_bIsEditPoint(bIsEditPoint) {
}

/// fXgN^
CTextPoint::~CTextPoint() {
	delete &m_pos;
}

/// @see	ITextPoint::Center
STDMETHODIMP CTextPoint::Center(VARIANT varOther, VARIANT_BOOL* pbInEditorRect) {
	VERIFY_IMPL();

	VARIANT	var;
	HRESULT	hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*pbInEditorRect = m_pos.Center(m_pos.GetDocument()->GetActiveView(), CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4))) {
		if(pbInEditorRect != 0)
			*pbInEditorRect = m_pos.Center(m_pos.GetDocument()->GetActiveView(), var.lVal);
	} else
		return hr;
	return S_OK;
}

/// @see	ITextPoint::CharNext
STDMETHODIMP CTextPoint::CharNext(long cch /* = 1 */) {
	VERIFY_IMPL();
	m_pos.CharNext(cch);
	return S_OK;
}

/// @see	ITextPoint::CharRight
STDMETHODIMP CTextPoint::CharPrev(long cch /* = 1 */) {
	VERIFY_IMPL();
	m_pos.CharPrev(cch);
	return S_OK;
}

/// @see	IEditPoint::Convert
STDMETHODIMP CTextPoint::Convert(ConvertType ct, VARIANT varOther) {
	VERIFY_IMPL();

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Convert(CCharPos(iLine, iChar), static_cast<RangeConvertType>(ct));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Convert(var.lVal, static_cast<RangeConvertType>(ct));
	else
		return hr;
	return S_OK;
}

/// @see	ITextPoint::Copy
STDMETHODIMP CTextPoint::Copy(VARIANT varOther) {
	VERIFY_IMPL();

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Copy(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Copy(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see	ITextPoint::CreateEditPoint
STDMETHODIMP CTextPoint::CreateEditPoint(IEditPoint** ppEditPoint) {
	VERIFY_IMPL();
	if(ppEditPoint != 0) {
		*ppEditPoint = new CTextPoint(*m_pos.GetDocument()->CreateEditPoint(), true);
		(*ppEditPoint)->AddRef();
		(*ppEditPoint)->MoveTo(m_pos.GetLineNumber(), m_pos.GetCharNumber());
	}
	return S_OK;
}

/// @see	IEditPoint::Cut
STDMETHODIMP CTextPoint::Cut(VARIANT varOther) {
	VERIFY_IMPL();

	CComVariant	var;
	HRESULT		hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Cut(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Cut(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see	IEditPoint::Delete
STDMETHODIMP CTextPoint::Delete(VARIANT varOther) {
	VERIFY_IMPL();

	CComVariant	var;
	HRESULT		hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Delete(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Delete(var.lVal);
	else
		return hr;
	return S_OK;
}

/// @see	IEditPoint:DestructiveInsert
STDMETHODIMP CTextPoint::DestructiveInsert(BSTR bstrText) {
	VERIFY_IMPL();
	m_pos.DestructiveInsert(bstrText);
	return S_OK;
}

/// @see	ITextPoint::EqualTo
STDMETHODIMP CTextPoint::EqualTo(ITextPoint* pTextPoint, VARIANT_BOOL* pbEqual) {
	VERIFY_IMPL();
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbEqual != 0) {
		long	iLine, iChar;

		pTextPoint->get_Line(&iLine);
		pTextPoint->get_Char(&iChar);
		*pbEqual = toVariantBoolean(
			m_pos.GetLineNumber() == iLine && m_pos.GetCharNumber() == iChar);
	}
	return S_OK;
}

/// @see	ITextPoint::get_AbsoluteCharOffset
STDMETHODIMP CTextPoint::get_AbsoluteCharOffset(long* pnAbsoluteCharOffset) {
	VERIFY_IMPL();
	VERIFY_POINTER(pnAbsoluteCharOffset);
	*pnAbsoluteCharOffset = m_pos.GetAbsoluteCharOffset();
	return S_OK;
}

/// @see	ITextPoint::get_AtEndOfDocument
STDMETHODIMP CTextPoint::get_AtEndOfDocument(VARIANT_BOOL* pbAtEndOfDocument) {
	VERIFY_IMPL();
	VERIFY_POINTER(pbAtEndOfDocument);
	*pbAtEndOfDocument = toVariantBoolean(m_pos.IsEndOfDocument());
	return S_OK;
}

/// @see	ITextPoint::get_AtEndOfLine
STDMETHODIMP CTextPoint::get_AtEndOfLine(VARIANT_BOOL* pbAtEndOfLine) {
	VERIFY_IMPL();
	VERIFY_POINTER(pbAtEndOfLine);
	*pbAtEndOfLine = toVariantBoolean(m_pos.IsEndOfLine());
	return S_OK;
}

/// @see	ITextPoint::get_AtFirstCharOfLine
STDMETHODIMP CTextPoint::get_AtFirstCharOfLine(VARIANT_BOOL* pbAsFirstCharOfLine) {
	VERIFY_IMPL();
	VERIFY_POINTER(pbAsFirstCharOfLine);
	*pbAsFirstCharOfLine = toVariantBoolean(m_pos.IsFirstCharOfLine());
	return S_OK;
}

/// @see	ITextPoint::get_AtLastCharOfLine
STDMETHODIMP CTextPoint::get_AtLastCharOfLine(VARIANT_BOOL* pbAsLastCharOfLine) {
	VERIFY_IMPL();
	VERIFY_POINTER(pbAsLastCharOfLine);
	*pbAsLastCharOfLine = toVariantBoolean(m_pos.IsLastCharOfLine());
	return S_OK;
}

/// @see	ITextPoint::get_AtStartOfDocument
STDMETHODIMP CTextPoint::get_AtStartOfDocument(VARIANT_BOOL* pbAtStartOfDocument) {
	VERIFY_IMPL();
	VERIFY_POINTER(pbAtStartOfDocument);
	*pbAtStartOfDocument = toVariantBoolean(m_pos.IsStartOfDocument());
	return S_OK;
}

/// @see	ITextPoint::get_AtStartOfLine
STDMETHODIMP CTextPoint::get_AtStartOfLine(VARIANT_BOOL* pbAtStartOfLine) {
	VERIFY_IMPL();
	VERIFY_POINTER(pbAtStartOfLine);
	*pbAtStartOfLine = toVariantBoolean(m_pos.IsStartOfLine());
	return S_OK;
}

/// @see	ITextPoint::get_Char
STDMETHODIMP CTextPoint::get_Char(long* pnChar) {
	VERIFY_IMPL();
	VERIFY_POINTER(pnChar);
	*pnChar = m_pos.GetCharNumber();
	return S_OK;
}

/// @see	IEditPoint::get_CharCountConvention
STDMETHODIMP CTextPoint::get_CharCountConvention(CharCountConvention* pConvention) {
	VERIFY_IMPL();
	VERIFY_POINTER(pConvention);
	*pConvention = static_cast<CharCountConvention>(m_pos.GetCharacterCountingConvention());
	return S_OK;
}

/// @see	ITextPoint::get_Column
STDMETHODIMP CTextPoint::get_Column(long* pnColumn) {
	VERIFY_IMPL();
	VERIFY_POINTER(pnColumn);
	*pnColumn = m_pos.GetColumnNumber();
	return S_OK;
}

/// @see	ITextPoint::get_Line
STDMETHODIMP CTextPoint::get_Line(long* pnLine) {
	VERIFY_IMPL();
	VERIFY_POINTER(pnLine);
	*pnLine = m_pos.GetLineNumber();
	return S_OK;
}

/// @see	ITextPoint::get_LineLength
STDMETHODIMP CTextPoint::get_LineLength(long* pnLineLength) {
	VERIFY_IMPL();
	VERIFY_POINTER(pnLineLength);
	*pnLineLength = m_pos.GetLineLength();
	return S_OK;
}

/// @see	IEditPoint::get_RestrictionExclusive
STDMETHODIMP CTextPoint::get_RestrictionExclusive(VARIANT_BOOL* pbExclusive) {
	VERIFY_IMPL();
	VERIFY_POINTER(pbExclusive);
	*pbExclusive = toVariantBoolean(m_pos.IsExcludedFromRestriction());
	return S_OK;
}

/// @see	IEditPoint::put_CharCountConvention
STDMETHODIMP CTextPoint::put_CharCountConvention(CharCountConvention convention) {
	VERIFY_IMPL();
	m_pos.SetCharacterCountingConvention(static_cast<CEditPoint::CharacterCountingConvention>(convention));
	return S_OK;
}

/// @see	IEditPoint::put_RestrictionExclusive
STDMETHODIMP CTextPoint::put_RestrictionExclusive(VARIANT_BOOL bExclusive) {
	VERIFY_IMPL();
	m_pos.ExcludeFromRestriction(toBoolean(bExclusive));
	return S_OK;
}

/// @see	IEditPoint::GetText
STDMETHODIMP CTextPoint::GetText(VARIANT varOther, BSTR* pbstrText) {
	VERIFY_IMPL();
	if(pbstrText != 0) {
		CComVariant	var;
		HRESULT		hr;

		::VariantInit(&var);

		if(varOther.vt == VT_DISPATCH) {
			GENERATE_CHARPOS_FROM_TEXTPOINT();
			*pbstrText = ::SysAllocString(m_pos.GetText(CCharPos(iLine, iChar)).c_str());
		} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
			*pbstrText = ::SysAllocString(m_pos.GetText(var.lVal).c_str());
		else {
			*pbstrText = 0;
			return hr;
		}
	}
	return (*pbstrText != 0) ? S_OK : E_OUTOFMEMORY;
}

/// @see	ITextPoint::GreaterThan
STDMETHODIMP CTextPoint::GreaterThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbGreater) {
	VERIFY_IMPL();
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbGreater != 0) {
		unsigned long	iLine, iChar;

		pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
		if(m_pos.GetLineNumber() > iLine)
			*pbGreater = VARIANT_TRUE;
		else if(m_pos.GetLineNumber() < iLine)
			*pbGreater = VARIANT_FALSE;
		else {
			pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
			*pbGreater = toVariantBoolean(m_pos.GetCharNumber() > iChar);
		}
	}
	return S_OK;
}

/// @see	IEditPoint::Indent
STDMETHODIMP CTextPoint::Indent(VARIANT varOther, short nLevel /* = 1 */) {
	VERIFY_IMPL();

	CComVariant	var;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.TabIndent(CCharPos(iLine, iChar), false, nLevel);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

/// @see	IEditPoint::Insert
STDMETHODIMP CTextPoint::Insert(BSTR bstrText) {
	VERIFY_IMPL();
	m_pos.Insert(bstrText);
	return S_OK;
}

/// @see	ITextPoint::Invoke
STDMETHODIMP CTextPoint::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTPOINT_ABSOLUTECHAROFFSET:	CALL_GETTER(AbsoluteCharOffset, VT_I4);
		case DISPID_TEXTPOINT_ATENDOFDOCUMENT:		CALL_GETTER(AtEndOfDocument, VT_BOOL);
		case DISPID_TEXTPOINT_ATENDOFLINE:			CALL_GETTER(AtEndOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_ATFIRSTCHAROFLINE:	CALL_GETTER(AtFirstCharOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_ATLASTCHAROFLINE:		CALL_GETTER(AtLastCharOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_ATSTARTOFDOCUMENT:	CALL_GETTER(AtStartOfDocument, VT_BOOL);
		case DISPID_TEXTPOINT_ATSTARTOFLINE:		CALL_GETTER(AtStartOfLine, VT_BOOL);
		case DISPID_TEXTPOINT_CHAR:					CALL_GETTER(Char, VT_I4);
		case DISPID_TEXTPOINT_COLUMN:				CALL_GETTER(Column, VT_I4);
		case DISPID_TEXTPOINT_LINE:					CALL_GETTER(Line, VT_I4);
		case DISPID_TEXTPOINT_LINELENGTH:			CALL_GETTER(LineLength, VT_I4);
		default:
			if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_CHARCOUNTCONVENTION) {
				CALL_GETTER_ENUM(CharCountConvention, CharCountConvention);
			} else if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_RESTRICTIONEXCLUSIVE) {
				CALL_GETTER(RestrictionExclusive, VT_BOOL);
			}
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_CHARCOUNTCONVENTION) {
			CALL_PUTTER_ENUM(CharCountConvention, CharCountConvention);
		} else if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_RESTRICTIONEXCLUSIVE) {
				CALL_PUTTER(RestrictionExclusive, VT_BOOL);
			}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTPOINT_CENTER:	CALL_METHOD_RET_1(Center, VT_BOOL, VT_VARIANT);
		case DISPID_TEXTPOINT_CREATEEDITPOINT:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_DISPATCH);
			return CreateEditPoint((pVarResult != 0) ?
				reinterpret_cast<IEditPoint**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTPOINT_EQUALTO:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return EqualTo(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_GREATERTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return GreaterThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_LESSTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return LessThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_REVEAL:	CALL_METHOD_RET_1(Reveal, VT_BOOL, VT_VARIANT);
		default:
			if(m_bIsEditPoint) {
				switch(dispidMember) {
				case DISPID_EDITPOINT_CHARNEXT:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(CharNext);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(CharNext, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CHARPREV:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(CharPrev);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(CharPrev, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CONVERT:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_I2);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Convert(static_cast<ConvertType>(args[1].iVal), args[0]);
				case DISPID_EDITPOINT_COPY:						CALL_METHOD_1(Copy, VT_VARIANT);
				case DISPID_EDITPOINT_CUT:						CALL_METHOD_1(Cut, VT_VARIANT);
				case DISPID_EDITPOINT_DELETE:					CALL_METHOD_1(Delete, VT_VARIANT);
				case DISPID_EDITPOINT_DESTRUCTIVEINSERT:		CALL_METHOD_1(DestructiveInsert, VT_BSTR);
				case DISPID_EDITPOINT_GETTEXT:					CALL_METHOD_RET_1(GetText, VT_BSTR, VT_VARIANT);
				case DISPID_EDITPOINT_INDENT:
					if(pDispParams->cArgs == 1) {				CALL_METHOD_1(Indent, VT_VARIANT);}
					else if(pDispParams->cArgs == 2) {			CALL_METHOD_2(Indent, VT_VARIANT, VT_I2);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_INSERT:					CALL_METHOD_1(Insert, VT_BSTR);
				case DISPID_EDITPOINT_LINEDOWN:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(LineDown);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(LineDown, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_LINEUP:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(LineUp);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(LineUp, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_MOVETO:					CALL_METHOD_2(MoveTo, VT_I4, VT_I4);
				case DISPID_EDITPOINT_MOVETOABSOLUTEOFFSET:		CALL_METHOD_1(MoveToAbsoluteOffset, VT_I4);
				case DISPID_EDITPOINT_MOVETOENDOFDOCUMENT:		CALL_METHOD_0(MoveToEndOfDocument);
				case DISPID_EDITPOINT_MOVETOENDOFLINE:			CALL_METHOD_0(MoveToEndOfLine);
				case DISPID_EDITPOINT_MOVETOFIRSTCHAROFLINE:	CALL_METHOD_0(MoveToFirstCharOfLine);
				case DISPID_EDITPOINT_MOVETOLASTCHAROFLINE:		CALL_METHOD_0(MoveToLastCharOfLine);
				case DISPID_EDITPOINT_MOVETONEXTBOOKMARK:		CALL_METHOD_0(MoveToNextBookmark);
				case DISPID_EDITPOINT_MOVETOPREVIOUSBOOKMARK:	CALL_METHOD_0(MoveToPreviousBookmark);
				case DISPID_EDITPOINT_MOVETOSTARTOFDOCUMENT:	CALL_METHOD_0(MoveToStartOfDocument);
				case DISPID_EDITPOINT_MOVETOSTARTOFLINE:		CALL_METHOD_0(MoveToStartOfLine);
				case DISPID_EDITPOINT_NEWLINE:					CALL_METHOD_0(NewLine);
				case DISPID_EDITPOINT_PAGEDOWN:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(PageDown);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(PageDown, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PAGEUP:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(PageUp);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(PageUp, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PASTE:
					if(pDispParams->cArgs == 0) {
						args[0] = 0;
						return Paste(args[0]);
					} else if(pDispParams->cArgs == 1) {		CALL_METHOD_1(Paste, VT_VARIANT);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_REPLACE:					CALL_METHOD_2(Replace, VT_BSTR, VT_VARIANT);
				case DISPID_EDITPOINT_SETBOOKMARK:
					if(pDispParams->cArgs == 0)	{			CALL_METHOD_0(SetBookmark);}
					else if(pDispParams->cArgs == 1)	{	CALL_METHOD_1(SetBookmark, VT_BOOL);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_TRANSPOSECHARS:			CALL_METHOD_0(TransposeChars);
				case DISPID_EDITPOINT_TRANSPOSELINES:			CALL_METHOD_0(TransposeLines);
				case DISPID_EDITPOINT_TRANSPOSEPARAGRAPHS:		CALL_METHOD_0(TransposeParagraphs);
				case DISPID_EDITPOINT_TRANSPOSEWORDS:			CALL_METHOD_0(TransposeWords);
				case DISPID_EDITPOINT_UNINDENT:
					if(pDispParams->cArgs == 1) {				CALL_METHOD_1(Unindent, VT_VARIANT);}
					else if(pDispParams->cArgs == 2) {			CALL_METHOD_2(Unindent, VT_VARIANT, VT_I2);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDNEXT:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordEndNext);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordEndNext, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDPREV:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordEndPrev);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordEndPrev, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDNEXT:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordNext);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordNext, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDPREV:
					if(pDispParams->cArgs == 0) {				CALL_METHOD_0(WordEndPrev);}
					else if(pDispParams->cArgs == 1) {			CALL_METHOD_1(WordEndPrev, VT_I4);}
					else return DISP_E_BADPARAMCOUNT;
				}
			}
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

/// @see	IObjectIdentity::IsEqualObject
STDMETHODIMP CTextPoint::IsEqualObject(IUnknown* punk) {
	if(punk == 0)
		return E_INVALIDARG;
	CComPtr<ITextPoint>	pRhs;
	if(FAILED(punk->QueryInterface(IID_ITextPoint, reinterpret_cast<void**>(&pRhs))))
		return S_FALSE;

	VARIANT_BOOL	b;
	EqualTo(pRhs, &b);
	return toBoolean(b) ? S_OK : S_FALSE;
}

/// @see	ITextPoint::LessThan
STDMETHODIMP CTextPoint::LessThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbLess) {
	VERIFY_IMPL();
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbLess != 0) {
		unsigned long	iLine, iChar;

		pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
		if(m_pos.GetLineNumber() < iLine)
			*pbLess = VARIANT_TRUE;
		else if(m_pos.GetLineNumber() > iLine)
			*pbLess = VARIANT_FALSE;
		else {
			pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
			*pbLess = toVariantBoolean(m_pos.GetCharNumber() < iChar);
		}
	}
	return S_OK;
}

/// @see	ITextPoint::LineDown
STDMETHODIMP CTextPoint::LineDown(long cLines /* = 1 */) {
	VERIFY_IMPL();
	m_pos.LineDown(cLines);
	return S_OK;
}

/// @see	ITextPoint::LineUp
STDMETHODIMP CTextPoint::LineUp(long cLines /* = 1 */) {
	VERIFY_IMPL();
	m_pos.LineUp(cLines);
	return S_OK;
}

/// @see	ITextPoint::MoveTo
STDMETHODIMP CTextPoint::MoveTo(long iLine, long iChar) {
	VERIFY_IMPL();
	m_pos.MoveTo(CCharPos(iLine, iChar));
	return S_OK;
}

/// @see	ITextPoint::MoveToAbsoluteOffset
STDMETHODIMP CTextPoint::MoveToAbsoluteOffset(long nOffset) {
	VERIFY_IMPL();
	m_pos.MoveToAbsoluteCharOffset(nOffset);
	return S_OK;
}

/// @see	ITextPoint::MoveToEndOfDocument
STDMETHODIMP CTextPoint::MoveToEndOfDocument() {
	VERIFY_IMPL();
	m_pos.MoveToEndOfDocument();
	return S_OK;
}

/// @see	ITextPoint::MoveToEndOfLine
STDMETHODIMP CTextPoint::MoveToEndOfLine() {
	VERIFY_IMPL();
	m_pos.MoveToEndOfLine();
	return S_OK;
}

/// @see	ITextPoint::MoveToFirstCharOfLine
STDMETHODIMP CTextPoint::MoveToFirstCharOfLine() {
	VERIFY_IMPL();
	m_pos.MoveToFirstCharOfLine();
	return S_OK;
}

/// @see	ITextPoint::MoveToLastCharOfLine
STDMETHODIMP CTextPoint::MoveToLastCharOfLine() {
	VERIFY_IMPL();
	m_pos.MoveToLastCharOfLine();
	return S_OK;
}

/// @see	ITextPoint::MoveToNextBookmark
STDMETHODIMP CTextPoint::MoveToNextBookmark() {
	VERIFY_IMPL();
	m_pos.MoveToNextBookmark();
	return S_OK;
}

/// @see	ITextPoint::MoveToPreviousBookmark
STDMETHODIMP CTextPoint::MoveToPreviousBookmark() {
	VERIFY_IMPL();
	m_pos.MoveToPrevBookmark();
	return S_OK;
}

/// @see	ITextPoint::MoveToStartOfDocument
STDMETHODIMP CTextPoint::MoveToStartOfDocument() {
	VERIFY_IMPL();
	m_pos.MoveToStartOfDocument();
	return S_OK;
}

/// @see	ITextPoint::MoveToStartOfLine
STDMETHODIMP CTextPoint::MoveToStartOfLine() {
	VERIFY_IMPL();
	m_pos.MoveToStartOfLine();
	return S_OK;
}

/// @see	IEditPoint::NewLine
STDMETHODIMP CTextPoint::NewLine() {
	VERIFY_IMPL();
	m_pos.NewLine();
	return S_OK;
}

/// @see	ITextPoint::PageDown
STDMETHODIMP CTextPoint::PageDown(long cPages /* = 1 */) {
	VERIFY_IMPL();
	m_pos.PageDown(cPages);
	return S_OK;
}

/// @see	ITextPoint::PageUp
STDMETHODIMP CTextPoint::PageUp(long cPages /* = 1 */) {
	VERIFY_IMPL();
	m_pos.PageUp(cPages);
	return S_OK;
}

/// @see	IEditPoint::Paste
STDMETHODIMP CTextPoint::Paste(VARIANT varOther) {
	VERIFY_IMPL();

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Paste(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.CEditPoint::Paste(var.lVal);	// B[
	else
		return hr;
	return S_OK;
}

/// @see	IEditPoint::Replace
STDMETHODIMP CTextPoint::Replace(BSTR bstrText, VARIANT varOther) {
	VERIFY_IMPL();

	HRESULT	hr;

	m_pos.GetDocument()->BeginEditCollection();
	if(FAILED(hr = Delete(varOther)) || FAILED(hr = Insert(bstrText))) {
		m_pos.GetDocument()->EndEditCollection();
		return hr;
	}
	m_pos.GetDocument()->EndEditCollection();
	return S_OK;
}

/// @see	ITextPoint::Reveal
STDMETHODIMP CTextPoint::Reveal(VARIANT varOther, VARIANT_BOOL* pbInEditorRect) {
	VERIFY_IMPL();

	VARIANT	var;
	HRESULT	hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*pbInEditorRect = m_pos.Reveal(m_pos.GetDocument()->GetActiveView(), CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4))) {
		if(pbInEditorRect != 0)
			*pbInEditorRect = m_pos.Reveal(m_pos.GetDocument()->GetActiveView(), var.lVal);
	} else
		return hr;
	return S_OK;
}

/// @see	IEditPoint::SetBookmark
STDMETHODIMP CTextPoint::SetBookmark(VARIANT_BOOL bSet /* = VARIANT_TRUE */) {
	VERIFY_IMPL();
	m_pos.GetDocument()->GetActiveView().GetBookmarker().SetBookmark(m_pos.GetLineNumber(), toBoolean(bSet));
	return S_OK;
}

/// @see	IEditPoint::TransposeChars
STDMETHODIMP CTextPoint::TransposeChars() {
	VERIFY_IMPL();
	m_pos.TransposeChars();
	return S_OK;
}

/// @see	IEditPoint::TransposeLines
STDMETHODIMP CTextPoint::TransposeLines() {
	VERIFY_IMPL();
	m_pos.TransposeLines();
	return S_OK;
}

/// @see	IEditPoint::TransposeParagraphs
STDMETHODIMP CTextPoint::TransposeParagraphs() {
	VERIFY_IMPL();
//	m_pos.TransposeParagraphs();
//	return S_OK;
	return E_NOTIMPL;
}

/// @see	IEditPoint::TransposeWords
STDMETHODIMP CTextPoint::TransposeWords() {
	VERIFY_IMPL();
	m_pos.TransposeWords();
	return S_OK;
}

/// @see	IEditPoint::Unindent
STDMETHODIMP CTextPoint::Unindent(VARIANT varOther, short nLevel /* = 1 */) {
	VERIFY_IMPL();

	VARIANT	var;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.TabIndent(CCharPos(iLine, iChar), false, -nLevel);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

/// @see	ITextPoint::WordEndNext
STDMETHODIMP CTextPoint::WordEndNext(long cWords /* = 1 */) {
	VERIFY_IMPL();
	m_pos.WordEndNext(cWords);
	return S_OK;
}

/// @see	ITextPoint::WordEndPrev
STDMETHODIMP CTextPoint::WordEndPrev(long cWords /* = 1 */) {
	VERIFY_IMPL();
	m_pos.WordEndPrev(cWords);
	return S_OK;
}

/// @see	ITextPoint::WordNext
STDMETHODIMP CTextPoint::WordNext(long cWords /* = 1 */) {
	VERIFY_IMPL();
	m_pos.WordNext(cWords);
	return S_OK;
}

/// @see	ITextPoint::WordPrev
STDMETHODIMP CTextPoint::WordPrev(long cWords /* = 1 */) {
	VERIFY_IMPL();
	m_pos.WordPrev(cWords);
	return S_OK;
}

#undef VERIFY_IMPL


// CTextRange class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
Ambient::CTextRange::CTextRange(CEditPoint& pos1, CEditPoint& pos2) : SAFE_MARK, m_pos1(pos1), m_pos2(pos2) {
}

/// @see	ITextRange::get_EndPoint
STDMETHODIMP Ambient::CTextRange::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);
//	*ppEndPoint = new CTextPoint(m_app, m_pRange->GetEndPoint());
//	(*ppEndPoint)->AddRef();
	return E_NOTIMPL;
}

/// @see	ITextRange::get_StartPoint
STDMETHODIMP Ambient::CTextRange::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
//	*ppStartPoint = new CTextPoint(m_app, m_pRange->GetStartPoint());
//	(*ppStartPoint)->AddRef();
	return E_NOTIMPL;
}

/// @see	ITextRange::Invoke
STDMETHODIMP Ambient::CTextRange::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTRANGE_ENDPOINT:		CALL_GETTER_ACTX(EndPoint, ITextPoint);
		case DISPID_TEXTRANGE_STARTPOINT:	CALL_GETTER_ACTX(StartPoint, ITextPoint);
		}
	}
	return DISP_E_MEMBERNOTFOUND;
}

/// @see	IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::CTextRange::IsEqualObject(IUnknown* punk) {
	if(punk == 0)
		return E_INVALIDARG;
	CComPtr<ITextRange>	pRhs;
	if(FAILED(punk->QueryInterface(IID_ITextRange, reinterpret_cast<void**>(&pRhs))))
		return S_FALSE;

	CComPtr<ITextPoint>	pStartPoint, pEndPoint;
	VARIANT_BOOL		b;
	pRhs->get_StartPoint(&pStartPoint);
	pRhs->get_EndPoint(&pEndPoint);
	pStartPoint->EqualTo(pEndPoint, &b);
	return toBoolean(b) ? S_OK : S_FALSE;
}


// CLexer class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {
	Ascension::TokenType GetTokenTypeByName(BSTR bstrName) {
		static map<wstring, Ascension::TokenType>	ids;

		if(ids.empty()) {
			ids[L"whiteSpace"]			= TT_WHITESPACE;
			ids[L"tab"]					= TT_TAB;
			ids[L"keyword"]				= TT_KEYWORD;
			ids[L"annotation"]			= TT_ANNOTATION;
			ids[L"operator"]			= TT_OPERATOR;
			ids[L"identifier"]			= TT_IDENTIFIER;
			ids[L"numeral"]				= TT_NUMERAL;
			ids[L"number"]				= TT_NUMBER;
			ids[L"singleQuotation"]		= TT_SINGLEQUOTATION;
			ids[L"doubleQuotation"]		= TT_DOUBLEQUOTATION;
			ids[L"otherQuotation"]		= TT_OTHERQUOTATION;
			ids[L"asciiControl"]		= TT_ASCII_CONTROL;
			ids[L"unicodeControl"]		= TT_UNICODE_CONTROL;
			ids[L"unspecified"]			= TT_UNSPECIFIED;
/*			ids[L"normal"]				= ETT_NORMAL;
			ids[L"selection"]			= ETT_SELECTION;
			ids[L"inactiveSelection"]	= ETT_INACTIVE_SELECTION;
			ids[L"indicatorMargin"]		= ETT_INDICATOR_MARGIN;
			ids[L"lineNumber"]			= ETT_LINENUMBER;
			ids[L"emphaticLineNumber"]	= ETT_EMPHATIC_LINENUMBER;
			ids[L"matchBrackets"]		= ETT_MATCH_BRACKETS;
			ids[L"endOfLine"]			= ETT_END_OF_LINE;
			ids[L"endOfFile"]			= ETT_END_OF_FILE;
			ids[L"link"]				= ETT_LINK;
			ids[L"restriction"]			= ETT_RESTRICTION;
			ids[L"matchText"]			= ETT_MATCHTEXT;
*/		}
		if(bstrName == 0)
			return static_cast<Ascension::TokenType>(-1);
		map<wstring, Ascension::TokenType>::const_iterator	it = ids.find(bstrName);
		return (it != ids.end()) ? it->second : static_cast<Ascension::TokenType>(-1);
	}
}

/// RXgN^
Ambient::CLexer::CLexer(Ascension::CLexer& impl) : SAFE_MARK, m_impl(impl) {
}

///	@see	ILexer::AddKeywords
STDMETHODIMP Ambient::CLexer::AddKeywords(BSTR bstrKeywords, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(isEmptyBSTR(bstrKeywords))
		return E_INVALIDARG;

	set<string_t>	setKeywords;
	wchar_t*		pCurrent = bstrKeywords;
	wchar_t*		pNext;

	while(*pCurrent != 0) {
		if(*pCurrent == L' ') {
			++pCurrent;
			continue;
		}
		pNext = wcschr(pCurrent, L' ');
		if(pNext != 0) {
			setKeywords.insert(string_t(pCurrent, pNext - pCurrent));
			pCurrent = pNext + 1;
		} else {
			setKeywords.insert(string_t(pCurrent));
			break;
		}
	}
	if(pnIdentifier != 0)
		*pnIdentifier = m_impl.AddKeywords(setKeywords);
	else
		m_impl.AddKeywords(setKeywords);
	return S_OK;
}

///	@see	ILexer::AddMultilineAnnotation
STDMETHODIMP Ambient::CLexer::AddMultilineAnnotation(BSTR bstrStartDelimiter,
		BSTR bstrEndDelimiter, ::AnnotationConstraint constraint, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(isEmptyBSTR(bstrStartDelimiter) || isEmptyBSTR(bstrEndDelimiter))
		return E_INVALIDARG;

	if(pnIdentifier != 0)
		*pnIdentifier = m_impl.AddMultilineAnnotation(bstrStartDelimiter,
			bstrEndDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	else
		m_impl.AddMultilineAnnotation(bstrStartDelimiter,
			bstrEndDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	return S_OK;
}

///	@see	ILexer::AddSinglelineAnnotation
STDMETHODIMP Ambient::CLexer::AddSinglelineAnnotation(BSTR bstrStartDelimiter,
		BSTR bstrEndDelimiter, ::AnnotationConstraint constraint, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(isEmptyBSTR(bstrStartDelimiter))
		return E_INVALIDARG;

	if(isEmptyBSTR(bstrEndDelimiter)) {
		if(pnIdentifier != 0)
			*pnIdentifier = m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
		else
			m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	} else {
		if(pnIdentifier != 0)
			*pnIdentifier = m_impl.AddSinglelineAnnotation(bstrStartDelimiter,
				bstrEndDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
		else
			m_impl.AddSinglelineAnnotation(bstrStartDelimiter,
				bstrEndDelimiter, static_cast<Ascension::AnnotationConstraint>(constraint));
	}
	return S_OK;
}

/// @see	ILexer::get_BackSolidusEscapeEnabled
STDMETHODIMP Ambient::CLexer::get_BackSolidusEscapeEnabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_impl.IsBackSolidusEscapeEnabled());
	return S_OK;
}

/// @see	ILexer::get_CaseSensitive
STDMETHODIMP Ambient::CLexer::get_CaseSensitive(VARIANT_BOOL* pbCaseSensitive) {
	VERIFY_POINTER(pbCaseSensitive);
	*pbCaseSensitive = toVariantBoolean(m_impl.IsCaseSensitive());
	return S_OK;
}

/// @see	ILexer::get_Freezed
STDMETHODIMP Ambient::CLexer::get_Freezed(VARIANT_BOOL* pbFreezed) {
	VERIFY_POINTER(pbFreezed);
	*pbFreezed = toVariantBoolean(m_impl.IsFreezed());
	return S_OK;
}

/// @see	ILexer::get_NumberFormat
STDMETHODIMP Ambient::CLexer::get_NumberFormat(::NumberFormat* pNumberFormat) {
	VERIFY_POINTER(pNumberFormat);
	*pNumberFormat = static_cast<::NumberFormat>(m_impl.GetNumberFormat());
	return S_OK;
}

/// @see	ILexer::get_TokenEnabled
STDMETHODIMP Ambient::CLexer::get_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);

	const Ascension::TokenType	type = GetTokenTypeByName(bstrTokenName);
	if(type == -1)
		return E_INVALIDARG;
	*pbEnabled = toVariantBoolean(m_impl.IsTokenEnabled(type));
	return S_OK;
}

/// @see	ILexer::get_UnicodeAlphabetsEnabled
STDMETHODIMP Ambient::CLexer::get_UnicodeAlphabetsEnabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_impl.IsUnicodeAlphabetsEnabled());
	return S_OK;
}

/// @see	ILexer::get_UnicodeWhiteSpacesEnabled
STDMETHODIMP Ambient::CLexer::get_UnicodeWhiteSpacesEnabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_impl.IsUnicodeWhiteSpacesEnabled());
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP Ambient::CLexer::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	bool		bCreatedResult = false;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_LEXER_BACKSOLIDUSESCAPEENABLED:		CALL_GETTER(BackSolidusEscapeEnabled, VT_BOOL);
		case DISPID_LEXER_CASESENSITIVE:				CALL_GETTER(CaseSensitive, VT_BOOL);
		case DISPID_LEXER_FREEZED:						CALL_GETTER(Freezed, VT_BOOL);
		case DISPID_LEXER_NUMBERFORMAT:					CALL_GETTER_ENUM(NumberFormat, ::NumberFormat);
		case DISPID_LEXER_TOKENENABLED:					CALL_GETTER_1(TokenEnabled, VT_BOOL, VT_BSTR);
		case DISPID_LEXER_UNICODEALPHABETSENABLED:		CALL_GETTER(UnicodeAlphabetsEnabled, VT_BOOL);
		case DISPID_LEXER_UNICODEWHITESPACESENABLED:	CALL_GETTER(UnicodeWhiteSpacesEnabled, VT_BOOL);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_LEXER_BACKSOLIDUSESCAPEENABLED:		CALL_PUTTER(BackSolidusEscapeEnabled, VT_BOOL);
		case DISPID_LEXER_CASESENSITIVE:				CALL_PUTTER(CaseSensitive, VT_BOOL);
		case DISPID_LEXER_FREEZED:						CALL_PUTTER(Freezed, VT_BOOL);
		case DISPID_LEXER_NUMBERFORMAT:					CALL_PUTTER_ENUM(NumberFormat, ::NumberFormat);
		case DISPID_LEXER_TOKENENABLED:					CALL_PUTTER_1(TokenEnabled, VT_BOOL, VT_BSTR);
		case DISPID_LEXER_UNICODEALPHABETSENABLED:		CALL_PUTTER(UnicodeAlphabetsEnabled, VT_BOOL);
		case DISPID_LEXER_UNICODEWHITESPACESENABLED:	CALL_PUTTER(UnicodeWhiteSpacesEnabled, VT_BOOL);
		}
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_LEXER_ADDKEYWORDS:	CALL_METHOD_RET_1(AddKeywords, VT_I4, VT_BSTR);
		case DISPID_LEXER_ADDMULTILINEANNOTATION:
			if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_INT);
				COERCE_RETURN(VT_I4);
				return AddMultilineAnnotation(
					args[2].bstrVal, args[1].bstrVal,
					static_cast<::AnnotationConstraint>(args[0].intVal),
					(pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddMultilineAnnotation(
					args[1].bstrVal, args[0].bstrVal,
					NoConstraint, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_LEXER_ADDSINGLELINEANNOTATION:
			if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_INT);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[2].bstrVal, args[1].bstrVal,
					static_cast<::AnnotationConstraint>(args[0].intVal),
					(pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[1].bstrVal, args[0].bstrVal,
					NoConstraint, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[0].bstrVal, 0,
					NoConstraint, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_LEXER_REMOVEALL:				CALL_METHOD_0(RemoveAll);
		case DISPID_LEXER_REMOVEIDENTIFIEDTOKEN:	CALL_METHOD_1(RemoveIdentifiedToken, VT_I4);
		case DISPID_LEXER_SETADDITIONALALPHABETS:	CALL_METHOD_1(SetAdditionalAlphabets, VT_BSTR);
		case DISPID_LEXER_SETBRACKETS:				CALL_METHOD_1(SetBrackets, VT_BSTR);
		case DISPID_LEXER_SETOPERATORS:				CALL_METHOD_1(SetOperators, VT_BSTR);
		}
		return DISP_E_MEMBERNOTFOUND;
	}

	return hr;
}

/// @see	ILexer::put_BackSolidusEscapeEnabled
STDMETHODIMP Ambient::CLexer::put_BackSolidusEscapeEnabled(VARIANT_BOOL bEnabled) {
	m_impl.EnableBackSolidusEscape(toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::put_CaseSensitive
STDMETHODIMP Ambient::CLexer::put_CaseSensitive(VARIANT_BOOL bCaseSensitive) {
	m_impl.IgnoreCase(!toBoolean(bCaseSensitive));
	return S_OK;
}

///	@see	ILexer::put_Freezed
STDMETHODIMP Ambient::CLexer::put_Freezed(VARIANT_BOOL bFreeze) {
	if(toBoolean(bFreeze))
		m_impl.Freeze();
	else
		m_impl.Unfreeze();
	return S_OK;
}

///	@see	ILexer::put_NumberFormat
STDMETHODIMP Ambient::CLexer::put_NumberFormat(::NumberFormat numberFormat) {
	try {
		if(numberFormat != LegacyAlpha)
			return E_NOTIMPL;
		m_impl.SetNumberFormat(static_cast<Ascension::NumberFormat>(numberFormat));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::put_TokenEnabled
STDMETHODIMP Ambient::CLexer::put_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL bEnabled) {
	const Ascension::TokenType	type = GetTokenTypeByName(bstrTokenName);
	if(type == -1)
		return E_INVALIDARG;
	m_impl.EnableToken(type, toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::put_UnicodeAlphabetsEnabled
STDMETHODIMP Ambient::CLexer::put_UnicodeAlphabetsEnabled(VARIANT_BOOL bEnabled) {
	m_impl.EnableUnicodeAlphabets(toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::put_UnicodeWhiteSpacesEnabled
STDMETHODIMP Ambient::CLexer::put_UnicodeWhiteSpacesEnabled(VARIANT_BOOL bEnabled) {
	m_impl.EnableUnicodeWhiteSpaces(toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::RemoveAll
STDMETHODIMP Ambient::CLexer::RemoveAll() {
	m_impl.RemoveAll();
	return S_OK;
}

///	@see	ILexer::RemoveIdentifiedToken
STDMETHODIMP Ambient::CLexer::RemoveIdentifiedToken(long nIdentifier) {
	try {
		m_impl.RemoveIdentifiedToken(static_cast<TokenCookie>(nIdentifier));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::SetAdditionalAlphabets
STDMETHODIMP Ambient::CLexer::SetAdditionalAlphabets(BSTR bstrAlphabets) {
	if(bstrAlphabets != 0)
		m_impl.SetAdditionalAlphabets(bstrAlphabets, ::SysStringLen(bstrAlphabets));
	else
		m_impl.SetAdditionalAlphabets(L"", 0);
	return S_OK;
}

///	@see	ILexer::SetBrackets
STDMETHODIMP Ambient::CLexer::SetBrackets(BSTR bstrOpeners) {
	try {
		m_impl.SetBrackets((bstrOpeners != 0) ? bstrOpeners : L"");
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::SetOperators
STDMETHODIMP Ambient::CLexer::SetOperators(BSTR bstrOperators) {
	set<string_t>	setOperators;

	if(bstrOperators != 0) {
		wchar_t*	pCurrent = bstrOperators;
		wchar_t*	pNext;

		while(true) {
			pNext = wcschr(pCurrent, L' ');
			if(pNext != 0) {
				setOperators.insert(string_t(pCurrent, pNext - pCurrent));
				pCurrent = pNext + 1;
			} else {
				setOperators.insert(string_t(pCurrent));
				break;
			}
		}
	}
	m_impl.SetOperators(setOperators);
	return S_OK;
}


// CEditorPreferences class implementation
/////////////////////////////////////////////////////////////////////////////

#define GET_DISPLAY_OPTION(lhs, id)									\
	VERIFY_POINTER(lhs);											\
	*lhs = toVariantBoolean(m_view.GetOptions().appearance[id]);	\
	return S_OK
#define PUT_DISPLAY_OPTION(id, rhs)						\
	CEditView::TOptions	options = m_view.GetOptions();	\
	if(options.appearance[id] != toBoolean(rhs)) {		\
		options.appearance[id] = toBoolean(rhs);		\
		m_view.SetOptions(options);						\
	}													\
	return S_OK

/**
 *	RXgN^
 *	@param view	r[
 */
CEditorPreferences::CEditorPreferences(CEditView& view) : SAFE_MARK, m_view(view) {
}

/// @see	IEditorPreferences::get_CharSpan
STDMETHODIMP CEditorPreferences::get_CharSpan(short* pnCharSpan) {
	VERIFY_POINTER(pnCharSpan);
	*pnCharSpan = static_cast<short>(m_view.GetLayoutSettings().GetSettings().nCharSpan);
	return S_OK;
}

/// @see	IEditorPreferences::get_CheckInputSequence
STDMETHODIMP CEditorPreferences::get_CheckInputSequence(BSTR bstrLanguage, VARIANT_BOOL* pbCheck) {
	VERIFY_POINTER(pbCheck);
	const InputSequenceCheckLanguage	langs = m_view.GetOptions().sequenceCheckingLanguages;

	for(size_t i = 0; i < _countof(ISCLanguages); ++i) {
		if(wcscmp(ISCLanguages[i].first, L"ainu") == 0) {
			*pbCheck = toVariantBoolean(langs & ISCLanguages[i].second);
			return S_OK;
		}
	}
	return E_INVALIDARG;
}

/// @see	IEditorPreferences::get_CloseBoldChars
STDMETHODIMP CEditorPreferences::get_CloseBoldChars(VARIANT_BOOL* pbCloseBoldChars) {
	VERIFY_POINTER(pbCloseBoldChars);
	*pbCloseBoldChars = toVariantBoolean(m_view.GetLayoutSettings().GetSettings().bCloseBoldCharacters);
	return S_OK;
}

/// @see	IEditorPreferences::get_EndOfFileLabel
STDMETHODIMP CEditorPreferences::get_EndOfFileLabel(BSTR* pbstrEndOfFileLabel) {
	VERIFY_POINTER(pbstrEndOfFileLabel);
	return toBoolean(*pbstrEndOfFileLabel =
		::SysAllocString(m_view.GetLayoutSettings().GetSettings().substitutionGlyphs.strEndOfFile.c_str())) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IEditorPreferences::get_GeneralWhiteSpaceSubstitutionChar
STDMETHODIMP CEditorPreferences::get_GeneralWhiteSpaceSubstitutionChar(long* pcp) {
	VERIFY_POINTER(pcp);
	*pcp = m_view.GetLayoutSettings().GetSettings().substitutionGlyphs.chGeneralWhiteSpace;
	return S_OK;
}

///	@see	IEditorPreferences::get_HorizontalTabSubstitutionChar
STDMETHODIMP CEditorPreferences::get_HorizontalTabSubstitutionChar(long* pcp) {
	VERIFY_POINTER(pcp);
	*pcp = m_view.GetLayoutSettings().GetSettings().substitutionGlyphs.chHorizontalTab;
	return S_OK;
}

/// @see	IEditorPreferences::get_IdeographicSpaceSubstitutionChar
STDMETHODIMP CEditorPreferences::get_IdeographicSpaceSubstitutionChar(long* pcp) {
	VERIFY_POINTER(pcp);
	*pcp = m_view.GetLayoutSettings().GetSettings().substitutionGlyphs.chIdeographicSpace;
	return S_OK;
}

/// @see	IEditorPreferences::get_LeadMargin
STDMETHODIMP CEditorPreferences::get_LeadMargin(short* pnLeadMargin) {
	VERIFY_POINTER(pnLeadMargin);
	*pnLeadMargin = static_cast<short>(m_view.GetLayoutSettings().GetSettings().nLeadMargin);
	return S_OK;
}

/// @see	IEditorPreferences::get_LexicalParsingEnabled
STDMETHODIMP CEditorPreferences::get_LexicalParsingEnabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_view.GetLayoutSettings().IsLexicalParsingEnabled());
	return S_OK;
}

/// @see	IEditorPreferences::get_LineBreakSubstitutionChar
STDMETHODIMP CEditorPreferences::get_LineBreakSubstitutionChar(::LineBreak lineBreak, long* pcp) {
	VERIFY_POINTER(pcp);

	const TLayoutSettings&	layout = m_view.GetLayoutSettings().GetSettings();
	switch(lineBreak) {
	case ::Lf:		*pcp = layout.substitutionGlyphs.chUnixEol;				break;
	case ::Cr:		*pcp = layout.substitutionGlyphs.chMacintoshEol;		break;
	case ::Crlf:	*pcp = layout.substitutionGlyphs.chWindowsEol;			break;
	case ::Nel:		*pcp = layout.substitutionGlyphs.chEbcdicEol;			break;
	case ::Ls:		*pcp = layout.substitutionGlyphs.chLineSeparator;		break;
	case ::Ps:		*pcp = layout.substitutionGlyphs.chParagraphSeparator;	break;
	default:		return E_INVALIDARG;
	}
	return S_OK;
}

/// @see	IEditorPreferences::get_LineNumberBorderStyle
STDMETHODIMP CEditorPreferences::get_LineNumberBorderStyle(::BorderType* pStyle) {
	VERIFY_POINTER(pStyle);
	switch(m_view.GetLayoutSettings().GetSettings().lineNumberLayout.borderStyle) {
	case TLineNumberLayout::LNBS_NONE:				*pStyle = NoBorder;		break;
	case TLineNumberLayout::LNBS_SOLID:				*pStyle = BorderSolid;	break;
	case TLineNumberLayout::LNBS_DASHED:
	case TLineNumberLayout::LNBS_DASHED_ROUNDED:	*pStyle = BorderDashed;	break;
	case TLineNumberLayout::LNBS_DOTTED:			*pStyle = BorderDotted;	break;
	}
	return S_OK;
}

/// @see	IEditorPreferences::get_LineNumberBorderWidth
STDMETHODIMP CEditorPreferences::get_LineNumberBorderWidth(short* pnWidth) {
	VERIFY_POINTER(pnWidth);
	*pnWidth = static_cast<short>(m_view.GetLayoutSettings().GetSettings().lineNumberLayout.nBorderWidth);
	return S_OK;
}

/// @see	IEditorPreferences::get_LineSpan
STDMETHODIMP CEditorPreferences::get_LineSpan(short* pnLineSpan) {
	VERIFY_POINTER(pnLineSpan);
	*pnLineSpan = static_cast<short>(m_view.GetLayoutSettings().GetSettings().nLineSpan);
	return S_OK;
}

/// @see	IEditorPreferences::get_MatchBracketScanLines
STDMETHODIMP CEditorPreferences::get_MatchBracketScanLines(long* pcLines) {
	VERIFY_POINTER(pcLines);
	*pcLines = m_view.GetOptions().cRecognizingLines;
	return S_OK;
}

/// @see	IEditorPreferences::get_PerformBidirection
STDMETHODIMP CEditorPreferences::get_PerformBidirection(VARIANT_BOOL* pbPerform) {
	VERIFY_POINTER(pbPerform);
//	*pbPerform = !toVariantBoolean(m_view.GetLayoutSettings().GetSettings().bPerformBidirection);
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::get_ResetDirectionByTokens
STDMETHODIMP CEditorPreferences::get_ResetDirectionByTokens(VARIANT_BOOL* pbResetDirByTokens) {
	VERIFY_POINTER(pbResetDirByTokens);
//	*pbResetDirByTokens = toVariantBoolean(m_view.GetLayoutSettings().GetSettings().bResetRunLevelByToken);
//	return S_OK;
	return E_NOTIMPL;
}

/// @see	IEditorPreferences::get_RightToLeftReading
STDMETHODIMP CEditorPreferences::get_RightToLeftReading(VARIANT_BOOL* pbRightToLeft) {
	VERIFY_POINTER(pbRightToLeft);
	*pbRightToLeft = toVariantBoolean(m_view.GetLayoutSettings().GetSettings().bRightToLeftReading);
	return S_OK;
}

///	@see	IEditorPreferences::get_SelectEndOfLine
STDMETHODIMP CEditorPreferences::get_SelectEndOfLine(VARIANT_BOOL* pbSelectEndOfLine) {
	GET_DISPLAY_OPTION(pbSelectEndOfLine, SHOW_SELECTION_ON_BREAK);
}

///	@see	IEditorPreferences::get_ShowBidirectionalFormatters
STDMETHODIMP CEditorPreferences::get_ShowBidirectionalFormatters(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_UNICODE_CONTROLS);
}

///	@see	IEditorPreferences::get_ShowCurrentUnderline
STDMETHODIMP CEditorPreferences::get_ShowCurrentUnderline(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_CURRENT_UNDERLINE);
}

///	@see	IEditorPreferences::get_ShowEndOfFile
STDMETHODIMP CEditorPreferences::get_ShowEndOfFile(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_END_OF_FILE);
}

///	@see	IEditorPreferences::get_ShowEndOfLine
STDMETHODIMP CEditorPreferences::get_ShowEndOfLine(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_BREAK_ARROWS);
}

///	@see	IEditorPreferences::get_ShowHandOnLink
STDMETHODIMP CEditorPreferences::get_ShowHandOnLink(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_HAND_ON_LINK);
}

///	@see	IEditorPreferences::get_ShowHintOnLink
STDMETHODIMP CEditorPreferences::get_ShowHintOnLink(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_HINT_ON_LINK);
}

///	@see	IEditorPreferences::get_ShowIndicatorMargin
STDMETHODIMP CEditorPreferences::get_ShowIndicatorMargin(VARIANT_BOOL* pbShow) {
	VERIFY_POINTER(pbShow);
	*pbShow = toVariantBoolean(m_view.GetLayoutSettings().GetSettings().lineNumberLayout.bShowIndicatorMargin);
	return S_OK;
}

///	@see	IEditorPreferences::get_ShowLineNumber
STDMETHODIMP CEditorPreferences::get_ShowLineNumber(VARIANT_BOOL* pbShow) {
	VERIFY_POINTER(pbShow);
	*pbShow = toVariantBoolean(m_view.GetLayoutSettings().GetSettings().lineNumberLayout.bShowLineNumbers);
	return S_OK;
}

///	@see	IEditorPreferences::get_ShowWhiteSpaceAlternative
STDMETHODIMP CEditorPreferences::get_ShowWhiteSpaceAlternative(VARIANT_BOOL* pbShow) {
	GET_DISPLAY_OPTION(pbShow, SHOW_WHITESPACE_ALTERNATIVE);
}

///	@see	IEditorPreferences::get_StartCharNumber
STDMETHODIMP CEditorPreferences::get_StartCharNumber(long* pnStartCharNumber) {
	VERIFY_POINTER(pnStartCharNumber);
	*pnStartCharNumber = m_view.GetLayoutSettings().GetSettings().iStartChar;
	return S_OK;
}

///	@see	IEditorPreferences::get_StartLineNumber
STDMETHODIMP CEditorPreferences::get_StartLineNumber(long* pnStartLineNumber) {
	VERIFY_POINTER(pnStartLineNumber);
	*pnStartLineNumber = m_view.GetLayoutSettings().GetSettings().lineNumberLayout.iStartLine;
	return S_OK;
}

///	@see	IEditorPreferences::get_TabWidth
STDMETHODIMP CEditorPreferences::get_TabWidth(short* pnWidth) {
	VERIFY_POINTER(pnWidth);
	*pnWidth = static_cast<short>(m_view.GetLayoutSettings().GetSettings().cchTabWidth);
	return S_OK;
}

///	@see	IEditorPreferences::get_ThinCaret
STDMETHODIMP CEditorPreferences::get_ThinCaret(VARIANT_BOOL* pbThinCaret) {
	GET_DISPLAY_OPTION(pbThinCaret, THIN_CARET);
}

///	@see	IEditorPreferences::get_TokenDecoration
STDMETHODIMP CEditorPreferences::get_TokenDecoration(BSTR bstrTokenTypeName, ITokenDecoration** ppTokenDecoration) {
	VERIFY_POINTER(ppTokenDecoration);
	if(bstrTokenTypeName == 0)
		return E_INVALIDARG;
	if(wcscmp(bstrTokenTypeName, L"whiteSpace") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_WHITESPACE);
	else if(wcscmp(bstrTokenTypeName, L"tab") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_TAB);
	else if(wcscmp(bstrTokenTypeName, L"operator") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_OPERATOR);
	else if(wcscmp(bstrTokenTypeName, L"identifier") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_IDENTIFIER);
	else if(wcscmp(bstrTokenTypeName, L"numeral") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_NUMERAL);
	else if(wcscmp(bstrTokenTypeName, L"number") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_NUMBER);
	else if(wcscmp(bstrTokenTypeName, L"singleQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_SINGLEQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"doubleQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_DOUBLEQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"otherQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_OTHERQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"asciiControl") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_ASCII_CONTROL);
	else if(wcscmp(bstrTokenTypeName, L"unicodeControl") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_UNICODE_CONTROL);
	else if(wcscmp(bstrTokenTypeName, L"unspecified") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_UNSPECIFIED);
	else if(wcscmp(bstrTokenTypeName, L"normal") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_NORMAL);
	else if(wcscmp(bstrTokenTypeName, L"selection") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_SELECTION);
	else if(wcscmp(bstrTokenTypeName, L"inactiveSelection") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_INACTIVE_SELECTION);
	else if(wcscmp(bstrTokenTypeName, L"indicatorMargin") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_INDICATOR_MARGIN);
	else if(wcscmp(bstrTokenTypeName, L"lineNumber") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_LINENUMBER);
	else if(wcscmp(bstrTokenTypeName, L"emphaticLineNumber") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_EMPHATIC_LINENUMBER);
	else if(wcscmp(bstrTokenTypeName, L"matchBrackets") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_MATCH_BRACKETS);
	else if(wcscmp(bstrTokenTypeName, L"endOfLine") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_END_OF_LINE);
	else if(wcscmp(bstrTokenTypeName, L"endOfFile") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_END_OF_FILE);
	else if(wcscmp(bstrTokenTypeName, L"link") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_LINK);
	else if(wcscmp(bstrTokenTypeName, L"matchText") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_MATCHTEXT);
	else if(wcscmp(bstrTokenTypeName, L"restriction") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_RESTRICTION);
	else {	// L[[hƃRgɂ̓NbL[lKv
		if(::SysStringLen(bstrTokenTypeName) >= 9 && wcsncmp(bstrTokenTypeName, L"keyword_", 8) == 0)
			*ppTokenDecoration = new CTokenDecoration(m_view,
				TT_KEYWORD, static_cast<TokenCookie>(wcstol(bstrTokenTypeName + 8, 0, 10)));
		else if(::SysStringLen(bstrTokenTypeName) >= 12 && wcsncmp(bstrTokenTypeName, L"annotation_", 11) == 0)
			*ppTokenDecoration = new CTokenDecoration(m_view,
				TT_ANNOTATION, static_cast<TokenCookie>(wcstol(bstrTokenTypeName + 11, 0, 10)));
		else {
			*ppTokenDecoration = 0;
			return E_INVALIDARG;
		}

	}
	(*ppTokenDecoration)->AddRef();

	return S_OK;
}

/// @see	IEditorPreferences::get_TopMargin
STDMETHODIMP CEditorPreferences::get_TopMargin(short* pnTopMargin) {
	VERIFY_POINTER(pnTopMargin);
	*pnTopMargin = static_cast<short>(m_view.GetLayoutSettings().GetSettings().nTopMargin);
	return S_OK;
}

/// @see	IEditorPreferences::get_UseEditorFontForCompletion
STDMETHODIMP CEditorPreferences::get_UseEditorFontForCompletion(VARIANT_BOOL* pbUse) {
	VERIFY_POINTER(pbUse);
	*pbUse = toVariantBoolean(m_view.GetOptions().appearance[USE_EDITOR_FONT_FOR_COMPLETION]);
	return S_OK;
}

///	@see	IEditorPreferences::get_WrapMode
STDMETHODIMP CEditorPreferences::get_WrapMode(::WrapMode* pWrapMode) {
	VERIFY_POINTER(pWrapMode);
	*pWrapMode = static_cast<::WrapMode>(m_view.GetLayoutSettings().GetSettings().wrapMode);
	return S_OK;
}

///	@see	IEditorPreferences::get_WrapWidth
STDMETHODIMP CEditorPreferences::get_WrapWidth(short* pnWrapWidth) {
	VERIFY_POINTER(pnWrapWidth);
	return E_NOTIMPL;
//	*pnWrapWidth = m_view.GetLayoutSettings().GetSettings().nWrapWidth;
//	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CEditorPreferences::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {
		switch(dispidMember) {
		case DISPID_EDITORPREFERENCES_CHARSPAN:							CALL_GETTER(CharSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_CLOSEBOLDCHARS:					CALL_GETTER(CloseBoldChars, VT_BOOL);
		case DISPID_EDITORPREFERENCES_ENDOFFILELABEL:					CALL_GETTER(EndOfFileLabel, VT_BSTR);
		case DISPID_EDITORPREFERENCES_GENERALWHITESPACESUBSTITUTIONCHAR:CALL_GETTER(GeneralWhiteSpaceSubstitutionChar, VT_I4);
		case DISPID_EDITORPREFERENCES_HORIZONTALTABSUBSTITUTIONCHAR:	CALL_GETTER(HorizontalTabSubstitutionChar, VT_I4);
		case DISPID_EDITORPREFERENCES_IDEOGRAPHICSPACESUBSTITUTIONCHAR:	CALL_GETTER(IdeographicSpaceSubstitutionChar, VT_I4);
		case DISPID_EDITORPREFERENCES_LEADMARGIN:						CALL_GETTER(LeadMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_LEXICALPARSINGENABLED:			CALL_GETTER(LexicalParsingEnabled, VT_BOOL);
		case DISPID_EDITORPREFERENCES_LINEBREAKSUBSTITUTIONCHAR:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_I4);
			return get_LineBreakSubstitutionChar(static_cast<::LineBreak>(args[0].lVal), (pVarResult != 0) ? &pVarResult->lVal : 0);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERSTYLE:			CALL_GETTER_ENUM(LineNumberBorderStyle, ::BorderType);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERWIDTH:			CALL_GETTER(LineNumberBorderWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_LINESPAN:							CALL_GETTER(LineSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_MATCHBRACKETSCANLINES:			CALL_GETTER(MatchBracketScanLines, VT_I4);
		case DISPID_EDITORPREFERENCES_PERFORMBIDIRECTION:				CALL_GETTER(PerformBidirection, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RESETDIRECTIONBYTOKENS:			CALL_GETTER(ResetDirectionByTokens, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RIGHTTOLEFTREADING:				CALL_GETTER(RightToLeftReading, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SELECTENDOFLINE:					CALL_GETTER(SelectEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWBIDIRECTIONALFORMATTERS:		CALL_GETTER(ShowBidirectionalFormatters, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWCURRENTUNDERLINE:				CALL_GETTER(ShowCurrentUnderline, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFFILE:					CALL_GETTER(ShowEndOfFile, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFLINE:					CALL_GETTER(ShowEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHANDONLINK:					CALL_GETTER(ShowHandOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHINTONLINK:					CALL_GETTER(ShowHintOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWINDICATORMARGIN:				CALL_GETTER(ShowIndicatorMargin, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWLINENUMBER:					CALL_GETTER(ShowLineNumber, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWWHITESPACEALTERNATIVE:		CALL_GETTER(ShowWhiteSpaceAlternative, VT_BOOL);
		case DISPID_EDITORPREFERENCES_STARTCHARNUMBER:					CALL_GETTER(StartCharNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_STARTLINENUMBER:					CALL_GETTER(StartLineNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_TABWIDTH:							CALL_GETTER(TabWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_THINCARET:						CALL_GETTER(ThinCaret, VT_BOOL);
		case DISPID_EDITORPREFERENCES_TOKENDECORATION:					CALL_GETTER_ACTX_1(TokenDecoration, VT_BSTR, ITokenDecoration);
		case DISPID_EDITORPREFERENCES_TOPMARGIN:						CALL_GETTER(TopMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_USEEDITORFONTFORCOMPLETION:		CALL_GETTER(UseEditorFontForCompletion, VT_BOOL);
		case DISPID_EDITORPREFERENCES_WRAPMODE:							CALL_GETTER_ENUM(WrapMode, ::WrapMode);
		case DISPID_EDITORPREFERENCES_WRAPWIDTH:						CALL_GETTER(WrapWidth, VT_I2);
		}
	} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT)) {
		switch(dispidMember) {
		case DISPID_EDITORPREFERENCES_CHARSPAN:							CALL_PUTTER(CharSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_CLOSEBOLDCHARS:					CALL_PUTTER(CloseBoldChars, VT_BOOL);
		case DISPID_EDITORPREFERENCES_ENDOFFILELABEL:					CALL_PUTTER(EndOfFileLabel, VT_BSTR);
		case DISPID_EDITORPREFERENCES_GENERALWHITESPACESUBSTITUTIONCHAR:CALL_PUTTER(GeneralWhiteSpaceSubstitutionChar, VT_I4);
		case DISPID_EDITORPREFERENCES_HORIZONTALTABSUBSTITUTIONCHAR:	CALL_PUTTER(HorizontalTabSubstitutionChar, VT_I4);
		case DISPID_EDITORPREFERENCES_IDEOGRAPHICSPACESUBSTITUTIONCHAR:	CALL_PUTTER(IdeographicSpaceSubstitutionChar, VT_I4);
		case DISPID_EDITORPREFERENCES_LEADMARGIN:						CALL_PUTTER(LeadMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_LEXICALPARSINGENABLED:			CALL_PUTTER(LexicalParsingEnabled, VT_BOOL);
		case DISPID_EDITORPREFERENCES_LINEBREAKSUBSTITUTIONCHAR:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_I4);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_LineBreakSubstitutionChar(static_cast<::LineBreak>(args[1].lVal), args[0].lVal);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERSTYLE:			CALL_PUTTER_ENUM(LineNumberBorderStyle, ::BorderType);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERWIDTH:			CALL_PUTTER(LineNumberBorderWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_LINESPAN:							CALL_PUTTER(LineSpan, VT_I2);
		case DISPID_EDITORPREFERENCES_MATCHBRACKETSCANLINES:			CALL_PUTTER(MatchBracketScanLines, VT_I4);
		case DISPID_EDITORPREFERENCES_PERFORMBIDIRECTION:				CALL_PUTTER(PerformBidirection, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RESETDIRECTIONBYTOKENS:			CALL_PUTTER(ResetDirectionByTokens, VT_BOOL);
		case DISPID_EDITORPREFERENCES_RIGHTTOLEFTREADING:				CALL_PUTTER(RightToLeftReading, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SELECTENDOFLINE:					CALL_PUTTER(SelectEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWBIDIRECTIONALFORMATTERS:		CALL_PUTTER(ShowBidirectionalFormatters, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWCURRENTUNDERLINE:				CALL_PUTTER(ShowCurrentUnderline, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFFILE:					CALL_PUTTER(ShowEndOfFile, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWENDOFLINE:					CALL_PUTTER(ShowEndOfLine, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHANDONLINK:					CALL_PUTTER(ShowHandOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWHINTONLINK:					CALL_PUTTER(ShowHintOnLink, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWINDICATORMARGIN:				CALL_PUTTER(ShowIndicatorMargin, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWLINENUMBER:					CALL_PUTTER(ShowLineNumber, VT_BOOL);
		case DISPID_EDITORPREFERENCES_SHOWWHITESPACEALTERNATIVE:		CALL_PUTTER(ShowWhiteSpaceAlternative, VT_BOOL);
		case DISPID_EDITORPREFERENCES_STARTCHARNUMBER:					CALL_PUTTER(StartCharNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_STARTLINENUMBER:					CALL_PUTTER(StartLineNumber, VT_I4);
		case DISPID_EDITORPREFERENCES_TABWIDTH:							CALL_PUTTER(TabWidth, VT_I2);
		case DISPID_EDITORPREFERENCES_THINCARET:						CALL_PUTTER(ThinCaret, VT_BOOL);
		case DISPID_EDITORPREFERENCES_TOPMARGIN:						CALL_PUTTER(TopMargin, VT_I2);
		case DISPID_EDITORPREFERENCES_USEEDITORFONTFORCOMPLETION:		CALL_PUTTER(UseEditorFontForCompletion, VT_BOOL);
		case DISPID_EDITORPREFERENCES_WRAPMODE:							CALL_PUTTER_ENUM(WrapMode, ::WrapMode);
		case DISPID_EDITORPREFERENCES_WRAPWIDTH:						CALL_PUTTER(WrapWidth, VT_I2);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {
		if(dispidMember == DISPID_EDITORPREFERENCES_RESET) {
			CALL_METHOD_0(Reset);
		}
	}

	return hr;
}

///	@see	IEditorPreferences::put_CharSpan
STDMETHODIMP CEditorPreferences::put_CharSpan(short nCharSpan) {
	if(nCharSpan < 0)
		return E_INVALIDARG;

	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();

	if(layout.nCharSpan != nCharSpan) {
		layout.nCharSpan = nCharSpan;
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

/// @see	IEditorPreferences::put_CheckInputSequence
STDMETHODIMP CEditorPreferences::put_CheckInputSequence(BSTR bstrLanguage, VARIANT_BOOL bCheck) {
	CEditView::TOptions	options = m_view.GetOptions();

	for(size_t i = 0; i < _countof(ISCLanguages); ++i) {
		if(wcscmp(ISCLanguages[i].first, L"ainu") == 0) {
			options.sequenceCheckingLanguages |= ISCLanguages[i].second;
			m_view.SetOptions(options);
			return S_OK;
		}
	}
	return E_INVALIDARG;
}

///	@see	IEditorPreferences::put_CloseBoldChars
STDMETHODIMP CEditorPreferences::put_CloseBoldChars(VARIANT_BOOL bCloseBoldChars) {
	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
	if(settings.bCloseBoldCharacters != toBoolean(bCloseBoldChars)) {
		settings.bCloseBoldCharacters = toBoolean(bCloseBoldChars);
		m_view.GetLayoutSettings().SetSettings(settings);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_EndOfFileLabel
STDMETHODIMP CEditorPreferences::put_EndOfFileLabel(BSTR bstrEndOfFileLabel) {
	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
	settings.substitutionGlyphs.strEndOfFile = (bstrEndOfFileLabel != 0) ? bstrEndOfFileLabel : L"";
	m_view.GetLayoutSettings().SetSettings(settings);
	return S_OK;
}

///	@see	IEditorPreferences::put_GeneralWhiteSpaceSubstitutionChar
STDMETHODIMP CEditorPreferences::put_GeneralWhiteSpaceSubstitutionChar(long cp) {
	if(cp < 0 || cp > 0xFFFF)
		return E_INVALIDARG;

	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
	if(settings.substitutionGlyphs.chGeneralWhiteSpace != static_cast<char_t>(cp)) {
		settings.substitutionGlyphs.chGeneralWhiteSpace = static_cast<char_t>(cp);
		m_view.GetLayoutSettings().SetSettings(settings);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_HorizontalTabSubstitutionChar
STDMETHODIMP CEditorPreferences::put_HorizontalTabSubstitutionChar(long cp) {
	if(cp < 0 || cp > 0xFFFF)
		return E_INVALIDARG;

	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
	if(settings.substitutionGlyphs.chHorizontalTab != static_cast<char_t>(cp)) {
		settings.substitutionGlyphs.chHorizontalTab = static_cast<char_t>(cp);
		m_view.GetLayoutSettings().SetSettings(settings);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_IdeographicSpaceSubstitutionChar
STDMETHODIMP CEditorPreferences::put_IdeographicSpaceSubstitutionChar(long cp) {
	if(cp < 0 || cp > 0xFFFF)
		return E_INVALIDARG;

	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
	if(settings.substitutionGlyphs.chIdeographicSpace != static_cast<char_t>(cp)) {
		settings.substitutionGlyphs.chIdeographicSpace = static_cast<char_t>(cp);
		m_view.GetLayoutSettings().SetSettings(settings);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_LeadMargin
STDMETHODIMP CEditorPreferences::put_LeadMargin(short nLeadMargin) {
	if(nLeadMargin < 0)
		return E_INVALIDARG;

	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();

	if(layout.nLeadMargin != nLeadMargin) {
		layout.nLeadMargin = nLeadMargin;
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

/// @see	IEditorPreferences::put_LexicalParsingEnabled
STDMETHODIMP CEditorPreferences::put_LexicalParsingEnabled(VARIANT_BOOL bEnabled) {
	m_view.GetLayoutSettings().EnableLexicalParsing(toBoolean(bEnabled));
	return S_OK;
}

/// @see	IEditorPreferences::put_LineBreakSubstitutionChar
STDMETHODIMP CEditorPreferences::put_LineBreakSubstitutionChar(::LineBreak lineBreak, long cp) {
	if(cp < 0 || cp > 0xFFFF)
		return E_INVALIDARG;

	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();
	switch(lineBreak) {
	case ::Lf:		layout.substitutionGlyphs.chUnixEol = static_cast<char_t>(cp);				break;
	case ::Cr:		layout.substitutionGlyphs.chMacintoshEol = static_cast<char_t>(cp);			break;
	case ::Crlf:	layout.substitutionGlyphs.chWindowsEol = static_cast<char_t>(cp);			break;
	case ::Nel:		layout.substitutionGlyphs.chEbcdicEol = static_cast<char_t>(cp);			break;
	case ::Ls:		layout.substitutionGlyphs.chLineSeparator = static_cast<char_t>(cp);		break;
	case ::Ps:		layout.substitutionGlyphs.chParagraphSeparator = static_cast<char_t>(cp);	break;
	default:		return E_INVALIDARG;
	}
	m_view.GetLayoutSettings().SetSettings(layout);
	return S_OK;
}

///	@see	IEditorPreferences::put_LineNumberBorderStyle
STDMETHODIMP CEditorPreferences::put_LineNumberBorderStyle(::BorderType style) {
	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();

	switch(style) {
		case NoBorder:		layout.lineNumberLayout.borderStyle = TLineNumberLayout::LNBS_NONE;		break;
		case BorderSolid:	layout.lineNumberLayout.borderStyle = TLineNumberLayout::LNBS_SOLID;	break;
		case BorderDashed:	layout.lineNumberLayout.borderStyle = TLineNumberLayout::LNBS_DASHED;	break;
		case BorderDotted:	layout.lineNumberLayout.borderStyle = TLineNumberLayout::LNBS_DOTTED;	break;
		default:			return E_INVALIDARG;
	}
	m_view.GetLayoutSettings().SetSettings(layout);
	return S_OK;
}

///	@see	IEditorPreferences::put_LineNumberBorderWidth
STDMETHODIMP CEditorPreferences::put_LineNumberBorderWidth(short nWidth) {
	if(nWidth < 0)
		return E_INVALIDARG;

	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();

	if(layout.lineNumberLayout.nBorderWidth != nWidth) {
		layout.lineNumberLayout.nBorderWidth = nWidth;
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_LineSpan
STDMETHODIMP CEditorPreferences::put_LineSpan(short nLineSpan) {
	if(nLineSpan < 0)
		return E_INVALIDARG;

	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();

	if(layout.nLineSpan != nLineSpan) {
		layout.nLineSpan = nLineSpan;
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_MatchBracketScanLines
STDMETHODIMP CEditorPreferences::put_MatchBracketScanLines(long cLines) {
	if(cLines < 0)
		return E_INVALIDARG;

	CEditView::TOptions	options = m_view.GetOptions();
	if(options.cRecognizingLines != cLines) {
		options.cRecognizingLines = cLines;
		m_view.SetOptions(options);
	}
	return S_OK;
}

/// @see	IEditorPreferences::put_PerformBidirection
STDMETHODIMP CEditorPreferences::put_PerformBidirection(VARIANT_BOOL bPerform) {
	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
//	if(settings.bPerformBidirection != toBoolean(bPerform)) {
//		settings.bPerformBidirection = toBoolean(bPerform);
//		m_view.GetLayoutSettings().SetSettings(settings);
//	}
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::put_ResetDirectionByTokens
STDMETHODIMP CEditorPreferences::put_ResetDirectionByTokens(VARIANT_BOOL bResetDirByTokens) {
	return E_NOTIMPL;
//	PUT_DISPLAY_OPTION(RESET_DIRECTION_BY_TOKEN, bResetDirByTokens);
}

///	@see	IEditorPreferences::put_RightToLeftReading
STDMETHODIMP CEditorPreferences::put_RightToLeftReading(VARIANT_BOOL bRightToLeft) {
	return E_NOTIMPL;
//	PUT_DISPLAY_OPTION(RIGHT_TO_LEFT_READING, bResetDirByTokens);
}

///	@see	IEditorPreferences::put_SelectEndOfLine
STDMETHODIMP CEditorPreferences::put_SelectEndOfLine(VARIANT_BOOL bSelectEndOfLine) {
	PUT_DISPLAY_OPTION(SHOW_SELECTION_ON_BREAK, bSelectEndOfLine);
}

///	@see	IEditorPreferences::put_ShowBidirectionalFormatters
STDMETHODIMP CEditorPreferences::put_ShowBidirectionalFormatters(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_UNICODE_CONTROLS, bShow);
}

///	@see	IEditorPreferences::put_ShowCurrentUnderline
STDMETHODIMP CEditorPreferences::put_ShowCurrentUnderline(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_CURRENT_UNDERLINE, bShow);
}

///	@see	IEditorPreferences::put_ShowEndOfFile
STDMETHODIMP CEditorPreferences::put_ShowEndOfFile(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_END_OF_FILE, bShow);
}

///	@see	IEditorPreferences::put_ShowEndOfLine
STDMETHODIMP CEditorPreferences::put_ShowEndOfLine(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_BREAK_ARROWS, bShow);
}

///	@see	IEditorPreferences::put_ShowHandOnLink
STDMETHODIMP CEditorPreferences::put_ShowHandOnLink(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_HAND_ON_LINK, bShow);
}

///	@see	IEditorPreferences::put_ShowHintOnLink
STDMETHODIMP CEditorPreferences::put_ShowHintOnLink(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_HINT_ON_LINK, bShow);
}

///	@see	IEditorPreferences::put_ShowIndicatorMargin
STDMETHODIMP CEditorPreferences::put_ShowIndicatorMargin(VARIANT_BOOL bShow) {
	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();
	if(layout.lineNumberLayout.bShowIndicatorMargin != toBoolean(bShow)) {
		layout.lineNumberLayout.bShowIndicatorMargin = toBoolean(bShow);
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowLineNumber
STDMETHODIMP CEditorPreferences::put_ShowLineNumber(VARIANT_BOOL bShow) {
	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();
	if(layout.lineNumberLayout.bShowLineNumbers != toBoolean(bShow)) {
		layout.lineNumberLayout.bShowLineNumbers = toBoolean(bShow);
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowWhiteSpaceAlternative
STDMETHODIMP CEditorPreferences::put_ShowWhiteSpaceAlternative(VARIANT_BOOL bShow) {
	PUT_DISPLAY_OPTION(SHOW_WHITESPACE_ALTERNATIVE, bShow);
}

///	@see	IEditorPreferences::put_StartCharNumber
STDMETHODIMP CEditorPreferences::put_StartCharNumber(long nStartCharNumber) {
	if(nStartCharNumber < 0)
		return E_INVALIDARG;

	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
	if(settings.iStartChar != nStartCharNumber) {
		settings.iStartChar = nStartCharNumber;
		m_view.GetLayoutSettings().SetSettings(settings);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_StartLineNumber
STDMETHODIMP CEditorPreferences::put_StartLineNumber(long nStartLineNumber) {
	if(nStartLineNumber < 0)
		return E_INVALIDARG;

	TLayoutSettings	settings = m_view.GetLayoutSettings().GetSettings();
	if(settings.lineNumberLayout.iStartLine != nStartLineNumber) {
		settings.lineNumberLayout.iStartLine = nStartLineNumber;
		m_view.GetLayoutSettings().SetSettings(settings);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_TabWidth
STDMETHODIMP CEditorPreferences::put_TabWidth(short nTabWidth) {
	if(nTabWidth < 0)
		return E_INVALIDARG;

	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();

	if(layout.cchTabWidth != nTabWidth) {
		layout.cchTabWidth = nTabWidth;
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

///	@see	IEditorPreferences::put_ThinCaret
STDMETHODIMP CEditorPreferences::put_ThinCaret(VARIANT_BOOL bThinCaret) {
	PUT_DISPLAY_OPTION(THIN_CARET, bThinCaret);
}

///	@see	IEditorPreferences::put_TopMargin
STDMETHODIMP CEditorPreferences::put_TopMargin(short nTopMargin) {
	if(nTopMargin < 0)
		return E_INVALIDARG;

	TLayoutSettings	layout = m_view.GetLayoutSettings().GetSettings();

	if(layout.nTopMargin != nTopMargin) {
		layout.nTopMargin = nTopMargin;
		m_view.GetLayoutSettings().SetSettings(layout);
	}
	return S_OK;
}

/// @see	IEditorPreferences::put_UseEditorFontForCompletion
STDMETHODIMP CEditorPreferences::put_UseEditorFontForCompletion(VARIANT_BOOL bUse) {
	PUT_DISPLAY_OPTION(USE_EDITOR_FONT_FOR_COMPLETION, bUse);
}

///	@see	IEditorPreferences::put_WrapMode
STDMETHODIMP CEditorPreferences::put_WrapMode(::WrapMode wrapMode) {
//	m_view.SetWrapMode(static_cast<Ascension::WrapMode>(wrapMode));
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::put_WrapWidth
STDMETHODIMP CEditorPreferences::put_WrapWidth(short nWrapWidth) {
//	m_view.SetWrapWidth(nWrapWidth);
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::Reset
STDMETHODIMP CEditorPreferences::Reset() {
	m_view.SetOptions(CEditView::TOptions());
	m_view.GetLayoutSettings().ResetConfigurations();
	return S_OK;
}

#undef GET_DISPLAY_OPTION
#undef PUT_DISPLAY_OPTION


// CTokenDecoration class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {	// Win32 API ƃXNvgnŐF̕\
	inline long WinRGBToScriptRGB(COLORREF clr) {
		return (clr == -1) ? -1 : (GetBValue(clr) | (GetGValue(clr) << 8) | (GetRValue(clr) << 16));
	}
	inline COLORREF ScriptRGBToWinRGB(long clr) {
		return (clr == -1) ? -1 : RGB((clr & 0xFF0000) >> 16, (clr & 0x00FF00) >> 8, clr & 0x0000FF);
	}
}

// CEditView::GetTextFoundation ͗O𓊂̂łňꊇ
#define GET_TF()																			\
	TTextFoundation	_tf;																	\
	try {																					\
		_tf = m_view.GetLayoutSettings().GetTokenFoundation(m_nTokenType, m_nTokenCookie);	\
	} catch(invalid_argument&) {															\
		return E_UNEXPECTED;																\
	}

/**
 *	RXgN^
 *	@param view			r[
 *	@param nTokenType	g[N̎
 *	@param nTokenCookie	g[ÑNbL[l
 */
CTokenDecoration::CTokenDecoration(CEditView& view, int nTokenType, TokenCookie nTokenCookie)
		: SAFE_MARK, m_view(view), m_nTokenType(nTokenType), m_nTokenCookie(nTokenCookie) {
}

///	@see	ITokenDecoration::get_BackgroundColor
STDMETHODIMP CTokenDecoration::get_BackgroundColor(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = WinRGBToScriptRGB(_tf.bgColor);
	return S_OK;
}

///	@see	ITokenDecoration::get_BoldFont
STDMETHODIMP CTokenDecoration::get_BoldFont(VARIANT_BOOL* pbBold) {
	VERIFY_POINTER(pbBold);
	GET_TF();
	*pbBold = toVariantBoolean(_tf.bold);
	return S_OK;
}

///	@see	ITokenDecoration::get_BorderColor
STDMETHODIMP CTokenDecoration::get_BorderColor(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = _tf.borderColor;
	return S_OK;
}

///	@see	ITokenDecoration::get_BorderStyle
STDMETHODIMP CTokenDecoration::get_BorderStyle(::BorderType* pBorderType) {
	VERIFY_POINTER(pBorderType);
	GET_TF();
	*pBorderType = static_cast<::BorderType>(_tf.border);
	return S_OK;
}

///	@see	ITokenDecoration::get_Color
STDMETHODIMP CTokenDecoration::get_Color(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = WinRGBToScriptRGB(_tf.fgColor);
	return S_OK;
}

///	@see	ITokenDecoration::get_ItalicFont
STDMETHODIMP CTokenDecoration::get_ItalicFont(VARIANT_BOOL* pbItalic) {
	VERIFY_POINTER(pbItalic);
	GET_TF();
	*pbItalic = toVariantBoolean(_tf.italic);
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTokenDecoration::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TOKENDECORATION_BACKGROUNDCOLOR:	CALL_GETTER(BackgroundColor, VT_I4);
		case DISPID_TOKENDECORATION_BOLDFONT:			CALL_GETTER(BoldFont, VT_BOOL);
		case DISPID_TOKENDECORATION_COLOR:				CALL_GETTER(Color, VT_I4);
		case DISPID_TOKENDECORATION_ITALICFONT:			CALL_GETTER(ItalicFont, VT_BOOL);
		case DISPID_TOKENDECORATION_BORDERSTYLE:		CALL_GETTER_ENUM(BorderStyle, ::BorderType);
		case DISPID_TOKENDECORATION_BORDERCOLOR:		CALL_GETTER(BorderColor, VT_I4);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_TOKENDECORATION_BACKGROUNDCOLOR:	CALL_PUTTER(BackgroundColor, VT_I4);
		case DISPID_TOKENDECORATION_BOLDFONT:			CALL_PUTTER(BoldFont, VT_BOOL);
		case DISPID_TOKENDECORATION_COLOR:				CALL_PUTTER(Color, VT_I4);
		case DISPID_TOKENDECORATION_ITALICFONT:			CALL_PUTTER(ItalicFont, VT_BOOL);
		case DISPID_TOKENDECORATION_BORDERSTYLE:		CALL_PUTTER_ENUM(BorderStyle, ::BorderType);
		case DISPID_TOKENDECORATION_BORDERCOLOR:		CALL_PUTTER(BorderColor, VT_I4);
		}
	}
	return hr;
}

///	@see	ITokenDecoration::put_BackgroundColor
STDMETHODIMP CTokenDecoration::put_BackgroundColor(long nColor) {
	GET_TF();
	const COLORREF	clr = toBoolean(nColor & 0x80000000) ? nColor : ScriptRGBToWinRGB(nColor);

	if(clr != _tf.bgColor) {
		_tf.bgColor = clr;
		m_view.GetLayoutSettings().SetTokenFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BoldFont
STDMETHODIMP CTokenDecoration::put_BoldFont(VARIANT_BOOL bBold) {
	GET_TF();
	if(_tf.bold != toBoolean(bBold)) {
		_tf.bold = toBoolean(bBold);
		m_view.GetLayoutSettings().SetTokenFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BorderColor
STDMETHODIMP CTokenDecoration::put_BorderColor(long nColor) {
	GET_TF();
	const COLORREF	clr = toBoolean(nColor & 0x80000000) ? nColor : ScriptRGBToWinRGB(nColor);

	if(clr != _tf.borderColor) {
		_tf.borderColor = clr;
		m_view.GetLayoutSettings().SetTokenFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BorderStyle
STDMETHODIMP CTokenDecoration::put_BorderStyle(::BorderType borderType) {
	GET_TF();
	if(_tf.border != static_cast<Ascension::BorderType>(borderType)) {
		_tf.border = static_cast<Ascension::BorderType>(borderType);
		m_view.GetLayoutSettings().SetTokenFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_Color
STDMETHODIMP CTokenDecoration::put_Color(long nColor) {
	GET_TF();
	const COLORREF	clr = toBoolean(nColor & 0x80000000) ? nColor : ScriptRGBToWinRGB(nColor);

	if(clr != _tf.fgColor) {
		_tf.fgColor = clr;
		m_view.GetLayoutSettings().SetTokenFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_ItalicFont
STDMETHODIMP CTokenDecoration::put_ItalicFont(VARIANT_BOOL bItalic) {
	GET_TF();
	if(_tf.italic != toBoolean(bItalic)) {
		_tf.italic = toBoolean(bItalic);
		m_view.GetLayoutSettings().SetTokenFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

#undef GET_TF


// CSearchOptions class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	ISearchOptions::get_CaseSensitivity
STDMETHODIMP CSearchOptions::get_CaseSensitivity(CaseFoldingType* pOptions) {
	VERIFY_POINTER(pOptions);
	*pOptions = static_cast<CaseFoldingType>(m_options.caseSensitivity);
	return S_OK;
}

///	@see	ISearchOptions::get_CharacterSkipOption
STDMETHODIMP CSearchOptions::get_CharacterSkipOption(CharacterSkipType* pOptions) {
	VERIFY_POINTER(pOptions);
	*pOptions = static_cast<CharacterSkipType>(m_options.characterSkipOptions);
	return S_OK;
}

///	@see	ISearchOptions::get_FoldingOption
STDMETHODIMP CSearchOptions::get_FoldingOption(FoldingType* pOptions) {
	VERIFY_POINTER(pOptions);
	*pOptions = static_cast<FoldingType>(m_options.foldingOptions);
	return S_OK;
}

///	@see	ISearchOptions::get_MultigraphExpansionOption
STDMETHODIMP CSearchOptions::get_MultigraphExpansionOption(MultigraphExpansionType* pOptions) {
	VERIFY_POINTER(pOptions);
	*pOptions = static_cast<MultigraphExpansionType>(m_options.multigraphExpansionOptions);
	return S_OK;
}

///	@see	ISearchOptions::get_OnlyIdentifier
STDMETHODIMP CSearchOptions::get_OnlyIdentifiers(VARIANT_BOOL* pbOnlyIdentifiers) {
	VERIFY_POINTER(pbOnlyIdentifiers);
//	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchOptions() & SF_ONLYIDENTIFIERS);
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	ISearchOptions::get_SearchType
STDMETHODIMP CSearchOptions::get_SearchType(::SearchType* pType) {
	VERIFY_POINTER(pType);
	switch(m_options.type) {
	case ST_LITERAL:	*pType = Literal;	break;
	case ST_REGEXP:		*pType = Regexp;	break;
	case ST_WILDCARD:	*pType = Wildcard;	break;
	case ST_MIGEMO:		*pType = Migemo;	break;
	}
	return S_OK;
}

///	@see	ISearchOptions::get_WholeWord
STDMETHODIMP CSearchOptions::get_WholeWord(VARIANT_BOOL* pbWholeWord) {
	VERIFY_POINTER(pbWholeWord);
	*pbWholeWord = toVariantBoolean(m_options.bWholeWord);
	return S_OK;
}

///	@see	ISearchOptions::Invoke
STDMETHODIMP CSearchOptions::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*		pArray = 0;
	BSTR*			arrBstrArgs = 0;
	bool			bCreatedResult = false;
	CComVariant		args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_SEARCHOPTIONS_CASESENSITIVITY:				CALL_GETTER_ENUM(CaseSensitivity, CaseFoldingType);
		case DISPID_SEARCHOPTIONS_CHARACTERSKIPOPTION:			CALL_GETTER_ENUM(CharacterSkipOption, CharacterSkipType);
		case DISPID_SEARCHOPTIONS_FOLDINGOPTION:				CALL_GETTER_ENUM(FoldingOption, FoldingType);
		case DISPID_SEARCHOPTIONS_MULTIGRAPHEXPANSIONOPTION:	CALL_GETTER_ENUM(MultigraphExpansionOption, MultigraphExpansionType);
		case DISPID_SEARCHOPTIONS_ONLYIDENTIFIERS:				CALL_GETTER(OnlyIdentifiers, VT_BOOL);
		case DISPID_SEARCHOPTIONS_SEARCHTYPE:					CALL_GETTER_ENUM(SearchType, ::SearchType);
		case DISPID_SEARCHOPTIONS_WHOLEWORD:					CALL_GETTER(WholeWord, VT_BOOL);
		}
	} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT)) {	// vb^
		switch(dispidMember) {
		case DISPID_SEARCHOPTIONS_CASESENSITIVITY:				CALL_PUTTER_ENUM(CaseSensitivity, CaseFoldingType);
		case DISPID_SEARCHOPTIONS_CHARACTERSKIPOPTION:			CALL_PUTTER_ENUM(CharacterSkipOption, CharacterSkipType);
		case DISPID_SEARCHOPTIONS_FOLDINGOPTION:				CALL_PUTTER_ENUM(FoldingOption, FoldingType);
		case DISPID_SEARCHOPTIONS_MULTIGRAPHEXPANSIONOPTION:	CALL_PUTTER_ENUM(MultigraphExpansionOption, MultigraphExpansionType);
		case DISPID_SEARCHOPTIONS_ONLYIDENTIFIERS:				CALL_PUTTER(OnlyIdentifiers, VT_BOOL);
		case DISPID_SEARCHOPTIONS_SEARCHTYPE:					CALL_PUTTER_ENUM(SearchType, ::SearchType);
		case DISPID_SEARCHOPTIONS_WHOLEWORD:					CALL_PUTTER(WholeWord, VT_BOOL);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
	}
	return hr;
}

///	@see	ISearchOptions::put_CaseSensitivity
STDMETHODIMP CSearchOptions::put_CaseSensitivity(CaseFoldingType caseFoldingType) {
	switch(caseFoldingType) {
	case MatchCase:				m_options.caseSensitivity = CS_NONE;	break;
	case IgnoreAsciiAlphabets:	m_options.caseSensitivity = CS_ASCII;	break;
	case UnicodeSimple:			m_options.caseSensitivity = CS_SIMPLE;	break;
	case UnicodeFull:			m_options.caseSensitivity = CS_FULL;	break;
	default:					return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ISearchOptions::put_CharacterSkipOption
STDMETHODIMP CSearchOptions::put_CharacterSkipOption(CharacterSkipType options) {
	m_options.characterSkipOptions = options;
	return S_OK;
}

///	@see	ISearchOptions::put_FoldingOption
STDMETHODIMP CSearchOptions::put_FoldingOption(FoldingType options) {
	m_options.foldingOptions = options;
	return S_OK;
}

///	@see	ISearchOptions::put_MultigraphExpansionOption
STDMETHODIMP CSearchOptions::put_MultigraphExpansionOption(MultigraphExpansionType options) {
	m_options.multigraphExpansionOptions = options;
	return S_OK;
}

///	@see	ISearchOptions::put_OnlyIdentifiers
STDMETHODIMP CSearchOptions::put_OnlyIdentifiers(VARIANT_BOOL bOnlyIdentifiers) {
//	m_options.bOnlyIdentifier = toBoolean(bOnlyIdentifiers);
	return E_NOTIMPL;
}

///	@see	ISearchOptions::put_SearchType
STDMETHODIMP CSearchOptions::put_SearchType(::SearchType type) {
	switch(type) {
	case Literal:	m_options.type = ST_LITERAL;	break;
	case Regexp:	m_options.type = ST_REGEXP;		break;
	case Wildcard:	return E_NOTIMPL;
	case Migemo:	m_options.type = ST_MIGEMO;		break;
	default:		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ISearchOptions::put_WholeWord
STDMETHODIMP CSearchOptions::put_WholeWord(VARIANT_BOOL bWholeWord) {
	m_options.bWholeWord = toBoolean(bWholeWord);
	return S_OK;
}


// CConfigurations class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CConfigurations::CConfigurations(CAlphaApp& app) : SAFE_MARK, m_app(app) {
}

///	@see	IConfigurations::AddDocumentType
STDMETHODIMP CConfigurations::AddDocumentType(BSTR bstrName, BSTR bstrFileSpec,
		BSTR bstrCommand /* = 0 */, VARIANT_BOOL bPrivate /* = VARIANT_FALSE */) {
	if(bstrName == 0 || bstrFileSpec == 0 || ::SysStringLen(bstrFileSpec) >= MAX_PATH)
		return E_INVALIDARG;

	TDocumentType	type;

	type.strName = bstrName;
	wcscpy(type.wszFileSpec, bstrFileSpec);
	type.strCommand = (bstrCommand != 0) ? bstrCommand : L"";
	type.bPrivate = toBoolean(bPrivate);
	m_app.GetBufferList().GetDocumentTypeManager().Add(type);
	return S_OK;
}

///	@see	IConfigurations::Apply
STDMETHODIMP CConfigurations::Apply() {
	m_app.LoadKeyBinds(L"");
	return S_OK;
}

///	@see	IConfigurations::get__NewEnum
STDMETHODIMP CConfigurations::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);
	*ppEnum = 0;
	return E_NOTIMPL;
}

///	@see	IConfigurations::get_KeyboardScheme
STDMETHODIMP CConfigurations::get_KeyboardSchemes(BSTR bstrScopeName, IKeyboardScheme** ppKeyboardScheme) {
	VERIFY_POINTER(ppKeyboardScheme);
	*ppKeyboardScheme = 0;
	if(bstrScopeName == 0)
		return E_INVALIDARG;
	else if(wcscmp(bstrScopeName, L"basic") != 0)	// ̂Ƃ1
		return E_INVALIDARG;

	if(0 == (*ppKeyboardScheme = new CKeyboardScheme(m_app.GetKeyboardMap())))
		return E_OUTOFMEMORY;
	(*ppKeyboardScheme)->AddRef();
	return S_OK;
}

///	@see	IConfigurations::get_Property
STDMETHODIMP CConfigurations::get_Property(BSTR bstrName, BSTR* pbstrValue) {
	VERIFY_POINTER(pbstrValue);
	if(bstrName == 0)
		return E_INVALIDARG;
	*pbstrValue = 0;
	return E_NOTIMPL;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CConfigurations::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[4];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_CONFIGURATIONS_NEWENUM:			CALL_GETTER(_NewEnum, VT_UNKNOWN);
		case DISPID_CONFIGURATIONS_KEYBOARDSCHEMES:	CALL_GETTER_ACTX_1(KeyboardSchemes, VT_BSTR, IKeyboardScheme);
		case DISPID_CONFIGURATIONS_PROPERTY:		CALL_GETTER_1(Property, VT_BSTR, VT_BSTR);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		if(dispidMember == DISPID_CONFIGURATIONS_PROPERTY) {
			CALL_PUTTER_1(Property, VT_BSTR, VT_BSTR);
		}
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_CONFIGURATIONS_ADDDOCUMENTTYPE:
			if(pDispParams->cArgs == 4) {
				CALL_METHOD_4(AddDocumentType, VT_BSTR, VT_BSTR, VT_BSTR, VT_BOOL);
			} else if(pDispParams->cArgs == 3) {
				CALL_METHOD_3(AddDocumentType, VT_BSTR, VT_BSTR, VT_BSTR);
			} else if(pDispParams->cArgs == 2) {
				CALL_METHOD_2(AddDocumentType, VT_BSTR, VT_BSTR);
			}
				return DISP_E_BADPARAMCOUNT;
		case DISPID_CONFIGURATIONS_APPLY:					CALL_METHOD_0(Apply);
		case DISPID_CONFIGURATIONS_REMOVEALLDOCUMENTTYPES:	CALL_METHOD_0(RemoveAllDocumentTypes);
		}
	}
	return hr;
}

///	@see	IConfigurations::put_Property
STDMETHODIMP CConfigurations::put_Property(BSTR bstrName, BSTR bstrValue) {
	if(bstrName == 0)
		return E_INVALIDARG;

	m_modifiedProperties[bstrName] = (bstrValue != 0) ? bstrValue : L"";
	return S_OK;
}

///	@see	IConfigurations::RemoveAllDocumentTypes
STDMETHODIMP CConfigurations::RemoveAllDocumentTypes() {
	m_app.GetBufferList().GetDocumentTypeManager().RemoveAll();
	return S_OK;
}


// CKeyboardScheme class implementation
/////////////////////////////////////////////////////////////////////////////

map<wstring, VirtualKey> CKeyboardScheme::m_keyValues;

///	RXgN^
CKeyboardScheme::CKeyboardScheme(CKeyboardMap& impl) : SAFE_MARK, m_impl(impl) {
}

///	@see	IKeyboardScheme::Assign
STDMETHODIMP CKeyboardScheme::Assign(BSTR bstrKeyCombination, VARIANT command_, VARIANT_BOOL* pbOverridden) {
	TKeyCombination	keys1, keys2;

	if(!_ParseKeyCombinationString(bstrKeyCombination, keys1, keys2))
		return E_INVALIDARG;
	if(command_.vt != VT_I4 && command_.vt != VT_DISPATCH)
		return E_INVALIDARG;

	CComVariant						command = command_;
	Alpha::CKeyAssignableCommand*	pNewCommand = (command.vt == VT_I4) ?
		new CBuiltInCommand(static_cast<CommandId>(command.lVal))
		: static_cast<Alpha::CKeyAssignableCommand*>(new CScriptletCommand(command.pdispVal));
	const bool	bOverridden = (keys2.key == VK_NULL) ?
		m_impl.Assign(*pNewCommand, keys1) : m_impl.Assign(*pNewCommand, keys1, keys2);

	if(pbOverridden != 0)
		*pbOverridden = toVariantBoolean(bOverridden);
	delete pNewCommand;
	return S_OK;
}

///	@see	IKeyboardScheme::get_Name
STDMETHODIMP CKeyboardScheme::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);
	*pbstrName = ::SysAllocString(m_strSchemeName.c_str());
	return (*pbstrName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CKeyboardScheme::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {
		if(dispidMember == DISPID_KEYBOARDSCHEME_NAME) {
			CALL_GETTER(Name, VT_BSTR);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {
		switch(dispidMember) {
		case DISPID_KEYBOARDSCHEME_ASSIGN:		CALL_METHOD_RET_2(Assign, VT_BOOL, VT_BSTR, VT_VARIANT);
		case DISPID_KEYBOARDSCHEME_LOAD:		CALL_METHOD_1(Load, VT_BSTR);
		case DISPID_KEYBOARDSCHEME_SAVE:		CALL_METHOD_1(Save, VT_BSTR);
		case DISPID_KEYBOARDSCHEME_UNASSIGN:	CALL_METHOD_1(Unassign, VT_BSTR);
		}
	}
	return hr;
}

///	@see	IKeyboardScheme::Load
STDMETHODIMP CKeyboardScheme::Load(BSTR bstrSchemeName) {
	if(bstrSchemeName == 0)
		return E_INVALIDARG;

	wchar_t	wszPath[MAX_PATH];

	::GetModuleFileName(0, wszPath, MAX_PATH);
	wcscpy(::PathFindFileNameW(wszPath), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(wszPath) + ::SysStringLen(bstrSchemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(wszPath, bstrSchemeName);
	wcscat(wszPath, L".akm");
	if(m_impl.Load(wszPath)) {
		m_strSchemeName = bstrSchemeName;
		return S_OK;
	}
	return E_FAIL;
}

bool CKeyboardScheme::_ParseKeyCombinationString(
		const BSTR bstr, TKeyCombination& firstKeys, TKeyCombination& secondKeys) {
	if(bstr == 0 || ::SysStringLen(bstr) > 100)
		return false;

	if(m_keyValues.empty()) {
		wchar_t	wsz[4] = {0, 0, 0, 0};
		m_keyValues[L"bs"] = m_keyValues[L"backspace"] = VK_BACK;
		m_keyValues[L"tab"] = VK_TAB;
		m_keyValues[L"del"] = m_keyValues[L"delete"] = VK_DELETE;
		m_keyValues[L"enter"] = VK_RETURN;
		m_keyValues[L"esc"] = m_keyValues[L"escape"] = VK_ESCAPE;
		m_keyValues[L"sp"] = m_keyValues[L"space"] = VK_SPACE;
		m_keyValues[L"pgup"] = m_keyValues[L"pageup"] = VK_PRIOR;
		m_keyValues[L"pgdn"] = m_keyValues[L"pagedown"] = VK_NEXT;
		m_keyValues[L"end"] = VK_END;
		m_keyValues[L"home"] = VK_HOME;
		m_keyValues[L"left"] = VK_LEFT;
		m_keyValues[L"up"] = VK_UP;
		m_keyValues[L"right"] = VK_RIGHT;
		m_keyValues[L"down"] = VK_DOWN;
		m_keyValues[L"ins"] = m_keyValues[L"insert"] = VK_INSERT;
		for(size_t i = 0; i < 10; ++i) {
			wsz[0] = L'0' + i;
			m_keyValues[wsz] = '0' + i;
		}
		for(size_t i = 0; i < 26; ++i) {
			wsz[0] = L'a' + i;
			m_keyValues[wsz] = 'A' + i;
		}
		wsz[0] = L'f';
		for(size_t i = 0; i < 10; ++i) {
			wsz[1] = L'0' + i + 1;
			m_keyValues[wsz] = VK_F1 + i;
		}
		wsz[1] = L'1';
		for(size_t i = 0; i < 10; ++i) {
			wsz[2] = L'0' + i;
			m_keyValues[wsz] = VK_F10 + i;
		}
		wsz[1] = L'2';
		for(size_t i = 0; i < 4; ++i) {
			wsz[2] = L'0' + i;
			m_keyValues[wsz] = VK_F20 + i;
		}
		m_keyValues[L":"] = VK_OEM_1;
		m_keyValues[L";"] = VK_OEM_PLUS;
		m_keyValues[L","] = VK_OEM_COMMA;
		m_keyValues[L"-"] = VK_OEM_MINUS;
		m_keyValues[L"."] = VK_OEM_PERIOD;
		m_keyValues[L"/"] = VK_OEM_2;
		m_keyValues[L"@"] = VK_OEM_3;
		m_keyValues[L"["] = VK_OEM_4;
		m_keyValues[L"\\"] = VK_OEM_5;
		m_keyValues[L"]"] = VK_OEM_6;
		m_keyValues[L"^"] = VK_OEM_7;
	}

	wchar_t		wszKeys[120];	// wcsncmp ĝő߂...
	KeyModifier	modifiers = 0;
	wchar_t*	p = wszKeys;

	firstKeys.key = secondKeys.key = VK_NULL;
	wcscpy(wszKeys, bstr);
	::CharLowerBuffW(wszKeys, wcslen(wszKeys));

	// ͂ŏCL[ƃCL[o
	while(*p != 0) {
		if(wcsncmp(p, L"c-", 2) == 0)			{modifiers |= KM_CTRL; p += 2;}
		else if(wcsncmp(p, L"ctrl+", 5) == 0)	{modifiers |= KM_CTRL; p += 5;}
		else if(wcsncmp(p, L"s-", 2) == 0)		{modifiers |= KM_SHIFT; p += 2;}
		else if(wcsncmp(p, L"shift+", 6) == 0)	{modifiers |= KM_SHIFT; p += 6;}
		else if(wcsncmp(p, L"m-", 2) == 0)		{modifiers |= KM_ALT; p += 2;}
		else if(wcsncmp(p, L"alt+", 4) == 0)	{modifiers |= KM_ALT; p += 4;}
		else {	// CL[
			wchar_t*	pwszSp = wcschr(p, L' ');
			if(pwszSp == p)
				return false;	// 擪ɋ󔒂
			if(pwszSp != 0) {
				if(firstKeys.key != VK_NULL)
					return false;	// 󔒂2ȏ゠
				*pwszSp = 0;
			}
			map<wstring, VirtualKey>::const_iterator	it = m_keyValues.find(p);
			if(it == m_keyValues.end())
				return false;	// CL[Ȃ
			if(firstKeys.key == VK_NULL) {
				firstKeys.key = it->second;
				firstKeys.modifiers = modifiers;
			} else {
				secondKeys.key = it->second;
				secondKeys.modifiers = modifiers;
			}
			if(pwszSp != 0) {
				p = pwszSp + 1;
				modifiers = 0;
			} else
				break;
		}
	}
	return firstKeys.key != VK_NULL;	// CL[1
}

///	@see	IKeyboardScheme::Save
STDMETHODIMP CKeyboardScheme::Save(BSTR bstrSchemeName) {
	if(bstrSchemeName == 0)
		return E_INVALIDARG;

	wchar_t	wszPath[MAX_PATH];

	::GetModuleFileName(0, wszPath, MAX_PATH);
	wcscpy(::PathFindFileNameW(wszPath), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(wszPath) + ::SysStringLen(bstrSchemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(wszPath, bstrSchemeName);
	wcscat(wszPath, L".akm");
	if(m_impl.Save(wszPath)) {
		m_strSchemeName = bstrSchemeName;
		return S_OK;
	}
	return E_FAIL;
}

/// @see	IKeyboardScheme::Unassign
STDMETHODIMP CKeyboardScheme::Unassign(BSTR bstrKeyCombination) {
	TKeyCombination	keys1, keys2;
	if(!_ParseKeyCombinationString(bstrKeyCombination, keys1, keys2))
		return E_INVALIDARG;
	if(keys2.key == VK_NULL)
		m_impl.Unassign(keys1);
	else
		m_impl.Unassign(keys1, keys2);
	return S_OK;
}


// CCommand class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param app	AvP[VIuWFNg
 *	@param id	R}hʎq
 */
Ambient::CCommand::CCommand(CAlphaApp& app, CommandId id) : SAFE_MARK, m_app(app), m_id(id) {
}

///	@see	ICommand::Execute
STDMETHODIMP Ambient::CCommand::Execute() {
	const_cast<CCommandManager&>(m_app.GetCommandManager()).ExecuteCommand(m_id, false);	// Y
	return S_OK;
}

///	@see	ICommand::get_Checked
STDMETHODIMP Ambient::CCommand::get_Checked(VARIANT_BOOL* pbChecked) {
	VERIFY_POINTER(pbChecked);
	*pbChecked = toVariantBoolean(m_app.GetCommandManager().IsChecked(m_id));
	return S_OK;
}

///	@see	ICommand::get_Description
STDMETHODIMP Ambient::CCommand::get_Description(BSTR* pbstrDescription) {
	VERIFY_POINTER(pbstrDescription);
	*pbstrDescription = ::SysAllocString(m_app.GetCommandManager().GetDescription(m_id).c_str());
	return (*pbstrDescription != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	ICommand::get_Enabled
STDMETHODIMP Ambient::CCommand::get_Enabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_app.GetCommandManager().IsEnabled(m_id, false));
	return S_OK;
}

/// @see	ICommand::get_Id
STDMETHODIMP Ambient::CCommand::get_Id(long* pnId) {
	VERIFY_POINTER(pnId);
	*pnId = m_id;
	return S_OK;
}

///	@see	ICommand::get_KeyCombination
STDMETHODIMP Ambient::CCommand::get_KeyCombination(BSTR* pbstrKeys) {
	VERIFY_POINTER(pbstrKeys);
	*pbstrKeys = ::SysAllocString(m_app.GetKeyboardMap().GetKeyString(m_id, false).c_str());
	return (*pbstrKeys != 0) ? S_OK  : E_OUTOFMEMORY;
}

///	@see	ICommand::get_Name
STDMETHODIMP Ambient::CCommand::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);

	wstring	strName = m_app.GetCommandManager().GetCaption(m_id);
	size_t	i = strName.find(L'(');

	if(i != wstring::npos) {
		strName = strName.substr(0, i);
		i = strName.find(L'&');
		if(i != wstring::npos)
			strName.erase(i, 1);
	}
	*pbstrName = ::SysAllocString(strName.c_str());
	return (*pbstrName != 0) ? S_OK  : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP Ambient::CCommand::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
//	CComVariant		args[3];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_COMMAND_CHECKED:		CALL_GETTER(Checked, VT_BOOL);
		case DISPID_COMMAND_DESCRIPTION:	CALL_GETTER(Description, VT_BSTR);
		case DISPID_COMMAND_ENABLED:		CALL_GETTER(Enabled, VT_BOOL);
		case DISPID_COMMAND_ID:				CALL_GETTER(Id, VT_I4);
		case DISPID_COMMAND_KEYCOMBINATION:	CALL_GETTER(KeyCombination, VT_BSTR);
		case DISPID_COMMAND_NAME:			CALL_GETTER(Name, VT_BSTR);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		if(dispidMember == DISPID_COMMAND_EXECUTE)
			CALL_METHOD_0(Execute);
	}
	return hr;
}

/// @see	IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::CCommand::IsEqualObject(IUnknown* punk) {
	if(punk == 0)
		return E_INVALIDARG;
	CComPtr<ICommand>	pRhs;
	if(FAILED(punk->QueryInterface(IID_ICommand, reinterpret_cast<void**>(&pRhs))))
		return S_FALSE;
	return (reinterpret_cast<Ambient::CCommand*>(static_cast<ICommand*>(pRhs))->m_id == m_id) ? S_OK : S_FALSE;
}


// CClipboardRing class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
Ambient::CClipboardRing::CClipboardRing(Ascension::CClipboardRing& impl) : SAFE_MARK, m_impl(impl) {
}

///	@see	IClipboardRing::Add
STDMETHODIMP Ambient::CClipboardRing::Add(BSTR bstrText) {
	if(bstrText == 0)
		return E_INVALIDARG;
	m_impl.Add(bstrText, false);
	return S_OK;
}

///	@see	IClipboardRing::Delete
STDMETHODIMP Ambient::CClipboardRing::Delete(short nIndex) {
	if(nIndex < 0 || nIndex > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;
	try {
		m_impl.Delete(static_cast<unsigned char>(nIndex));
	} catch(...) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IClipboardRing::DeleteAll
STDMETHODIMP Ambient::CClipboardRing::DeleteAll() {
	m_impl.DeleteAll();
	return S_OK;
}

///	@see	IClipboardRing::get_Count
STDMETHODIMP Ambient::CClipboardRing::get_Count(short* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = m_impl.GetCount();
	return S_OK;
}

///	@see	IClipboardRing::get_Text
STDMETHODIMP Ambient::CClipboardRing::get_Text(short nIndex, BSTR* pbstrText) {
	VERIFY_POINTER(pbstrText);
	if(nIndex < 0 || nIndex > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;

	wstring	str;
	bool	b;

	try {
		m_impl.GetText(static_cast<unsigned char>(nIndex), str, b);
	} catch(...) {
		return E_INVALIDARG;
	}
	*pbstrText = ::SysAllocString(str.c_str());
	return (*pbstrText != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP Ambient::CClipboardRing::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	CComVariant		args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_CLIPBOARDRING_COUNT:	CALL_GETTER(Count, VT_I2);
		case DISPID_CLIPBOARDRING_TEXT:		CALL_GETTER_1(Text, VT_BSTR, VT_I2);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		switch(dispidMember) {
		case DISPID_CLIPBOARDRING_ADD:			CALL_METHOD_1(Add, VT_BSTR);
		case DISPID_CLIPBOARDRING_DELETE:		CALL_METHOD_1(Delete, VT_I2);
		case DISPID_CLIPBOARDRING_DELETEALL:	CALL_METHOD_0(DeleteAll);
		case DISPID_CLIPBOARDRING_LIMITCOUNT:	CALL_METHOD_1(LimitCount, VT_I2);
		}
	}
	return hr;
}

/// @see	IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::CClipboardRing::IsEqualObject(IUnknown* punk) {
	if(punk == 0)
		return E_INVALIDARG;
	CComPtr<IClipboardRing>	dummy;
	return SUCCEEDED(punk->QueryInterface(IID_IClipboardRing, reinterpret_cast<void**>(&dummy))) ? S_OK : S_FALSE;
}

///	@see	IClipboardRing::LimitCount
STDMETHODIMP Ambient::CClipboardRing::LimitCount(short nLimit) {
	if(nLimit < 0 || nLimit > numeric_limits<uchar>::max())
		return E_INVALIDARG;
	m_impl.LimitCount(static_cast<uchar>(nLimit));
	return S_OK;
}


// CAutomationAbbreviations class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	IAbbreviations::Expand
STDMETHODIMP Ambient::CAbbreviations::Expand(BSTR bstrAbbrev, BSTR* pbstrExpanded) {
	VERIFY_POINTER(pbstrExpanded);
	*pbstrExpanded = 0;
	if(bstrAbbrev == 0 || *bstrAbbrev == 0)
		return E_INVALIDARG;
	const string_t	str = CAlphaApp::GetInstance().GetActiveView().GetAbbreviations().Expand(bstrAbbrev);
	*pbstrExpanded = ::SysAllocString(str.c_str());
	return (*pbstrExpanded != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IAbbreviations::get__NewEnum
STDMETHODIMP Ambient::CAbbreviations::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);

	set<string_t>	abbreviations;

	CAlphaApp::GetInstance().GetActiveView().GetAbbreviations().GetList(abbreviations);

	VARIANT* const	pAbbreviations = new VARIANT[abbreviations.size()];

	set<string_t>::const_iterator	it = abbreviations.begin();
	for(size_t i = 0; i < abbreviations.size(); ++i, ++it) {
		::VariantInit(&pAbbreviations[i]);
		pAbbreviations[i].vt = VT_BSTR;
		pAbbreviations[i].bstrVal = ::SysAllocString(it->c_str());
	}
	*ppEnum = new IEnumVARIANTImpl(pAbbreviations, abbreviations.size());
	if(*ppEnum != 0)
		(*ppEnum)->AddRef();

	for(size_t i = 0; i < abbreviations.size(); ++i)
		::VariantClear(&pAbbreviations[i]);
	delete[] pAbbreviations;

	return (*ppEnum != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IDispatch::Invoke
STDMETHODIMP Ambient::CAbbreviations::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_ABBREVIATIONS_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_ABBREVIATIONS_EXPAND:		CALL_METHOD_RET_1(Expand, VT_BSTR, VT_BSTR);
		case DISPID_ABBREVIATIONS_REGISTER:		CALL_METHOD_2(Register, VT_BSTR, VT_BSTR);
		case DISPID_ABBREVIATIONS_REVOKE:		CALL_METHOD_1(Revoke, VT_BSTR);
		case DISPID_ABBREVIATIONS_REVOKEALL:	CALL_METHOD_0(RevokeAll);
		}
	}

	return hr;
}

/// @see	IObjectIdentity::IsEqualObject
STDMETHODIMP Ambient::CAbbreviations::IsEqualObject(IUnknown* punk) {
	if(punk == 0)
		return E_INVALIDARG;
	CComPtr<IAbbreviations>	dummy;
	return SUCCEEDED(punk->QueryInterface(IID_IAbbreviations, reinterpret_cast<void**>(&dummy))) ? S_OK : S_FALSE;
}

///	@see	IAbbreviations::Register
STDMETHODIMP Ambient::CAbbreviations::Register(BSTR bstrAbbrev, BSTR bstrExpanded) {
	if(bstrAbbrev == 0 || bstrExpanded == 0)
		return E_INVALIDARG;
	try {
		CEditView::GetAbbreviations().Register(bstrAbbrev, bstrExpanded);
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IAutomationAbbreviations::Revoke
STDMETHODIMP Ambient::CAbbreviations::Revoke(BSTR bstrAbbrev) {
	if(bstrAbbrev == 0 || *bstrAbbrev == 0)
		return E_INVALIDARG;
	CAlphaApp::GetInstance().GetActiveView().GetAbbreviations().Revoke(bstrAbbrev);
	return S_OK;
}

///	@see	IAutomationAbbreviations::RevokeAll
STDMETHODIMP Ambient::CAbbreviations::RevokeAll() {
	CAlphaApp::GetInstance().GetActiveView().GetAbbreviations().RevokeAll();
	return S_OK;
}


// CScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CScriptHost::CScriptHost(CAlphaScriptHost* pImpl) : SAFE_MARK, m_pImpl(pImpl) {
	assert(m_pImpl != 0);
	m_pImpl->AddRef();
}

///	fXgN^
CScriptHost::~CScriptHost() {
	m_pImpl->Release();
}

///	@see	IScriptHost::ConnectObject
STDMETHODIMP CScriptHost::ConnectObject(IDispatch* pObject, BSTR bstrPrefix) {
	VERIFY_POINTER(pObject);
	if(bstrPrefix == 0)
		return E_INVALIDARG;

	try {
		HRESULT	hr;
		if(FAILED(hr = m_pImpl->ConnectObject(*pObject, bstrPrefix)))
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.ConnectObject"));
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	}
	return S_OK;
}

///	@see	IScriptHost::CreateObject
STDMETHODIMP CScriptHost::CreateObject(
		BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	if(ppObject == 0)
		return S_OK;
	*ppObject = 0;
	if(bstrProgId == 0)
		return E_INVALIDARG;

	CLSID	clsidObject;
	HRESULT	hr;

	try {
		if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsidObject)))
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
		if(URLPOLICY_ALLOW != VerifyCreationObject(clsidObject)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
		}
		if(FAILED(hr = ::CoCreateInstance(clsidObject, 0,
				CLSCTX_ALL, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.CreateObject"));
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
		return hr;
	}
	if(URLPOLICY_ALLOW != VerifyRunningObject(*ppObject, clsidObject)) {
		(*ppObject)->Release();
		*ppObject = 0;
		return 0x800A01AD;
	}
	return (bstrPrefix == 0) ? S_OK : ConnectObject(*ppObject, bstrPrefix);
}

///	@see	IScriptHost::DisconnectObject
STDMETHODIMP CScriptHost::DisconnectObject(IDispatch* pObject) {
	VERIFY_POINTER(pObject);

	try {
		const HRESULT	hr = m_pImpl->DisconnectObject(*pObject);
		if(FAILED(hr))
			throw CComException(hr, IID_IScriptHost,
				OLESTR("Ambient.ScriptHost.DisconnectObject"));
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	}
	return S_OK;
}

///	@see	IScriptHost::Echo
STDMETHODIMP CScriptHost::Echo(SAFEARRAY/*<VARIANT>*/* pArguments) {
	if(pArguments == 0 && ::SafeArrayGetDim(pArguments) != 1)
		return E_INVALIDARG;
	if(!m_pImpl->IsInteractive())
		return S_OK;

	wostringstream	ss;
	long			cArguments;
	VARIANT**		argumentsArray = 0;
	HWND			hWnd;

	::SafeArrayGetUBound(pArguments, 1, &cArguments);
	++cArguments;
	::SafeArrayAccessData(pArguments, reinterpret_cast<void**>(&argumentsArray));
	for(long i = 0; i < cArguments; ++i) {
		CComVariant	argument;
		argument.ChangeType(VT_BSTR, argumentsArray[i]);
		ss << SAFE_BSTR(argument.bstrVal);
		if(i != cArguments - 1)
			ss << L" ";
	}
	::SafeArrayUnaccessData(pArguments);
	m_pImpl->GetWindow(&hWnd);
	::MessageBox(hWnd, ss.str().c_str(), CAlphaScriptHost::m_pwszName, 0);

	return S_OK;
}

///	@see	IScriptHost::get_Arguments
STDMETHODIMP CScriptHost::get_Arguments(IArguments** ppArguments) {
	VERIFY_POINTER(ppArguments);

	vector<wstring>	vecArgs;
	if(0 == (*ppArguments = new CArguments(vecArgs)))
		return E_OUTOFMEMORY;
	(*ppArguments)->AddRef();
	return S_OK;
}

///	@see	IScriptHost::get_BuildVersion
STDMETHODIMP CScriptHost::get_BuildVersion(short* pnBuildVersion) {
	VERIFY_POINTER(pnBuildVersion);
	*pnBuildVersion = CAlphaScriptHost::m_nBuildVersion;
	return S_OK;
}

///	@see	IScriptHost::get_FullName
STDMETHODIMP CScriptHost::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszPath);
	return (*pbstrFullName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_Interactive
STDMETHODIMP CScriptHost::get_Interactive(VARIANT_BOOL* pbInteractive) {
	VERIFY_POINTER(pbInteractive);
	*pbInteractive = toVariantBoolean(m_pImpl->IsInteractive());
	return S_OK;
}

///	@see	IScriptHost::get_Name
STDMETHODIMP CScriptHost::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrName = ::SysAllocString(::PathFindFileNameW(wszPath));
	return (*pbstrName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_Path
STDMETHODIMP CScriptHost::get_Path(BSTR* pbstrPath) {
	VERIFY_POINTER(pbstrPath);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrPath = ::SysAllocStringLen(wszPath, wszPath - ::PathFindFileNameW(wszPath) - 1);
	return (*pbstrPath != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_ScriptFullName
STDMETHODIMP CScriptHost::get_ScriptFullName(BSTR* pbstrScriptFullName) {
	VERIFY_POINTER(pbstrScriptFullName);
	*pbstrScriptFullName = ::SysAllocString(m_pImpl->GetScriptPath().c_str());
	return (*pbstrScriptFullName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_ScriptName
STDMETHODIMP CScriptHost::get_ScriptName(BSTR* pbstrScriptName) {
	VERIFY_POINTER(pbstrScriptName);
	*pbstrScriptName = ::SysAllocString(::PathFindFileNameW(m_pImpl->GetScriptPath().c_str()));
	return (*pbstrScriptName != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::get_StdErr
STDMETHODIMP CScriptHost::get_StdErr(IDispatch** ppStdErr) {
	VERIFY_POINTER(ppStdErr);
	*ppStdErr = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdIn
STDMETHODIMP CScriptHost::get_StdIn(IDispatch** ppStdIn) {
	VERIFY_POINTER(ppStdIn);
	*ppStdIn = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdOut
STDMETHODIMP CScriptHost::get_StdOut(IDispatch** ppStdOut) {
	VERIFY_POINTER(ppStdOut);
	*ppStdOut = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_Timeout
STDMETHODIMP CScriptHost::get_Timeout(long* pnMilliseconds) {
	VERIFY_POINTER(pnMilliseconds);
	*pnMilliseconds = static_cast<long>(m_pImpl->GetTimeout());
	return S_OK;
}

///	@see	IScriptHost::get_Version
STDMETHODIMP CScriptHost::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);

	wchar_t	wszVersion[10];
	swprintf(wszVersion, L"%u.%u",
		CAlphaScriptHost::m_nMajorVersion, CAlphaScriptHost::m_nMinorVersion);
	*pbstrVersion = ::SysAllocString(wszVersion);
	return (*pbstrVersion != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IScriptHost::GetObject
STDMETHODIMP CScriptHost::GetObject(
		BSTR bstrPathName, BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	if(ppObject == 0)
		return S_OK;

	HRESULT	hr = S_OK;
	CLSID	clsid = CLSID_NULL;

	*ppObject = 0;
	try {
		if(bstrProgId != 0) {
			if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsid)))
				throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
		if(URLPOLICY_ALLOW != VerifyCreationObject(clsid)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return hr;
	}

	try {
		if(bstrProgId == 0) {
			if(FAILED(hr = ::CoGetObject(bstrPathName, 0, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
				throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		} else {	// GetInstanceFromFile g
			MULTI_QI	mq = {&IID_IDispatch, 0, 0};

			if(FAILED(hr = ::CoGetInstanceFromFile(0, &clsid, 0,
					CLSCTX_ALL, STGM_READWRITE, bstrPathName, 1, &mq)))
				throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
			hr = mq.pItf->QueryInterface(IID_IDispatch, reinterpret_cast<void**>(ppObject));
		}
		if(URLPOLICY_ALLOW != VerifyRunningObject(*ppObject, clsid)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Ambient.ScriptHost.GetObject"));
		}
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
		return hr;
	}
	return hr;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CScriptHost::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	bool		bCreatedResult = false;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_ARGUMENTS:		CALL_GETTER_ACTX(Arguments, IArguments);
		case DISPID_SCRIPTHOST_BUILDVERSION:	CALL_GETTER(BuildVersion, VT_I2);
		case DISPID_SCRIPTHOST_FULLNAME:		CALL_GETTER(FullName, VT_BSTR);
		case DISPID_SCRIPTHOST_INTERACTIVE:		CALL_GETTER(Interactive, VT_BOOL);
		case DISPID_SCRIPTHOST_NAME:			CALL_GETTER(Name, VT_BSTR);
		case DISPID_SCRIPTHOST_SCRIPTFULLNAME:	CALL_GETTER(ScriptFullName, VT_BSTR);
		case DISPID_SCRIPTHOST_SCRIPTNAME:		CALL_GETTER(ScriptName, VT_BSTR);
		case DISPID_SCRIPTHOST_STDERR:			CALL_GETTER(StdErr, VT_DISPATCH);
		case DISPID_SCRIPTHOST_STDIN:			CALL_GETTER(StdIn, VT_DISPATCH);
		case DISPID_SCRIPTHOST_STDOUT:			CALL_GETTER(StdOut, VT_DISPATCH);
		case DISPID_SCRIPTHOST_TIMEOUT:			CALL_GETTER(Timeout, VT_I4);
		case DISPID_SCRIPTHOST_VERSION:			CALL_GETTER(Version, VT_BSTR);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_INTERACTIVE:	CALL_PUTTER(Interactive, VT_BOOL);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
			;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_CONNECTOBJECT:	CALL_METHOD_2(ConnectObject, VT_DISPATCH, VT_BSTR);
		case DISPID_SCRIPTHOST_CREATEOBJECT:
			COERCE_RETURN(VT_DISPATCH);
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 2) {
//				CALL_METHOD_RET_2(CreateObject, VT_DISPATCH, VT_BSTR, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[1].bstrVal, args[0].bstrVal,
						(pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return S_OK;
		case DISPID_SCRIPTHOST_DISCONNECTOBJECT:	CALL_METHOD_1(DisconnectObject, VT_DISPATCH);
		case DISPID_SCRIPTHOST_ECHO:
			if(pDispParams->cArgs == 1 && pDispParams->rgvarg[0].vt == VT_SAFEARRAY)
				return Echo(pDispParams->rgvarg[0].parray);
			else {
				SAFEARRAY* const	pArray = ::SafeArrayCreateVector(VT_VARIANT, 0, pDispParams->cArgs);
				VARIANTARG**		ppArguments = 0;

				hr = ::SafeArrayAccessData(pArray, reinterpret_cast<void**>(&ppArguments));
				for(unsigned int i = 0; i < pDispParams->cArgs; ++i)
					ppArguments[i] = &pDispParams->rgvarg[pDispParams->cArgs - i - 1];
				hr = ::SafeArrayUnaccessData(pArray);
				hr = Echo(pArray);
				::SafeArrayDestroy(pArray);
				return hr;
			}
		case DISPID_SCRIPTHOST_GETOBJECT:
			COERCE_RETURN(VT_DISPATCH);
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[0].bstrVal, 0, 0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[1].bstrVal, args[0].bstrVal,
						0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[2].bstrVal, args[1].bstrVal,
						args[0].bstrVal, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_SCRIPTHOST_LOADCONSTANTS:	CALL_METHOD_1(LoadConstants, VT_DISPATCH);
		case DISPID_SCRIPTHOST_QUIT:
			if(pDispParams->cArgs == 1) {
				CALL_METHOD_1(Quit, VT_I2);
			} else if(pDispParams->cArgs == 0) {
				CALL_METHOD_0(Quit);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_SCRIPTHOST_SLEEP:	CALL_METHOD_1(Sleep, VT_I4);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IScriptHost::put_Interactive
STDMETHODIMP CScriptHost::put_Interactive(VARIANT_BOOL bInteractive) {
	m_pImpl->SetInteractiveMode(toBoolean(bInteractive));
	return S_OK;
}

/// @see	IScriptHost::LoadConstants
STDMETHODIMP CScriptHost::LoadConstants(IDispatch* pObject) {
	if(pObject == 0)
		return E_INVALIDARG;

	UINT	cInfos;
	pObject->GetTypeInfoCount(&cInfos);
	if(cInfos != 0) {
		CComPtr<ITypeInfo>	pTypeInfo;
		if(SUCCEEDED(pObject->GetTypeInfo(0, LOCALE_USER_DEFAULT, &pTypeInfo))) {
			CComPtr<ITypeLib>	pTypeLib;
			UINT				i;
			if(SUCCEEDED(pTypeInfo->GetContainingTypeLib(&pTypeLib, &i)))
				return m_pImpl->LoadConstants(*pTypeLib) ? S_OK : E_INVALIDARG;
		}
	}
	return E_INVALIDARG;
}

///	@see	IScriptHost::Quit
STDMETHODIMP CScriptHost::Quit(short nExitCode /* = 0 */) {
	IActiveScript*	pScriptEngine = 0;
	EXCEPINFO		ei;

	m_pImpl->GetScriptEngine(pScriptEngine);
	ZeroMemory(&ei, sizeof(EXCEPINFO));
	HRESULT	hr = pScriptEngine->InterruptScriptThread(SCRIPTTHREADID_ALL, &ei, 0);
	pScriptEngine->Release();
	return hr;
}

///	@see	IScriptHost::Sleep
STDMETHODIMP CScriptHost::Sleep(long nMilliseconds) {
	if(nMilliseconds < 0)
		return E_INVALIDARG;
	m_pImpl->Sleep(static_cast<unsigned long>(nMilliseconds));
	return S_OK;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param clsid	쐬悤ƂĂIuWFNg CLSID
 *	@return			|V[
 */
DWORD CScriptHost::VerifyCreationObject(CLSID& clsid) {
	IActiveScript*			pScriptEngine = 0;
	CComPtr<IObjectSafety>	pObjectSafety;
	DWORD					dwSupportedOpts, dwEnabledOpts;

	m_pImpl->GetScriptEngine(pScriptEngine);
	if(FAILED(pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety)))) {
		pScriptEngine->Release();
		return URLPOLICY_DISALLOW;
	}
	pScriptEngine->Release();
	if(FAILED(pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(dwEnabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		CComPtr<IServiceProvider>				pServiceProvider;
		CComPtr<IInternetHostSecurityManager>	pSecurityManager;

		if(FAILED(m_pImpl->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&pServiceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pServiceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&pSecurityManager))))
			return URLPOLICY_DISALLOW;

		DWORD	dwPolicy;
		if(FAILED(pSecurityManager->ProcessUrlAction(URLACTION_ACTIVEX_RUN,
				reinterpret_cast<BYTE*>(&dwPolicy), sizeof(DWORD),
				reinterpret_cast<BYTE*>(&clsid), sizeof(CLSID), 0, 0)))
			return URLPOLICY_DISALLOW;
		return dwPolicy;
	} else
		return toBoolean(dwEnabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW : URLPOLICY_ALLOW;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param pUnk		IuWFNg
 *	@param clsid	IuWFNg CLSID
 *	@return			|V[
 */
DWORD CScriptHost::VerifyRunningObject(IUnknown* pUnk, CLSID& clsid) {
/*	CComPtr<IActiveScriptSite>	pScriptHost;
	CComPtr<IObjectSafety>		pObjectSafety;
	DWORD						dwSupportedOpts, dwEnabledOpts;

	if(FAILED(m_pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety))))
		return URLPOLICY_DISALLOW;
	if(FAILED(pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(dwEnabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		CComPtr<IServiceProvider>				pServiceProvider;
		CComPtr<IInternetHostSecurityManager>	pSecurityManager;

		if(FAILED(m_pScriptEngine->GetScriptSite(IID_IActiveScriptSite, reinterpret_cast<void**>(&pScriptHost))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pScriptHost->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&pServiceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pServiceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&pSecurityManager))))
			return URLPOLICY_DISALLOW;

		DWORD			dwPolicy, cbPolicy;
		DWORD*			pdwPolicy;
		CONFIRMSAFETY	cs = {clsid, pUnk, 0};

		cs.pUnk->AddRef();
		if(FAILED(pSecurityManager->QueryCustomPolicy(GUID_CUSTOM_CONFIRMOBJECTSAFETY,
				reinterpret_cast<BYTE**>(&pdwPolicy), &cbPolicy,
				reinterpret_cast<BYTE*>(&cs), sizeof(CONFIRMSAFETY), 0)))
			return URLPOLICY_DISALLOW;
		dwPolicy = URLPOLICY_DISALLOW;
		if (pdwPolicy != 0) {
			if (sizeof(DWORD) <= cbPolicy)
			dwPolicy = *pdwPolicy;
			::CoTaskMemFree(pdwPolicy);
		}
		return dwPolicy;
	} else*/
		return /*toBoolean(dwEnabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW :*/ URLPOLICY_ALLOW;
}


// CArguments class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CArguments::CArguments(const vector<wstring>& args) : SAFE_MARK, m_arguments(args) {
}

///	@see	IArguments::Count
STDMETHODIMP CArguments::Count(long* pcArgs) {
	if(pcArgs != 0)
		*pcArgs = m_arguments.size();
	return S_OK;
}

///	@see	IArguments::get__NewEnum
STDMETHODIMP CArguments::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);
	*ppEnum = 0;
	return E_NOTIMPL;
}

///	@see	IArguments::get_Item
STDMETHODIMP CArguments::get_Item(long nIndex, BSTR* pbstrArgs) {
	VERIFY_POINTER(pbstrArgs);

	if(nIndex < 0 || nIndex >= static_cast<long>(m_arguments.size()))
		return 0x800A0009;
	*pbstrArgs = ::SysAllocString(m_arguments[nIndex].c_str());
	return (*pbstrArgs != 0) ? S_OK : E_OUTOFMEMORY;
}

///	@see	IArguments::get_Length
STDMETHODIMP CArguments::get_Length(long* pcArgs) {
	VERIFY_POINTER(pcArgs);
	*pcArgs = m_arguments.size();
	return S_OK;
}

///	@see	IArguments::get_Named
STDMETHODIMP CArguments::get_Named(IDispatch** ppNamed) {
	VERIFY_POINTER(ppNamed);
	*ppNamed = 0;
	return E_NOTIMPL;
}

///	@see	IArguments::get_Unamed
STDMETHODIMP CArguments::get_Unnamed(IDispatch** ppUnnamed) {
	VERIFY_POINTER(ppUnnamed);
	*ppUnnamed = 0;
	return E_NOTIMPL;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CArguments::Invoke(INVOKE_ARGLIST) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_ARGUMENTS_NEWENUM:	CALL_GETTER(_NewEnum, VT_UNKNOWN);
		case DISPID_ARGUMENTS_ITEM:		CALL_GETTER_1(Item, VT_BSTR, VT_I4);
		case DISPID_ARGUMENTS_LENGTH:	CALL_GETTER(Length, VT_I4);
		case DISPID_ARGUMENTS_NAMED:	CALL_GETTER(Named, VT_DISPATCH);
		case DISPID_ARGUMENTS_UNNAMED:	CALL_GETTER(Unnamed, VT_DISPATCH);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	else if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_ARGUMENTS_COUNT:		CALL_METHOD_RET_0(Count, VT_I4);
		case DISPID_ARGUMENTS_SHOWUSAGE:	CALL_METHOD_0(ShowUsage);
		default:
			DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IArguments::ShowUsage
STDMETHODIMP CArguments::ShowUsage() {
	return E_NOTIMPL;
}


#undef INVOKE_ARGLIST
#undef VERIFY_ARGUMENTS_COUNT
#undef COERCE_ARGUMENT_AT
#undef SAFE_MARK
#undef UNSAFE_MARK
#undef CHECK_IF_DISPOSED

#pragma warning(default : 4390)

/* [EOF] */