// AlphaView.h
// (c) 2003-2005 exeal

#ifndef _ALPHA_VIEW_H_
#define _ALPHA_VIEW_H_
#include "Ascension\EditView.h"
#include "AlphaDoc.h"


namespace Alpha {
	class CActiveViewListener;
	namespace Ambient {
		class CTextEditor;
		class CTextSelection;
		class CLexer;
		class CEditorPreferences;
	}

	///	Ascension r[ Alpha 
	class CAlphaView : public Ascension::CEditView {
		// RXgN^
	public:
		CAlphaView(CAlphaDoc& document, CActiveViewListener& app);
		CAlphaView(const CAlphaView& rhs);
		~CAlphaView();
	private:
		operator =(const CAlphaView& rhs);	// gȂ

		// \bh
	public:
		HRESULT			GetAutomation(ITextEditor** pp) const;
		HRESULT			GetAutomation(ITextSelection** pp) const;
		HRESULT			GetAutomation(ILexer** pp) const;
		HRESULT			GetAutomation(IEditorPreferences** pp) const;
		const wchar_t*	GetCurrentPositionString() const;
		CAlphaDoc&		GetDocument() const;
		bool			InputCharacter(Ascension::CodePoint cp);
		bool			InsertText(const Ascension::string_t& text, bool bAsRectangle);
	protected:
		Ascension::string_t	QueryInvokableLinkMessage(const Ascension::string_t& strUri);
		void				QueryLineColors(Ascension::length_t iLine, COLORREF& fgColor, COLORREF& bgColor);
	protected:
		bool	OnKeyDown(UINT nChar, UINT nFlags);
		void	OnSetFocus(HWND hwndOld);

		// f[^o
	private:
		CActiveViewListener&			m_app;
		Ambient::CTextEditor*			m_pAutomationTextEditor;
		Ambient::CTextSelection*		m_pAutomationTextSelection;
		Ambient::CLexer*				m_pAutomationLexer;
		Ambient::CEditorPreferences*	m_pAutomationPrefs;
	};
}

#endif /* _ALPHA_VIEW_H_ */

/* [EOF] */