/**
 * @file
 */
/******************************************************************************
 * Copyright AllSeen Alliance. All rights reserved.
 *
 *    Permission to use, copy, modify, and/or distribute this software for any
 *    purpose with or without fee is hereby granted, provided that the above
 *    copyright notice and this permission notice appear in all copies.
 *
 *    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *    WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *    MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *    ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ******************************************************************************/

#include "ajs.h"
#include "ajs_io.h"


#define AJS_IO_FUNCTION_I2C_SLAVE   0x00003000
#define AJS_IO_FUNCTION_I2C_MASTER  0x00007000
static const AJS_IO_Info info[] = {
    {  0,                             0,  "",   "",  "Dummy" },
    {  0,                             1,  "",   "",  "+3.3V" },
    {  0,                             2,  "",   "",  "+5V" },
    {  AJS_IO_FUNCTION_I2C_SDA,       3,  "GPIO_2",   "",  "I2C1 SDA" },
    {  0,                             4,  "",   "",  "+5V" },
    {  AJS_IO_FUNCTION_I2C_SCL,       5,  "GPIO_3",   "",  "I2C1 SCL" },
    {  0,                             6,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    7,  "GPIO_4",   "",  "GPCLK0" },	/* DHT11 Data */
    {  AJS_IO_FUNCTION_UART_TX,       8,  "GPIO_14",  "",  "UART0 TXD" },
    {  0,                             9,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_UART_RX,       10, "GPIO_15",  "",  "UART0 RXD" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    11, "GPIO_17",  "",  "" },	/* HC SR04 Trig */
    {  AJS_IO_FUNCTION_PWM|AJS_IO_FUNCTION_DIGITAL_IO,         12, "GPIO_18",  "",  "PCM_CLK" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    13, "GPIO_27",  "",  "" },	/* HC SR04 Fch */
    {  0,                             14,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    15, "GPIO_22",  "",  "" },	/* Tact Sw */
    {  AJS_IO_FUNCTION_DIGITAL_IO,    16, "GPIO_23",  "",  "" },
    {  0,                             17,  "",   "",  "+3.3V" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    18, "GPIO_24",  "",  "" },	/* Servo(PWM) */
    {  AJS_IO_FUNCTION_SPI_MOSI,      19, "GPIO_10",  "",  "SIO0 MOSI" },
    {  0,                             20,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_SPI_MISO,      21, "GPIO_9",   "",  "SIO0 MISO" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    22, "GPIO_25",  "",  "" },
    {  AJS_IO_FUNCTION_SPI_SCK,       23, "GPIO_11",  "",  "SIO0 SCLK" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    24, "GPIO_8",   "",  "SIO0 CE0" },
    {  0,                             25,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    26, "GPIO_7",   "",  "SIO0 CE1" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    27, "ID_SD",    "",  "" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    28, "ID_SC",    "",  "" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    29, "GPIO_5",   "",  "" },	/* LED */
    {  0,                             30,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    31, "GPIO_6",   "",  "" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    32, "GPIO_12",  "",  "" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    33, "GPIO_13",  "",  "" },
    {  0,                             34,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    35, "GPIO_19",  "",  "" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    36, "GPIO_16",  "",  "" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    37, "GPIO_26",  "",  "" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    38, "GPIO_20",  "",  "" },
    {  0,                             39,  "",   "",  "GND" },
    {  AJS_IO_FUNCTION_DIGITAL_IO,    40, "GPIO_21",  "",  "" },
};

uint16_t AJS_TargetIO_GetNumPins()
{
    return ArraySize(info);
}

const AJS_IO_Info* AJS_TargetIO_GetInfo(uint16_t pin)
{
    if (pin < ArraySize(info)) {
        return &info[pin];
    } else {
        return NULL;
    }
}
