/******************************************************************************
 * Copyright Hisashi Hashimoto. All rights reserved.
 *
 *    Permission to use, copy, modify, and/or distribute this software for any
 *    purpose with or without fee is hereby granted, provided that the above
 *    copyright notice and this permission notice appear in all copies.
 *
 *    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *    WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *    MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *    ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ******************************************************************************/
var AJ = require('AllJoyn');
var IO = require('IO');
// No need to check
var far = 50.0 ;
// need to notify
var bound = 10.0 ;
// Call distcheck 10000ms interval
var inter = 1 * 1000 ;
// GPIO 5 assigned to pin 29
var led = IO.digitalOut(IO.pin[29]);
print(IO.pin[29].info.description, ",", IO.pin[29].functions)  ;
// var blinky = setInterval(function(){led.toggle();}, 10);
//

//Force the device name
AJ.store("DeviceName", "Usonic Sensor");
AJ.store("Manufacturer", "QCE");
AJ.store("Description", "Detection of Invading System via Usonic Sensor");
 
//Create interface for remote interaction

AJ.interfaceDefinition['org.example.usonic'] =
{
    redDuty: { type:AJ.SIGNAL, description:'Somebody is entering'},
    greenDuty: { type:AJ.SIGNAL, description:'Nobody is here:'},
    blink: { type:AJ.SIGNAL, description:'Somebody is coming' }
};
 
AJ.objectDefinition['/usonic'] = {
    interfaces:['org.example.usonic']
};
 
function sendEvent(whatEvent) {
        var sig = AJ.signal('/usonic', whatEvent);
        //This makes it as a true Event so a session is not required
        sig.sessionless = true;
        sig.timeToLive = 60; //60 seconds
        sig.send();
}

function distcheck()
{
    var distance = parseFloat(IO.system('/usr/local/bin/usonic.py')) ;

    led.level = 0 ;
    print("distance =", distance) ;
    if( distance > bound && distance < far) {
          print("Somebody near") ;
          sendEvent({blink:'org.example.usonic'});
//          AJ.notification(AJ.notification.Warning, "Somebody near").send(100) ;
          led.level = 0 ;
    } else if(distance <= bound) {
          print("Somebody enter") ;
          sendEvent({redDuty:'org.example.usonic'});
//          AJ.notification(AJ.notification.Emergency, "Somebody enter").send(100) ;
          led.level = 1 ;
    } else {
          print("Nobody near") ;
          sendEvent({greenDuty:'org.example.usonic'});
//          AJ.notification(AJ.notification.Info, "Nobody enter").send(100) ;
          led.level = 0 ;
    }
}

setInterval(distcheck, inter) ;
