/******************************************************************************
 * Copyright AllSeen Alliance. All rights reserved.
 *
 *    Permission to use, copy, modify, and/or distribute this software for any
 *    purpose with or without fee is hereby granted, provided that the above
 *    copyright notice and this permission notice appear in all copies.
 *
 *    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *    WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *    MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *    ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ******************************************************************************/
var IO = require('IO');
var AJ = require('AllJoyn');

AJ.interfaceDefinition['org.allseen.DoorBell'] = { ding_dong:{ type:AJ.SIGNAL } };

AJ.objectDefinition['/pushbutton'] = { interfaces:['org.allseen.DoorBell'] };

var pb = IO.digitalIn(IO.pin[36], IO.pullUp);

AJ.onAttach = function()
{
    AJ.findService('org.allseen.DoorBell', function(svc) {
        var dingdong = svc.signal('/pushbutton', 'ding_dong');
          print("Somebody near") ;
          AJ.notification(AJ.notification.Warning, "Somebody near").send(100) ;
        pb.setTrigger(IO.fallingEdge, function() { dingdong.send() });
    });
}

AJ.onDetach = function()
{
          print("Somebody near") ;
          AJ.notification(AJ.notification.Warning, "Somebody near").send(100) ;
    pb.setTrigger(IO.disable);
}
