/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;

public class LocationManager {
    private static Location installLocation = null;
    private static Location configurationLocation = null;
    private static Location userLocation = null;
    private static Location instanceLocation = null;
    public static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    public static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_INSTANCE_AREA_DEFAULT = "osgi.instance.area.default";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_USER_AREA_DEFAULT = "osgi.user.area.default";
    public static final String PROP_MANIFEST_CACHE = "osgi.manifest.cache";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_USER_DIR = "user.dir";
    public static final String BUNDLES_DIR = "bundles";
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    public static final String BUNDLE_DATA_FILE = ".bundledata";
    public static final String MANIFESTS_DIR = "manifests";
    public static final String CONFIG_FILE = "config.ini";
    public static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String CONFIG_DIR = "configuration";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";

    public static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return LocationManager.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return LocationManager.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    private static void mungeConfigurationLocation() {
        String location = FrameworkProperties.getProperty(PROP_CONFIG_AREA);
        if (location != null) {
            if ((location = LocationManager.buildURL(location, false).toExternalForm()).endsWith(".cfg")) {
                int index = location.lastIndexOf(47);
                location = location.substring(0, index + 1);
            }
            if (!location.endsWith("/")) {
                location = String.valueOf(location) + "/";
            }
            FrameworkProperties.setProperty(PROP_CONFIG_AREA, location);
        }
    }

    public static void initializeLocations() {
        URL defaultLocation;
        installLocation = LocationManager.buildLocation(PROP_INSTALL_AREA, null, null, true);
        Location temp = LocationManager.buildLocation(PROP_USER_AREA_DEFAULT, null, "", false);
        URL uRL = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = LocationManager.buildURL(new File(FrameworkProperties.getProperty(PROP_USER_HOME), "user").getAbsolutePath(), true);
        }
        userLocation = LocationManager.buildLocation(PROP_USER_AREA, defaultLocation, "", false);
        temp = LocationManager.buildLocation(PROP_INSTANCE_AREA_DEFAULT, null, "", false);
        URL uRL2 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = LocationManager.buildURL(new File(FrameworkProperties.getProperty(PROP_USER_DIR), "workspace").getAbsolutePath(), true);
        }
        instanceLocation = LocationManager.buildLocation(PROP_INSTANCE_AREA, defaultLocation, "", false);
        LocationManager.mungeConfigurationLocation();
        temp = LocationManager.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "", false);
        URL uRL3 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = LocationManager.buildURL(LocationManager.computeDefaultConfigurationLocation(), true);
        }
        configurationLocation = LocationManager.buildLocation(PROP_CONFIG_AREA, defaultLocation, "", false);
        URL parentLocation = LocationManager.computeSharedConfigurationLocation();
        if (parentLocation != null && !parentLocation.equals(configurationLocation.getURL())) {
            BasicLocation parent = new BasicLocation(null, parentLocation, true);
            ((BasicLocation)configurationLocation).setParent(parent);
        }
        LocationManager.initializeDerivedConfigurationLocations();
    }

    private static Location buildLocation(String property, URL defaultLocation, String userDefaultAppendage, boolean readOnlyDefault) {
        String base;
        boolean readOnly;
        String location = FrameworkProperties.clearProperty(property);
        String userReadOnlySetting = FrameworkProperties.getProperty(String.valueOf(property) + READ_ONLY_AREA_SUFFIX);
        boolean bl = readOnly = userReadOnlySetting == null ? readOnlyDefault : Boolean.valueOf(userReadOnlySetting);
        if (location == null) {
            return new BasicLocation(property, defaultLocation, readOnly);
        }
        String trimmedLocation = location.trim();
        if (trimmedLocation.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (trimmedLocation.equalsIgnoreCase(NO_DEFAULT)) {
            return new BasicLocation(property, null, readOnly);
        }
        if (trimmedLocation.startsWith(USER_HOME)) {
            base = LocationManager.substituteVar(location, USER_HOME, PROP_USER_HOME);
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        } else if (trimmedLocation.startsWith(USER_DIR)) {
            base = LocationManager.substituteVar(location, USER_DIR, PROP_USER_DIR);
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        }
        URL url = LocationManager.buildURL(location, true);
        BasicLocation result = null;
        if (url != null) {
            result = new BasicLocation(property, null, readOnly);
            result.setURL(url, false);
        }
        return result;
    }

    private static String substituteVar(String source, String var, String prop) {
        String value = FrameworkProperties.getProperty(prop, "");
        return String.valueOf(value) + source.substring(var.length());
    }

    private static void initializeDerivedConfigurationLocations() {
        if (FrameworkProperties.getProperty(PROP_MANIFEST_CACHE) == null) {
            FrameworkProperties.setProperty(PROP_MANIFEST_CACHE, LocationManager.getConfigurationFile(MANIFESTS_DIR).getAbsolutePath());
        }
    }

    private static URL computeInstallConfigurationLocation() {
        String property = FrameworkProperties.getProperty(PROP_INSTALL_AREA);
        if (property != null) {
            try {
                return new URL(property);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    private static URL computeSharedConfigurationLocation() {
        String property = FrameworkProperties.getProperty(PROP_SHARED_CONFIG_AREA);
        if (property == null) {
            return null;
        }
        try {
            URL sharedConfigurationURL = new URL(property);
            if (sharedConfigurationURL.getPath().startsWith("/")) {
                return sharedConfigurationURL;
            }
            URL installURL = installLocation.getURL();
            if (!sharedConfigurationURL.getProtocol().equals(installURL.getProtocol())) {
                return sharedConfigurationURL;
            }
            sharedConfigurationURL = new URL(installURL, sharedConfigurationURL.getPath());
            FrameworkProperties.setProperty(PROP_SHARED_CONFIG_AREA, sharedConfigurationURL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private static String computeDefaultConfigurationLocation() {
        URL installURL = LocationManager.computeInstallConfigurationLocation();
        if (installURL != null) {
            File installDir = new File(installURL.getFile());
            if ("file".equals(installURL.getProtocol()) && LocationManager.canWrite(installDir)) {
                return new File(installDir, CONFIG_DIR).getAbsolutePath();
            }
        }
        return LocationManager.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    /*
     * Exception decompiling
     */
    private static boolean canWrite(File installDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 56->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String computeDefaultUserAreaLocation(String pathAppendage) {
        String installProperty = FrameworkProperties.getProperty(PROP_INSTALL_AREA);
        URL installURL = LocationManager.buildURL(installProperty, true);
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getFile());
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty(PRODUCT_SITE_ID);
                if (appId == null || appId.trim().length() == 0) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = String.valueOf(appName) + File.separator + appId + "_" + appVersion;
            }
            catch (IOException iOException) {}
        }
        String userHome = FrameworkProperties.getProperty(PROP_USER_HOME);
        return new File(userHome, String.valueOf(appName) + "/" + pathAppendage).getAbsolutePath();
    }

    public static Location getUserLocation() {
        return userLocation;
    }

    public static Location getConfigurationLocation() {
        return configurationLocation;
    }

    public static Location getInstallLocation() {
        return installLocation;
    }

    public static Location getInstanceLocation() {
        return instanceLocation;
    }

    public static File getOSGiConfigurationDir() {
        return new File(configurationLocation.getURL().getFile(), "org.eclipse.osgi");
    }

    public static File getConfigurationFile(String filename) {
        File dir = LocationManager.getOSGiConfigurationDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, filename);
    }
}

