/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util.image;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageUtils {
    public static Image createThumbnail(Image img, int width, int height) {
        Image retImage = new Image(null, width, height);
        GC gc = new GC((Drawable)retImage);
        gc.setBackground(new Color(null, 255, 255, 255));
        gc.fillRectangle(0, 0, retImage.getBounds().width, retImage.getBounds().height);
        if (img.getBounds().width > retImage.getBounds().width || img.getBounds().height > retImage.getBounds().height) {
            int overw = img.getBounds().width - retImage.getBounds().width;
            int overh = img.getBounds().height - retImage.getBounds().height;
            double ratio = 0.0;
            ratio = overw > overh ? (double)retImage.getBounds().width / (double)img.getBounds().width : (double)retImage.getBounds().height / (double)img.getBounds().height;
            int dw = (int)((double)img.getBounds().width * ratio);
            int dh = (int)((double)img.getBounds().height * ratio);
            int cx = (retImage.getBounds().width - dw) / 2;
            int cy = (retImage.getBounds().height - dh) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, dw, dh);
        } else {
            int cx = (retImage.getBounds().width - img.getBounds().width) / 2;
            int cy = (retImage.getBounds().height - img.getBounds().height) / 2;
            gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, cx, cy, img.getBounds().width, img.getBounds().height);
        }
        gc.dispose();
        return retImage;
    }

    public static void writeJpegWithQuality(BufferedImage image, File file, float quality) throws IOException {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> imageWriterIterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (imageWriterIterator.hasNext()) {
            imageWriter = imageWriterIterator.next();
        }
        if (imageWriter == null) {
            throw new IOException("imageWriter not found");
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iioImage = new IIOImage(image, null, null);
        JPEGImageWriteParam imageWriteParam = new JPEGImageWriteParam(null);
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(quality);
        imageWriter.write(null, iioImage, imageWriteParam);
        imageOutputStream.close();
        imageWriter.dispose();
    }

    public static void writeJpegWithQuality(BufferedImage image, OutputStream output, float quality) throws IOException {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> imageWriterIterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (imageWriterIterator.hasNext()) {
            imageWriter = imageWriterIterator.next();
        }
        if (imageWriter == null) {
            throw new IOException("imageWriter not found");
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(output);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iioImage = new IIOImage(image, null, null);
        JPEGImageWriteParam imageWriteParam = new JPEGImageWriteParam(null);
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(quality);
        imageWriter.write(null, iioImage, imageWriteParam);
        imageOutputStream.flush();
    }

    public static BufferedImage getBluredImage(BufferedImage image, int size) {
        float[] elements = new float[size * size];
        float v = 1.0f / (float)elements.length;
        int i = 0;
        while (i < elements.length) {
            elements[i] = v;
            ++i;
        }
        BufferedImage base = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        base.getGraphics().drawImage(image, 0, 0, null);
        BufferedImage bimg = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Kernel kernel = new Kernel(size, size, elements);
        ConvolveOp cop = new ConvolveOp(kernel, 1, null);
        cop.filter(base, bimg);
        return bimg;
    }

    public static Image loadImage(Class cl, String resource) {
        Image ret = new Image((Device)Display.getCurrent(), cl.getClassLoader().getResourceAsStream(resource));
        return ret;
    }

    public static Image loadImage(String pluginID, String name) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginID, (String)name).createImage();
    }
}

