/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.ui.GenericParametersFFMpegPreference;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericParameters {
    private Map<String, String> parameters = new HashMap<String, String>();
    public static String PARAM_NAME = "#name";
    public static String PARAM_COMMENT = "#comment";
    private String name = "";
    private String comment = "";
    public String[] singleParams = new String[]{"vn", "an", "sameq"};

    public boolean isSingleParam(String key) {
        int i = 0;
        while (i < this.singleParams.length) {
            if (key.equals(this.singleParams[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void set(String key, String value) {
        if (GenericParameters.isParamCSV(key)) {
            this.parseParamCSV(key, value);
        } else {
            this.parameters.put(key, value);
        }
    }

    public static String removeSystemParam(String csv) {
        String[] values = csv.split(",");
        String ret = "";
        int i = 0;
        while (i < values.length) {
            if (!GenericParameters.isParamCSV(values[i])) {
                ret = String.valueOf(ret) + values[i];
                if (i != values.length - 1) {
                    ret = String.valueOf(ret) + ",";
                }
            }
            ++i;
        }
        return ret;
    }

    private boolean isSystemKey(String key) {
        int i = 0;
        while (i < GenericParametersFFMpegPreference.SYSTEM_KEYS.length) {
            if (key.equals(GenericParametersFFMpegPreference.SYSTEM_KEYS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] toArgParams() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.parameters.keySet()) {
            if (this.isSystemKey(key)) continue;
            String value = this.parameters.get(key);
            if (this.isSingleParam(key)) {
                if (!value.equals("1")) continue;
                list.add("-" + key);
                continue;
            }
            this.addList(list, key, value);
        }
        return list.toArray(new String[list.size()]);
    }

    private void addList(List<String> list, String key, String value) {
        list.add("-" + key);
        list.add(value);
    }

    public static GenericParameters csvToParameters(String csv) {
        csv = StringUtils.replace((String)csv, (String)"\n", (String)"");
        csv = StringUtils.replace((String)csv, (String)"\r", (String)"");
        GenericParameters parameters = new GenericParameters();
        String[] name_value = csv.split(",");
        int i = 0;
        while (i < name_value.length) {
            if (name_value[0].length() > 0) {
                String[] n_v = name_value[i].split("=");
                if (n_v.length > 1) {
                    parameters.set(n_v[0], n_v[1]);
                } else if (GenericParameters.isParamCSV(n_v[0])) {
                    parameters.set(n_v[0], "");
                } else {
                    parameters.set(n_v[0], "1");
                }
            }
            ++i;
        }
        return parameters;
    }

    public static String parametersToCsv(GenericParameters parameters) {
        String separator = ",";
        StringBuffer buffer = new StringBuffer();
        buffer.append(parameters.toParamCSV());
        buffer.append(separator);
        Map<String, String> map = parameters.getParameters();
        for (String key : map.keySet()) {
            String value = map.get(key);
            buffer.append(String.valueOf(key) + "=" + value);
            buffer.append(separator);
        }
        String v = buffer.toString();
        return v.substring(0, v.length() - 1);
    }

    private String toParamCSV() {
        String separator = ",";
        String v = "";
        v = String.valueOf(v) + PARAM_NAME + "=" + this.storeLineSeparator(this.getName()) + separator;
        v = String.valueOf(v) + PARAM_COMMENT + "=" + this.storeLineSeparator(this.getComment());
        return v;
    }

    private void parseParamCSV(String key, String value) {
        if (GenericParameters.isParamCSV(key)) {
            String v = this.restoreLineSeparator(value);
            if (key.equals(PARAM_NAME)) {
                this.setName(v);
            } else if (key.equals(PARAM_COMMENT)) {
                this.setComment(v);
            }
        }
    }

    private String restoreLineSeparator(String value) {
        String v = StringUtils.replace((String)value, (String)"\\n", (String)"\n");
        return v;
    }

    private String storeLineSeparator(String value) {
        String v = StringUtils.replace((String)value, (String)"\n", (String)"\\n");
        v = StringUtils.replace((String)v, (String)"\r", (String)"");
        return v;
    }

    private static boolean isParamCSV(String key) {
        return key.startsWith("#");
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

