/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.potrace;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.potrace.MkBitmapUtils;
import jp.sourceforge.akjrcp.potrace.PotraceUtils;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedCommand;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedCommandExecuter;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedRuntimeCommand;
import jp.sourceforge.akjrcp.util.directorybased.PbmToImageCommand;
import jp.sourceforge.akjrcp.util.directorybased.PgmToImageCommand;
import jp.sourceforge.akjrcp.util.directorybased.PostScriptToImageCommand;
import jp.sourceforge.akjrcp.util.directorybased.RenameCommand;

public class PotraceExecuter
extends DirectoryBasedCommandExecuter {
    private GenericParameters genericParameters;
    private String mkBitmapPath;
    private String potracePath;
    private List<File> temporaryFiles = new ArrayList<File>();
    private boolean execMkbitmap;
    private boolean execPotrace;
    private File finalExported;
    private boolean mixImage;

    public boolean isExecMkbitmap() {
        return this.execMkbitmap;
    }

    public void setExecMkbitmap(boolean execMkbitmap) {
        this.execMkbitmap = execMkbitmap;
    }

    public boolean isExecPotrace() {
        return this.execPotrace;
    }

    public void setExecPotrace(boolean execPotrace) {
        this.execPotrace = execPotrace;
    }

    public String getPotracePath() {
        return this.potracePath;
    }

    public void setPotracePath(String potracePath) {
        this.potracePath = potracePath;
    }

    protected void inFinallyAction(File file, File output) {
        int i = 0;
        while (i < this.temporaryFiles.size()) {
            File tmp = this.temporaryFiles.get(i);
            if (tmp != null) {
                tmp.delete();
            }
            ++i;
        }
    }

    protected void processReturnValue(int value) {
        if (value != 0) {
            log.warn((Object)("error-exit:" + value));
        }
    }

    private boolean isSupportedInput(String input) {
        if (input.toLowerCase().endsWith(".bmp")) {
            return true;
        }
        if (input.toLowerCase().endsWith(".pbm")) {
            return true;
        }
        if (input.toLowerCase().endsWith(".pgm")) {
            return true;
        }
        return input.toLowerCase().endsWith(".ppm");
    }

    /*
     * Unable to fully structure code
     */
    protected DirectoryBasedCommand[] toCommand(File input, File output) {
        cList = new ArrayList<DirectoryBasedCommand>();
        width = 0;
        height = 0;
        bimage = null;
        try {
            bimage = ImageIO.read(input);
            width = bimage.getWidth();
            height = bimage.getHeight();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        if (this.isSupportedInput(input.getName())) {
            bmpFile = input;
        } else {
            block29: {
                try {
                    bmpFile = File.createTempFile("tmp", ".bmp");
                    this.temporaryFiles.add(bmpFile);
                    System.out.println(String.valueOf(bimage.getWidth()) + "," + bimage.getHeight());
                    if (bimage != null) break block29;
                    PotraceExecuter.log.warn((Object)"input image is null");
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            tmpImage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 1);
            tmpImage.getGraphics().drawImage(bimage, 0, 0, null);
            ImageIO.write((RenderedImage)tmpImage, "bmp", bmpFile);
        }
        if (this.execMkbitmap) {
            try {
                potraceInput = File.createTempFile("tmp", ".pbm");
                this.temporaryFiles.add(potraceInput);
                mkCommand = MkBitmapUtils.toCommand(this.mkBitmapPath, this.genericParameters, bmpFile.getAbsolutePath(), potraceInput.getAbsolutePath());
                cList.add(new DirectoryBasedRuntimeCommand("mkbitmap", mkCommand));
                scale = this.genericParameters.getParameters().get("MKBITMAP_s");
                if (!scale.equals("")) {
                    (int)Double.parseDouble(scale);
                }
                if (this.execPotrace) ** GOTO lbl63
                if (this.outputExtension.equals("png") || this.outputExtension.equals("jpg") || this.outputExtension.equals("bmp")) {
                    if (this.genericParameters.getParameters().get("MKBITMAP_g") != null) {
                        cList.add(new PgmToImageCommand(potraceInput, output, this.outputExtension));
                    }
                    cList.add(new PbmToImageCommand(potraceInput, output, this.outputExtension));
                }
                cList.add(new RenameCommand(potraceInput, output));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            potraceInput = bmpFile;
        }
lbl63:
        // 5 sources

        if (this.execPotrace) {
            try {
                this.genericParameters.set("P", String.valueOf(width) + "x" + height);
                if (this.outputExtension.equals("png") || this.outputExtension.equals("jpg") || this.outputExtension.equals("bmp")) {
                    this.finalExported = File.createTempFile("tmp", ".ps");
                    this.temporaryFiles.add(potraceInput);
                    potraceCommand = PotraceUtils.toCommand(this.potracePath, this.genericParameters, potraceInput.getAbsolutePath(), this.finalExported.getAbsolutePath());
                    cList.add(new DirectoryBasedRuntimeCommand("potrace", potraceCommand));
                    command = new PostScriptToImageCommand(this.finalExported, output, this.outputExtension);
                    if (this.mixImage) {
                        command.setImage(bimage);
                    }
                    command.setWidth(width);
                    command.setHeight(height);
                    cList.add(command);
                }
                backend = "postscript";
                if (this.outputExtension.equals("ps")) {
                    backend = "postscript";
                } else if (this.outputExtension.equals("eps")) {
                    backend = "eps";
                } else if (this.outputExtension.equals("svg")) {
                    backend = "svg";
                } else if (this.outputExtension.equals("pdf")) {
                    backend = "pdf";
                } else if (this.outputExtension.equals("pgm")) {
                    backend = "pgm";
                }
                this.genericParameters.set("b", backend);
                potraceCommand = PotraceUtils.toCommand(this.potracePath, this.genericParameters, potraceInput.getAbsolutePath(), output.getAbsolutePath());
                cList.add(new DirectoryBasedRuntimeCommand("potrace", potraceCommand));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            this.finalExported = potraceInput;
        }
        return cList.toArray(new DirectoryBasedCommand[cList.size()]);
    }

    protected void afterExecuteCommand(DirectoryBasedCommand command) {
    }

    protected void beforeExecuteCommand(DirectoryBasedCommand command) {
    }

    public GenericParameters getGenericParameters() {
        return this.genericParameters;
    }

    public void setGenericParameters(GenericParameters genericParameters) {
        this.genericParameters = genericParameters;
        if (genericParameters.getParameters().get("MKBITMAP_USE") != null) {
            this.execMkbitmap = true;
        }
        if (genericParameters.getParameters().get("POTRACE_USE") != null) {
            this.execPotrace = true;
        }
    }

    public String getMkBitmapPath() {
        return this.mkBitmapPath;
    }

    public void setMkBitmapPath(String mkBitmapPath) {
        this.mkBitmapPath = mkBitmapPath;
    }

    public boolean isMixImage() {
        return this.mixImage;
    }

    public void setMixImage(boolean mixImage) {
        this.mixImage = mixImage;
    }
}

