/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.util.ArrayList;

public class FFMpegCommandUtil {
    public static final String[] MJPEG_HIGHQUALITY_EXPORT = new String[]{"-vcodec", "mjpeg", "-qscale", "1", "-qmin", "1", "-qmax", "1"};
    public static final String[] MJPEG_HIGHQUALITY_EXPORT_NOAUDIO = new String[]{"-vcodec", "mjpeg", "-qscale", "1", "-qmin", "1", "-qmax", "1", "-an"};

    public static String[] makeInputPipeCommand(String ffmpeg, boolean overwrite, String[] inputOptions, String[] others) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        if (overwrite) {
            list.add("-y");
        }
        list.add("-f");
        list.add("image2pipe");
        list.add("-vcodec");
        list.add("mjpeg");
        int i = 0;
        while (i < inputOptions.length) {
            list.add(inputOptions[i]);
            ++i;
        }
        list.add("-i");
        list.add("-");
        i = 0;
        while (i < others.length) {
            list.add(others[i]);
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public static String[] makeInputPipeCommand(String ffmpeg, boolean overwrite) {
        return FFMpegCommandUtil.makeInputPipeCommand(ffmpeg, overwrite, new String[0], new String[0]);
    }

    public static String[] makePCMOutputPipeCommand(String ffmpeg, String input, int rate, int channel) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-i");
        list.add(input);
        list.add("-f");
        list.add("s16le");
        list.add("-ar");
        list.add("" + rate);
        list.add("-ac");
        list.add("" + channel);
        list.add("-");
        return list.toArray(new String[0]);
    }

    public static String[] makeJpegOutputPipeCommand(String ffmpeg, String input, String[] options) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-i");
        list.add(input);
        list.add("-f");
        list.add("image2pipe");
        list.add("-vcodec");
        list.add("mjpeg");
        list.add("-qscale");
        list.add("1");
        list.add("-qmin");
        list.add("1");
        list.add("-qmax");
        list.add("1");
        list.add("-an");
        int i = 0;
        while (i < options.length) {
            list.add(options[i]);
            ++i;
        }
        list.add("-");
        return list.toArray(new String[0]);
    }

    public static String[] makeJpegOutputPipeCommand(String ffmpeg, String input) {
        return FFMpegCommandUtil.makeJpegOutputPipeCommand(ffmpeg, input, new String[0]);
    }

    public static String[] makeWaveOutputPipeCommand(String ffmpeg, String input) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-i");
        list.add(input);
        list.add("-f");
        list.add("wav");
        list.add("-");
        return list.toArray(new String[0]);
    }

    public static String[] copyAudioCommand(String ffmpeg, String input, String output) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-i");
        list.add(input);
        list.add("-vn");
        list.add("-acodec");
        list.add("copy");
        list.add(output);
        return list.toArray(new String[0]);
    }

    public static String toDigits(int value, int digit) {
        String result = "" + value;
        while (result.length() < digit) {
            result = "0" + result;
        }
        return result;
    }

    public static String[] makeJpegInputCommand(String ffmpeg, String inputDir, String head, int digit, String foot, String fps, String audioInput, String output) {
        return FFMpegCommandUtil.makeJpegInputCommand(ffmpeg, inputDir, head, digit, foot, fps, audioInput, "copy", new String[0], output);
    }

    public static String[] makePCMInputCommand(String ffmpeg, String audioInput, String audioCodec, String[] options, String output) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-y");
        if (audioInput == null) {
            return null;
        }
        list.add("-f");
        list.add("s16le");
        list.add("-ar");
        list.add("48000");
        list.add("-ac");
        list.add("2");
        list.add("-i");
        list.add(audioInput);
        list.add("-acodec");
        list.add(audioCodec);
        int i = 0;
        while (i < options.length) {
            list.add(options[i]);
            ++i;
        }
        list.add(output);
        return list.toArray(new String[list.size()]);
    }

    public static String[] makeJpegInputCommand(String ffmpeg, String inputDir, String head, int digit, String foot, String fps, String audioInput, String videoCodec, String audioCodec, String[] options, String output) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-y");
        if (audioInput != null) {
            list.add("-f");
            list.add("s16le");
            list.add("-ar");
            list.add("48000");
            list.add("-ac");
            list.add("2");
            list.add("-i");
            list.add(audioInput);
        }
        list.add("-r");
        list.add(fps);
        list.add("-i");
        String input = String.valueOf(inputDir) + "\\" + head + "%0" + digit + "d" + foot;
        list.add(input);
        if (audioInput != null) {
            list.add("-acodec");
            list.add(audioCodec);
        } else {
            list.add("-an");
        }
        list.add("-vcodec");
        list.add(videoCodec);
        int i = 0;
        while (i < options.length) {
            list.add(options[i]);
            ++i;
        }
        list.add(output);
        return list.toArray(new String[0]);
    }

    public static String[] makeMuxPCMAndVideoCommand(String ffmpeg, String input, String audioInput, String videoCodec, String audioCodec, String[] options, String output) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-y");
        if (audioInput != null) {
            list.add("-f");
            list.add("s16le");
            list.add("-ar");
            list.add("48000");
            list.add("-ac");
            list.add("2");
            list.add("-i");
            list.add(audioInput);
        }
        list.add("-i");
        list.add(input);
        if (audioInput != null) {
            list.add("-acodec");
            list.add(audioCodec);
        } else {
            list.add("-an");
        }
        list.add("-vcodec");
        list.add(videoCodec);
        int i = 0;
        while (i < options.length) {
            list.add(options[i]);
            ++i;
        }
        list.add(output);
        return list.toArray(new String[0]);
    }

    public static String[] makeJpegInputCommand(String ffmpeg, String inputDir, String head, int digit, String foot, String fps, String audioInput, String videoCodec, String[] options, String output) {
        return FFMpegCommandUtil.makeJpegInputCommand(ffmpeg, inputDir, head, digit, foot, fps, audioInput, videoCodec, "pcm_s16le", options, output);
    }
}

