/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.LocalOptimizer;
import org.eclipse.draw2d.graph.NestingTree;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankSorter;
import org.eclipse.draw2d.graph.Subgraph;

class CompoundRankSorter
extends RankSorter {
    boolean init;
    RowKey key = new RowKey();
    Map map = new HashMap();

    CompoundRankSorter() {
    }

    void addRowEntry(Subgraph s, int row) {
        this.key.s = s;
        this.key.rank = row;
        if (!this.map.containsKey(this.key)) {
            this.map.put(new RowKey(s, row), new RowEntry());
        }
    }

    protected void assignIncomingSortValues() {
        super.assignIncomingSortValues();
        this.pullTogetherSubgraphs();
    }

    protected void assignOutgoingSortValues() {
        super.assignOutgoingSortValues();
        this.pullTogetherSubgraphs();
    }

    void optimize(DirectedGraph g) {
        CompoundDirectedGraph graph = (CompoundDirectedGraph)g;
        Iterator containment = graph.containment.iterator();
        while (containment.hasNext()) {
            graph.removeEdge((Edge)containment.next());
        }
        graph.containment.clear();
        new LocalOptimizer().visit(graph);
    }

    private void pullTogetherSubgraphs() {
    }

    double evaluateNodeOutgoing() {
        double result = super.evaluateNodeOutgoing();
        if (this.progress > 0.2) {
            double connectivity;
            Subgraph s = this.node.getParent();
            result = connectivity = this.mergeConnectivity(s, this.node.rank + 1, result, this.progress);
        }
        return result;
    }

    double evaluateNodeIncoming() {
        double result = super.evaluateNodeIncoming();
        if (this.progress > 0.2) {
            double connectivity;
            Subgraph s = this.node.getParent();
            result = connectivity = this.mergeConnectivity(s, this.node.rank - 1, result, this.progress);
        }
        return result;
    }

    double mergeConnectivity(Subgraph s, int row, double result, double scaleFactor) {
        while (s != null && this.getRowEntry(s, row) == null) {
            s = s.getParent();
        }
        if (s != null) {
            RowEntry entry = this.getRowEntry(s, row);
            double connectivity = entry.contribution / (double)entry.count;
            result = connectivity * 0.3 + 0.7 * result;
            s = s.getParent();
        }
        return result;
    }

    RowEntry getRowEntry(Subgraph s, int row) {
        this.key.s = s;
        this.key.rank = row;
        return (RowEntry)this.map.get(this.key);
    }

    void copyConstraints(NestingTree tree) {
        if (tree.subgraph != null) {
            tree.sortValue = tree.subgraph.rowOrder;
        }
        int i = 0;
        while (i < tree.contents.size()) {
            Object child = tree.contents.get(i);
            if (child instanceof Node) {
                Node n = (Node)child;
                n.sortValue = n.rowOrder;
            } else {
                this.copyConstraints((NestingTree)child);
            }
            ++i;
        }
    }

    public void init(DirectedGraph g) {
        super.init(g);
        this.init = true;
        int row = 0;
        while (row < g.ranks.size()) {
            Rank rank = g.ranks.getRank(row);
            NestingTree tree = NestingTree.buildNestingTreeForRank(rank);
            this.copyConstraints(tree);
            tree.recursiveSort(true);
            rank.clear();
            tree.repopulateRank(rank);
            int j = 0;
            while (j < rank.count()) {
                Node n = rank.getNode(j);
                Subgraph s = n.getParent();
                while (s != null) {
                    this.addRowEntry(s, row);
                    s = s.getParent();
                }
                ++j;
            }
            ++row;
        }
    }

    protected void postSort() {
        super.postSort();
        if (this.init) {
            this.updateRank(this.rank);
        }
    }

    void updateRank(Rank rank) {
        Subgraph s;
        Node n;
        int j = 0;
        while (j < rank.count()) {
            n = rank.getNode(j);
            s = n.getParent();
            while (s != null) {
                this.getRowEntry(s, this.currentRow).reset();
                s = s.getParent();
            }
            ++j;
        }
        j = 0;
        while (j < rank.count()) {
            n = rank.getNode(j);
            s = n.getParent();
            while (s != null) {
                RowEntry entry = this.getRowEntry(s, this.currentRow);
                ++entry.count;
                entry.contribution += (double)n.index;
                s = s.getParent();
            }
            ++j;
        }
    }

    static class RowEntry {
        double contribution;
        int count;

        RowEntry() {
        }

        void reset() {
            this.count = 0;
            this.contribution = 0.0;
        }
    }

    static class RowKey {
        int rank;
        Subgraph s;

        RowKey() {
        }

        RowKey(Subgraph s, int rank) {
            this.s = s;
            this.rank = rank;
        }

        public boolean equals(Object obj) {
            RowKey rp = (RowKey)obj;
            return rp.s == this.s && rp.rank == this.rank;
        }

        public int hashCode() {
            return this.s.hashCode() ^ this.rank * 31;
        }
    }
}

