/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;

public class FLVTool2Executer {
    private String flvtool2Path;
    private File input;
    private ProcessPrinter printer;

    public FLVTool2Executer(String flvtool2Path, ProcessPrinter printer) {
        this.flvtool2Path = flvtool2Path;
        this.printer = printer;
    }

    public String[] toCommands() {
        String[] args = this.flvtool2Path.indexOf("akj_friends") != -1 ? new String[]{this.flvtool2Path, "-U", this.input.getAbsolutePath()} : new String[]{this.flvtool2Path, "u", this.input.getAbsolutePath()};
        return args;
    }

    public void execute() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        String[] commands = this.toCommands();
        this.printer.printOutput(this.toDebugArray(commands));
        Process process = runtime.exec(commands);
        ProcessMonitor monitor = new ProcessMonitor(process, this.printer);
        monitor.startMonitor();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        this.input = input;
    }
}

