/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import org.eclipse.help.HelpSystem;
import org.eclipse.help.internal.xhtml.UACharsetProcessor;
import org.eclipse.help.internal.xhtml.UAContentFilterProcessor;
import org.eclipse.help.internal.xhtml.UAContentMergeProcessor;
import org.w3c.dom.Document;

public class XHTMLSupport {
    private static UAContentFilterProcessor filterProcessor = new UAContentFilterProcessor();
    private Document document = null;
    private UAContentMergeProcessor mergeProcessor = null;
    private UACharsetProcessor charsetProcessor = null;

    public XHTMLSupport(String pluginID, String file, Document document, String locale) {
        this.document = document;
        this.mergeProcessor = new UAContentMergeProcessor(pluginID, file, document, locale);
        this.charsetProcessor = new UACharsetProcessor();
    }

    public Document processDOM() {
        return this.processDOM(true);
    }

    public Document processDOM(boolean filter) {
        if (filter && !HelpSystem.isShared()) {
            filterProcessor.applyFilters(this.document);
        }
        this.mergeProcessor.resolveIncludes();
        this.mergeProcessor.resolveContentExtensions();
        this.charsetProcessor.processCharset(this.document);
        return this.document;
    }

    public static UAContentFilterProcessor getFilterProcessor() {
        return filterProcessor;
    }

    public static void setFilterProcessor(UAContentFilterProcessor filterProcessor) {
        XHTMLSupport.filterProcessor = filterProcessor;
    }
}

