/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.youtubedl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ui.DirectoryPathCombo;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.URLBasedExecuterListener;
import jp.sourceforge.akjrcp.util.ClipboardUtil;
import jp.sourceforge.akjrcp.util.ExecutingControler;
import jp.sourceforge.akjrcp.util.ImageUtils;
import jp.sourceforge.akjrcp.util.ProgressMonitorUtils;
import jp.sourceforge.akjrcp.util.YoutubeDLExecuter;
import jp.sourceforge.akjrcp.util.YoutubeUtils;
import jp.sourceforge.akjrcp.youtubedl.YoutubeDLListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class YoutubeDLView
extends ViewPart {
    public static Log log = LogFactory.getLog(YoutubeDLView.class);
    public static final String ID = YoutubeDLView.class.getName();
    Composite composite;
    private YoutubeDLExecuteControler youtubeDLExecuteControler;
    Text urlLine;
    public static List<YoutubeDLListener> youtubeDLListeners = new ArrayList<YoutubeDLListener>();
    private String urlText;
    private File exportDir;
    private DirectoryPathCombo pathCombo;
    private IProgressMonitor progressMonitor;
    private Button renameFile;
    private boolean rename;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Group compo2 = new Group(parent, 0);
        compo2.setLayout((Layout)new GridLayout(1, false));
        compo2.setText(Messages.getString("youtubedl.group_download"));
        this.youtubeDLExecuteControler = new YoutubeDLExecuteControler();
        this.pathCombo = new DirectoryPathCombo((Composite)compo2, 0, Akj_betasPlugin.getDefault().getPreferenceStore(), "explorer.paths", ImageUtils.loadImage("jp.sourceforge.akjrcp.akj_betas", "icons/opendir.gif"), ImageUtils.loadImage("jp.sourceforge.akjrcp.akj_betas", "icons/showin.gif"));
        Group compo = new Group(parent, 0);
        compo.setText(Messages.getString("youtubedl.group_url"));
        compo.setLayout((Layout)new GridLayout(2, false));
        Button pasteButton = new Button((Composite)compo, 0);
        pasteButton.setImage(ImageUtils.loadImage("jp.sourceforge.akjrcp.akj_betas", "icons/url_clipboard.gif"));
        pasteButton.setAlignment(0x1000000);
        pasteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                YoutubeDLView.this.pasteAction();
            }
        });
        GridData labelData = new GridData();
        labelData.minimumWidth = 32;
        labelData.minimumHeight = 32;
        labelData.grabExcessHorizontalSpace = true;
        labelData.grabExcessVerticalSpace = true;
        pasteButton.setLayoutData((Object)labelData);
        pasteButton.setToolTipText(Messages.getString("youtubedl.paste_clipboard"));
        GridData urlData = new GridData();
        urlData.minimumWidth = 400;
        urlData.minimumHeight = 24;
        urlData.grabExcessHorizontalSpace = true;
        urlData.grabExcessVerticalSpace = false;
        this.urlLine = new Text((Composite)compo, 0);
        this.urlLine.setFont(new Font(null, "MS-Mincho", 12, 0));
        this.urlLine.setLayoutData((Object)urlData);
        this.urlLine.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                YoutubeDLView.this.youtubeDLExecuteControler.updateControlSwitch();
            }
        });
        this.pathCombo.updatePaths();
        this.pathCombo.setSelectionListener(new SelectChange());
        this.renameFile = new Button(parent, 32);
        this.renameFile.setText(Messages.getString("youtubedl.rename_file"));
        this.renameFile.setSelection(PlatformUI.getPreferenceStore().getBoolean("youtubedl.rename_file"));
        this.renameFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                YoutubeDLView.this.storeValue(e.getSource());
            }
        });
        this.youtubeDLExecuteControler.addControl((Control)this.urlLine);
        this.youtubeDLExecuteControler.addControl((Control)this.pathCombo);
        this.youtubeDLExecuteControler.addControl((Control)pasteButton);
        this.youtubeDLExecuteControler.addControl((Control)this.renameFile);
        new ExecutingControler.ExecutingControlButton(parent, 0, this.youtubeDLExecuteControler, Messages.getString("youtubedl.exec"), Messages.getString("singleimagetomovie.cancel"));
        if (!this.isYoutubeDLExist()) {
            Akj_betasPlugin.getDefault().getProcessPrinter().printError(String.valueOf(Messages.getString("youtubedl.error_no_youtubedl")) + "\n");
        }
        try {
            this.pasteAction();
            this.youtubeDLExecuteControler.updateControlSwitch();
        }
        catch (Exception exception) {
            log.warn((Object)"paste faild");
        }
    }

    public void pasteAction() {
        String[] lines;
        String text = ClipboardUtil.getCurrentText(PlatformUI.getWorkbench().getDisplay());
        if (text != null && YoutubeUtils.isYoutubeURL((lines = text.split("\n"))[0])) {
            this.urlLine.setText(lines[0]);
        }
    }

    public void storeValue(Object object) {
        if (object == this.renameFile) {
            PlatformUI.getPreferenceStore().setValue("youtubedl.rename_file", this.renameFile.getSelection());
        }
    }

    public boolean isYoutubeDLExist() {
        String python = PlatformUI.getPreferenceStore().getString("youtubedl.path_python");
        String dl_py = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.py");
        String dl_exe = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.exe");
        if (python.length() > 0 && new File(python).exists() && dl_py.length() > 0 && new File(dl_py).exists()) {
            return true;
        }
        return dl_exe.length() > 0 && new File(dl_exe).exists();
    }

    public void setStatusValue(String value) {
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new SetMessage(value));
    }

    public void setFocus() {
        this.urlLine.setFocus();
    }

    public class SelectChange
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            YoutubeDLView.this.youtubeDLExecuteControler.updateControlSwitch();
        }
    }

    public class OverwriteCheck
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            FileOverwriteControler controler;
            boolean r;
            File f = new File(event.getFilePath());
            if (f.exists() && !(r = (controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1)).canOverwrite(f))) {
                ((FileDirChoicer)((Object)event.getSource())).removePath();
            }
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
        }
    }

    public class FileSelected
    implements FileDirChoicer.FileStatusChangeListener {
        public void addList(FileDirChoicer.FileStatusChangeEvent event) {
            YoutubeDLView.this.youtubeDLExecuteControler.updateControlSwitch();
        }

        public void removeList(FileDirChoicer.FileStatusChangeEvent event) {
            YoutubeDLView.this.youtubeDLExecuteControler.updateControlSwitch();
        }
    }

    public class YoutubeDLExecuteControler
    extends ExecutingControler {
        private YoutubeDLExecuter youtubeExecuter;

        public void afterExecute() {
        }

        public void beforeExecute() {
            YoutubeDLView.this.urlText = YoutubeDLView.this.urlLine.getText();
            YoutubeDLView.this.exportDir = YoutubeDLView.this.pathCombo.getSelectedDirectory();
            YoutubeDLView.this.progressMonitor = ProgressMonitorUtils.getProgressMonitor();
            YoutubeDLView.this.rename = YoutubeDLView.this.renameFile.getSelection();
        }

        public boolean canExecute() {
            return YoutubeDLView.this.isYoutubeDLExist() && YoutubeDLView.this.pathCombo.getSelectedDirectory() != null && YoutubeUtils.isYoutubeURL(YoutubeDLView.this.urlLine.getText());
        }

        public void cancelExecuting() {
            if (this.youtubeExecuter != null) {
                this.youtubeExecuter.cancel();
            }
        }

        public void inExecute() {
            this.youtubeExecuter = new YoutubeDLExecuter();
            this.youtubeExecuter.setExportDir(YoutubeDLView.this.exportDir.getAbsolutePath());
            String python = PlatformUI.getPreferenceStore().getString("youtubedl.path_python");
            String dl_py = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.py");
            String dl_exe = PlatformUI.getPreferenceStore().getString("youtubedl.path_youtubedl.exe");
            boolean setPath = false;
            if (python.length() > 0 && new File(python).exists() && dl_py.length() > 0 && new File(dl_py).exists()) {
                this.youtubeExecuter.setPythonPath(python);
                this.youtubeExecuter.setYoutubeDLPath(dl_py);
                setPath = true;
            }
            if (!setPath) {
                if (dl_exe.length() > 0 && new File(dl_exe).exists()) {
                    this.youtubeExecuter.setYoutubeDLPath(dl_exe);
                    setPath = true;
                } else {
                    log.warn((Object)"youtube-dl not found");
                }
            }
            this.youtubeExecuter.setRenameFile(YoutubeDLView.this.rename);
            this.youtubeExecuter.setExecuteListener(new DLMonitor());
            try {
                this.youtubeExecuter.execute(new URL[]{new URL(YoutubeDLView.this.urlText)});
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public class UpdateExplorer
    extends Thread {
        public void run() {
            int i = 0;
            while (i < youtubeDLListeners.size()) {
                youtubeDLListeners.get(i).downloaded("");
                ++i;
            }
        }
    }

    public class DLMonitor
    implements URLBasedExecuterListener {
        int lastprocess = 0;

        public void afterConvert() {
        }

        public void beforeConvert() {
        }

        public void endConvert(URL url) {
            ProgressMonitorUtils.progressMonitorDone(YoutubeDLView.this.progressMonitor, true);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateExplorer());
        }

        public void faildConvert(URL url, String message) {
            ProgressMonitorUtils.progressMonitorDone(YoutubeDLView.this.progressMonitor, true);
            YoutubeDLView.this.setStatusValue(Messages.getString("youtubedl.faild"));
            Akj_betasPlugin.getDefault().getProcessPrinter().printError(Messages.getString("youtubedl.faild.detail"));
        }

        public void printProcess(String line) {
            if (YoutubeDLExecuter.isProgressLine(line)) {
                int value = YoutubeDLExecuter.getProgressPersent(line);
                int add = value - this.lastprocess;
                if (add > 0) {
                    ProgressMonitorUtils.progressMonitorWorked(YoutubeDLView.this.progressMonitor, add, true);
                }
                this.lastprocess = value;
            } else {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(line);
            }
        }

        public void startConvert(URL url) {
            ProgressMonitorUtils.progressMonitorBegin(YoutubeDLView.this.progressMonitor, "Download:" + url.toString(), 100, true);
            this.lastprocess = 0;
        }
    }

    public class SetMessage
    implements Runnable {
        String message;

        SetMessage(String message) {
            this.message = message;
        }

        public void run() {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)YoutubeDLView.this.getViewSite().getWorkbenchWindow();
            WWinActionBars actionBars = workbenchWindow.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(this.message);
        }
    }
}

