/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import org.apache.commons.lang.StringUtils;

public class FileNameUtils {
    public static String getChangedExtensionName(File file, String extension) {
        return FileNameUtils.getChangedExtensionName(file, extension, false);
    }

    public static String getChangedExtensionName(String name, String extension) {
        String baseName;
        if (name.lastIndexOf(".") == -1) {
            baseName = name;
        } else {
            int index = name.lastIndexOf(".");
            baseName = name.substring(0, index);
        }
        return String.valueOf(baseName) + "." + extension;
    }

    public static String getChangedExtensionName(File file, String extension, boolean overwrite) {
        int index;
        File newFile = null;
        String baseName = null;
        if (file.getName().lastIndexOf(".") == -1) {
            baseName = file.getName();
        } else {
            index = file.getName().lastIndexOf(".");
            baseName = file.getName().substring(0, index);
        }
        newFile = new File(file.getParent(), String.valueOf(baseName) + "." + extension);
        index = 1;
        if (!overwrite) {
            while (newFile.exists()) {
                String specific = "(" + index + ")";
                newFile = new File(file.getParent(), String.valueOf(baseName) + specific + "." + extension);
                ++index;
            }
        }
        return newFile.getAbsolutePath();
    }

    public static String toSafeJPName(String path) {
        String shoudreplace = ":;,*?\"<>|?";
        String replace = "\uff1a\uff1b\u3001\uff0a\uff1f\uffe5\u201d\uff1c\uff1e\uff5c\uff1f";
        String ret = path;
        ret = StringUtils.replaceChars((String)ret, (String)shoudreplace, (String)replace);
        return ret;
    }

    public static boolean changeExtension(File file, String extension) {
        return file.renameTo(new File(FileNameUtils.getChangedExtensionName(file, extension)));
    }
}

