/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView;
import jp.sourceforge.akjrcp.flvtools.explorer.MonitorCancelable;
import jp.sourceforge.akjrcp.ui.SimpleFileList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ConvertingMonitorDialog
extends Dialog {
    private SimpleFileList fileList;
    private File[] files = new File[0];
    private int index = -1;
    private IWorkbenchSite site;
    private MonitorCancelable cancelable;

    protected ConvertingMonitorDialog(IWorkbenchSite site) {
        super(site.getShell());
        this.site = site;
    }

    public boolean isOpened() {
        return this.getShell() != null && !this.getShell().isDisposed();
    }

    protected Point getInitialSize() {
        return new Point(300, 350);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("explorer.convertdialog"));
    }

    public void closeWindow() {
        this.close();
    }

    public void setFileList(File[] files) {
        this.files = files;
    }

    public void updateSelect(int index) {
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateSelect(index));
    }

    public void selectFile(int index) {
        this.index = index;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        this.fileList = new SimpleFileList(composite);
        this.fileList.getTable().setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < this.files.length) {
            this.fileList.addFile(this.files[i]);
            ++i;
        }
        this.fileList.setInput(this.site);
        this.fileList.selectFile(this.index);
        Button cancel = new Button(composite, 0);
        cancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConvertingMonitorDialog.this.cancelable != null) {
                    ExplorerView.log.info((Object)"cancel called");
                    ConvertingMonitorDialog.this.cancelable.cancel();
                }
                ConvertingMonitorDialog.this.closeWindow();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        cancel.setText(Messages.getString("explorer.cancel"));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public SimpleFileList getFileList() {
        return this.fileList;
    }

    public void setFileList(SimpleFileList fileList) {
        this.fileList = fileList;
    }

    public MonitorCancelable getCancelable() {
        return this.cancelable;
    }

    public void setCancelable(MonitorCancelable cancelable) {
        this.cancelable = cancelable;
    }

    public class UpdateSelect
    extends Thread {
        private int index;

        public UpdateSelect(int index) {
            this.index = index;
        }

        public void run() {
            ConvertingMonitorDialog.this.fileList.selectFile(this.index);
        }
    }
}

