/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.io;

import java.io.IOException;
import java.io.Writer;

public final class DotTerminatedMessageWriter
extends Writer {
    private static final int __NOTHING_SPECIAL_STATE = 0;
    private static final int __LAST_WAS_CR_STATE = 1;
    private static final int __LAST_WAS_NL_STATE = 2;
    private int __state;
    private Writer __output;

    public DotTerminatedMessageWriter(Writer writer) {
        super((Object)writer);
        this.__output = writer;
        this.__state = 0;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.__output == null) {
                Object var2_2 = null;
                return;
            }
            if (this.__state == 1) {
                this.__output.write(10);
            } else if (this.__state != 2) {
                this.__output.write("\r\n");
            }
            this.__output.write(".\r\n");
            this.__output.flush();
            this.__output = null;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.__output.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            switch (n) {
                case 13: {
                    this.__state = 1;
                    this.__output.write(13);
                    return;
                }
                case 10: {
                    if (this.__state != 1) {
                        this.__output.write(13);
                    }
                    this.__output.write(10);
                    this.__state = 2;
                    return;
                }
                case 46: {
                    if (this.__state != 2) break;
                    this.__output.write(46);
                    break;
                }
            }
            this.__state = 0;
            this.__output.write(n);
            return;
        }
    }

    public void write(String string) throws IOException {
        this.write(string.toCharArray());
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (n2-- > 0) {
                this.write(cArray[n++]);
            }
        }
    }
}

