/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.video;

import java.util.StringTokenizer;

public class Video {
    private static final String[] aspectratio_table_strings = new String[]{"res.", "1:1", "4:3", "16:9", "2.21:1", "0.8055", "0.8437", "0.9375", "0.9815", "1.0255", "1.0695", "1.1250", "1.1575", "1.2015", "res.", "res."};
    private static final String[] framerate_table_strings = new String[]{"forbidden fps", "23.976fps", "24fps", "25fps", "29.97fps", "30fps", "50fps", "59.94fps", "60fps", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def."};
    private static final float[] aspectratio_table = new float[]{1.0f, 1.0f, 1.3333f, 1.7778f, 2.21f, 0.8055f, 0.8437f, 0.9375f, 0.9815f, 1.0255f, 1.0695f, 1.125f, 1.1575f, 1.2015f, 1.0f, 1.0f};
    private static final int[] framerate_table = new int[]{-1, 23976, 24000, 25000, 29970, 30000, 50000, 59940, 60000, -1, -1, -1, -1, -1, -1, -1};

    public static String getAspectRatio(int n) {
        return aspectratio_table_strings[n];
    }

    public static float getAspectRatioValue(int n) {
        return aspectratio_table[n];
    }

    public static int getFrameRate(int n) {
        return framerate_table[n];
    }

    public static String getVideoformatfromBytes(byte[] byArray) {
        return "" + ((0xFF & byArray[4]) << 4 | (0xF0 & byArray[5]) >>> 4) + "*" + ((0xF & byArray[5]) << 8 | 0xFF & byArray[6]) + ", " + framerate_table_strings[0xF & byArray[7]] + ", " + aspectratio_table_strings[(0xFF & byArray[7]) >>> 4] + ", " + ((0xFF & byArray[8]) << 10 | (0xFF & byArray[9]) << 2 | (0xC0 & byArray[10]) >>> 6) * 400 + "bps, vbv " + ((0x1F & byArray[10]) << 5 | (0xF8 & byArray[11]) >>> 3);
    }

    public static byte[] getSequenceEndCode() {
        byte[] byArray = new byte[]{0, 0, 1, -73};
        return byArray;
    }

    public static byte[] getSequenceStartCode() {
        byte[] byArray = new byte[]{0, 0, 1, -77};
        return byArray;
    }

    public static byte[] setSequenceDisplayExtension(String string, String[] stringArray) {
        byte[] byArray = new byte[]{0, 0, 1, -75, 43, 2, 2, 2, 0, 0, 0, 0};
        Video.setSequenceDisplayExtension(byArray, 0, string, stringArray);
        return byArray;
    }

    public static void setSequenceDisplayExtension(byte[] byArray, int n, String string, String[] stringArray) throws ArrayIndexOutOfBoundsException {
        int[] nArray = Video.getHVSize(string, stringArray);
        byArray[n += (1 & byArray[n + 4]) != 0 ? 8 : 5] = (byte)(0xFF & nArray[0] >>> 6);
        byArray[n + 1] = (byte)(0xFC & nArray[0] << 2);
        int n2 = n + 1;
        byArray[n2] = (byte)(byArray[n2] | 2);
        int n3 = n + 1;
        byArray[n3] = (byte)(byArray[n3] | (byte)(1 & nArray[0] >>> 13));
        byArray[n + 2] = (byte)(0xFF & nArray[1] >>> 5);
        byArray[n + 3] = (byte)(0xF8 & nArray[1] << 3);
    }

    private static int[] getHVSize(String string, String[] stringArray) {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        int[] nArray = new int[]{720, 576};
        for (n2 = 0; n2 < 2; ++n2) {
            try {
                nArray[n2] = n = Integer.parseInt(stringArray[n2].trim());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n2 = 0; stringTokenizer.hasMoreTokens() && n2 < 2; ++n2) {
            try {
                nArray[n2] = n = Integer.parseInt(stringTokenizer.nextElement().toString().trim());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nArray;
    }
}

