/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.File;
import java.io.InputStream;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamProcessBase {
    public int ERRORCODE = 0;
    public int MainBufferSize = 0x7D0000;

    public StreamProcessBase() {
        this.init();
    }

    public void init() {
        this.MainBufferSize = Integer.parseInt(Common.getSettings().getProperty(Keys.KEY_MainBuffer));
        if (this.MainBufferSize <= 0) {
            this.MainBufferSize = 4096000;
        }
    }

    public boolean pause() {
        return Common.waitingMainProcess();
    }

    public String FramesToTime(int n, double d) {
        return String.valueOf(Math.round((double)n * d / 90.0));
    }

    public long[][] loadTempVideoPts(String string, boolean bl) {
        if (string.equals("-1")) {
            return null;
        }
        if (bl) {
            System.out.println("-> loading video PTS logfile...");
        }
        XInputFile xInputFile = new XInputFile(new File(string));
        int n = (int)xInputFile.length() / 16;
        long[][] lArray = new long[2][n];
        byte[] byArray = new byte[(int)xInputFile.length()];
        int n2 = 0;
        try {
            InputStream inputStream = xInputFile.getInputStream();
            inputStream.read(byArray, 0, byArray.length);
            for (int i = 0; i < n; i += 2) {
                lArray[0][i] = CommonParsing.getValue(byArray, n2, 8, false);
                lArray[0][i + 1] = CommonParsing.getValue(byArray, n2 += 8, 8, false);
                lArray[1][i] = CommonParsing.getValue(byArray, n2 += 8, 8, false);
                lArray[1][i + 1] = CommonParsing.getValue(byArray, n2 += 8, 8, false);
                n2 += 8;
                if (!bl) continue;
                System.out.println("#s " + i + " _" + lArray[0][i] + " #e " + (i + 1) + " _" + lArray[0][i + 1] + " /#s " + i + " _" + lArray[1][i] + " #e " + (i + 1) + " _" + lArray[1][i + 1]);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
            return null;
        }
        Common.setMessage(Resource.getString("video.msg.pts.start_end", Common.formatTime_1(lArray[0][0] / 90L)) + " " + Common.formatTime_1(lArray[0][lArray[0].length - 1] / 90L));
        return lArray;
    }

    public long[][] loadTempOtherPts(String string, String string2, String string3, String string4, String string5, int n, boolean bl, boolean bl2) {
        if (string.equals("-1")) {
            return null;
        }
        if (bl2) {
            System.out.println("-> loading PTS logfile...");
        }
        XInputFile xInputFile = new XInputFile(new File(string));
        int n2 = (int)xInputFile.length() / 16;
        long[][] lArray = new long[2][n2 + 1];
        lArray[0][n2] = -1L;
        lArray[1][n2] = -1L;
        byte[] byArray = new byte[(int)xInputFile.length()];
        int n3 = 0;
        try {
            InputStream inputStream = xInputFile.getInputStream();
            inputStream.read(byArray, 0, byArray.length);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                long l = CommonParsing.getValue(byArray, n3, 8, false);
                long l2 = CommonParsing.getValue(byArray, n3 += 8, 8, false);
                n3 += 8;
                if (bl2) {
                    System.out.println(" #" + n4 + "/" + i + " _" + l + " / " + l2);
                }
                if (n4 > 0 && l <= lArray[0][n4 - 1]) {
                    if (n4 > 1 && Math.abs(l - lArray[0][n4 - 2]) < 150000L && Math.abs(l - lArray[0][n4 - 1]) > 500000L) {
                        --n4;
                        if (bl2) {
                            System.out.print(" <!^> ");
                        }
                    } else {
                        if (!bl2) continue;
                        System.out.print(" <!v> ");
                        continue;
                    }
                }
                lArray[0][n4] = l;
                lArray[1][n4] = l2;
                ++n4;
            }
            if (n4 < n2) {
                Common.setMessage(Resource.getString(string2, " " + (n2 - n4)));
                long[][] lArray2 = new long[2][n4];
                System.arraycopy(lArray[0], 0, lArray2[0], 0, n4);
                System.arraycopy(lArray[1], 0, lArray2[1], 0, n4);
                lArray[0] = new long[n4 + 1];
                System.arraycopy(lArray2[0], 0, lArray[0], 0, n4);
                lArray[0][n4] = -1L;
                lArray[1] = new long[n4 + 1];
                System.arraycopy(lArray2[1], 0, lArray[1], 0, n4);
                lArray[1][n4] = -1L;
            }
            inputStream.close();
            if (n == 1 && (lArray[0][0] == 0xFFFFFFFFL || lArray[0][0] == 0L)) {
                Common.setMessage(Resource.getString(string5));
                bl = true;
            }
            if (bl) {
                long[] lArray3 = new long[]{lArray[0][0], lArray[1][0]};
                lArray[0] = new long[2];
                lArray[0][0] = lArray3[0];
                lArray[0][1] = -1L;
                lArray[1] = new long[2];
                lArray[1][0] = lArray3[1];
                lArray[1][1] = -1L;
                Common.setMessage(Resource.getString(string3));
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
            return null;
        }
        Common.setMessage(Resource.getString(string4, Common.formatTime_1(lArray[0][0] / 90L)) + " " + Common.formatTime_1(lArray[0][lArray[0].length - 2] / 90L));
        return lArray;
    }

    public int checkPTSMatch(long[] lArray, long[] lArray2) {
        if (lArray2[0] < lArray[0]) {
            if (lArray2[lArray2.length - 2] < lArray[0]) {
                Common.setMessage(Resource.getString("checkpts.1st.latter"));
                return lArray2.length - 2;
            }
            int n = lArray2.length - 1;
            for (int i = 0; i < n; ++i) {
                if (lArray2[i + 1] <= lArray[0]) continue;
                return i;
            }
            return 0;
        }
        if (lArray2[0] >= lArray[lArray.length - 1]) {
            Common.setMessage(Resource.getString("checkpts.last.ends"));
            return -1;
        }
        return 0;
    }

    public String infoPTSMatch(String string, String string2, boolean bl, boolean bl2) {
        if (!string2.equals("-1") && !string.equals("-1") && !bl && bl2) {
            return "? ";
        }
        return "";
    }

    public boolean SyncCheck(int[] nArray, double d, double d2, long l, int n, long[] lArray, long[] lArray2, boolean bl, boolean bl2) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n3 < lArray.length) {
            double d3 = l - lArray[n3 + 1];
            double d4 = d - (double)lArray2[n3 + 1];
            if (bl2) {
                System.out.println("A " + bl + "/" + n2 + "/" + n3 + "/ =1 " + n + "/" + lArray2[n3 + 1] + "/" + d + " ~2 " + lArray[n3 + 1] + "/" + l + " ~3 " + d3 + "/" + d4 + "/" + (d4 - d3));
            }
            if (Math.abs(d4) <= d2 / 2.0) {
                bl = false;
                n3 += 2;
            } else if (Math.abs(d3) <= d2 / 2.0) {
                bl = false;
                n3 += 2;
            }
            if (bl2) {
                System.out.println("B " + bl + "/" + n2 + "/" + n3);
            }
        }
        if (n2 < lArray.length) {
            boolean bl3 = false;
            double d5 = l - lArray[n2];
            double d6 = d - (double)lArray2[n2];
            if (bl2) {
                System.out.println("C " + bl + "/" + n2 + "/" + n3 + "/ =4 " + n + "/" + lArray2[n2] + "/" + d + " ~5 " + lArray[n2] + "/" + l + " ~6 " + d5 + "/" + d6 + "/" + (d6 - d5));
            }
            if (!bl && Math.abs(d5) <= d2 / 2.0) {
                bl = true;
                bl3 = true;
                n2 += 2;
            } else if (!bl && Math.abs(Math.abs(d6) - Math.abs(d5)) <= d2 / 2.0) {
                bl = true;
                bl3 = true;
                n2 += 2;
            }
            if (bl2) {
                System.out.println("D " + bl + "/" + n2 + "/" + n3);
            }
            if (n2 < lArray.length && bl && d + d2 / 2.0 > (double)lArray2[n2]) {
                bl = false;
            }
            if (bl2) {
                System.out.println("E " + bl + "/" + n2 + "/" + n3);
            }
            if (bl3 && bl) {
                Common.getGuiInterface().showAVOffset("" + (int)(d5 / 90.0) + "/" + (int)(d6 / 90.0) + "/" + (int)((d6 - d5) / 90.0));
            }
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return bl;
    }
}

