/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.awt.Toolkit;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sourceforge.dvb.projectx.audio.MpaConverter;
import net.sourceforge.dvb.projectx.audio.MpaDecoder;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamParser;
import net.sourceforge.dvb.projectx.parser.StreamParserBase;
import net.sourceforge.dvb.projectx.parser.VBI;
import net.sourceforge.dvb.projectx.thirdparty.TS;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class MainProcess
extends Thread {
    private MpaConverter MPAConverter;
    private MpaDecoder MPADecoder;
    private int ERRORCODE = 0;
    private int MainBufferSize = 0x7D0000;
    private TS tf = new TS();

    public void run() {
        Common.setRunningProcess(true);
        this.startProcessing();
        Common.setRunningProcess(false);
    }

    private void startProcessing() {
        boolean bl = false;
        Common.setGlobalDebug(Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog));
        JobCollection jobCollection = null;
        JobProcessing jobProcessing = null;
        try {
            Common.setProcessTime(System.currentTimeMillis());
            Common.updateProgressBar(Resource.getString("run.prepare.colls"), 0L, 0L);
            Common.getGuiInterface().showAVOffset(Resource.getString("run.av.offset"));
            Common.getGuiInterface().updateTtxHeader("");
            Common.getGuiInterface().updateVpsLabel("");
            Common.setMessage(null, false);
            if (CommonParsing.isInfoScan()) {
                Common.setMessage(Resource.getString("run.start.quick.info"));
                Common.setMessage("");
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (CommonParsing.getPvaPidToExtract() == -1) {
                if (Common.getSettings().getBooleanProperty(Keys.KEY_useAllCollections)) {
                    n2 = Common.getCollectionListSize();
                } else {
                    n = Common.getActiveCollection();
                    n2 = n + 1;
                }
                Common.setMessage(Resource.getString("run.session.infos"));
                Common.setMessage("");
                while (n < n2) {
                    Common.clearMessageLog();
                    Common.setMessage(DateFormat.getDateInstance(0).format(new Date()) + "  " + DateFormat.getTimeInstance(0).format(new Date()));
                    Common.setMessage(Common.getVersionName() + " (" + Common.getVersionDate() + ")");
                    System.gc();
                    if (n < Common.getCollectionListSize()) {
                        Common.setProcessedCollection(n);
                        jobCollection = Common.getCollection(n);
                        jobCollection.startProcessing(Common.isRunningCLI());
                        jobProcessing = jobCollection.getJobProcessing();
                        Common.setMessage("");
                        Common.setMessage(Resource.getString("run.working.coll") + " " + n);
                        if (jobCollection.getInputFilesCount() == 0) {
                            Common.getGuiInterface().showAVOffset(Resource.getString("run.av.offset"));
                            Common.updateProgressBar("", 0L, 0L);
                            Common.setMessage(Resource.getString("run.no.input"));
                        } else {
                            Common.getGuiInterface().updateTtxHeader("");
                            Common.getGuiInterface().updateVpsLabel("");
                            CommonParsing.setCutCounter(0);
                            CommonParsing.setCutStatus(false);
                            MainProcess mainProcess = this;
                            mainProcess.tf.setfirstID();
                            this.messageSettings();
                            String string = jobCollection.checkOutputDirectory();
                            if (string != null) {
                                Common.setMessage(Resource.getString("run.write.output.notexists") + ":");
                                Common.setMessage("'" + string + "'");
                            } else {
                                if (Common.getSettings().getBooleanProperty(Keys.KEY_ExportPanel_createSubDirNumber)) {
                                    string = "[" + n + "]";
                                    jobCollection.setOutputDirectory(jobCollection.getOutputDirectory() + jobCollection.getFileSeparator() + string);
                                    new File(jobCollection.getOutputDirectory()).mkdirs();
                                }
                                if (Common.getSettings().getBooleanProperty(Keys.KEY_ExportPanel_createSubDirName)) {
                                    File file = new File(jobCollection.getFirstFileBase());
                                    string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date(jobCollection.getFirstFileDate())) + "_" + jobCollection.getFirstFileName();
                                    jobCollection.setOutputDirectory(jobCollection.getOutputDirectory() + jobCollection.getFileSeparator() + string);
                                    new File(jobCollection.getOutputDirectory()).mkdirs();
                                }
                                if (Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createVdrIndex) && Common.getSettings().getIntProperty(Keys.KEY_ConversionMode) == 1) {
                                    string = "_" + new File(jobCollection.getFirstFileBase()).getName() + System.getProperty("file.separator") + new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss.SSS").format(new Date()) + ".rec";
                                    jobCollection.setOutputDirectory(jobCollection.getOutputDirectory() + jobCollection.getFileSeparator() + string);
                                    new File(jobCollection.getOutputDirectory()).mkdirs();
                                }
                                Common.setMessage(Resource.getString("run.write.output.to") + " '" + jobCollection.getOutputDirectory() + "'");
                                int n4 = jobCollection.getCutpointCount();
                                if (n4 > 0) {
                                    Common.setMessage("-> " + n4 + " " + Resource.getString("run.cutpoints.defined") + " ( " + Keys.ITEMS_CutMode[Common.getSettings().getIntProperty(Keys.KEY_CutMode)] + " )");
                                }
                                jobCollection.setLogFiles();
                                int n5 = jobCollection.getActionType();
                                if (n5 < 0) {
                                    n5 = Common.getSettings().getIntProperty(Keys.KEY_ConversionMode);
                                }
                                if (!CommonParsing.isInfoScan() && n5 == 4 && Common.getSettings().getBooleanProperty(Keys.KEY_TS_generatePmt)) {
                                    Common.setMessage("");
                                    Common.setMessage(Resource.getString("run.start.quick.info"));
                                    CommonParsing.setInfoScan(true);
                                    long l = jobProcessing.getSplitSize();
                                    jobProcessing.setSplitSize(0L);
                                    this.processCollection(jobCollection);
                                    jobProcessing.setSourceVideoFrameNumber(0);
                                    jobProcessing.setFileNumber(0);
                                    CommonParsing.setCutCounter(0);
                                    CommonParsing.setCutStatus(false);
                                    CommonParsing.setInfoScan(false);
                                    jobProcessing.setSplitSize(l);
                                    Common.setMessage("");
                                    Common.setMessage(Resource.getString("run.end.quick.info"));
                                }
                                jobProcessing.getChapters().init(Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createChapters));
                                this.processCollection(jobCollection);
                                jobProcessing.clearStatusStrings();
                                jobProcessing.getChapters().finish(jobCollection.getOutputDirectory(), jobCollection.getFirstFileName());
                                jobCollection.finishProcessing();
                            }
                        }
                    }
                    ++n;
                    ++n3;
                }
            } else {
                Common.setProcessedCollection(Common.getActiveCollection());
                Common.setMessage(DateFormat.getDateInstance(0).format(new Date()) + "  " + DateFormat.getTimeInstance(0).format(new Date()));
                Common.setMessage(Common.getVersionName() + " (" + Common.getVersionDate() + ")");
                Common.setMessage("");
                Common.setMessage(Resource.getString("run.session.infos"));
                Common.setMessage("");
                Common.setMessage(Resource.getString("run.working.coll") + " " + Common.getProcessedCollection());
                jobCollection = Common.getCollection(Common.getProcessedCollection());
                if (jobCollection.getInputFilesCount() == 0) {
                    Common.setMessage(Resource.getString("run.coll.empty"));
                } else {
                    String string = jobCollection.checkOutputDirectory();
                    if (string != null) {
                        Common.setMessage(Resource.getString("run.write.output.notexists") + ":");
                        Common.setMessage("'" + string + "'");
                    } else {
                        Common.setMessage(Resource.getString("run.write.raw") + " " + jobCollection.getOutputDirectory());
                        jobCollection.startProcessing(Common.isRunningCLI());
                        this.processCollection(jobCollection);
                        CommonParsing.setPvaPidToExtract(0);
                        jobCollection.finishProcessing();
                    }
                }
            }
            Common.updateProgressBar(Resource.getString("run.done", "" + n3) + " " + Common.formatTime_1(Common.getProcessTime()));
        }
        catch (Exception exception) {
            Common.setMessage(Resource.getString("run.stopped"));
            Common.setExceptionMessage(exception);
            bl = true;
        }
        catch (Error error) {
            Common.setMessage(Resource.getString("run.stopped"));
            Common.setErrorMessage(error);
            bl = true;
        }
        CommonParsing.setPvaPidExtraction(false);
        if (CommonParsing.isInfoScan()) {
            Common.setMessage("");
            Common.setMessage(Resource.getString("run.end.quick.info"));
        }
        CommonParsing.setProcessPausing(false);
        CommonParsing.setProcessCancelled(false);
        CommonParsing.setInfoScan(false);
        if (bl) {
            Common.setMessage(Resource.getString("all.msg.error.summary", String.valueOf(Common.getErrorCount())));
            jobCollection.closeDebugLogStream();
            jobCollection.closeNormalLogStream(Common.getMessageLog());
        } else {
            Common.setMessage(" ", false, 0xEFFFEF);
        }
        jobCollection.finishProcessing();
        if (Common.isRunningCLI() || Common.getSettings().getBooleanProperty(Keys.KEY_closeOnEnd)) {
            Common.exitApplication(bl ? 1 : 0);
        }
        Common.getGuiInterface().resetMainFrameTitle();
    }

    private void messageSettings() {
        Common.setMessage(" ");
        this.messageSetting(Keys.KEY_DebugLog);
        this.messageSetting(Keys.KEY_NormalLog);
        this.messageSetting(Keys.KEY_simpleMPG);
        this.messageSetting(Keys.KEY_enhancedPES);
        if (Common.getSettings().getBooleanProperty(Keys.KEY_SplitSize)) {
            Common.setMessage(Resource.getString("run.split.output") + " " + Common.getSettings().getProperty(Keys.KEY_ExportPanel_SplitSize_Value) + " MB");
        }
        this.messageSetting(Keys.KEY_WriteOptions_writeVideo);
        this.messageSetting(Keys.KEY_WriteOptions_writeAudio);
        if (Common.getSettings().getIntProperty(Keys.KEY_ConversionMode) == 0) {
            if (Common.getSettings().getBooleanProperty(Keys.KEY_additionalOffset)) {
                Common.setMessage(Resource.getString("run.add.time.offset", "" + Common.getSettings().getProperty(Keys.KEY_ExportPanel_additionalOffset_Value)));
            }
            if (Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createM2sIndex)) {
                Common.setMessage("-> " + Resource.getString("ExternPanel.createM2sIndex.Tip") + " " + Resource.getString(Keys.KEY_ExternPanel_createM2sIndex[0]));
            }
            if (Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createInfoIndex)) {
                Common.setMessage("-> " + Resource.getString("ExternPanel.createInfoIndex.Tip") + " " + Resource.getString(Keys.KEY_ExternPanel_createInfoIndex[0]));
            }
            this.messageSetting(Keys.KEY_ExternPanel_createD2vIndex);
            if (Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_ExternPanel_createD2vIndex[0]) + " " + Resource.getString(Keys.KEY_ExternPanel_splitProjectFile[0]));
            }
            if (Common.getSettings().getBooleanProperty(Keys.KEY_OptionDAR)) {
                Common.setMessage("-> " + Resource.getString("CollectionPanel.ExportLimits") + " " + Resource.getString(Keys.KEY_OptionDAR[0]) + " " + Keys.ITEMS_ExportDAR[Common.getSettings().getIntProperty(Keys.KEY_ExportDAR)]);
            }
            if (Common.getSettings().getBooleanProperty(Keys.KEY_OptionHorizontalResolution)) {
                Common.setMessage("-> " + Resource.getString("CollectionPanel.ExportLimits") + " " + Resource.getString(Keys.KEY_OptionHorizontalResolution[0]) + " " + Common.getSettings().getProperty(Keys.KEY_ExportHorizontalResolution));
            }
            this.messageSetting(Keys.KEY_VideoPanel_clearCDF);
            this.messageSetting(Keys.KEY_VideoPanel_patchToInterlaced);
            this.messageSetting(Keys.KEY_VideoPanel_patchToProgressive);
            this.messageSetting(Keys.KEY_VideoPanel_toggleFieldorder);
            this.messageSetting(Keys.KEY_VideoPanel_addEndcode);
            this.messageSetting(Keys.KEY_VideoPanel_insertEndcode);
            if (Common.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_addSde)) {
                Common.setMessage("-> " + Resource.getString(Keys.KEY_VideoPanel_addSde[0]) + " " + Common.getSettings().getProperty(Keys.KEY_VideoPanel_SdeValue));
            }
            this.messageSetting(Keys.KEY_VideoPanel_addSequenceHeader);
        }
        boolean bl = true;
        this.messageSetting(Resource.getString("run.stream.type.disabled"), Keys.KEY_Streamtype_MpgVideo, bl);
        this.messageSetting(Resource.getString("run.stream.type.disabled"), Keys.KEY_Streamtype_MpgAudio, bl);
        this.messageSetting(Resource.getString("run.stream.type.disabled"), Keys.KEY_Streamtype_Ac3Audio, bl);
        this.messageSetting(Resource.getString("run.stream.type.disabled"), Keys.KEY_Streamtype_PcmAudio, bl);
        this.messageSetting(Resource.getString("run.stream.type.disabled"), Keys.KEY_Streamtype_Teletext, bl);
        this.messageSetting(Resource.getString("run.stream.type.disabled"), Keys.KEY_Streamtype_Subpicture, bl);
        this.messageSetting(Resource.getString("run.stream.type.disabled"), Keys.KEY_Streamtype_Vbi, bl);
        this.messageSetting(Keys.KEY_PVA_FileOverlap);
        this.messageSetting(Keys.KEY_PVA_Audio);
        this.messageSetting(Keys.KEY_VOB_resetPts);
        this.messageSetting(Keys.KEY_TS_ignoreScrambled);
        this.messageSetting(Keys.KEY_TS_blindSearch);
        this.messageSetting(Keys.KEY_TS_joinPackets);
        this.messageSetting(Keys.KEY_TS_HumaxAdaption);
        this.messageSetting(Keys.KEY_TS_FinepassAdaption);
        this.messageSetting(Keys.KEY_TS_generatePmt);
        this.messageSetting(Keys.KEY_TS_generateTtx);
        this.messageSetting(Keys.KEY_Input_getEnclosedPackets);
        this.messageSetting(Keys.KEY_Input_concatenateForeignRecords);
        this.messageSetting(Keys.KEY_Video_ignoreErrors);
        this.messageSetting(Keys.KEY_Video_trimPts);
        this.messageSetting(Keys.KEY_Conversion_startWithVideo);
        this.messageSetting(Keys.KEY_Conversion_addPcrToStream);
        Common.setMessage(" ");
    }

    private void messageSetting(String[] stringArray) {
        if (Common.getSettings().getBooleanProperty(stringArray)) {
            Common.setMessage("-> " + Resource.getString(stringArray[0]));
        }
    }

    private void messageSetting(String string, String[] stringArray) {
        if (Common.getSettings().getBooleanProperty(stringArray)) {
            Common.setMessage(string + " " + Resource.getString(stringArray[0]));
        }
    }

    private void messageSetting(String string, String[] stringArray, boolean bl) {
        if (Common.getSettings().getBooleanProperty(stringArray) != bl) {
            Common.setMessage(string + " " + Resource.getString(stringArray[0]));
        }
    }

    public boolean pause() {
        if (!CommonParsing.isProcessPausing()) {
            return false;
        }
        try {
            MainProcess.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            Common.setMessage("!> interrupted suspend mode ");
            Common.setExceptionMessage(interruptedException);
        }
        return true;
    }

    private void processCollection(JobCollection jobCollection) {
        XInputFile xInputFile;
        int n;
        JobProcessing jobProcessing = jobCollection.getJobProcessing();
        String string = "-1";
        String string2 = "-1";
        this.MainBufferSize = Integer.parseInt(Common.getSettings().getProperty(Keys.KEY_MainBuffer));
        if (this.MainBufferSize <= 0) {
            this.MainBufferSize = 4096000;
        }
        jobProcessing.setSplitSize(Common.getSettings().getBooleanProperty(Keys.KEY_SplitSize) ? 0x100000L * (long)Integer.parseInt(Common.getSettings().getProperty(Keys.KEY_ExportPanel_SplitSize_Value)) : 0L);
        long l = jobProcessing.getSplitSize();
        jobProcessing.setLastHeaderBytePosition(0L);
        jobProcessing.setFirstAudioPts(0L);
        jobProcessing.setSplitPart(0);
        jobProcessing.setSplitLoopActive(true);
        jobProcessing.setNextFileStartPts(0L);
        jobProcessing.setCutComparePoint(10000000L);
        jobProcessing.setVideoExportTime(0L);
        jobProcessing.setVideoExportTimeSummary(0L);
        jobProcessing.setLastGopTimecode(0L);
        jobProcessing.setLastGopPts(0L);
        jobProcessing.setLastSimplifiedPts(0L);
        jobProcessing.setMediaFilesExportLength(0L);
        CommonParsing.setVideoFramerate(3600.0);
        if (Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile)) {
            jobProcessing.setProjectFileSplitSize(Long.parseLong(Common.getSettings().getProperty(Keys.KEY_ExternPanel_ProjectFileSplitSize)) * 0x100000L);
        }
        jobProcessing.setElementaryVideoStream(false);
        jobProcessing.set1stVideoPTS(-1L);
        VBI.reset();
        String[] stringArray = new String[]{Resource.getString("working.convertType.demux"), Resource.getString("working.convertType.makeVDR"), Resource.getString("working.convertType.makeMPG2"), Resource.getString("working.convertType.makePVA"), Resource.getString("working.convertType.makeTS"), Resource.getString("working.convertType.packetFilter")};
        int n2 = jobCollection.getActionType();
        if (n2 < 0) {
            n2 = Common.getSettings().getIntProperty(Keys.KEY_ConversionMode);
        }
        List list = jobCollection.getInputFilesAsList();
        int n3 = list.size();
        int n4 = 0;
        StreamParserBase streamParserBase = new StreamParserBase();
        int n5 = -1;
        int n6 = -1;
        block18: for (n = 0; n < n3; ++n) {
            xInputFile = ((XInputFile)list.get(n)).getNewInstance();
            if (xInputFile == null) continue;
            if (xInputFile.getStreamInfo() == null) {
                Common.getScanClass().getStreamInfo(xInputFile);
            }
            n6 = xInputFile.getStreamInfo().getStreamType();
            if (n5 != -1 && n5 != n6) break;
            switch (n6) {
                case 1: 
                case 6: 
                case 7: {
                    if (n != 0 || n2 != 0) break;
                    jobProcessing.setNextFileStartPts(streamParserBase.nextFilePTS(jobCollection, 1, 1, 0L, 0));
                    break;
                }
                case 2: {
                    if (n != 0 || n2 != 0) break;
                    jobProcessing.setNextFileStartPts(streamParserBase.nextFilePTS(jobCollection, 1, n6, 0L, 0));
                    break;
                }
                case 3: {
                    if (n != 0 || n2 != 0) break;
                    jobProcessing.setNextFileStartPts(streamParserBase.nextFilePTS(jobCollection, 1, n6, 0L, 0));
                    break;
                }
                case 4: {
                    if (n != 0 || n2 != 0) break;
                    jobProcessing.setNextFileStartPts(streamParserBase.nextFilePTS(jobCollection, 3, 1, 0L, 0));
                    break;
                }
                case 5: {
                    if (n != 0 || n2 != 0) break;
                    jobProcessing.setNextFileStartPts(streamParserBase.nextFilePTS(jobCollection, 2, 1, 0L, 0));
                    break;
                }
                default: {
                    break block18;
                }
            }
            n5 = n6;
            ++n4;
        }
        jobCollection.setPrimaryInputFileSegments(n4);
        Common.getGuiInterface().resetBitrateMonitor();
        while (jobProcessing.isSplitLoopActive()) {
            Common.showSplitPart(jobProcessing.getSplitPart());
            jobProcessing.clearSummaryInfo();
            jobProcessing.clearSubStreamCounters();
            jobProcessing.setBorrowedPts(-1L);
            jobProcessing.countVideoExportTimeSummary(jobProcessing.getVideoExportTime());
            jobProcessing.setVideoExportTime(0L);
            if (new File(string).exists()) {
                new File(string).delete();
            }
            block20: for (n = 0; n < n3; ++n) {
                if (n == 1 && jobCollection.getPrimaryInputFileSegments() > 0) {
                    n = jobCollection.getPrimaryInputFileSegments();
                }
                if (n >= n3) break;
                xInputFile = (XInputFile)list.get(n);
                Common.setMessage("");
                Common.setMessage(Resource.getString("working.file", "" + n, "'" + xInputFile + "'", Common.formatNumber(xInputFile.length())));
                if (!xInputFile.exists()) {
                    Common.setMessage(Resource.getString("working.file.not.found"));
                    continue;
                }
                if (xInputFile.length() <= 0L) {
                    Common.setMessage(Resource.getString("working.file.not.found") + " " + Resource.getString("ScanInfo.Size") + " " + Common.formatNumber(xInputFile.length()) + " " + Resource.getString("ScanInfo.Bytes"));
                    continue;
                }
                if (xInputFile.getStreamInfo() == null) {
                    Common.getScanClass().getStreamInfo(xInputFile);
                }
                n5 = xInputFile.getStreamInfo().getStreamType();
                Common.setMessage(Resource.getString("working.filetype", Keys.ITEMS_FileTypes[n5]));
                switch (n5) {
                    case 1: {
                        if (n > 0) {
                            new StreamParser(0).parseStream(jobCollection, xInputFile, n5, n2, string);
                            continue block20;
                        }
                        if (!CommonParsing.getPvaPidExtraction()) {
                            Common.setMessage(stringArray[n2]);
                        }
                        string = Common.getSettings().getBooleanProperty(Keys.KEY_enhancedPES) ? new StreamParser(1).parseStream(jobCollection, xInputFile, 3, n2, string) : new StreamParser(1).parseStream(jobCollection, xInputFile, n5, n2, string);
                        if (n2 != 0) continue block20;
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        continue block20;
                    }
                    case 2: {
                        if (n > 0) {
                            new StreamParser(0).parseStream(jobCollection, xInputFile, n5, n2, string);
                            continue block20;
                        }
                        if (!CommonParsing.getPvaPidExtraction()) {
                            Common.setMessage(stringArray[n2]);
                        }
                        string = new StreamParser(1).parseStream(jobCollection, xInputFile, n5, n2, string);
                        if (n2 != 0) continue block20;
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        continue block20;
                    }
                    case 3: {
                        if (n > 0) {
                            new StreamParser(0).parseStream(jobCollection, xInputFile, n5, n2, string);
                            continue block20;
                        }
                        if (!CommonParsing.getPvaPidExtraction()) {
                            Common.setMessage(stringArray[n2]);
                        }
                        string = Common.getSettings().getBooleanProperty(Keys.KEY_simpleMPG) ? new StreamParser(1).parseStream(jobCollection, xInputFile, 1, n2, string) : new StreamParser(1).parseStream(jobCollection, xInputFile, n5, n2, string);
                        if (n2 != 0) continue block20;
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        continue block20;
                    }
                    case 4: {
                        if (n > 0) {
                            Common.setMessage(Resource.getString("all.msg.noprimaryfile"));
                            continue block20;
                        }
                        if (!CommonParsing.getPvaPidExtraction()) {
                            Common.setMessage(stringArray[n2]);
                        }
                        string = new StreamParser(3).parseStream(jobCollection, xInputFile, 1, n2, string);
                        if (n2 != 0) continue block20;
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        continue block20;
                    }
                    case 5: {
                        if (n > 0) {
                            Common.setMessage(Resource.getString("all.msg.noprimaryfile"));
                            continue block20;
                        }
                        if (!CommonParsing.getPvaPidExtraction()) {
                            Common.setMessage(stringArray[n2]);
                        }
                        string = new StreamParser(2).parseStream(jobCollection, xInputFile, 1, n2, null);
                        if (n2 != 0) continue block20;
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        continue block20;
                    }
                    case 6: 
                    case 7: {
                        if (n > 0) {
                            CommonParsing.resetSplitMode(jobProcessing, string);
                            new StreamParser(0).parseStream(jobCollection, xInputFile, 1, n2, string);
                            continue block20;
                        }
                        if (!CommonParsing.getPvaPidExtraction()) {
                            Common.setMessage(stringArray[n2]);
                        }
                        string = Common.getSettings().getBooleanProperty(Keys.KEY_enhancedPES) ? new StreamParser(1).parseStream(jobCollection, xInputFile, 3, n2, string) : new StreamParser(1).parseStream(jobCollection, xInputFile, 1, n2, string);
                        if (n2 != 0) continue block20;
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        continue block20;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        new StreamParser(5).parseStream(jobCollection, xInputFile, n5, n2, string);
                        continue block20;
                    }
                    case 8: {
                        string = new StreamParser(4).parseStream(jobCollection, xInputFile, n5, n2, string);
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        continue block20;
                    }
                    case 16: {
                        CommonParsing.resetSplitMode(jobProcessing, string);
                        new StreamParser(6).parseStream(jobCollection, xInputFile, n5, n2, string);
                        continue block20;
                    }
                    default: {
                        Common.setMessage(Resource.getString("working.file.notsupported"));
                    }
                }
            }
            if (jobProcessing.getSplitSize() > 0L) {
                Common.setMessage(Resource.getString("working.end.of.part") + " " + jobProcessing.getSplitPart());
                jobProcessing.setSplitPart(jobProcessing.getSplitPart() + 1);
            } else {
                jobProcessing.setSplitLoopActive(false);
            }
            Common.setMessage("");
            Object[] objectArray = jobProcessing.getSummaryInfo().toArray();
            Arrays.sort(objectArray);
            Common.setMessage(Resource.getString("working.summary"));
            Common.setMessage(objectArray);
            jobProcessing.clearSummaryInfo();
            if (CommonParsing.isInfoScan()) continue;
            Common.performPostCommand(objectArray);
        }
        Common.setMessage("=> " + Common.formatNumber(jobProcessing.getMediaFilesExportLength()) + " " + Resource.getString("working.bytes.written"));
        Common.setMessage(Resource.getString("all.msg.error.summary", String.valueOf(Common.getErrorCount())));
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        jobCollection.closeDebugLogStream();
        jobCollection.closeNormalLogStream(Common.getMessageLog());
        List list2 = jobProcessing.getTemporaryFileList();
        if (!list2.isEmpty()) {
            for (n6 = 0; n6 < list2.size(); n6 += 2) {
                if (!new File(list2.get(n6).toString()).exists()) continue;
                new File(list2.get(n6).toString()).delete();
            }
            list2.clear();
        }
        jobProcessing.setSplitSize(l);
        Toolkit.getDefaultToolkit().beep();
    }
}

