/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.Video;

public class Gop {
    private byte[] headerrescue = new byte[1];
    private long VbvBuffer_Value = 0L;
    private boolean Debug;
    private boolean CreateD2vIndex;
    private boolean SplitProjectFile;
    private boolean AddSequenceHeader;
    private boolean Message_3;
    private boolean AddSequenceDisplayExension;
    private boolean PatchToProgressive;
    private boolean PatchToInterlaced;
    private boolean ToggleFieldorder;
    private boolean ClearCDF;
    private boolean Save1stFrameOfGop;
    private boolean Preview_AllGops;
    private boolean Preview_fastDecode;
    private boolean TrimPts;
    private boolean IgnoreErrors;
    private boolean OptionDAR;
    private boolean OptionHorizontalResolution;
    private boolean WriteVideo;
    private boolean InsertEndcode;
    private boolean DumpDroppedGop;
    private int ChangeBitrateInAllSequences;
    private int ChangeVbvDelay;
    private int CutMode;
    private int ExportDAR;
    private int ChangeAspectRatio;
    private int ChangeVbvBuffer;
    private String ExportHorizontalResolution;
    private String SDE_Value;
    private JobProcessing job_processing;

    public Gop(JobCollection jobCollection) {
        this.getSettings(jobCollection);
    }

    private void getSettings(JobCollection jobCollection) {
        this.Debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.CreateD2vIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createD2vIndex);
        this.SplitProjectFile = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile);
        this.AddSequenceHeader = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_addSequenceHeader);
        this.Message_3 = jobCollection.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg3);
        this.AddSequenceDisplayExension = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_addSde);
        this.PatchToProgressive = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_patchToProgressive);
        this.PatchToInterlaced = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_patchToInterlaced);
        this.ToggleFieldorder = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_toggleFieldorder);
        this.ClearCDF = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_clearCDF);
        this.Save1stFrameOfGop = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_save1stFrameOfGop);
        this.Preview_AllGops = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Preview_AllGops);
        this.Preview_fastDecode = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Preview_fastDecode);
        this.TrimPts = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Video_trimPts);
        this.IgnoreErrors = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Video_ignoreErrors);
        this.OptionDAR = jobCollection.getSettings().getBooleanProperty(Keys.KEY_OptionDAR);
        this.OptionHorizontalResolution = jobCollection.getSettings().getBooleanProperty(Keys.KEY_OptionHorizontalResolution);
        this.WriteVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeVideo);
        this.InsertEndcode = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_insertEndcode);
        this.DumpDroppedGop = jobCollection.getSettings().getBooleanProperty(Keys.KEY_dumpDroppedGop);
        this.ChangeBitrateInAllSequences = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeBitrateInAllSequences);
        this.ChangeVbvDelay = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeVbvDelay);
        this.CutMode = jobCollection.getSettings().getIntProperty(Keys.KEY_CutMode);
        this.ExportDAR = jobCollection.getSettings().getIntProperty(Keys.KEY_ExportDAR);
        this.ChangeAspectRatio = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeAspectRatio);
        this.ChangeVbvBuffer = jobCollection.getSettings().getIntProperty(Keys.KEY_ChangeVbvBuffer);
        this.ExportHorizontalResolution = jobCollection.getSettings().getProperty(Keys.KEY_ExportHorizontalResolution);
        this.SDE_Value = jobCollection.getSettings().getProperty(Keys.KEY_VideoPanel_SdeValue);
    }

    private void messageDropError(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, long l, long l2, String string, int n5) {
        Common.setMessage(Resource.getString("video.msg.error.gop.drop", String.valueOf(n3 - 1), Common.formatTime_1(l / 90L), String.valueOf(l)) + ", errorcode: " + Integer.toHexString(n5).toUpperCase());
        Common.setMessage(Resource.getString("video.msg.error.gop.diff", String.valueOf(n + 1) + "/" + (n2 + 1), String.valueOf((l2 - l) / 90L)) + " " + Common.formatTime_1((long)((double)n4 * (CommonParsing.getVideoFramerate() / 90.0))));
        if (this.DumpDroppedGop) {
            String string2 = string + "-GOP#" + (n3 - 1) + ".bin";
            byte[] byArray3 = new byte[16];
            Arrays.fill(byArray3, (byte)-1);
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
                dataOutputStream.writeInt(n3 - 1);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeInt(n2);
                dataOutputStream.write(byArray3, 0, 4);
                dataOutputStream.write(byArray2);
                dataOutputStream.write(byArray3);
                dataOutputStream.write(byArray);
                dataOutputStream.write(Video.getSequenceEndCode());
                dataOutputStream.flush();
                dataOutputStream.close();
                Common.setMessage(Resource.getString("video.msg.error.gop.dump") + " " + string);
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
    }

    public void goptest(JobProcessing jobProcessing, IDDBufferedOutputStream iDDBufferedOutputStream, byte[] byArray, byte[] byArray2, DataOutputStream dataOutputStream, String string, int[] nArray, List list, List list2) {
        this.goptest(jobProcessing, iDDBufferedOutputStream, byArray, byArray2, dataOutputStream, string, nArray, list, list2, true);
    }

    public void goptest(JobProcessing jobProcessing, IDDBufferedOutputStream iDDBufferedOutputStream, byte[] byArray, byte[] byArray2, DataOutputStream dataOutputStream, String string, int[] nArray, List list, List list2, boolean bl) {
        long l;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray2 = jobProcessing.getStatusVariables();
        int n6 = 0;
        Object[] objectArray = jobProcessing.getStatusStrings();
        Common.setFps(jobProcessing.getSourceVideoFrameNumber());
        if (byArray.length < 12) {
            Common.setMessage(Resource.getString("video.msg.error.lackofdata", String.valueOf(nArray2[6])));
            return;
        }
        if (byArray2.length == 0) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            n5 = 0;
            n4 = 0;
            while (n4 < byArray.length - 7) {
                n3 = CommonParsing.validateStartcode(byArray, n4);
                if (n3 < 0) {
                    n4 += -n3;
                    continue;
                }
                n2 = CommonParsing.getPES_IdField(byArray, n4);
                if (n2 == 184) {
                    d2 = 90.0 * (3600000.0 * (double)((0x7C & byArray[n4 + 4]) >>> 2) + 60000.0 * (double)((3 & byArray[n4 + 4]) << 4 | (0xF0 & byArray[n4 + 5]) >>> 4) + 1000.0 * (double)((7 & byArray[n4 + 5]) << 3 | (0xE0 & byArray[n4 + 6]) >>> 5) + (double)((0x1F & byArray[n4 + 6]) << 1 | (0x80 & byArray[n4 + 7]) >>> 7) * (CommonParsing.getVideoFramerate() / 90.0));
                    n4 += 7;
                    continue;
                }
                if (n2 == 0) {
                    n5 = n4;
                    d4 = CommonParsing.getVideoFramerate() * (double)((0xFF & byArray[n4 + 4]) << 2 | (0xC0 & byArray[n4 + 5]) >>> 6);
                    d = d4 + (double)jobProcessing.getEndPtsOfGop();
                    break;
                }
                n4 += 4;
            }
            if ((d3 = d2 - (double)jobProcessing.getLastGopTimecode()) >= 0.0 && d3 < 2.7E7) {
                d = (double)jobProcessing.getLastGopPts() + d3 + d4;
                Common.setMessage(Resource.getString("video.msg.error.nopts.use_goptc", "" + nArray2[6]));
            } else {
                Common.setMessage(Resource.getString("video.msg.error.nopts.use_lastpts", "" + nArray2[6]));
            }
            byArray2 = new byte[16];
            for (n4 = 0; n4 < 8; ++n4) {
                byArray2[7 - n4] = (byte)(0xFFL & (long)d >>> n4 * 8);
                byArray2[15 - n4] = (byte)(0xFFL & (long)n5 >>> n4 * 8);
            }
            jobProcessing.setLastGopTimecode((long)d2);
        }
        long[][] lArray = new long[2][byArray2.length / 16];
        for (n = 0; n < byArray2.length / 16; ++n) {
            for (int i = 0; i < 8; ++i) {
                long[] lArray2 = lArray[0];
                int n7 = n;
                lArray2[n7] = lArray2[n7] | (0xFFL & (long)byArray2[n * 16 + i]) << (7 - i) * 8;
                long[] lArray3 = lArray[1];
                int n8 = n;
                lArray3[n8] = lArray3[n8] | (0xFFL & (long)byArray2[n * 16 + 8 + i]) << (7 - i) * 8;
            }
        }
        if (lArray[0].length > 1 && Math.abs(lArray[0][lArray[0].length - 1] - lArray[0][0]) < 100L) {
            long l2 = lArray[0][0];
            long l3 = lArray[1][0];
            lArray = new long[2][1];
            lArray[0][0] = l2;
            lArray[1][0] = l3;
            nArray2[8] = nArray2[8] + 1;
        }
        if (this.Debug) {
            System.out.println("\ngop" + nArray2[6] + "/tc_o53 " + jobProcessing.getLastGopTimecode() + "/lp_o54 " + jobProcessing.getLastGopPts() + "/lp_o8 " + jobProcessing.getEndPtsOfGop() + "/lp_o40 " + jobProcessing.getLastSimplifiedPts());
            for (n = 0; n < lArray[0].length; ++n) {
                System.out.println("p" + n + " " + lArray[0][n] + "/ " + lArray[1][n]);
            }
        }
        Calendar calendar = Calendar.getInstance();
        String string2 = Common.formatTime_1((long)((double)jobProcessing.getExportedVideoFrameNumber() * (CommonParsing.getVideoFramerate() / 90.0)));
        String string3 = "";
        String[] stringArray = new String[]{"res.", "1.000 (1:1)", "0.6735 (4:3)", "0.7031 (16:9)", "0.7615 (2.21:1)", "0.8055", "0.8437", "0.9375", "0.9815", "1.0255", "1.0695", "1.1250", "1.1575", "1.2015", "res."};
        String[] stringArray2 = new String[]{"forbidden fps", "23.976fps", "24fps", "25fps", "29.97fps", "30fps", "50fps", "59.94fps", "60fps", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def.", "n.def."};
        double[] dArray = new double[]{0.0, 3753.7537, 3750.0, 3600.0, 3003.003, 3000.0, 1800.0, 1501.5015, 1500.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int n9 = 0;
        n5 = 0;
        n4 = -1;
        n3 = 0;
        n2 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 65535;
        int n14 = jobProcessing.getExportedVideoFrameNumber();
        int n15 = 0;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        int n19 = 0;
        int[] nArray3 = new int[]{5, 50, 20, 5, 5, 5, 5, 5};
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        long l4 = jobProcessing.getVideoExportTime();
        long l5 = jobProcessing.getLastGopTimecode();
        long l6 = 0L;
        long l7 = l = jobProcessing.getEndPtsOfGop() == -10000L ? -20000L : jobProcessing.getEndPtsOfGop();
        long l8 = 0L;
        String[] stringArray3 = new String[]{"0", "I", "P", "B", "D", "5", "6", "7"};
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<long[]> arrayList4 = new ArrayList<long[]>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byte by = 0;
        try {
            int n20;
            int n21;
            int n22;
            int n23;
            byte[] byArray3;
            if (jobProcessing.hasSequenceHeader()) {
                byteArrayOutputStream2.write(-120);
            } else {
                byteArrayOutputStream2.write(-128);
            }
            if (jobProcessing.getSplitSize() > 0L && !jobProcessing.hasSequenceHeader() && jobProcessing.getExportedVideoFrameNumber() == 0) {
                byArray3 = new byte[this.headerrescue.length + byArray.length];
                System.arraycopy(this.headerrescue, 0, byArray3, 0, this.headerrescue.length);
                System.arraycopy(byArray, 0, byArray3, this.headerrescue.length, byArray.length);
                byArray = byArray3;
                jobProcessing.setSequenceHeader(true);
                n23 = 0;
                while (n23 < lArray[1].length) {
                    long[] lArray4 = lArray[1];
                    int n24 = n23++;
                    lArray4[n24] = lArray4[n24] + (long)this.headerrescue.length;
                }
            } else if (!(list.isEmpty() || jobProcessing.hasSequenceHeader() || CommonParsing.getCutStatus())) {
                byArray3 = new byte[this.headerrescue.length + byArray.length];
                System.arraycopy(this.headerrescue, 0, byArray3, 0, this.headerrescue.length);
                System.arraycopy(byArray, 0, byArray3, this.headerrescue.length, byArray.length);
                byArray = byArray3;
                jobProcessing.setSequenceHeader(true);
                n23 = 0;
                while (n23 < lArray[1].length) {
                    long[] lArray5 = lArray[1];
                    int n25 = n23++;
                    lArray5[n25] = lArray5[n25] + (long)this.headerrescue.length;
                }
            } else if (!jobProcessing.hasSequenceHeader() && this.AddSequenceHeader) {
                byArray3 = new byte[this.headerrescue.length + byArray.length];
                System.arraycopy(this.headerrescue, 0, byArray3, 0, this.headerrescue.length);
                System.arraycopy(byArray, 0, byArray3, this.headerrescue.length, byArray.length);
                byArray = byArray3;
                jobProcessing.setSequenceHeader(true);
                n23 = 0;
                while (n23 < lArray[1].length) {
                    long[] lArray6 = lArray[1];
                    int n26 = n23++;
                    lArray6[n26] = lArray6[n26] + (long)this.headerrescue.length;
                }
            }
            if (jobProcessing.hasSequenceHeader()) {
                int n27 = (0xFF & byArray[n19 + 4]) << 4 | (0xF0 & byArray[n19 + 5]) >>> 4;
                n23 = (0xF & byArray[n19 + 5]) << 8 | 0xFF & byArray[n19 + 6];
                n22 = 0xF & byArray[n19 + 7];
                n21 = 0xF & byArray[n19 + 7] >>> 4;
                double d = dArray[n22];
                if (n27 == 0 || n23 == 0 || d == 0.0 || n21 == 0 || n21 > 13) {
                    nArray2[4] = nArray2[4] + 1;
                    this.messageDropError(byArray, byArray2, n5, n4, nArray2[6], jobProcessing.getExportedVideoFrameNumber(), l7, l, string, n6 |= 0x80);
                    jobProcessing.setSequenceHeader(false);
                    byteArrayOutputStream.close();
                    byteArrayOutputStream2.close();
                    byArray = null;
                    return;
                }
                CommonParsing.setVideoFramerate(d);
                this.VbvBuffer_Value = 16384 * ((0x1F & byArray[n19 + 10]) << 5 | (0xF8 & byArray[n19 + 11]) >>> 3);
                Object[] objectArray2 = new String[]{String.valueOf(n27), String.valueOf(n23), stringArray2[n22], stringArray[n21], ""};
                nArray2[7] = n21 - 1;
                if (jobProcessing.isNewVideoStream() || jobProcessing.getExportedVideoFrameNumber() == 0) {
                    string3 = Resource.getString("video.msg.basics", "" + (String)objectArray2[0] + "*" + (String)objectArray2[1] + " @ " + (String)objectArray2[2] + " @ " + (String)objectArray2[3] + " @ " + ((0xFF & byArray[n19 + 8]) << 10 | (0xFF & byArray[n19 + 9]) << 2 | (0xC0 & byArray[n19 + 10]) >>> 6) * 400) + " " + ((0x1F & byArray[n19 + 10]) << 5 | (0xF8 & byArray[n19 + 11]) >>> 3);
                    arrayList3.add(string3);
                    if (jobProcessing.getExportedVideoFrameNumber() == 0) {
                        bl7 = true;
                        by = byArray[n19 + 7];
                    } else {
                        bl9 = true;
                    }
                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                }
                if (!Arrays.equals(objectArray, objectArray2)) {
                    String string4 = Resource.getString("video.msg.basics", (String)objectArray2[0] + "*" + (String)objectArray2[1] + " @ " + (String)objectArray2[2] + " @ " + (String)objectArray2[3] + " @ " + ((0xFF & byArray[n19 + 8]) << 10 | (0xFF & byArray[n19 + 9]) << 2 | (0xC0 & byArray[n19 + 10]) >>> 6) * 400) + " " + ((0x1F & byArray[n19 + 10]) << 5 | (0xF8 & byArray[n19 + 11]) >>> 3);
                    Common.setMessage(Resource.getString("video.msg.newformat", "" + nArray2[6]) + " (" + string2 + ")");
                    Common.setMessage(string4);
                    jobProcessing.getChapters().addChapter(string2, string4);
                    bl9 = true;
                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                }
                n19 = 12;
            }
            nArray2[6] = nArray2[6] + 1;
            while (n19 < byArray.length - 10) {
                int n28 = CommonParsing.validateStartcode(byArray, n19);
                if (n28 < 0) {
                    n19 += -n28 - 1;
                } else {
                    if (n17 > -1 && this.ClearCDF) {
                        Arrays.fill(byArray, n17, n19, (byte)0);
                        n17 = -1;
                    }
                    if ((arrayList2.size() & 1) != 0 && !arrayList2.get(arrayList2.size() - 1).toString().startsWith("_")) {
                        arrayList2.add(String.valueOf(n19));
                    }
                    if ((n23 = CommonParsing.getPES_IdField(byArray, n19)) >= 1 && n23 <= 175) {
                        if (this.Debug) {
                            System.out.println("A " + n19 + " /slice " + n23);
                        }
                        n19 += 7;
                    } else if (n23 == 178) {
                        if ((arrayList2.size() & 1) == 0) {
                            arrayList2.add(String.valueOf(n19));
                        }
                        n17 = n19;
                        n19 += 3;
                    } else if ((0xF0 & byArray[n19 + 3]) == 224) {
                        n22 = 4;
                        if (CommonParsing.getPES_LengthField(byArray, n19) == 0) {
                            if (n19 + (n22 += 5 + (0xFF & byArray[n19 + 8])) >= byArray.length) {
                                n22 = byArray.length - n19;
                            }
                            Arrays.fill(byArray, n19, n19 + n22, (byte)0);
                            if (this.Message_3) {
                                Common.setMessage(Resource.getString("video.msg.error.pesext_in_es", String.valueOf(nArray2[6] - 1), String.valueOf(n19)));
                            }
                        } else {
                            Arrays.fill(byArray, n19, n19 + n22, (byte)0);
                            if (this.Message_3) {
                                Common.setMessage(Resource.getString("video.msg.error.pes_in_es", String.valueOf(nArray2[6] - 1), String.valueOf(n19)));
                            }
                        }
                        n19 += n22 - 1;
                    } else if (!bl8 && n23 == 181 && byArray[n19 + 4] >>> 4 == 1) {
                        nArray[0] = 1;
                        bl8 = true;
                        n18 = n19 + 5;
                        n16 = n19 + 10;
                        n19 += 9;
                        if (jobProcessing.hasSequenceHeader() && byteArrayOutputStream2.size() == 1) {
                            byteArrayOutputStream2.reset();
                            byteArrayOutputStream2.write((byte)(8 | (8 & byArray[n18]) << 4));
                        }
                    } else if (!bl12 && n23 == 181 && byArray[n19 + 4] >>> 4 == 2) {
                        if (this.AddSequenceDisplayExension && jobProcessing.hasSequenceHeader()) {
                            Video.setSequenceDisplayExtension(byArray, n19, this.SDE_Value, (String[])objectArray);
                        }
                        bl13 = true;
                        n19 += 8;
                    } else if (n23 == 184) {
                        bl12 = true;
                        n10 = n19 + 7;
                        bl5 = true;
                        bl11 = (0x20 & byArray[n19 + 7]) != 0;
                        l6 = 90L * (3600000L * (long)((0x7C & byArray[n19 + 4]) >>> 2) + 60000L * (long)((3 & byArray[n19 + 4]) << 4 | (0xF0 & byArray[n19 + 5]) >>> 4) + 1000L * (long)((7 & byArray[n19 + 5]) << 3 | (0xE0 & byArray[n19 + 6]) >>> 5) + (long)((double)((0x1F & byArray[n19 + 6]) << 1 | (0x80 & byArray[n19 + 7]) >>> 7) * (CommonParsing.getVideoFramerate() / 90.0)));
                        if ((double)Math.abs(l6 - jobProcessing.getLastGopTimecode()) < CommonParsing.getVideoFramerate() || jobProcessing.getSourceVideoFrameNumber() == 0) {
                            jobProcessing.setLastGopTimecode(l6);
                        }
                        if (this.Debug) {
                            System.out.println("\n//b8 " + l6 + "/ " + Integer.toHexString(0x80 & byArray[n19 + 4] | 0x7F & byArray[n19 + 7]) + "/ " + n19 + "/ " + jobProcessing.hasSequenceHeader());
                        }
                        if (jobProcessing.hasSequenceHeader()) {
                            this.headerrescue = new byte[n19];
                            System.arraycopy(byArray, 0, this.headerrescue, 0, n19);
                        }
                        Date date = new Date((long)((double)jobProcessing.getExportedVideoFrameNumber() * (CommonParsing.getVideoFramerate() / 90.0)));
                        calendar.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
                        calendar.setTime(date);
                        n21 = calendar.get(11);
                        int n29 = calendar.get(12);
                        n20 = calendar.get(13);
                        int n30 = calendar.get(14) / ((int)CommonParsing.getVideoFramerate() / 90);
                        byArray[4 + n19] = (byte)(0x80 & byArray[n19 + 4] | n21 << 2 | n29 >>> 4);
                        byArray[5 + n19] = (byte)((0xF & n29) << 4 | 8 | n20 >>> 3);
                        byArray[6 + n19] = (byte)((7 & n20) << 5 | n30 >>> 1);
                        byArray[7 + n19] = (byte)(0x7F & byArray[n19 + 7] | n30 << 7);
                        n19 += 6;
                    } else if (n23 == 0) {
                        bl12 = true;
                        n9 = (0xFF & byArray[n19 + 4]) << 2 | (0xC0 & byArray[n19 + 5]) >>> 6;
                        n15 = (0x38 & byArray[n19 + 5]) >>> 3;
                        if (n15 < 1 || n15 > 4) {
                            Common.setMessage(Resource.getString("video.msg.error.frame.wrong", "" + n15) + " " + n9);
                            bl10 = true;
                            n6 |= 1;
                        }
                        arrayList.add(String.valueOf(n9 << 4 | n15));
                        if (this.ChangeBitrateInAllSequences != 2 && this.ChangeBitrateInAllSequences > 0 && this.ChangeVbvDelay > 0) {
                            int n31 = n19 + 5;
                            byArray[n31] = (byte)(byArray[n31] | 7);
                            int n32 = n19 + 6;
                            byArray[n32] = (byte)(byArray[n32] | 0xFF);
                            int n33 = n19 + 7;
                            byArray[n33] = (byte)(byArray[n33] | 0xF8);
                        }
                        if (n9 > n5) {
                            n5 = n9;
                        }
                        if (this.Debug) {
                            System.out.println(n4 + "/ " + n5 + "/ " + n9 + "/ " + n19 + " * " + stringArray3[n15] + "/ " + byArray.length);
                        }
                        if (!bl2 && (long)n19 >= lArray[1][0]) {
                            l7 = lArray[0][0] - (long)(CommonParsing.getVideoFramerate() * (double)n9);
                            bl2 = true;
                        } else if (!bl3 && (long)n19 >= lArray[1][lArray[1].length - 1]) {
                            l = lArray[0][lArray[0].length - 1] - (long)(CommonParsing.getVideoFramerate() * (double)n9);
                            bl3 = true;
                        }
                        if (n4 == -1 && n15 == 1) {
                            n13 = (7 & byArray[n19 + 5]) << 13 | (0xFF & byArray[n19 + 6]) << 5 | (0xF8 & byArray[n19 + 7]) >>> 3;
                            bl6 = true;
                            if (jobProcessing.getExportedVideoFrameNumber() == 0) {
                                arrayList3.add(Resource.getString("video.msg.export.start") + " " + (nArray2[6] - 1));
                            }
                            if (n9 > 0 && ((double)Math.abs(l7 - jobProcessing.getEndPtsOfGop()) > CommonParsing.getVideoFramerate() || bl11)) {
                                byArray[n19 + 4] = 0;
                                int n34 = n19 + 5;
                                byArray[n34] = (byte)(byArray[n34] & 0x3F);
                                int n35 = n10;
                                byArray[n35] = (byte)(byArray[n35] | 0x40);
                                if (bl11) {
                                    int n36 = n10;
                                    byArray[n36] = (byte)(byArray[n36] & 0xFFFFFFDF);
                                }
                                byteArrayOutputStream.write(byArray, 0, n19);
                                n11 = n19;
                                if (jobProcessing.getExportedVideoFrameNumber() > 0) {
                                    arrayList3.add(Resource.getString("video.msg.pts.diff", String.valueOf(l7 - jobProcessing.getEndPtsOfGop()), Common.formatTime_1((l7 - jobProcessing.getEndPtsOfGop()) / 90L)) + " " + (bl11 ? Resource.getString("video.msg.error.brokenlink") : ""));
                                }
                                arrayList3.add(Resource.getString("video.msg.frame.drop", "" + (nArray2[6] - 1)) + " " + Common.formatTime_1((long)((double)jobProcessing.getExportedVideoFrameNumber() * (CommonParsing.getVideoFramerate() / 90.0))));
                                jobProcessing.countExportedVideoFrameNumber(-n9);
                                n3 -= n9;
                                n12 = n9;
                                bl4 = true;
                                nArray2[0] = nArray2[0] + 1;
                            }
                        }
                        if (n4 > -1 && bl4) {
                            if (bl5) {
                                byteArrayOutputStream.write(byArray, n11, n19 - n11);
                            }
                            n11 = n19;
                            if (n12 > n9) {
                                bl5 = false;
                                if ((arrayList2.size() & 1) == 0) {
                                    arrayList2.add("_" + String.valueOf(n19));
                                }
                            } else {
                                bl5 = true;
                                byArray[n19 + 4] = (byte)(n9 - n12 >>> 2);
                                byArray[n19 + 5] = (byte)(0x3F & byArray[n19 + 5] | n9 - n12 << 6);
                                if ((arrayList2.size() & 1) == 1) {
                                    arrayList2.add("_" + String.valueOf(n19));
                                }
                            }
                        }
                        if (n15 == 2) {
                            if (!bl4) {
                                long[] lArray7 = new long[]{jobProcessing.getSourceVideoFrameNumber(), n19};
                                arrayList4.add(lArray7);
                            } else {
                                long[] lArray8 = new long[]{jobProcessing.getSourceVideoFrameNumber(), byteArrayOutputStream.size()};
                                arrayList4.add(lArray8);
                            }
                        }
                        jobProcessing.countSourceVideoFrameNumber(1);
                        jobProcessing.countExportedVideoFrameNumber(1);
                        ++n4;
                        ++n3;
                        n2 = 128;
                        for (n22 = n19 + 6; n22 < n19 + 15 && n22 + 8 < byArray.length; ++n22) {
                            n28 = CommonParsing.validateStartcode(byArray, n22);
                            if (n28 < 0) {
                                n22 += -n28 - 1;
                                continue;
                            }
                            if (byArray[n22 + 3] != -75 || (0xF0 & byArray[n22 + 4]) != 128) continue;
                            n2 = 0x80 & byArray[n22 + 8];
                            if (this.PatchToProgressive) {
                                int n37 = n22 + 8;
                                byArray[n37] = (byte)(byArray[n37] | 0xFFFFFF80);
                            } else if (this.PatchToInterlaced) {
                                int n38 = n22 + 8;
                                byArray[n38] = (byte)(byArray[n38] & 0x7F);
                            }
                            if (this.ToggleFieldorder) {
                                int n39 = n22 + 7;
                                byArray[n39] = (byte)(byArray[n39] ^ 0xFFFFFF80);
                            }
                            if (!this.ClearCDF || (0x40 & byArray[n22 + 8]) == 0) break;
                            int n40 = n22 + 8;
                            byArray[n40] = (byte)(byArray[n40] & 0xFFFFFF80);
                            byArray[n22 + 9] = 0;
                            byArray[n22 + 10] = 0;
                            if ((arrayList2.size() & 1) == 0) {
                                arrayList2.add(String.valueOf(n22 + 9));
                            }
                            n19 = n22;
                            break;
                        }
                        if (bl6 || !bl4 || bl4 && bl5) {
                            byteArrayOutputStream2.write((byte)(n15 | n2));
                        }
                        n19 += 7;
                        bl6 = false;
                    }
                }
                ++n19;
            }
            if (bl4) {
                if (bl5) {
                    byteArrayOutputStream.write(byArray, n11, byArray.length - n11);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
                bl4 = false;
            }
            if (n18 != -1 && n18 < byArray.length) {
                if (this.PatchToProgressive) {
                    int n41 = n18;
                    byArray[n41] = (byte)(byArray[n41] | 8);
                } else if (this.PatchToInterlaced) {
                    int n42 = n18;
                    byArray[n42] = (byte)(byArray[n42] & 0xFFFFFFF7);
                }
            }
            if (lArray[0].length < 2) {
                l = l7;
                nArray2[1] = nArray2[1] + 1;
            }
            if (jobProcessing.get1stVideoPTS() == -1L) {
                jobProcessing.set1stVideoPTS(l7);
            }
            int[] nArray4 = new int[arrayList.size()];
            for (n23 = 0; n23 < nArray4.length; ++n23) {
                nArray4[n23] = Integer.parseInt(arrayList.get(n23).toString());
            }
            int[] nArray5 = new int[nArray4.length];
            Arrays.fill(nArray5, -1);
            if (nArray4.length == 0) {
                Common.setMessage(Resource.getString("video.msg.error.frame.not", String.valueOf(nArray2[6] - 1)));
                bl10 = true;
                n6 |= 2;
            }
            if (nArray4.length > 0 && (nArray4[0] & 0xF) != 1) {
                Common.setMessage(Resource.getString("video.msg.error.frame.not.i", String.valueOf(nArray2[6] - 1)));
            }
            for (n22 = 0; !bl10 && n22 < nArray4.length; ++n22) {
                n21 = nArray4[n22] >>> 4;
                if (n21 < 0 || n21 > nArray4.length - 1 || nArray5[n21] != -1) {
                    bl10 = true;
                    n6 |= 4;
                    break;
                }
                nArray5[n21] = nArray4[n22];
            }
            for (n22 = 0; !bl10 && n22 < nArray5.length; ++n22) {
                if (nArray5[n22] != -1) continue;
                bl10 = true;
                n6 |= 8;
            }
            if (this.Save1stFrameOfGop) {
                Common.getMpvDecoderClass().decodeArray(byArray, false, this.Preview_AllGops, this.Preview_fastDecode);
            }
            if ((double)l7 < (double)jobProcessing.getLastGopPts() - CommonParsing.getVideoFramerate() / 2.0) {
                Common.setMessage(Resource.getString("video.msg.error.pts.early", String.valueOf(nArray2[6] - 1), String.valueOf(jobProcessing.getLastGopPts())));
                bl10 = true;
                n6 |= 0x10;
            }
            if (this.TrimPts && l7 < jobProcessing.getEndPtsOfGop() && (double)(jobProcessing.getEndPtsOfGop() - l7) < CommonParsing.getVideoFramerate() / 2.0) {
                if (this.Debug) {
                    System.out.println("videostart trimmed to o8 " + jobProcessing.getEndPtsOfGop() + " /sp " + l7);
                }
                l7 = jobProcessing.getEndPtsOfGop();
            }
            if (n5 != n4 || Math.abs(l - l7) > 2000L) {
                bl10 = true;
                n6 |= 0x20;
            }
            if (jobProcessing.getSourceVideoFrameNumber() > 0 && this.IgnoreErrors) {
                l = l7;
                n5 = n4;
                bl10 = false;
            }
            if (Integer.parseInt(objectArray[0]) <= 720 && byArray.length > 2750000) {
                bl10 = true;
                n6 |= 0x40;
            }
            jobProcessing.setLastSimplifiedPts(l7 + (long)((double)n12 * CommonParsing.getVideoFramerate()) + (long)((double)(n5 - n12 + 1) * CommonParsing.getVideoFramerate()));
            if (bl10) {
                jobProcessing.setExportedVideoFrameNumber(n14);
                nArray2[4] = nArray2[4] + 1;
                this.messageDropError(byArray, byArray2, n5, n4, nArray2[6], jobProcessing.getExportedVideoFrameNumber(), l7, l, string, n6);
            } else {
                arrayList4.clear();
                jobProcessing.countLastGopTimecode((long)(CommonParsing.getVideoFramerate() * (double)(n5 + 1)));
                jobProcessing.setLastGopPts(l7 + (long)(CommonParsing.getVideoFramerate() * (double)(n5 + 1)));
                switch (this.CutMode) {
                    case 0: {
                        l8 = jobProcessing.getCutByteposition();
                        break;
                    }
                    case 1: {
                        l8 = nArray2[6];
                        break;
                    }
                    case 2: {
                        l8 = jobProcessing.getSourceVideoFrameNumber();
                        break;
                    }
                    case 3: {
                        l8 = l7 + 1000L;
                        break;
                    }
                    case 4: {
                        l8 = l7 - jobProcessing.get1stVideoPTS();
                    }
                }
                if (!CommonParsing.makecut(jobProcessing, string, l7, l8, arrayList4, n14, list, nArray2[6] - 1, jobProcessing.getCellTimes())) {
                    jobProcessing.setExportedVideoFrameNumber(n14);
                } else if (this.OptionDAR && this.ExportDAR != nArray2[7]) {
                    jobProcessing.setExportedVideoFrameNumber(n14);
                } else if (this.OptionHorizontalResolution && !this.ExportHorizontalResolution.equals(objectArray[0])) {
                    jobProcessing.setExportedVideoFrameNumber(n14);
                } else if (bl) {
                    int n43;
                    jobProcessing.setEndPtsOfGop((l7 += (long)((double)n12 * CommonParsing.getVideoFramerate())) + (long)((double)(n5 - n12 + 1) * CommonParsing.getVideoFramerate()));
                    dataOutputStream.writeLong(l7);
                    dataOutputStream.writeLong(jobProcessing.getEndPtsOfGop());
                    dataOutputStream.writeLong(l4);
                    dataOutputStream.writeLong(jobProcessing.countVideoExportTime((long)((double)(n5 - n12 + 1) * CommonParsing.getVideoFramerate())));
                    double d = CommonParsing.getVideoFramerate() * (double)(n5 - n12 + 1);
                    if (d <= 0.0) {
                        d = CommonParsing.getVideoFramerate() * 10.0;
                    }
                    int n44 = (int)((double)(90000L * (long)(byArray.length * 8)) / d / 400.0);
                    if (jobProcessing.hasSequenceHeader()) {
                        if (this.ChangeBitrateInAllSequences == 2 && n13 < 65535) {
                            n44 = (int)(90000L * this.VbvBuffer_Value / (long)n13 / 400L);
                        }
                        if (this.ChangeAspectRatio > 0) {
                            byArray[7] = (byte)(0xF & byArray[7] | this.ChangeAspectRatio << 4);
                        }
                        if (this.ChangeVbvBuffer > 0) {
                            byArray[10] = (byte)(0xE0 & byArray[10] | 3);
                            byArray[11] = (byte)(7 & byArray[11] | 0x80);
                        }
                    }
                    if (n44 < jobProcessing.getMinBitrate()) {
                        jobProcessing.setMinBitrate(n44);
                    }
                    if (n44 > jobProcessing.getMaxBitrate()) {
                        jobProcessing.setMaxBitrate(n44);
                    }
                    if (jobProcessing.hasSequenceHeader()) {
                        if (this.ChangeBitrateInAllSequences > 0) {
                            n20 = (this.ChangeBitrateInAllSequences - 3) * 2500 * 3;
                            if (n20 > 0) {
                                n44 = n20;
                            }
                            int n45 = n44;
                            if (this.ChangeBitrateInAllSequences == 3) {
                                n45 = 262143;
                            }
                            byArray[8] = (byte)(n45 >>> 10);
                            byArray[9] = (byte)(0xFF & n45 >> 2);
                            byArray[10] = (byte)(0x3F & byArray[10] | (3 & n45) << 6);
                            nArray2[2] = nArray2[2] + 1;
                        } else {
                            nArray2[3] = nArray2[3] + 1;
                        }
                    }
                    byteArrayOutputStream2.flush();
                    byte[] byArray4 = byteArrayOutputStream2.toByteArray();
                    int n46 = 0;
                    int n47 = Short.MAX_VALUE & nArray2[9] >>> 15;
                    int n48 = Short.MAX_VALUE & nArray2[9];
                    int n49 = nArray2[9] >>> 30;
                    for (n43 = 1; n43 < byArray4.length; ++n43) {
                        n46 += 2;
                        n49 |= (0x80 & byArray4[n43]) != 0 ? 2 : 1;
                    }
                    if (n46 < n47 || n47 == 0) {
                        n47 = n46;
                    }
                    if (n46 > n48 || n48 == 0) {
                        n48 = n46;
                    }
                    nArray2[9] = n49 << 30 | (Short.MAX_VALUE & n47) << 15 | Short.MAX_VALUE & n48;
                    Common.getGuiInterface().updateBitrateMonitor(n44, byArray4, Common.formatTime_1((jobProcessing.getVideoExportTimeSummary() + jobProcessing.getVideoExportTime()) / 90L).substring(0, 8));
                    if (jobProcessing.isNewVideoStream() && arrayList3.size() > 0) {
                        jobProcessing.getChapters().addChapter(string2, string3);
                    }
                    for (n43 = 0; n43 < arrayList3.size(); ++n43) {
                        Common.setMessage(arrayList3.get(n43).toString());
                        jobProcessing.setNewVideoStream(false);
                    }
                    if (bl7 && (this.CreateD2vIndex || this.SplitProjectFile)) {
                        jobProcessing.getProjectFileD2V().FrameRate(by);
                        bl7 = false;
                    }
                    jobProcessing.getProjectFileD2V().addGOP(jobProcessing.getProjectFileExportLength(), n3);
                    if (bl9 && this.InsertEndcode) {
                        if (this.WriteVideo) {
                            iDDBufferedOutputStream.write(Video.getSequenceEndCode());
                            jobProcessing.countMediaFilesExportLength(4L);
                            jobProcessing.countAllMediaFilesExportLength(4L);
                            jobProcessing.countProjectFileExportLength(4L);
                        }
                        jobProcessing.addCellTime(String.valueOf(jobProcessing.getExportedVideoFrameNumber()));
                        Common.setMessage("-> save ChapterFrameIndex: " + jobProcessing.getExportedVideoFrameNumber());
                    }
                    if (this.WriteVideo) {
                        if (bl8 && this.AddSequenceDisplayExension && !bl13 && jobProcessing.hasSequenceHeader()) {
                            n43 = n16 != -1 ? n16 : this.headerrescue.length;
                            iDDBufferedOutputStream.write(byArray, 0, n43);
                            iDDBufferedOutputStream.write(Video.setSequenceDisplayExtension(this.SDE_Value, (String[])objectArray));
                            iDDBufferedOutputStream.write(byArray, n43, byArray.length - n43);
                            jobProcessing.countMediaFilesExportLength(12L);
                            jobProcessing.countAllMediaFilesExportLength(12L);
                            jobProcessing.countProjectFileExportLength(12L);
                        } else {
                            iDDBufferedOutputStream.write(byArray);
                        }
                        jobProcessing.countMediaFilesExportLength(byArray.length);
                        bl14 = true;
                    }
                    if (list2.indexOf(String.valueOf(l8)) >= 0) {
                        jobProcessing.addCellTime(String.valueOf(jobProcessing.getExportedVideoFrameNumber()));
                        Common.setMessage("-> save ChapterFrameIndex: " + jobProcessing.getExportedVideoFrameNumber());
                    }
                    jobProcessing.countProjectFileExportLength(byArray.length);
                    jobProcessing.countAllMediaFilesExportLength(byArray.length);
                }
                Common.getGuiInterface().showExportStatus(bl14 ? Resource.getString("audio.status.write") : Resource.getString("audio.status.pause"));
            }
            arrayList3.clear();
            jobProcessing.setSequenceHeader(false);
            byteArrayOutputStream.close();
            byteArrayOutputStream2.close();
            byArray = null;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }
}

