/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.io;

public class BitWalker {
    private final int USER_DATA_START_CODE = 434;
    private final int EXTENSION_START_CODE = 437;
    private final int PICTURE_CODING_EXTENSION_ID = 8;
    public static final int FRAME_PICTURE = 3;
    private int BitPos = 0;
    private int BufferPos = 0;
    private long StartPos = 0L;
    private byte[] buf = new byte[0];

    public BitWalker() {
    }

    public BitWalker(byte[] byArray, int n) {
        this.setBuf(byArray, n);
    }

    public void resetCounters() {
        this.BufferPos = (int)this.StartPos;
        this.BitPos = this.BufferPos << 3;
    }

    public void setStartPos(int n) {
        this.StartPos = n;
        this.resetCounters();
    }

    public void setBuf(byte[] byArray, int n) {
        this.buf = byArray;
        this.setStartPos(n);
    }

    private void skipBits(int n) {
        this.BitPos += n;
        this.BufferPos = this.BitPos >>> 3;
    }

    private void Flush_Bits(int n) {
        this.skipBits(n);
    }

    private int showBits(int n) {
        int n2 = this.BitPos >>> 3;
        int n3 = (0xFF & this.buf[n2]) << 24 | (0xFF & this.buf[n2 + 1]) << 16 | (0xFF & this.buf[n2 + 2]) << 8 | 0xFF & this.buf[n2 + 3];
        n3 <<= this.BitPos & 7;
        return n3 >>>= 32 - n;
    }

    private int Show_Bits(int n) {
        return this.showBits(n);
    }

    private int popBits(int n) {
        int n2 = this.showBits(n);
        this.BitPos += n;
        this.BufferPos = this.BitPos >>> 3;
        return n2;
    }

    private int Get_Bits(int n) {
        return this.popBits(n);
    }

    private void next_start_code() {
        this.skipBits(8 - (this.BitPos & 7) & 7);
        while (this.showBits(24) != 1) {
            this.skipBits(8);
        }
    }

    private void user_data() {
        this.skipBits(32);
        while (this.popBits(24) != 1) {
            this.skipBits(8);
        }
    }

    private int search_picture_structure() {
        this.skipBits(18);
        int n = this.popBits(2);
        this.skipBits(8);
        int n2 = this.popBits(1);
        if (n2 == 1) {
            return 3;
        }
        return n;
    }

    private int find_picture_structure() {
        int n;
        this.next_start_code();
        while ((n = this.showBits(32)) == 437 || n == 434) {
            if (n == 437) {
                this.skipBits(32);
                int n2 = this.popBits(4);
                switch (n2) {
                    case 8: {
                        return this.search_picture_structure();
                    }
                }
            } else {
                this.user_data();
            }
            this.next_start_code();
        }
        return 3;
    }

    public int getPictureStructure(boolean bl) {
        int n = 3;
        try {
            this.resetCounters();
            n = this.find_picture_structure();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }
}

