/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.BitrateMonitor;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.parser.CommonParsing;

public class ProcessWindow
extends JFrame {
    private String title = Resource.getString("ProcessWindow.Title");
    private JLabel ttxheaderLabel;
    private JLabel ttxvpsLabel;
    private JLabel OffsetLabel;
    private JLabel StatusLabel;
    private JTextArea TextArea;
    private JViewport viewport;
    private JComboBox extractComboBox;
    private JProgressBar Progressbar;
    private String SplitPart;
    private BitrateMonitor Monitor;
    private CheckBoxListener _CheckBoxListener = new CheckBoxListener();
    ActionListener _BoxListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            Common.getSettings().setBooleanProperty(string, jCheckBoxMenuItem.getState());
        }
    };

    public ProcessWindow() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProcessWindow.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.setBounds(200, 100, 740, 480);
        this.buildMenu();
        jPanel.add((Component)this.buildHeadPanel(), "North");
        jPanel.add((Component)this.buildLogWindowPanel(), "Center");
        jPanel.add((Component)this.buildProgressPanel(), "South");
        this.getContentPane().add(jPanel);
        this.setTitle(this.title);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    public void close() {
        this.focusToText();
        this.dispose();
    }

    public void iconify() {
        this.focusToText();
        this.setState(1);
    }

    private void focusToText() {
        this.TextArea.requestFocus();
    }

    private void saveLog() {
        String string = CommonGui.getUserInput(this, "save log", "save logfile", Common.getSettings().getProperty(Keys.KEY_OutputDirectory) + System.getProperty("file.separator") + "pjx_log.txt");
        if (string != null && string.length() > 0) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
                printWriter.print(this.getLogContent());
                printWriter.close();
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
        this.toFront();
    }

    private String getLogContent() {
        return this.TextArea.getText();
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildEditMenu());
        jMenuBar.add(this.buildMessageMenu());
        jMenuBar.add(this.buildPreferencesMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        JMenuItem jMenuItem;
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        String[][] stringArrayArray = new String[][]{Keys.KEY_DebugLog, Keys.KEY_NormalLog};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            jMenuItem = new JCheckBoxMenuItem(Resource.getString(stringArrayArray[i][0]));
            jMenuItem.setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jMenuItem.setActionCommand(stringArrayArray[i][0]);
            ((JCheckBoxMenuItem)jMenuItem).setState(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jMenuItem.addActionListener(this._BoxListener);
            jMenu.add(jMenuItem);
        }
        jMenu.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Resource.getString(Keys.KEY_closeOnEnd[0]));
        jCheckBoxMenuItem.setToolTipText(Resource.getString(Keys.KEY_closeOnEnd[0]) + ".Tip");
        jCheckBoxMenuItem.setActionCommand(Keys.KEY_closeOnEnd[0]);
        jCheckBoxMenuItem.setState(Common.getSettings().getBooleanProperty(Keys.KEY_closeOnEnd));
        jCheckBoxMenuItem.addActionListener(this._BoxListener);
        jMenu.add(jCheckBoxMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.SaveAs");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessWindow.this.saveLog();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem();
        CommonGui.localize(jMenuItem2, "Common.Close");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcessWindow.this.close();
            }
        });
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Edit");
        String[][] stringArrayArray = new String[][]{Keys.KEY_minimizeMainFrame, Keys.KEY_hideProcessWindow, Keys.KEY_showSubpictureWindow, Keys.KEY_useAllCollections, Keys.KEY_ExportPanel_createSubDirNumber, Keys.KEY_ExportPanel_createSubDirName, Keys.KEY_enablePostProcessing, Keys.KEY_simpleMPG, Keys.KEY_enhancedPES, Keys.KEY_useAutoPidFilter};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxMenuItem.setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxMenuItem.setActionCommand(stringArrayArray[i][0]);
            jCheckBoxMenuItem.setState(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxMenuItem.addActionListener(this._BoxListener);
            if (i == 3 || i == 4 || i == 6 || i == 7) {
                jMenu.addSeparator();
            }
            jMenu.add(jCheckBoxMenuItem);
        }
        return jMenu;
    }

    protected JMenu buildMessageMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Messages");
        String[][] stringArrayArray = new String[][]{Keys.KEY_MessagePanel_Msg1, Keys.KEY_MessagePanel_Msg2, Keys.KEY_MessagePanel_Msg3, Keys.KEY_MessagePanel_Msg8, Keys.KEY_MessagePanel_Msg5, Keys.KEY_MessagePanel_Msg6, Keys.KEY_MessagePanel_Msg7, Keys.KEY_MessagePanel_Msg4};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxMenuItem.setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxMenuItem.setActionCommand(stringArrayArray[i][0]);
            jCheckBoxMenuItem.setState(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxMenuItem.addActionListener(this._BoxListener);
            if (i == 3 || i == 4 || i == 7) {
                jMenu.addSeparator();
            }
            jMenu.add(jCheckBoxMenuItem);
        }
        return jMenu;
    }

    protected JMenu buildPreferencesMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Preferences");
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        CommonGui.localize(jMenuItem, "Common.Preferences");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.getGuiInterface().showPreSettings();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JPanel buildHeadPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buildProcessPanel(), "North");
        jPanel.add((Component)this.buildActionPanel(), "South");
        return jPanel;
    }

    protected JPanel buildProcessPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("MainPanel.Process")));
        JButton jButton = new JButton(CommonGui.loadIcon("start.gif"));
        jButton.setMnemonic('s');
        jButton.setMaximumSize(new Dimension(60, 36));
        jButton.setPreferredSize(new Dimension(60, 36));
        jButton.setToolTipText(Resource.getString("button.go.Tip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!Common.isRunningProcess()) {
                    if (Common.isCollectionListEmpty()) {
                        return;
                    }
                    Common.setRunningProcess(true);
                    ProcessWindow.this.extractComboBox.removeAllItems();
                    CommonParsing.setPvaPidToExtract(-1);
                    Common.startMainProcess();
                } else {
                    if (!CommonParsing.isProcessPausing()) {
                        Common.setMessage(Resource.getString("golistener.msg.paused"), true, 0xFFFFE0);
                    } else {
                        Common.setMessage(Resource.getString("golistener.msg.resumed"), true, 0xFFFFFF);
                    }
                    CommonParsing.setProcessPausing(!CommonParsing.isProcessPausing());
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(4, 1)));
        JButton jButton2 = new JButton(CommonGui.loadIcon("stop.gif"));
        jButton2.setMnemonic('c');
        jButton2.setMaximumSize(new Dimension(36, 36));
        jButton2.setPreferredSize(new Dimension(36, 36));
        jButton2.setToolTipText(Resource.getString("button.c.Tip"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.breakMainProcess();
            }
        });
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        JButton jButton3 = new JButton(CommonGui.loadIcon("scan.gif"));
        jButton3.setMnemonic('i');
        jButton3.setMaximumSize(new Dimension(36, 36));
        jButton3.setPreferredSize(new Dimension(36, 36));
        jButton3.setToolTipText(Resource.getString("button.i.Tip"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!Common.startProcess()) {
                    return;
                }
                ProcessWindow.this.extractComboBox.removeAllItems();
                CommonParsing.setInfoScan(true);
                Common.startMainProcess();
            }
        });
        jPanel.add(jButton3);
        jPanel.add(Box.createRigidArea(new Dimension(4, 1)));
        JButton jButton4 = new JButton(CommonGui.loadIcon("extract.gif"));
        jButton4.setMnemonic('e');
        jButton4.setMaximumSize(new Dimension(36, 36));
        jButton4.setPreferredSize(new Dimension(36, 36));
        jButton4.setToolTipText(Resource.getString("button.e.Tip"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Common.isRunningProcess()) {
                    return;
                }
                if (ProcessWindow.this.extractComboBox.getItemCount() == 0) {
                    return;
                }
                Common.setRunningProcess(true);
                CommonParsing.setPvaPidExtraction(true);
                CommonParsing.setPvaPidToExtract(Integer.parseInt(ProcessWindow.this.extractComboBox.getSelectedItem().toString(), 16));
                Common.setMessage(Resource.getString("golistener.msg.extracting") + ProcessWindow.this.extractComboBox.getSelectedItem().toString() + "...");
                Common.startMainProcess();
            }
        });
        jPanel.add(jButton4);
        jPanel.add(Box.createRigidArea(new Dimension(4, 1)));
        this.extractComboBox = new JComboBox();
        this.extractComboBox.setMaximumSize(new Dimension(44, 26));
        this.extractComboBox.setPreferredSize(new Dimension(44, 26));
        this.extractComboBox.setMaximumRowCount(5);
        jPanel.add(this.extractComboBox);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.add(this.buildStatusPanel());
        return jPanel;
    }

    protected JPanel buildStatusPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.Monitor = new BitrateMonitor();
        this.Monitor.setToolTipText(Resource.getString("MainPanel.BitrateMonitor.Tip"));
        jPanel.add(this.Monitor);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.add(this.Monitor);
        jPanel2.setPreferredSize(new Dimension(114, 36));
        jPanel2.setMaximumSize(new Dimension(114, 36));
        jPanel.add(jPanel2);
        final JLabel jLabel = new JLabel();
        final JLabel jLabel2 = new JLabel();
        final JLabel jLabel3 = new JLabel();
        final JLabel jLabel4 = new JLabel();
        jLabel4.setToolTipText(Resource.getString("MainPanel.writtenMB.Tip"));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel3.setPreferredSize(new Dimension(100, 18));
        jPanel3.setMaximumSize(new Dimension(100, 18));
        jPanel3.setBackground(new Color(225, 225, 250));
        jPanel3.add(jLabel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel4.setPreferredSize(new Dimension(100, 18));
        jPanel4.setMaximumSize(new Dimension(100, 18));
        jPanel4.add(jLabel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel6.setPreferredSize(new Dimension(100, 18));
        jPanel6.setMaximumSize(new Dimension(100, 18));
        jPanel6.add(jLabel);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel7.setPreferredSize(new Dimension(100, 18));
        jPanel7.setMaximumSize(new Dimension(100, 18));
        jPanel7.add(jLabel3);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(jPanel6);
        jPanel8.add(jPanel7);
        jPanel.add(jPanel8);
        this.OffsetLabel = new JLabel(Resource.getString("MainPanel.AudioVideoOffset"));
        this.OffsetLabel.setToolTipText(Resource.getString("MainPanel.AudioVideoOffset.Tip"));
        this.StatusLabel = new JLabel(Resource.getString("MainPanel.nonVideoExportStatus"));
        this.StatusLabel.setToolTipText(Resource.getString("MainPanel.nonVideoExportStatus.Tip"));
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel9.setPreferredSize(new Dimension(100, 18));
        jPanel9.setMaximumSize(new Dimension(100, 18));
        jPanel9.add(this.OffsetLabel);
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel10.setPreferredSize(new Dimension(100, 18));
        jPanel10.setMaximumSize(new Dimension(100, 18));
        jPanel10.add(this.StatusLabel);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        jPanel11.add(jPanel9);
        jPanel11.add(jPanel10);
        jPanel.add(jPanel11);
        final JLabel jLabel5 = new JLabel();
        jLabel5.setToolTipText("process time elapsed");
        final JLabel jLabel6 = new JLabel();
        jLabel6.setToolTipText("warnings/error counter");
        JPanel jPanel12 = new JPanel(new BorderLayout());
        jPanel12.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel12.setPreferredSize(new Dimension(60, 18));
        jPanel12.setMaximumSize(new Dimension(60, 18));
        jPanel12.add(jLabel5);
        JPanel jPanel13 = new JPanel(new BorderLayout());
        jPanel13.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel13.setPreferredSize(new Dimension(60, 18));
        jPanel13.setMaximumSize(new Dimension(60, 18));
        jPanel13.add(jLabel6);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BoxLayout(jPanel14, 1));
        jPanel14.add(jPanel12);
        jPanel14.add(jPanel13);
        jPanel.add(jPanel14);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Clock
        implements Runnable {
            private Thread clockThread = null;
            private String last_value = "";
            private String last_exp = "";
            private String last_fps = "";
            private int last_coll = 0;

            Clock() {
            }

            public void start() {
                if (this.clockThread == null) {
                    this.clockThread = new Thread((Runnable)this, "Clock_2");
                    this.clockThread.setPriority(1);
                    this.clockThread.start();
                }
            }

            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                while (this.clockThread == thread) {
                    this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            private void update() {
                this.updateFpsLabel();
                this.updateDataTroughputLabel();
                this.updateExportedSizeLabel();
                this.updateCollectionLabel();
                this.updateTimeLabel();
            }

            private void updateFpsLabel() {
                String string = Common.getFps();
                if (!this.last_fps.equals(string)) {
                    jLabel3.setText(string + " fps");
                }
                this.last_fps = string;
            }

            private void updateDataTroughputLabel() {
                String string = Common.getDataTroughput();
                if (!this.last_value.equals(string)) {
                    jLabel.setText(string + " kB/s");
                }
                this.last_value = string;
            }

            private void updateExportedSizeLabel() {
                String string = Common.getExportedSize();
                if (!this.last_exp.equals(string)) {
                    jLabel4.setText(string);
                }
                this.last_exp = string;
            }

            private void updateCollectionLabel() {
                int n;
                int n2 = n = Common.isRunningProcess() ? Common.getProcessedCollection() : Common.getActiveCollection();
                if (this.last_coll != n) {
                    jLabel2.setText("Collection: " + (n < 0 ? "-" : String.valueOf(n)));
                }
                this.last_coll = n;
            }

            private void updateTimeLabel() {
                jLabel5.setText(Common.formatTime_4(Common.getProcessTime()));
                jLabel6.setText(String.valueOf(Common.getErrorCount()));
            }

            public void stop() {
                this.clockThread = null;
            }
        }
        new Clock().start();
        return jPanel;
    }

    protected JPanel buildActionPanel() {
        final Object[] objectArray = Keys.ITEMS_ConversionMode;
        int n = Common.getSettings().getIntProperty(Keys.KEY_ConversionMode);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                String string = jRadioButton.getActionCommand();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!string.equals(objectArray[i].toString())) continue;
                    Common.getSettings().setProperty(Keys.KEY_ConversionMode[0], String.valueOf(i));
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(new JLabel(Resource.getString("ProcessWindowPanel.Action")));
        jPanel.setToolTipText(Resource.getString("MainPanel.Process.Tip"));
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < objectArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton(objectArray[i].toString());
            jRadioButton.setActionCommand(objectArray[i].toString());
            jRadioButton.setSelected(i == n);
            jRadioButton.addActionListener(actionListener);
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
        }
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        JCheckBox jCheckBox = new JCheckBox(Resource.getString(Keys.KEY_ConversionModePriority[0]));
        jCheckBox.setToolTipText(Resource.getString(Keys.KEY_ConversionModePriority[0] + ".Tip"));
        jCheckBox.setActionCommand(Keys.KEY_ConversionModePriority[0]);
        jCheckBox.setSelected(Common.getSettings().getBooleanProperty(Keys.KEY_ConversionModePriority));
        jCheckBox.addActionListener(this._CheckBoxListener);
        jPanel.add(jCheckBox);
        return jPanel;
    }

    protected JPanel buildLogWindowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JLabel jLabel = new JLabel(CommonGui.loadIcon("_teletext.gif"));
        jPanel3.add(jLabel);
        jPanel3.add(Box.createRigidArea(new Dimension(4, 1)));
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText(Resource.getString(Keys.KEY_showTtxHeader[0] + ".Tip"));
        jCheckBox.setActionCommand(Keys.KEY_showTtxHeader[0]);
        jCheckBox.setSelected(Common.getSettings().getBooleanProperty(Keys.KEY_showTtxHeader));
        jCheckBox.addActionListener(this._CheckBoxListener);
        jPanel3.add(jCheckBox);
        jPanel2.add((Component)jPanel3, "West");
        this.ttxheaderLabel = new JLabel("");
        this.ttxheaderLabel.setToolTipText(Resource.getString("LogwindowPanel.showTtxHeader.Tip1"));
        jPanel2.add((Component)this.ttxheaderLabel, "Center");
        this.ttxvpsLabel = new JLabel("");
        this.ttxvpsLabel.setToolTipText(Resource.getString("LogwindowPanel.showVpsLabel.Tip"));
        jPanel2.add((Component)this.ttxvpsLabel, "East");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 1));
        jPanel4.add(jPanel2);
        this.TextArea = new JTextArea();
        this.TextArea.setEditable(true);
        this.TextArea.setRows(16);
        this.TextArea.setTabSize(12);
        this.TextArea.setFont(new Font("Tahoma", 0, 12));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.TextArea);
        this.viewport = jScrollPane.getViewport();
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("ProcessWindowPanel.Title")));
        jPanel5.setAlignmentX(0.5f);
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jScrollPane, "Center");
        jPanel.add(jPanel5);
        return jPanel;
    }

    protected JPanel buildProgressPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.Progressbar = new JProgressBar();
        this.Progressbar.setString(Resource.getString("run.status"));
        this.Progressbar.setStringPainted(true);
        this.Progressbar.addChangeListener(new ChangeListener(){
            int _val = 0;

            public void stateChanged(ChangeEvent changeEvent) {
                if (!Common.isRunningCLI()) {
                    Common.setFrameTitle("" + (int)(ProcessWindow.this.Progressbar.getPercentComplete() * 100.0) + "% (" + Common.getProcessedCollection() + ") " + Common.getVersionName() + "/" + Common.getVersionDate());
                }
            }
        });
        jPanel.add(this.Progressbar);
        return jPanel;
    }

    public void setMessage(String string, boolean bl, int n) {
        if (n != -1) {
            this.TextArea.setBackground(new Color(n));
        }
        if (bl) {
            this.show();
        }
        if (string == null) {
            this.TextArea.setText(null);
            return;
        }
        this.TextArea.append(Common.getLineSeparator() + string);
        this.viewport.setViewPosition(new Point(0, this.TextArea.getHeight()));
    }

    public void updateTtxHeader(String string) {
        this.ttxheaderLabel.setText(string);
    }

    public void updateVpsLabel(String string) {
        this.ttxvpsLabel.setText(string);
    }

    public void addPidToExtract(Object object) {
        this.extractComboBox.addItem(object);
    }

    public void showExportStatus(String string) {
        this.StatusLabel.setText(string);
    }

    public void showExportStatus(String string, int n) {
        this.StatusLabel.setText(string + " " + n);
    }

    public void showAVOffset(String string) {
        this.OffsetLabel.setText(string);
    }

    public void resetBitrateMonitor() {
        this.Monitor.reset();
    }

    public void updateBitrateMonitor(int n, byte[] byArray, String string) {
        this.Monitor.update(n, byArray, string);
    }

    public void updateProgressBar(int n) {
        this.Progressbar.setValue(n);
    }

    public void updateProgressBar(String string) {
        this.Progressbar.setString(string);
        this.Progressbar.setStringPainted(true);
    }
}

