/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxItemListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.TextFieldKeyListener;
import net.sourceforge.dvb.projectx.gui.TextFieldListener;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;

public class PreSettings
extends JFrame {
    private String title = Resource.getString("PreferencesPanel.Title");
    private final Color head_color = new Color(224, 224, 224);
    private ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    private ComboBoxItemListener _ComboBoxItemListener = new ComboBoxItemListener();
    private CheckBoxListener _CheckBoxListener = new CheckBoxListener();
    private TextFieldListener _TextFieldListener = new TextFieldListener();
    private TextFieldKeyListener _TextFieldKeyListener = new TextFieldKeyListener();

    public PreSettings() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreSettings.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.buildMenu();
        jPanel.add(this.buildTabPanel());
        this.getContentPane().add(jPanel);
        this.setTitle(this.title);
        this.setBounds(200, 100, 720, 400);
        this.setResizable(false);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    public void close() {
        this.dispose();
    }

    public void savePreferences() {
        String string = CommonGui.getUserInput(this, "save ini", "save inifile", Common.getSettings().getInifile());
        if (string != null && string.length() > 0) {
            Common.saveSettings(string);
        }
        this.toFront();
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.SaveAs");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreSettings.this.savePreferences();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem();
        CommonGui.localize(jMenuItem2, "Common.Close");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreSettings.this.close();
            }
        });
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected JPanel buildTabPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        JTabbedPane jTabbedPane = new JTabbedPane(2);
        jTabbedPane.addTab(Resource.getString("TabPanel.OptionPanel"), this.buildOptionPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.ExportPanel"), this.buildExportPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.SpecialPanel"), this.buildSpecialPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.VideoPanel"), this.buildVideoPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.AudioPanel"), this.buildAudioPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.SubtitlePanel"), this.buildSubtitlePanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.ExternPanel"), this.buildExternPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.NetPanel"), this.buildNetPanel());
        jTabbedPane.addTab(Resource.getString("TabPanel.PostCommandsPanel"), this.buildPostCommandsPanel());
        jTabbedPane.setSelectedIndex(0);
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    protected JPanel buildHeadPanel(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(this.head_color);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.add(new JLabel(" " + string));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "North");
        return jPanel3;
    }

    protected JPanel buildMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        return jPanel;
    }

    protected JPanel buildSpecialPanel() {
        JCheckBox jCheckBox;
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("SpecialPanel.Title1")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_PVA_FileOverlap, Keys.KEY_PVA_Audio, Keys.KEY_VOB_resetPts, Keys.KEY_TS_ignoreScrambled, Keys.KEY_TS_blindSearch, Keys.KEY_TS_joinPackets, Keys.KEY_TS_HumaxAdaption, Keys.KEY_TS_FinepassAdaption, Keys.KEY_TS_generatePmt, Keys.KEY_TS_generateTtx, Keys.KEY_TS_setMainAudioAc3};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            jComponent = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jComponent.setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jComponent.setPreferredSize(new Dimension(270, 20));
            jComponent.setMaximumSize(new Dimension(270, 20));
            ((AbstractButton)jComponent).setActionCommand(stringArrayArray[i][0]);
            ((AbstractButton)jComponent).setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            ((AbstractButton)jComponent).addActionListener(this._CheckBoxListener);
            if (i == 2 || i == 3) {
                jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
            }
            jPanel2.add(jComponent);
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_TsHeaderMode);
        jComboBox.setPreferredSize(new Dimension(270, 20));
        jComboBox.setMaximumSize(new Dimension(270, 20));
        jComboBox.setActionCommand(Keys.KEY_TsHeaderMode[0]);
        jComboBox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_TsHeaderMode));
        jComboBox.addActionListener(this._ComboBoxIndexListener);
        jPanel2.add(jComboBox);
        jPanel.add(jPanel2);
        jComponent = new JPanel();
        jComponent.setLayout(new ColumnLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder(Resource.getString("SpecialPanel.Title2")));
        JLabel jLabel = new JLabel(Resource.getString("SpecialPanel.PtsShift") + " ");
        jLabel.setToolTipText(Resource.getString("SpecialPanel.PtsShift.Tip"));
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_PtsShift);
        jComboBox2.setPreferredSize(new Dimension(60, 20));
        jComboBox2.setMaximumSize(new Dimension(60, 20));
        jComboBox2.setEditable(true);
        jComboBox2.setActionCommand(Keys.KEY_PtsShift_Value[0]);
        jComboBox2.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_PtsShift_Value));
        jComboBox2.addActionListener(this._ComboBoxItemListener);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jLabel);
        jPanel3.add(jComboBox2);
        jComponent.add(jPanel3);
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_Input_getEnclosedPackets, Keys.KEY_Input_concatenateForeignRecords, Keys.KEY_Audio_ignoreErrors, Keys.KEY_Audio_limitPts, Keys.KEY_Video_ignoreErrors, Keys.KEY_Video_trimPts};
        for (int i = 0; i < stringArrayArray2.length; ++i) {
            jCheckBox = new JCheckBox(Resource.getString(stringArrayArray2[i][0]));
            jCheckBox.setToolTipText(Resource.getString(stringArrayArray2[i][0] + ".Tip"));
            jCheckBox.setPreferredSize(new Dimension(270, 20));
            jCheckBox.setMaximumSize(new Dimension(270, 20));
            jCheckBox.setActionCommand(stringArrayArray2[i][0]);
            jCheckBox.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray2[i]));
            jCheckBox.addActionListener(this._CheckBoxListener);
            if (i == 2 || i == 4) {
                jComponent.add(Box.createRigidArea(new Dimension(1, 10)));
            }
            jComponent.add(jCheckBox);
        }
        jComponent.add(Box.createRigidArea(new Dimension(1, 10)));
        jComponent.add(new JLabel(Resource.getString("SpecialPanel.Conversion")));
        String[][] stringArrayArray3 = new String[][]{Keys.KEY_Conversion_startWithVideo};
        jCheckBox = new JCheckBox(Resource.getString(stringArrayArray3[0][0]));
        jCheckBox.setToolTipText(Resource.getString(stringArrayArray3[0][0] + ".Tip"));
        jCheckBox.setPreferredSize(new Dimension(270, 20));
        jCheckBox.setMaximumSize(new Dimension(270, 20));
        jCheckBox.setActionCommand(stringArrayArray3[0][0]);
        jCheckBox.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray3[0]));
        jCheckBox.addActionListener(this._CheckBoxListener);
        jComponent.add(jCheckBox);
        String[][] stringArrayArray4 = new String[][]{Keys.KEY_Conversion_addPcrToStream};
        JCheckBox jCheckBox2 = new JCheckBox(Resource.getString(stringArrayArray4[0][0]));
        jCheckBox2.setToolTipText(Resource.getString(stringArrayArray4[0][0] + ".Tip"));
        jCheckBox2.setPreferredSize(new Dimension(192, 20));
        jCheckBox2.setMaximumSize(new Dimension(192, 20));
        jCheckBox2.setActionCommand(stringArrayArray4[0][0]);
        jCheckBox2.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray4[0]));
        jCheckBox2.addActionListener(this._CheckBoxListener);
        String[][] stringArrayArray5 = new String[][]{Keys.KEY_Conversion_PcrCounter};
        JCheckBox jCheckBox3 = new JCheckBox(Resource.getString(stringArrayArray5[0][0]));
        jCheckBox3.setToolTipText(Resource.getString(stringArrayArray5[0][0] + ".Tip"));
        jCheckBox3.setPreferredSize(new Dimension(80, 20));
        jCheckBox3.setMaximumSize(new Dimension(80, 20));
        jCheckBox3.setActionCommand(stringArrayArray5[0][0]);
        jCheckBox3.setSelected(Common.getSettings().getBooleanProperty(stringArrayArray5[0]));
        jCheckBox3.addActionListener(this._CheckBoxListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jCheckBox2);
        jPanel4.add(jCheckBox3);
        jComponent.add(jPanel4);
        JComboBox<Object> jComboBox3 = new JComboBox<Object>(Keys.ITEMS_PcrDelta);
        jComboBox3.setPreferredSize(new Dimension(60, 20));
        jComboBox3.setMaximumSize(new Dimension(60, 20));
        jComboBox3.setEditable(true);
        jComboBox3.setActionCommand(Keys.KEY_PcrDelta_Value[0]);
        jComboBox3.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_PcrDelta_Value));
        jComboBox3.addActionListener(this._ComboBoxItemListener);
        jComponent.add(jComboBox3);
        jPanel.add(jComponent);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.SpecialPanel"));
    }

    protected JPanel buildExportPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.SplitPanel")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_SplitSize, Keys.KEY_Streamtype_MpgVideo, Keys.KEY_Streamtype_MpgAudio, Keys.KEY_Streamtype_Ac3Audio, Keys.KEY_Streamtype_PcmAudio, Keys.KEY_Streamtype_Teletext, Keys.KEY_Streamtype_Subpicture, Keys.KEY_Streamtype_Vbi, Keys.KEY_WriteOptions_writeVideo, Keys.KEY_WriteOptions_writeAudio, Keys.KEY_additionalOffset, Keys.KEY_ExportPanel_Export_Overlap};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (int i = 0; i < stringArrayArray.length; ++i) {
            jCheckBoxArray[i] = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxArray[i].setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxArray[i].setActionCommand(stringArrayArray[i][0]);
            jCheckBoxArray[i].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxArray[i].addActionListener(this._CheckBoxListener);
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_Export_SplitSize);
        jComboBox.setPreferredSize(new Dimension(100, 22));
        jComboBox.setMaximumSize(new Dimension(100, 22));
        jComboBox.setEditable(true);
        jComboBox.setActionCommand(Keys.KEY_ExportPanel_SplitSize_Value[0]);
        jComboBox.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_ExportPanel_SplitSize_Value));
        jComboBox.addActionListener(this._ComboBoxItemListener);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jCheckBoxArray[0]);
        jPanel3.add(jComboBox);
        jPanel2.add(jPanel3);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_Export_Overlap);
        jComboBox2.setPreferredSize(new Dimension(100, 22));
        jComboBox2.setMaximumSize(new Dimension(100, 22));
        jComboBox2.setActionCommand(Keys.KEY_ExportPanel_Overlap_Value[0]);
        jComboBox2.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_ExportPanel_Overlap_Value));
        jComboBox2.addActionListener(this._ComboBoxIndexListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jCheckBoxArray[11]);
        jPanel4.add(jComboBox2);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(new JLabel(Resource.getString("ExportPanel.WriteOptions.InfoScan")));
        JComboBox<Object> jComboBox3 = new JComboBox<Object>(Keys.ITEMS_Infoscan);
        jComboBox3.setPreferredSize(new Dimension(60, 22));
        jComboBox3.setMaximumSize(new Dimension(60, 22));
        jComboBox3.setEditable(true);
        jComboBox3.setActionCommand(Keys.KEY_ExportPanel_Infoscan_Value[0]);
        jComboBox3.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_ExportPanel_Infoscan_Value));
        jComboBox3.addActionListener(this._ComboBoxItemListener);
        jPanel5.add(jComboBox3);
        jPanel2.add(jPanel5);
        jPanel.add(jPanel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.StreamtypePanel")));
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setToolTipText(Resource.getString("ExportPanel.StreamtypePanel.Tip"));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new ColumnLayout());
        for (int i = 1; i < 5; ++i) {
            jPanel7.add(jCheckBoxArray[i]);
        }
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new ColumnLayout());
        for (int i = 5; i < 8; ++i) {
            jPanel8.add(jCheckBoxArray[i]);
        }
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel8);
        jPanel.add(jPanel6);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new ColumnLayout());
        jPanel9.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.WriteOptions")));
        jPanel9.setToolTipText(Resource.getString("ExportPanel.WriteOptions.Tip"));
        jPanel9.add(jCheckBoxArray[8]);
        jPanel9.add(jCheckBoxArray[9]);
        jPanel.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new ColumnLayout());
        jPanel10.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExportPanel.additionalOffset.Title")));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        jPanel11.add(jCheckBoxArray[10]);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_ExportPanel_additionalOffset_Value));
        jTextField.setPreferredSize(new Dimension(80, 22));
        jTextField.setMaximumSize(new Dimension(80, 22));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_ExportPanel_additionalOffset_Value[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_ExportPanel_additionalOffset_Value[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel11.add(jTextField);
        jPanel10.add(jPanel11);
        jPanel.add(jPanel10);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.ExportPanel"));
    }

    protected JPanel buildVideoPanel() {
        Object object;
        String[] stringArray;
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("VideoPanel.Title1")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_VideoPanel_addEndcode, Keys.KEY_VideoPanel_insertEndcode, Keys.KEY_VideoPanel_addSequenceHeader, Keys.KEY_VideoPanel_clearCDF, Keys.KEY_VideoPanel_patchToProgressive, Keys.KEY_VideoPanel_patchToInterlaced, Keys.KEY_VideoPanel_toggleFieldorder, Keys.KEY_VideoPanel_addSde};
        final JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (int i = 0; i < stringArrayArray.length; ++i) {
            jCheckBoxArray[i] = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxArray[i].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[i].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[i].setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxArray[i].setActionCommand(stringArrayArray[i][0]);
            jCheckBoxArray[i].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxArray[i].addActionListener(this._CheckBoxListener);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                String string = jCheckBox.getActionCommand();
                if (string.equals(Keys.KEY_VideoPanel_patchToProgressive[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[5].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_VideoPanel_patchToInterlaced[0], false);
                    return;
                }
                if (string.equals(Keys.KEY_VideoPanel_patchToInterlaced[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[4].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_VideoPanel_patchToProgressive[0], false);
                    return;
                }
            }
        };
        jCheckBoxArray[4].addActionListener(actionListener);
        jCheckBoxArray[5].addActionListener(actionListener);
        for (int i = 0; i < 7; ++i) {
            jPanel2.add(jCheckBoxArray[i]);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jCheckBoxArray[7].setPreferredSize(new Dimension(180, 20));
        jCheckBoxArray[7].setMaximumSize(new Dimension(180, 20));
        jPanel3.add(jCheckBoxArray[7]);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_VideoPanel_SdeValue));
        jTextField.setPreferredSize(new Dimension(80, 20));
        jTextField.setMaximumSize(new Dimension(80, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_VideoPanel_SdeValue[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_VideoPanel_SdeValue[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel3.add(jTextField);
        jPanel2.add(jPanel3);
        jPanel2.add(new JLabel(Resource.getString("VideoPanel.patchResolution")));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setToolTipText(Resource.getString("VideoPanel.patchResolution.Tip"));
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_ConditionalHorizontalPatch);
        jComboBox.setPreferredSize(new Dimension(160, 20));
        jComboBox.setMaximumSize(new Dimension(160, 20));
        jComboBox.setActionCommand(Keys.KEY_ConditionalHorizontalPatch[0]);
        jComboBox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_ConditionalHorizontalPatch));
        jComboBox.addActionListener(this._ComboBoxIndexListener);
        jPanel4.add(jComboBox);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_ExportHorizontalResolution);
        jComboBox2.setPreferredSize(new Dimension(50, 20));
        jComboBox2.setMaximumSize(new Dimension(50, 20));
        jComboBox2.setActionCommand(Keys.KEY_ConditionalHorizontalResolution[0]);
        jComboBox2.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_ConditionalHorizontalResolution));
        jComboBox2.addActionListener(this._ComboBoxItemListener);
        jPanel4.add(jComboBox2);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new ColumnLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(Resource.getString("VideoPanel.Title1")));
        String[] stringArray2 = new String[]{Resource.getString("VideoPanel.ChangeVbvBuffer"), Resource.getString("VideoPanel.ChangeVbvDelay"), Resource.getString("VideoPanel.ChangeAspectRatio")};
        Object[][] objectArrayArray = new Object[][]{Keys.ITEMS_ChangeVbvBuffer, Keys.ITEMS_ChangeVbvDelay, Keys.ITEMS_ChangeAspectRatio};
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_ChangeVbvBuffer, Keys.KEY_ChangeVbvDelay, Keys.KEY_ChangeAspectRatio};
        for (int i = 0; i < stringArrayArray2.length; ++i) {
            jComponent = new JLabel(stringArray2[i]);
            jComponent.setPreferredSize(new Dimension(120, 20));
            jComponent.setMaximumSize(new Dimension(120, 20));
            stringArray = new JComboBox(objectArrayArray[i]);
            stringArray.setPreferredSize(new Dimension(150, 20));
            stringArray.setMaximumSize(new Dimension(150, 20));
            stringArray.setActionCommand(stringArrayArray2[i][0]);
            stringArray.setSelectedIndex(Common.getSettings().getIntProperty(stringArrayArray2[i]));
            stringArray.addActionListener(this._ComboBoxIndexListener);
            object = new JPanel();
            ((Container)object).setLayout(new BoxLayout((Container)object, 0));
            ((JComponent)object).setToolTipText(stringArray2[i] + ".Tip");
            ((Container)object).add(jComponent);
            ((Container)object).add((Component)stringArray);
            jPanel2.add((Component)object);
        }
        jPanel.add(jPanel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(2, 1));
        jComponent = new JPanel();
        jComponent.setLayout(new ColumnLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder(Resource.getString("VideoPanel.Title2")));
        stringArray = new String[]{Resource.getString("VideoPanel.patchBitrateValue"), Resource.getString("VideoPanel.patch1stBitrateValue")};
        object = new Object[][]{Keys.ITEMS_BitrateInAllSequences, Keys.ITEMS_BitrateInFirstSequence};
        String[][] stringArrayArray3 = new String[][]{Keys.KEY_ChangeBitrateInAllSequences, Keys.KEY_ChangeBitrateInFirstSequence};
        for (int i = 0; i < stringArrayArray3.length; ++i) {
            JLabel jLabel = new JLabel(stringArray[i]);
            jLabel.setPreferredSize(new Dimension(270, 20));
            jLabel.setMaximumSize(new Dimension(270, 20));
            jLabel.setToolTipText(stringArray[i] + ".Tip");
            JComboBox jComboBox3 = new JComboBox((E[])object[i]);
            jComboBox3.setPreferredSize(new Dimension(270, 20));
            jComboBox3.setMaximumSize(new Dimension(270, 20));
            jComboBox3.setActionCommand(stringArrayArray3[i][0]);
            jComboBox3.setSelectedIndex(Common.getSettings().getIntProperty(stringArrayArray3[i]));
            jComboBox3.addActionListener(this._ComboBoxIndexListener);
            jComponent.add(jLabel);
            jComponent.add(jComboBox3);
        }
        jPanel6.add(jComponent);
        jPanel.add(jPanel6);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.VideoPanel"));
    }

    protected JPanel buildExternPanel() {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExternPanel.Title1")));
        jPanel2.setToolTipText(Resource.getString("ExternPanel.Title1.Tip"));
        String[][] stringArrayArray = new String[][]{Keys.KEY_ExternPanel_createVdrIndex, Keys.KEY_ExternPanel_createCellTimes, Keys.KEY_ExternPanel_exportPts, Keys.KEY_ExternPanel_createChapters, Keys.KEY_ExternPanel_renameAudio, Keys.KEY_ExternPanel_renameVideo, Keys.KEY_ExternPanel_appendExtension, Keys.KEY_ExternPanel_createM2sIndex, Keys.KEY_ExternPanel_createInfoIndex, Keys.KEY_ExternPanel_createD2vIndex, Keys.KEY_ExternPanel_createDgiIndex, Keys.KEY_ExternPanel_splitProjectFile};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (n = 0; n < stringArrayArray.length; ++n) {
            jCheckBoxArray[n] = new JCheckBox(Resource.getString(stringArrayArray[n][0]));
            jCheckBoxArray[n].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[n].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[n].setToolTipText(Resource.getString(stringArrayArray[n][0] + ".Tip"));
            jCheckBoxArray[n].setActionCommand(stringArrayArray[n][0]);
            jCheckBoxArray[n].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[n]));
            jCheckBoxArray[n].addActionListener(this._CheckBoxListener);
            if (n != 10) continue;
            jCheckBoxArray[n].setEnabled(false);
        }
        for (n = 0; n < 7; ++n) {
            jPanel2.add(jCheckBoxArray[n]);
        }
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Resource.getString("ExternPanel.Title2")));
        jPanel3.setToolTipText(Resource.getString("ExternPanel.Title2.Tip"));
        jPanel3.add(new JLabel(Resource.getString("ExternPanel.createM2sIndex")));
        jPanel3.add(jCheckBoxArray[7]);
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(new JLabel(Resource.getString("ExternPanel.createInfoLabel")));
        jPanel3.add(jCheckBoxArray[8]);
        jPanel3.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel3.add(new JLabel(Resource.getString("ExternPanel.createD2vIndex")));
        for (int i = 9; i < stringArrayArray.length; ++i) {
            jPanel3.add(jCheckBoxArray[i]);
        }
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_ExternPanel_ProjectFileSplitSize));
        jTextField.setPreferredSize(new Dimension(70, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_ExternPanel_ProjectFileSplitSize[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_ExternPanel_ProjectFileSplitSize[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("ExternPanel.ProjectFileSplitSize"));
        jPanel4.add(jLabel);
        jPanel4.add(jTextField);
        jPanel3.add(jPanel4);
        jPanel.add(jPanel3);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.ExternPanel"));
    }

    protected JPanel buildAudioPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("AudioPanel.Title1")));
        jPanel2.add(new JLabel(Resource.getString("AudioPanel.loslessMpaConversion.Tip1")));
        jPanel2.add(new JLabel(Resource.getString("AudioPanel.loslessMpaConversion.Tip2")));
        jPanel2.setToolTipText(Resource.getString("AudioPanel.loslessMpaConversion.Tip"));
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_loslessMpaConversionMode);
        jComboBox.setPreferredSize(new Dimension(270, 20));
        jComboBox.setMaximumSize(new Dimension(270, 20));
        jComboBox.setActionCommand(Keys.KEY_AudioPanel_loslessMpaConversionMode[0]);
        jComboBox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_AudioPanel_loslessMpaConversionMode));
        jComboBox.addActionListener(this._ComboBoxIndexListener);
        jPanel2.add(jComboBox);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 20)));
        String[][] stringArrayArray = new String[][]{Keys.KEY_AudioPanel_decodeMpgAudio, Keys.KEY_AudioPanel_Normalize, Keys.KEY_AudioPanel_Downmix, Keys.KEY_AudioPanel_fadeInOut, Keys.KEY_AudioPanel_changeByteorder, Keys.KEY_AudioPanel_addRiffHeader, Keys.KEY_AudioPanel_addAiffHeader, Keys.KEY_AudioPanel_validateCRC, Keys.KEY_AudioPanel_clearCRC, Keys.KEY_AudioPanel_fillGapsWithLastFrame, Keys.KEY_AudioPanel_addFrames, Keys.KEY_AudioPanel_patch1stAc3Header, Keys.KEY_AudioPanel_replaceAc3withSilence, Keys.KEY_AudioPanel_allowSpaces, Keys.KEY_AudioPanel_addRiffToMpgAudio, Keys.KEY_AudioPanel_addRiffToMpgAudioL3, Keys.KEY_AudioPanel_addRiffToAc3, Keys.KEY_AudioPanel_createDDWave};
        final JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (int i = 0; i < stringArrayArray.length; ++i) {
            jCheckBoxArray[i] = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxArray[i].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[i].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[i].setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxArray[i].setActionCommand(stringArrayArray[i][0]);
            jCheckBoxArray[i].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxArray[i].addActionListener(this._CheckBoxListener);
        }
        jPanel2.add(jCheckBoxArray[0]);
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_resampleAudioMode);
        jComboBox2.setPreferredSize(new Dimension(270, 20));
        jComboBox2.setMaximumSize(new Dimension(270, 20));
        jComboBox2.setActionCommand(Keys.KEY_AudioPanel_resampleAudioMode[0]);
        jComboBox2.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_AudioPanel_resampleAudioMode));
        jComboBox2.addActionListener(this._ComboBoxIndexListener);
        jPanel2.add(jComboBox2);
        final JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_AudioPanel_NormalizeValue));
        jTextField.setPreferredSize(new Dimension(50, 20));
        jTextField.setMaximumSize(new Dimension(50, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_AudioPanel_NormalizeValue[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_AudioPanel_NormalizeValue[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                if (string.length() == 0) {
                    jTextField.setText("98");
                    return;
                }
                try {
                    int n = Integer.parseInt(string);
                    if (n > 100 || n < 0) {
                        n = 98;
                    }
                    jTextField.setText("" + n);
                }
                catch (Exception exception) {
                    jTextField.setText("98");
                }
            }
        });
        jCheckBoxArray[1].setPreferredSize(new Dimension(180, 20));
        jCheckBoxArray[1].setMaximumSize(new Dimension(180, 20));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jCheckBoxArray[1]);
        jPanel3.add(jTextField);
        jPanel2.add(jPanel3);
        for (int i = 2; i < 7; ++i) {
            jPanel2.add(jCheckBoxArray[i]);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                String string = jCheckBox.getActionCommand();
                if (string.equals(Keys.KEY_AudioPanel_changeByteorder[0]) && Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader)) {
                    jCheckBoxArray[4].setSelected(true);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_changeByteorder[0], true);
                    return;
                }
                if (string.equals(Keys.KEY_AudioPanel_addRiffHeader[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[6].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addAiffHeader[0], false);
                    return;
                }
                if (string.equals(Keys.KEY_AudioPanel_addAiffHeader[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[4].setSelected(true);
                    jCheckBoxArray[5].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_changeByteorder[0], true);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addRiffHeader[0], false);
                    return;
                }
            }
        };
        jCheckBoxArray[4].addActionListener(actionListener);
        jCheckBoxArray[5].addActionListener(actionListener);
        jCheckBoxArray[6].addActionListener(actionListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Resource.getString("AudioPanel.Title2")));
        for (int i = 7; i < stringArrayArray.length; ++i) {
            if (i == 14 || i == 17) {
                jPanel4.add(Box.createRigidArea(new Dimension(1, 10)));
            }
            jPanel4.add(jCheckBoxArray[i]);
        }
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                String string = jCheckBox.getActionCommand();
                if (string.equals(Keys.KEY_AudioPanel_addRiffToMpgAudioL3[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[15].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudio[0], false);
                    return;
                }
                if (string.equals(Keys.KEY_AudioPanel_addRiffToMpgAudio[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[16].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_AudioPanel_addRiffToMpgAudioL3[0], false);
                    return;
                }
            }
        };
        jCheckBoxArray[15].addActionListener(actionListener2);
        jCheckBoxArray[16].addActionListener(actionListener2);
        jPanel.add(jPanel2);
        jPanel.add(jPanel4);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.AudioPanel"));
    }

    protected JPanel buildSubtitlePanel() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("SubtitlePanel.Title.Teletext")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_SubtitlePanel_decodeMegaradio, Keys.KEY_SubtitlePanel_decodeHiddenRows, Keys.KEY_SubtitlePanel_rebuildPTS, Keys.KEY_SubtitlePanel_keepOriginalTimecode, Keys.KEY_SubtitlePanel_exportTextAsUnicode, Keys.KEY_SubtitlePanel_exportTextAsUTF8, Keys.KEY_SubtitlePanel_useTextOutline, Keys.KEY_SubtitlePanel_specialTermination};
        final JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (int i = 0; i < stringArrayArray.length; ++i) {
            jCheckBoxArray[i] = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxArray[i].setPreferredSize(new Dimension(260, 20));
            jCheckBoxArray[i].setMaximumSize(new Dimension(260, 20));
            jCheckBoxArray[i].setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxArray[i].setActionCommand(stringArrayArray[i][0]);
            jCheckBoxArray[i].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxArray[i].addActionListener(this._CheckBoxListener);
        }
        jPanel2.add(jCheckBoxArray[0]);
        jPanel2.add(jCheckBoxArray[1]);
        jPanel2.add(jCheckBoxArray[2]);
        jPanel2.add(jCheckBoxArray[3]);
        jPanel2.add(jCheckBoxArray[4]);
        jPanel2.add(jCheckBoxArray[5]);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                String string = jCheckBox.getActionCommand();
                if (string.equals(Keys.KEY_SubtitlePanel_exportTextAsUnicode[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[5].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_SubtitlePanel_exportTextAsUTF8[0], false);
                    return;
                }
                if (string.equals(Keys.KEY_SubtitlePanel_exportTextAsUTF8[0]) && jCheckBox.isSelected()) {
                    jCheckBoxArray[4].setSelected(false);
                    Common.getSettings().setBooleanProperty(Keys.KEY_SubtitlePanel_exportTextAsUnicode[0], false);
                    return;
                }
            }
        };
        jCheckBoxArray[4].addActionListener(actionListener);
        jCheckBoxArray[5].addActionListener(actionListener);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JLabel jLabel = new JLabel(Resource.getString("SubtitlePanel.TtxPages"));
        jLabel.setToolTipText(Resource.getString("SubtitlePanel.TtxPages.Tip"));
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_SubtitlePanel_TtxPage1, Keys.KEY_SubtitlePanel_TtxPage2, Keys.KEY_SubtitlePanel_TtxPage3, Keys.KEY_SubtitlePanel_TtxPage4, Keys.KEY_SubtitlePanel_TtxPage5, Keys.KEY_SubtitlePanel_TtxPage6, Keys.KEY_SubtitlePanel_TtxPage7, Keys.KEY_SubtitlePanel_TtxPage8};
        Object[] objectArray = new Object[]{"null", "149", "150", "199", "299", "599", "691", "692", "693", "694", "699", "777", "779", "784", "785", "786", "881", "882", "884", "885", "886", "887", "888", "889"};
        for (int i = 0; i < stringArrayArray2.length; ++i) {
            jComponent = new JComboBox<Object>(objectArray);
            jComponent.setPreferredSize(new Dimension(64, 22));
            jComponent.setMaximumSize(new Dimension(64, 22));
            ((JComboBox)jComponent).setEditable(true);
            ((JComboBox)jComponent).setActionCommand(stringArrayArray2[i][0]);
            ((JComboBox)jComponent).setSelectedItem(Common.getSettings().getProperty(stringArrayArray2[i]));
            ((JComboBox)jComponent).addActionListener(this._ComboBoxItemListener);
            if (i < 4) {
                jPanel3.add(jComponent);
                continue;
            }
            jPanel4.add(jComponent);
        }
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jComponent = new JLabel(Resource.getString("SubtitlePanel.Language"));
        jComponent.setToolTipText(Resource.getString("SubtitlePanel.Language.Tip"));
        jComponent.setPreferredSize(new Dimension(80, 22));
        jComponent.setMaximumSize(new Dimension(80, 22));
        jPanel5.add(jComponent);
        JComboBox<Object> jComboBox = new JComboBox<Object>(Keys.ITEMS_TtxLanguagePair);
        jComboBox.setPreferredSize(new Dimension(140, 22));
        jComboBox.setMaximumSize(new Dimension(140, 22));
        jComboBox.setActionCommand(Keys.KEY_TtxLanguagePair[0]);
        jComboBox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_TtxLanguagePair));
        jComboBox.addActionListener(this._ComboBoxIndexListener);
        jPanel5.add(jComboBox);
        jPanel2.add(jPanel5);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setToolTipText(Resource.getString("SubtitlePanel.Format.Tip"));
        jPanel6.add(new JLabel("1. " + Resource.getString("SubtitlePanel.Format")));
        JComboBox<Object> jComboBox2 = new JComboBox<Object>(Keys.ITEMS_SubtitleExportFormat);
        jComboBox2.setPreferredSize(new Dimension(80, 22));
        jComboBox2.setMaximumSize(new Dimension(80, 22));
        jComboBox2.setActionCommand(Keys.KEY_SubtitleExportFormat[0]);
        jComboBox2.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubtitleExportFormat));
        jComboBox2.addActionListener(this._ComboBoxItemListener);
        jPanel6.add(jComboBox2);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.setToolTipText(Resource.getString("SubtitlePanel.Format.Tip"));
        jPanel7.add(new JLabel("2. " + Resource.getString("SubtitlePanel.Format")));
        JComboBox<Object> jComboBox3 = new JComboBox<Object>(Keys.ITEMS_SubtitleExportFormat);
        jComboBox3.setPreferredSize(new Dimension(80, 22));
        jComboBox3.setMaximumSize(new Dimension(80, 22));
        jComboBox3.setActionCommand(Keys.KEY_SubtitleExportFormat_2[0]);
        jComboBox3.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubtitleExportFormat_2));
        jComboBox3.addActionListener(this._ComboBoxItemListener);
        jPanel7.add(jComboBox3);
        jPanel2.add(jPanel7);
        jPanel.add(jPanel2);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new ColumnLayout());
        jPanel8.setBorder(BorderFactory.createTitledBorder(Resource.getString("SubtitlePanel.Title")));
        jPanel8.add(new JLabel(Resource.getString("SubtitlePanel.Title.Teletext")));
        jPanel8.add(jCheckBoxArray[6]);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        JLabel jLabel2 = new JLabel(Resource.getString("SubtitlePanel.Font"));
        jLabel2.setToolTipText(Resource.getString("SubtitlePanel.Font.Tip"));
        jLabel2.setPreferredSize(new Dimension(100, 22));
        jLabel2.setMaximumSize(new Dimension(100, 22));
        jPanel9.add(jLabel2);
        JComboBox<Object> jComboBox4 = new JComboBox<Object>(Common.getFonts());
        jComboBox4.setPreferredSize(new Dimension(150, 22));
        jComboBox4.setMaximumSize(new Dimension(150, 22));
        jComboBox4.setActionCommand(Keys.KEY_SubtitleFont[0]);
        jComboBox4.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubtitleFont));
        jComboBox4.addActionListener(this._ComboBoxItemListener);
        jPanel9.add(jComboBox4);
        jPanel8.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        JLabel jLabel3 = new JLabel(Resource.getString("SubtitlePanel.SupValues"));
        jLabel3.setPreferredSize(new Dimension(60, 22));
        jLabel3.setMaximumSize(new Dimension(60, 22));
        jPanel10.add(jLabel3);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_SubtitlePanel_Format_SUP_Values));
        jTextField.setPreferredSize(new Dimension(190, 22));
        jTextField.setMaximumSize(new Dimension(190, 22));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_SubtitlePanel_Format_SUP_Values[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_SubtitlePanel_Format_SUP_Values[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel10.add(jTextField);
        jPanel8.add(jPanel10);
        jPanel8.add(Box.createRigidArea(new Dimension(1, 15)));
        JLabel jLabel4 = new JLabel(Resource.getString("SubtitlePanel.Colormodel"));
        jLabel4.setToolTipText(Resource.getString("SubtitlePanel.Colormodel.Tip"));
        jPanel8.add(jLabel4);
        JComboBox<Object> jComboBox5 = new JComboBox<Object>(Common.getColorModels());
        jComboBox5.setPreferredSize(new Dimension(130, 22));
        jComboBox5.setMaximumSize(new Dimension(130, 22));
        jComboBox5.setActionCommand(Keys.KEY_SubpictureColorModel[0]);
        jComboBox5.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_SubpictureColorModel));
        jComboBox5.addActionListener(this._ComboBoxItemListener);
        jPanel8.add(jComboBox5);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        jPanel11.add(new JLabel(Resource.getString("SubtitlePanel.PageId")));
        JTextField jTextField2 = new JTextField(Common.getSettings().getProperty(Keys.KEY_SubtitlePanel_PageId_Value));
        jTextField2.setPreferredSize(new Dimension(40, 20));
        jTextField2.setMaximumSize(new Dimension(100, 20));
        jTextField2.setToolTipText(Resource.getString(Keys.KEY_SubtitlePanel_PageId_Value[0] + ".Tip"));
        jTextField2.setEditable(true);
        jTextField2.setActionCommand(Keys.KEY_SubtitlePanel_PageId_Value[0]);
        jTextField2.addActionListener(this._TextFieldListener);
        jTextField2.addKeyListener(this._TextFieldKeyListener);
        jPanel11.add(jTextField2);
        jPanel8.add(jPanel11);
        jPanel8.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel8.add(new JLabel(Resource.getString("SubtitlePanel.Title")));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 0));
        jPanel12.setToolTipText(Resource.getString("SubtitlePanel.ChangeDisplay.Tip"));
        JLabel jLabel5 = new JLabel(Resource.getString("SubtitlePanel.ChangeDisplay"));
        jLabel5.setPreferredSize(new Dimension(140, 22));
        jLabel5.setMaximumSize(new Dimension(140, 22));
        jPanel12.add(jLabel5);
        JComboBox<Object> jComboBox6 = new JComboBox<Object>(Keys.ITEMS_SubtitleChangeDisplay);
        jComboBox6.setPreferredSize(new Dimension(120, 22));
        jComboBox6.setMaximumSize(new Dimension(120, 22));
        jComboBox6.setActionCommand(Keys.KEY_SubtitleChangeDisplay[0]);
        jComboBox6.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_SubtitleChangeDisplay));
        jComboBox6.addActionListener(this._ComboBoxIndexListener);
        jPanel12.add(jComboBox6);
        jPanel8.add(jPanel12);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 0));
        jPanel13.setToolTipText(Resource.getString("SubtitlePanel.MovePosition.Tip"));
        JLabel jLabel6 = new JLabel(Resource.getString("SubtitlePanel.MovePosition"));
        jLabel6.setPreferredSize(new Dimension(140, 22));
        jLabel6.setMaximumSize(new Dimension(140, 22));
        jPanel13.add(jLabel6);
        JTextField jTextField3 = new JTextField(Common.getSettings().getProperty(Keys.KEY_SubtitleMovePosition_Value));
        jTextField3.setPreferredSize(new Dimension(120, 22));
        jTextField3.setMaximumSize(new Dimension(120, 22));
        jTextField3.setEditable(true);
        jTextField3.setActionCommand(Keys.KEY_SubtitleMovePosition_Value[0]);
        jTextField3.addActionListener(this._TextFieldListener);
        jTextField3.addKeyListener(this._TextFieldKeyListener);
        jPanel13.add(jTextField3);
        jPanel8.add(jPanel13);
        jPanel8.add(Box.createRigidArea(new Dimension(1, 10)));
        jPanel8.add(new JLabel("Test:"));
        jPanel8.add(jCheckBoxArray[7]);
        jPanel.add(jPanel8);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.SubtitlePanel"));
    }

    protected JPanel buildOptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("OptionPanel.Various.Title")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_dumpDroppedGop, Keys.KEY_holdStreamInfoOnOSD, Keys.KEY_additionalInputBuffer};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (int i = 0; i < stringArrayArray.length; ++i) {
            jCheckBoxArray[i] = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxArray[i].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[i].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[i].setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxArray[i].setActionCommand(stringArrayArray[i][0]);
            jCheckBoxArray[i].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxArray[i].addActionListener(this._CheckBoxListener);
            if (i >= 2) continue;
            jPanel2.add(jCheckBoxArray[i]);
        }
        jPanel2.add(Box.createRigidArea(new Dimension(1, 4)));
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_StartPath_Value));
        jTextField.setPreferredSize(new Dimension(250, 25));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_StartPath_Value[0] + ".Tip"));
        jTextField.setEditable(true);
        jTextField.setActionCommand(Keys.KEY_StartPath_Value[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel2.add(new JLabel(Resource.getString("OptionPanel.StartPath")));
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(Resource.getString("OptionPanel.Buffer.Title")));
        jPanel3.add(jCheckBoxArray[2]);
        String[][] stringArrayArray2 = new String[][]{Keys.KEY_MainBuffer, Keys.KEY_ScanBuffer, Keys.KEY_PreviewBuffer};
        Object[][] objectArrayArray = new Object[][]{{"10240000", "8192000", "7168000", "6144000", "5120000", "4096000", "3072000", "2048000", "1024000"}, {"384000", "512000", "1024000", "1536000", "2048000", "2560000", "3072000"}, {"256000", "384000", "512000", "768000", "1024000", "1536000", "2048000", "2560000", "3072000"}};
        for (int i = 0; i < stringArrayArray2.length; ++i) {
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArrayArray[i]);
            jComboBox.setPreferredSize(new Dimension(100, 24));
            jComboBox.setMaximumSize(new Dimension(100, 24));
            jComboBox.setEditable(true);
            jComboBox.setMaximumRowCount(6);
            jComboBox.setActionCommand(stringArrayArray2[i][0]);
            jComboBox.setSelectedItem(Common.getSettings().getProperty(stringArrayArray2[i]));
            jComboBox.addActionListener(this._ComboBoxItemListener);
            JLabel jLabel = new JLabel(Resource.getString(stringArrayArray2[i][0]));
            jLabel.setToolTipText(Resource.getString(stringArrayArray2[i][0] + ".Tip"));
            jPanel3.add(jLabel);
            jPanel3.add(jComboBox);
        }
        jPanel.add(jPanel3);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.OptionPanel"));
    }

    protected JPanel buildNetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("FtpPanel.Title")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_killFtpClient, Keys.KEY_useFtpServerResume, Keys.KEY_autostartWebServer};
        JCheckBox[] jCheckBoxArray = new JCheckBox[stringArrayArray.length];
        for (int i = 0; i < 2; ++i) {
            jCheckBoxArray[i] = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxArray[i].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[i].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[i].setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxArray[i].setActionCommand(stringArrayArray[i][0]);
            jCheckBoxArray[i].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxArray[i].addActionListener(this._CheckBoxListener);
            jPanel2.add(jCheckBoxArray[i]);
        }
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JLabel jLabel = new JLabel(Resource.getString("ftp.command.label"));
        jLabel.setPreferredSize(new Dimension(100, 20));
        jLabel.setMaximumSize(new Dimension(100, 20));
        jLabel.setToolTipText(Resource.getString("ftp.command.tip"));
        jPanel3.add(jLabel);
        JTextField jTextField = new JTextField(Common.getSettings().getProperty(Keys.KEY_FtpServer_Commands));
        jTextField.setPreferredSize(new Dimension(160, 20));
        jTextField.setMaximumSize(new Dimension(160, 20));
        jTextField.setToolTipText(Resource.getString(Keys.KEY_FtpServer_Commands[0] + ".Tip"));
        jTextField.setActionCommand(Keys.KEY_FtpServer_Commands[0]);
        jTextField.addActionListener(this._TextFieldListener);
        jTextField.addKeyListener(this._TextFieldKeyListener);
        jPanel3.add(jTextField);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(Resource.getString("NetPanel.Title")));
        for (int i = 2; i < stringArrayArray.length; ++i) {
            jCheckBoxArray[i] = new JCheckBox(Resource.getString(stringArrayArray[i][0]));
            jCheckBoxArray[i].setPreferredSize(new Dimension(270, 20));
            jCheckBoxArray[i].setMaximumSize(new Dimension(270, 20));
            jCheckBoxArray[i].setToolTipText(Resource.getString(stringArrayArray[i][0] + ".Tip"));
            jCheckBoxArray[i].setActionCommand(stringArrayArray[i][0]);
            jCheckBoxArray[i].setSelected(Common.getSettings().getBooleanProperty(stringArrayArray[i]));
            jCheckBoxArray[i].addActionListener(this._CheckBoxListener);
            jPanel4.add(jCheckBoxArray[i]);
        }
        jPanel4.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JLabel jLabel2 = new JLabel("Port:");
        jLabel2.setPreferredSize(new Dimension(100, 20));
        jLabel2.setMaximumSize(new Dimension(100, 20));
        jPanel5.add(jLabel2);
        JTextField jTextField2 = new JTextField(Common.getSettings().getProperty(Keys.KEY_WebServerPort));
        jTextField2.setPreferredSize(new Dimension(160, 20));
        jTextField2.setMaximumSize(new Dimension(160, 20));
        jTextField2.setToolTipText(Resource.getString(Keys.KEY_WebServerPort[0] + ".Tip"));
        jTextField2.setActionCommand(Keys.KEY_WebServerPort[0]);
        jTextField2.addActionListener(this._TextFieldListener);
        jTextField2.addKeyListener(this._TextFieldKeyListener);
        jPanel5.add(jTextField2);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        JLabel jLabel3 = new JLabel("Keyword:");
        jLabel3.setPreferredSize(new Dimension(100, 20));
        jLabel3.setMaximumSize(new Dimension(100, 20));
        jLabel3.setToolTipText("mustn't be empty");
        jPanel6.add(jLabel3);
        JTextField jTextField3 = new JTextField(Common.getSettings().getProperty(Keys.KEY_WebServerAccess));
        jTextField3.setPreferredSize(new Dimension(160, 20));
        jTextField3.setMaximumSize(new Dimension(160, 20));
        jTextField3.setToolTipText(Resource.getString(Keys.KEY_WebServerAccess[0] + ".Tip"));
        jTextField3.setActionCommand(Keys.KEY_WebServerAccess[0]);
        jTextField3.addActionListener(this._TextFieldListener);
        jTextField3.addKeyListener(this._TextFieldKeyListener);
        jPanel6.add(jTextField3);
        jPanel4.add(jPanel6);
        JButton jButton = new JButton("re-/start WebIF");
        jButton.setPreferredSize(new Dimension(120, 22));
        jButton.setMaximumSize(new Dimension(120, 22));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.startWebServer();
            }
        });
        JButton jButton2 = new JButton("stop WebIF");
        jButton2.setPreferredSize(new Dimension(120, 22));
        jButton2.setMaximumSize(new Dimension(120, 22));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.stopWebServer();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add(jPanel4);
        return this.buildHeadPanel(jPanel, Resource.getString("TabPanel.NetPanel"));
    }

    protected JPanel buildPostCommandsPanel() {
        JPanel jPanel;
        JComponent jComponent;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    String string2 = "";
                    if (string.equals(Keys.KEY_PostCommands_Cmd1[0])) {
                        string2 = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd1);
                    } else if (string.equals(Keys.KEY_PostCommands_Cmd2[0])) {
                        string2 = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd2);
                    } else if (string.equals(Keys.KEY_PostCommands_Cmd3[0])) {
                        string2 = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd3);
                    }
                    Common.performCommand(string2);
                }
                catch (Exception exception) {
                    Common.setExceptionMessage(exception);
                }
            }
        };
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("PostCommands.Title")));
        String[][] stringArrayArray = new String[][]{Keys.KEY_PostCommands_Cmd1, Keys.KEY_PostCommands_Cmd2, Keys.KEY_PostCommands_Cmd3, Keys.KEY_PostCommands_Cmd4, Keys.KEY_PostCommands_Cmd5, Keys.KEY_PostCommands_Cmd6, Keys.KEY_PostCommands_Cmd7, Keys.KEY_PostCommands_Cmd8};
        for (int i = 0; i < 3; ++i) {
            JTextField jTextField = new JTextField(Common.getSettings().getProperty(stringArrayArray[i]));
            jTextField.setPreferredSize(new Dimension(400, 25));
            jTextField.setEditable(true);
            jTextField.setActionCommand(stringArrayArray[i][0]);
            jTextField.addActionListener(this._TextFieldListener);
            jTextField.addKeyListener(this._TextFieldKeyListener);
            jComponent = new JButton(Resource.getString("PostCommands.Execute"));
            ((AbstractButton)jComponent).setActionCommand(stringArrayArray[i][0]);
            jComponent.setPreferredSize(new Dimension(100, 20));
            ((AbstractButton)jComponent).addActionListener(actionListener);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(jTextField);
            jPanel.add(jComponent);
            jPanel2.add(jPanel);
        }
        jPanel2.add(Box.createRigidArea(new Dimension(1, 10)));
        JLabel jLabel = new JLabel(Resource.getString("PostCommands.PostProcessing"));
        jLabel.setToolTipText(Resource.getString("PostCommands.PostProcessing.Tip"));
        jPanel2.add(jLabel);
        for (int i = 3; i < stringArrayArray.length; ++i) {
            jComponent = new JTextField(Common.getSettings().getProperty(stringArrayArray[i]));
            jComponent.setPreferredSize(new Dimension(400, 25));
            ((JTextComponent)jComponent).setEditable(true);
            ((JTextField)jComponent).setActionCommand(stringArrayArray[i][0]);
            ((JTextField)jComponent).addActionListener(this._TextFieldListener);
            jComponent.addKeyListener(this._TextFieldKeyListener);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(jComponent);
            jPanel.add(new JLabel(Keys.ITEMS_ConversionMode[i - 3].toString()));
            jPanel2.add(jPanel);
        }
        return this.buildHeadPanel(jPanel2, Resource.getString("TabPanel.PostCommandsPanel"));
    }
}

