/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.gui.X_JFileChooser;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.PreviewObject;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;

public class PicturePanel
extends JPanel {
    private Image StreamTypeImage = Resource.loadImage("_container.gif");
    private Image VideoImage = Resource.loadImage("_video.gif");
    private Image AudioImage = Resource.loadImage("_audio.gif");
    private Image TeletextImage = Resource.loadImage("_teletext.gif");
    private Image SubtitleImage = Resource.loadImage("_subtitle.gif");
    private Image PlaytimeImage = Resource.loadImage("_playtime.gif");
    private Image PalPlusImage = Resource.loadImage("_ppl.gif");
    private Image SubpictureImage;
    private Image image;
    private MemoryImageSource source;
    private boolean showFileInfo = false;
    private boolean isSubpictureAvailable = false;
    private boolean isOSDInfoAvailable = false;
    private boolean isOSDErrorInfo = false;
    private boolean PLAY = true;
    private StreamInfo streamInfo = null;
    private Font font_1;
    private Font font_2;
    private Font font_3;
    private int ErrorFlag = 0;
    private int bmpCount = 0;
    private int collection_number = -1;
    private final String tooltip1 = Resource.getString("mpvdecoder.tip1");
    private long cutfiles_length = 0L;
    private long[] cutfiles_points = null;
    private long chapter_length = 0L;
    private long[] chapter_points = null;
    private Object[] OSDInfo;
    private JPopupMenu popup;
    private Clock clock;
    private byte[] bmpHead = new byte[]{66, 77, 0, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, -120, 11, 0, 0, -120, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private double[] aspectratio_table = new double[]{1.3333, 1.3333, 1.3333, 1.7778, 2.21, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333, 1.3333};

    public PicturePanel() {
        this.source = new MemoryImageSource(512, 288, Common.getMpvDecoderClass().getPreviewPixel(), 0, 512);
        this.source.setAnimated(true);
        this.image = this.createImage(this.source);
        this.font_1 = new Font("Tahoma", 0, 12);
        this.font_2 = new Font("Tahoma", 1, 12);
        this.font_3 = new Font("Tahoma", 1, 24);
        this.setBackground(Color.black);
        this.setVisible(true);
        this.setToolTipText(this.tooltip1);
        this.setSize(512, 346);
        this.buildPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 1 && (PicturePanel.this.showFileInfo || PicturePanel.this.isOSDInfoAvailable)) {
                    PicturePanel.this.showFileInfo = false;
                    PicturePanel.this.isOSDInfoAvailable = false;
                    PicturePanel.this.repaint();
                }
                if (mouseEvent.getClickCount() >= 1 && mouseEvent.getModifiers() == 4) {
                    PicturePanel.this.popup.show(PicturePanel.this.getParent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.clock = new Clock();
    }

    protected void buildPopupMenu() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("save_1")) {
                    PicturePanel.this.saveBMP(Common.getMpvDecoderClass().getPixels(), Common.getMpvDecoderClass().getWidth(), Common.getMpvDecoderClass().getHeight(), 0, false);
                } else if (string.equals("save_2")) {
                    PicturePanel.this.saveBMP(Common.getMpvDecoderClass().getPixels(), Common.getMpvDecoderClass().getWidth(), Common.getMpvDecoderClass().getHeight(), Common.getMpvDecoderClass().getAspectRatio(), true);
                }
            }
        };
        this.popup = new JPopupMenu("save");
        JMenuItem jMenuItem = this.popup.add(Resource.getString("PreviewPanel.saveCurrentPicture"));
        jMenuItem.setActionCommand("save_1");
        JMenuItem jMenuItem2 = this.popup.add(Resource.getString("PreviewPanel.saveCurrentPictureDAR"));
        jMenuItem2.setActionCommand("save_2");
        this.popup.pack();
        UIManager.addPropertyChangeListener(new UISwitchListener(this.popup));
        jMenuItem.addActionListener(actionListener);
        jMenuItem2.addActionListener(actionListener);
    }

    public void startClock() {
        this.clock.start();
    }

    public void startClock(int n) {
        this.clock.start(n);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 600, 600);
        graphics.setColor(new Color(0, 35, 110));
        graphics.fillRect(0, 290, 514, 340);
        this.paintOutline(graphics);
        graphics.drawImage(this.image, 2, 2, this);
        graphics.setFont(this.font_1);
        graphics.setColor(Color.white);
        graphics.drawString(Common.getMpvDecoderClass().getInfo_1(), 36, 303);
        graphics.drawString(Common.getMpvDecoderClass().getInfo_2(), 36, 317);
        this.paintWSSInfo(graphics);
        this.paintErrorInfo(graphics);
        this.paintPlayInfo(graphics);
        graphics.setFont(this.font_2);
        this.paintCutInfo(graphics);
        this.paintChapterInfo(graphics);
        this.paintSubpicture(graphics);
        this.paintOSDInfo(graphics);
        this.paintFileInfo(graphics);
        this.paintCollectionNumber(graphics);
    }

    private void paintOutline(Graphics graphics) {
        Color color = new Color(191, 191, 191);
        Color color2 = new Color(255, 255, 255);
        Color color3 = new Color(151, 151, 151);
        graphics.setColor(color3);
        graphics.drawLine(1, 1, 514, 1);
        graphics.drawLine(1, 1, 1, 400);
        graphics.setColor(color);
        graphics.drawLine(2, 290, 514, 290);
        graphics.drawLine(514, 2, 514, 400);
        graphics.setColor(color2);
        graphics.drawLine(0, 0, 515, 0);
        graphics.drawLine(0, 0, 0, 400);
        graphics.drawLine(0, 291, 515, 291);
        graphics.drawLine(515, 0, 515, 400);
    }

    private void paintCollectionNumber(Graphics graphics) {
        if (this.collection_number < 0) {
            return;
        }
        graphics.setFont(this.font_2);
        graphics.setColor(Color.green);
        graphics.drawString("Collection", 454, 16);
        graphics.setFont(this.font_3);
        graphics.setColor(Color.green);
        graphics.drawString(String.valueOf(this.collection_number), 474, 38);
    }

    private void paintWSSInfo(Graphics graphics) {
        String string = Common.getMpvDecoderClass().getWSSInfo();
        if (string == null) {
            this.setToolTipText(this.tooltip1);
            return;
        }
        graphics.setFont(this.font_2);
        graphics.setColor(Color.green);
        graphics.drawString("WSS present", 10, 16);
        graphics.drawString(Common.getMpvDecoderClass().getWSSFormatInfo(), 10, 30);
        if (Common.getMpvDecoderClass().getPalPlusInfo()) {
            graphics.drawImage(this.PalPlusImage, 8, 34, this);
        }
        this.setToolTipText("<html>" + this.tooltip1 + "<p><p>" + string + "</html>");
    }

    private void paintPlayInfo(Graphics graphics) {
        int[] nArray = new int[]{10, 10, 30};
        int[] nArray2 = new int[]{294, 314, 304};
        if (this.PLAY) {
            graphics.setColor(Color.green);
            graphics.fillPolygon(nArray, nArray2, 3);
        } else {
            graphics.setColor(Color.red);
            graphics.fillRect(10, 294, 20, 20);
        }
    }

    private void paintErrorInfo(Graphics graphics) {
        this.ErrorFlag = Common.getMpvDecoderClass().getErrors();
        if ((this.ErrorFlag & 1) != 0) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 120, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("error while decoding frame", 160, 133);
        }
        if ((this.ErrorFlag & 4) != 0) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 135, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("not enough data in buffer", 160, 148);
        }
        if ((this.ErrorFlag & 2) != 0) {
            graphics.setColor(Color.white);
            graphics.fill3DRect(150, 150, 200, 20, true);
            graphics.setColor(Color.red);
            graphics.drawString("cannot find sequence header", 160, 163);
        }
    }

    private void paintCutInfo(Graphics graphics) {
        if (this.cutfiles_length <= 0L) {
            return;
        }
        int n = 10;
        int n2 = 327;
        int n3 = 492;
        int n4 = 6;
        graphics.setColor(new Color(0, 200, 0));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.white);
        graphics.drawRect(n - 2, n2 - 2, n3 + 3, n4 + 3);
        if (this.cutfiles_points != null && this.cutfiles_points.length > 0) {
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < this.cutfiles_points.length && this.cutfiles_points[i] <= this.cutfiles_length; ++i) {
                n5 = i == 0 ? 0 : (int)(this.cutfiles_points[i - 1] * (long)n3 / this.cutfiles_length);
                n6 = (int)(this.cutfiles_points[i] * (long)n3 / this.cutfiles_length);
                if (i % 2 == 0) {
                    graphics.setColor(new Color(150, 0, 0));
                    graphics.fillRect(n + n5, n2, n6 - n5, n4);
                }
                graphics.setColor(new Color(200, 100, 200));
                graphics.fillRect(n + n6 - 1, n2 - 4, 2, n4 + 8);
                int[] nArray = new int[]{n + n6 - 1, n + n6 - 5, n + n6 + 5};
                int[] nArray2 = new int[]{n2 - 3, n2 - 3 - 5, n2 - 3 - 5};
                graphics.fillPolygon(nArray, nArray2, 3);
            }
            if ((this.cutfiles_points.length & 1) == 0) {
                n5 = (int)(this.cutfiles_points[this.cutfiles_points.length - 1] * (long)n3 / this.cutfiles_length);
                graphics.setColor(new Color(150, 0, 0));
                graphics.fillRect(n + n5, n2, n3 - n5, n4);
            }
        }
    }

    private void paintChapterInfo(Graphics graphics) {
        if (this.chapter_length <= 0L) {
            return;
        }
        int n = 10;
        int n2 = 327;
        int n3 = 492;
        int n4 = 6;
        if (this.chapter_points != null && this.chapter_points.length > 0) {
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < this.chapter_points.length && this.chapter_points[i] <= this.chapter_length; ++i) {
                n5 = i == 0 ? 0 : (int)(this.chapter_points[i - 1] * (long)n3 / this.chapter_length);
                n6 = (int)(this.chapter_points[i] * (long)n3 / this.chapter_length);
                graphics.setColor(new Color(195, 205, 255));
                graphics.fillRect(n + n6 - 1, n2 - 4, 2, n4 + 8);
                int[] nArray = new int[]{n + n6 - 1, n + n6 - 5, n + n6 + 5};
                int[] nArray2 = new int[]{n2 + n4 + 3, n2 + n4 + 3 + 5, n2 + n4 + 3 + 5};
                graphics.fillPolygon(nArray, nArray2, 3);
            }
        }
    }

    private void paintOSDBg(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = new Color(150, 150, 255, 210);
        Color color2 = new Color(50, 20, 225, 210);
        Color color3 = new Color(255, 150, 150, 210);
        Color color4 = new Color(225, 20, 20, 210);
        graphics.setColor(this.isOSDErrorInfo ? color3 : color);
        graphics.fillRect(n, n2 + 20, n3, 220);
        graphics.setColor(this.isOSDErrorInfo ? color4 : color2);
        graphics.fillRect(n, n2, n3, 20);
        graphics.fillRect(n, n2 + n4, n3, 34);
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2 + 20, n + n3 - 1, n2 + 20);
        graphics.drawLine(n, n2 + 240, n + n3 - 1, n2 + 240);
    }

    private void paintOSDInfo(Graphics graphics) {
        if (!this.isOSDInfoAvailable || this.OSDInfo == null || this.OSDInfo.length == 0) {
            return;
        }
        int n = 8;
        int n2 = 8;
        int n3 = 496;
        int n4 = 240;
        int n5 = 0;
        this.paintOSDBg(graphics, n, n2, n3, n4);
        graphics.setColor(Color.white);
        graphics.drawString(this.OSDInfo[0].toString(), n + 10, n2 + 14);
        graphics.drawString(this.OSDInfo[1].toString(), n + 10, n2 + n4 + 16);
        n5 = n2 + 24;
        for (int i = 2; i < this.OSDInfo.length; ++i) {
            n5 = this.paintSubInfo(graphics, this.OSDInfo[i].toString(), null, n, n5);
        }
    }

    private void paintFileInfo(Graphics graphics) {
        if (!this.showFileInfo) {
            return;
        }
        int n = 8;
        int n2 = 8;
        int n3 = 496;
        int n4 = 240;
        int n5 = 0;
        this.paintOSDBg(graphics, n, n2, n3, n4);
        graphics.setColor(Color.white);
        graphics.drawString(this.streamInfo.getFileSourceAndName(), n + 6, n2 + 14);
        graphics.drawString(this.streamInfo.getFileDate(), n + 6, n2 + n4 + 16);
        graphics.drawString(this.streamInfo.getFileSize(), n + 6, n2 + n4 + 30);
        n5 = n2 + 24;
        n5 = this.paintSubInfo(graphics, this.streamInfo.getFileType(), this.StreamTypeImage, n, n5);
        Object[] objectArray = this.streamInfo.getVideoStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.VideoImage, n, n5);
        objectArray = this.streamInfo.getAudioStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.AudioImage, n, n5);
        objectArray = this.streamInfo.getTeletextStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.TeletextImage, n, n5);
        objectArray = this.streamInfo.getSubpictureStreams();
        n5 = this.paintSubInfo(graphics, objectArray, this.SubtitleImage, n, n5);
        n5 = this.paintSubInfo(graphics, this.streamInfo.getPlaytime(), this.PlaytimeImage, n, n5);
    }

    private int paintSubInfo(Graphics graphics, String string, Image image, int n, int n2) {
        if (string != null && string.length() > 0) {
            int n3;
            if (n2 > 230) {
                graphics.fillPolygon(new int[]{n + 3, n + 17, n + 9}, new int[]{n2, n2, n2 + 7}, 3);
                graphics.drawString("...", n + 25, n2 + 6);
                return n2;
            }
            int n4 = string.indexOf("\t");
            int n5 = n3 = image != null ? 25 : 10;
            if (image != null) {
                graphics.drawImage(image, n + 2, n2, this);
            }
            if (n4 >= 0) {
                graphics.drawString(string.substring(n4 + 1), n + n3 + 120, n2 + 12);
                graphics.drawString(string.substring(0, n4), n + n3, n2 + 12);
            } else {
                graphics.drawString(string, n + n3, n2 + 12);
            }
            n2 += 16;
        }
        return n2;
    }

    private int paintSubInfo(Graphics graphics, Object[] objectArray, Image image, int n, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                n2 = this.paintSubInfo(graphics, "" + (i + 1) + ".  " + objectArray[i].toString(), image, n, n2);
            }
        }
        return n2;
    }

    private void paintSubpicture(Graphics graphics) {
        if (!this.isSubpictureAvailable) {
            return;
        }
        graphics.drawImage(this.SubpictureImage, 66, 2, this);
    }

    private void loadSubpicture() {
        this.SubpictureImage = !this.isSubpictureAvailable ? null : Common.getSubpictureClass().getScaledImage();
    }

    public void setStreamInfo(StreamInfo streamInfo) {
        this.streamInfo = streamInfo.getNewInstance();
        boolean bl = this.showFileInfo = this.streamInfo != null;
        if (this.showFileInfo && !Common.getSettings().getBooleanProperty(Keys.KEY_holdStreamInfoOnOSD)) {
            this.startClock(10000);
        }
        this.isSubpictureAvailable = this.showFileInfo && this.streamInfo.getStreamType() == 16;
        this.loadSubpicture();
        this.isOSDInfoAvailable = false;
        this.isOSDErrorInfo = false;
        this.repaint();
    }

    public void setOSD(Object[] objectArray) {
        this.isOSDErrorInfo = false;
        this.setOSDMessage(objectArray);
    }

    public void setOSDMessage(String string, boolean bl) {
        this.isOSDErrorInfo = bl;
        this.setOSDMessage(new Object[]{bl ? "Fehler" : "Info", "", "", string});
    }

    public void setOSDMessage(Object[] objectArray) {
        this.setOSDMessage(objectArray, false);
    }

    public void setOSDMessage(Object[] objectArray, boolean bl) {
        this.OSDInfo = objectArray;
        this.isOSDInfoAvailable = true;
        this.showFileInfo = false;
        if (!bl) {
            this.startClock(10000);
        }
        this.repaint();
    }

    public void showCollectionNumber(int n) {
        this.collection_number = n;
        this.startClock();
        this.repaint();
    }

    public void updatePreviewPixel() {
        this.source.newPixels();
    }

    public void showCutIcon(boolean bl, Object[] objectArray, Object object) {
        this.PLAY = bl;
        List list = (List)object;
        if (!list.isEmpty()) {
            this.cutfiles_length = ((PreviewObject)list.get(list.size() - 1)).getEnd();
            if (objectArray != null) {
                this.cutfiles_points = new long[objectArray.length];
                for (int i = 0; i < this.cutfiles_points.length; ++i) {
                    this.cutfiles_points[i] = CommonParsing.parseCutValue(objectArray[i].toString(), false);
                }
            } else {
                this.cutfiles_points = null;
            }
        } else {
            this.cutfiles_length = 0L;
            this.cutfiles_points = null;
        }
        this.repaint();
    }

    public void showChapterIcon(Object[] objectArray, Object object) {
        List list = (List)object;
        if (!list.isEmpty()) {
            this.chapter_length = ((PreviewObject)list.get(list.size() - 1)).getEnd();
            if (objectArray != null) {
                this.chapter_points = new long[objectArray.length];
                for (int i = 0; i < this.chapter_points.length; ++i) {
                    this.chapter_points[i] = CommonParsing.parseCutValue(objectArray[i].toString(), false);
                }
            } else {
                this.chapter_points = null;
            }
        } else {
            this.chapter_length = 0L;
            this.chapter_points = null;
        }
        this.repaint();
    }

    private int YUVtoRGB(int n) {
        int n2 = 255;
        int n3 = 0xFF & n >>> 16;
        int n4 = 0xFF & n >>> 8;
        int n5 = 0xFF & n;
        if (n3 == 0) {
            return 0;
        }
        int n6 = (int)((float)n3 + 1.402f * (float)(n5 - 128));
        int n7 = (int)((double)n3 - 0.34414 * (double)(n4 - 128) - 0.71414 * (double)(n5 - 128));
        int n8 = (int)((double)n3 + 1.722 * (double)(n4 - 128));
        int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
        int n10 = n7 < 0 ? 0 : (n7 = n7 > 255 ? 255 : n7);
        n8 = n8 < 0 ? 0 : (n8 > 255 ? 255 : n8);
        return n2 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    private void littleEndian(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            byArray[n + i] = (byte)(n2 >> i * 8 & 0xFF);
        }
    }

    private void saveBMP(int[] nArray, int n, int n2, int n3, boolean bl) {
        Object object;
        int n4;
        int[] nArray2 = null;
        int n5 = n4 = (0xF & n) != 0 ? (n & 0xFFFFFFF0) + 16 : n;
        if (bl) {
            nArray2 = this.getScaledPixel(nArray, n, n2, this.aspectratio_table[n3]);
            if (nArray2 == null) {
                nArray2 = nArray;
            } else {
                n4 = n = (int)Math.round(this.aspectratio_table[n3] * (double)n2);
            }
        } else {
            nArray2 = nArray;
        }
        int n6 = n * n2;
        if (n6 <= 0) {
            return;
        }
        X_JFileChooser x_JFileChooser = CommonGui.getMainFileChooser();
        if (this.bmpCount == 0) {
            // empty if block
        }
        String string = x_JFileChooser.getCurrentDirectory() + System.getProperty("file.separator") + "X_picture[" + this.bmpCount + "].bmp";
        x_JFileChooser.setSelectedFile(new File(string));
        x_JFileChooser.rescanCurrentDirectory();
        x_JFileChooser.setDialogTitle("save picture");
        int n7 = x_JFileChooser.showSaveDialog(this);
        if (n7 == 0) {
            object = x_JFileChooser.getSelectedFile();
            if (object != null && !((File)object).isDirectory()) {
                string = ((File)object).getAbsolutePath();
            }
        } else {
            return;
        }
        object = new byte[3];
        int n8 = (n & 3) != 0 ? n & 3 : 0;
        n6 = n * n2 * 3 + (n8 > 0 ? n8 * n2 : 0);
        this.littleEndian(this.bmpHead, 2, 54 + n6);
        this.littleEndian(this.bmpHead, 18, n);
        this.littleEndian(this.bmpHead, 22, n2);
        this.littleEndian(this.bmpHead, 34, n6);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 2048000);
            bufferedOutputStream.write(this.bmpHead);
            for (int i = n2 - 1; i >= 0; --i) {
                int n9 = 0;
                for (int j = 0; j < n; ++j) {
                    n9 = this.YUVtoRGB(nArray2[j + i * n4]);
                    for (int k = 0; k < 3; ++k) {
                        object[k] = (byte)(n9 >> k * 8 & 0xFF);
                    }
                    bufferedOutputStream.write((byte[])object);
                }
                if (n8 <= 0) continue;
                bufferedOutputStream.write(new byte[n8]);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            ++this.bmpCount;
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private int[] getScaledPixel(int[] nArray, int n, int n2, double d) {
        int n3 = n2;
        int n4 = n;
        int n5 = (0xF & n) != 0 ? (n & 0xFFFFFFF0) + 16 : n;
        int n6 = n2;
        int n7 = (int)Math.round((double)n2 * d);
        int n8 = n7 * n6;
        if (n8 > 0x1000000 || n8 <= 0) {
            return null;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        double d2 = (double)n3 / (double)n6;
        double d3 = (double)n4 / (double)n7;
        int[] nArray2 = new int[n8];
        for (int i = 0; f < (float)n3 && i < n6; ++i) {
            for (int j = 0; f2 < (float)n4 && j < n7; ++j) {
                nArray2[j + i * n7] = nArray[(int)f2 + (int)f * n5];
                f2 = (float)((double)f2 + d3);
            }
            f = (float)((double)f + d2);
            f2 = 0.0f;
        }
        return nArray2;
    }

    private class Clock
    implements Runnable {
        private Thread clockThread = null;
        private int sleepAmount = 3000;

        private Clock() {
        }

        public void start() {
            this.start(3000);
        }

        public void start(int n) {
            if (this.clockThread == null) {
                this.clockThread = new Thread((Runnable)this, "Clock_4");
                this.clockThread.setPriority(1);
                this.sleepAmount = n;
                this.clockThread.start();
            }
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.clockThread == thread) {
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.update()) {
                    PicturePanel.this.repaint();
                }
                this.stop();
            }
        }

        private boolean update() {
            boolean bl = false;
            if (PicturePanel.this.collection_number >= 0) {
                PicturePanel.this.collection_number = -1;
                bl = true;
            }
            if (PicturePanel.this.showFileInfo) {
                PicturePanel.this.showFileInfo = false;
                bl = true;
            }
            if (PicturePanel.this.isOSDInfoAvailable) {
                PicturePanel.this.isOSDInfoAvailable = false;
                bl = true;
            }
            return bl;
        }

        public void stop() {
            this.clockThread = null;
        }
    }
}

