/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;
    JCheckBox box;

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setToolTipText("click to start/stop monitoring + memory saving");
        Font font = new Font("serif", 0, 10);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(40, 20));
        this.controls.add(this.tf);
        JLabel jLabel = new JLabel("ms");
        this.controls.add(jLabel);
        this.box = new JCheckBox("call gc()");
        this.box.setPreferredSize(new Dimension(80, 20));
        this.box.setSelected(true);
        this.controls.add(this.box);
        this.controls.setPreferredSize(new Dimension(100, 80));
        this.controls.setMaximumSize(new Dimension(100, 80));
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MemoryMonitor.this.removeAll();
                MemoryMonitor.this.doControls = !MemoryMonitor.this.doControls;
                if (MemoryMonitor.this.doControls) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        long l = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                        if (l >= 50L) {
                            MemoryMonitor.this.surf.sleepAmount = l;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private float freeMemory;
        private float totalMemory;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;
        private int gc_counter = 0;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Surface.this.thread == null) {
                        Surface.this.start();
                    } else {
                        Surface.this.stop();
                    }
                }
            });
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 80);
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float f = this.r.freeMemory();
            float f2 = this.r.totalMemory();
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)f2 / 1024) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)(f2 - f) / 1024) + "K used";
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float f3 = this.ascent + this.descent;
            float f4 = (float)this.h - f3 * 2.0f - 0.5f;
            float f5 = f4 / 10.0f;
            float f6 = 20.0f;
            float f7 = (float)this.w - f6 - 10.0f;
            this.big.setColor(this.mfColor);
            int n4 = (int)(f / f2 * 10.0f);
            for (n3 = 0; n3 < n4; ++n3) {
                this.mfRect.setRect(5.0, f3 + (float)n3 * f5, f6, f5 - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (n3 < 10) {
                this.muRect.setRect(5.0, f3 + (float)n3 * f5, f6, f5 - 1.0f);
                this.big.fill(this.muRect);
                ++n3;
            }
            this.big.setColor(this.graphColor);
            int n5 = 30;
            int n6 = (int)f3;
            int n7 = this.w - n5 - 5;
            int n8 = (int)f4;
            this.graphOutlineRect.setRect(n5, n6, n7, n8);
            this.big.draw(this.graphOutlineRect);
            int n9 = n8 / 10;
            for (n2 = n6; n2 <= n8 + n6; n2 += n9) {
                this.graphLine.setLine(n5, n2, n5 + n7, n2);
                this.big.draw(this.graphLine);
            }
            n2 = n7 / 15;
            if (this.columnInc == 0) {
                this.columnInc = n2;
            }
            for (n = n5 + this.columnInc; n < n7 + n5; n += n2) {
                this.graphLine.setLine(n, n6, n, n6 + n8);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[n7];
                this.ptNum = 0;
            } else if (this.pts.length != n7) {
                int[] nArray = null;
                if (this.ptNum < n7) {
                    nArray = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, nArray, 0, nArray.length);
                } else {
                    nArray = new int[n7];
                    System.arraycopy(this.pts, this.pts.length - nArray.length, nArray, 0, nArray.length);
                    this.ptNum = nArray.length - 2;
                }
                this.pts = new int[n7];
                System.arraycopy(nArray, 0, this.pts, 0, nArray.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)n6 + (float)n8 * (f / f2));
                n = n5 + n7 - this.ptNum;
                int n10 = 0;
                while (n10 < this.ptNum) {
                    if (n10 != 0) {
                        if (this.pts[n10] != this.pts[n10 - 1]) {
                            this.big.drawLine(n - 1, this.pts[n10 - 1], n, this.pts[n10]);
                        } else {
                            this.big.fillRect(n, this.pts[n10], 1, 1);
                        }
                    }
                    ++n10;
                    ++n;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    for (n = 1; n < this.ptNum; ++n) {
                        this.pts[n - 1] = this.pts[n];
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            if (this.gc_counter > 4) {
                if (this.thread != null && MemoryMonitor.this.box.isSelected() && f < 2048000.0f) {
                    this.big.setColor(Color.red);
                    this.big.fillRect(84, this.h - this.descent - 6, 4, 4);
                    System.gc();
                }
                this.gc_counter = 0;
            } else {
                ++this.gc_counter;
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            while (this.thread == thread && this.isShowing()) {
                Dimension dimension = this.getSize();
                if (dimension.width != this.w || dimension.height != this.h) {
                    this.w = dimension.width;
                    this.h = dimension.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
                    this.ascent = fontMetrics.getAscent();
                    this.descent = fontMetrics.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.thread = null;
        }
    }
}

