/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.AboutBox;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.CollectionPanel;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxItemListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.FtpChooser;
import net.sourceforge.dvb.projectx.gui.HexViewer;
import net.sourceforge.dvb.projectx.gui.Html;
import net.sourceforge.dvb.projectx.gui.MemoryMonitor;
import net.sourceforge.dvb.projectx.gui.PatchDialog;
import net.sourceforge.dvb.projectx.gui.StartUp;
import net.sourceforge.dvb.projectx.gui.TextFieldListener;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.parser.HpFix;
import net.sourceforge.dvb.projectx.parser.StripAudio;
import net.sourceforge.dvb.projectx.parser.StripRelook;
import net.sourceforge.dvb.projectx.xinput.XInputDirectory;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class MainFrame
extends JPanel {
    private static String frametitle = "";
    private static int GlobalReturnCode = 0;
    private static boolean SilentAction = true;
    private static Object[][] FileObjectTable = new Object[5][11];
    private static CollectionPanel collection_panel;
    private static JFrame frame;
    private static JComboBox comboBox_0;
    private JRadioButtonMenuItem[] lf_item = null;
    private JTable tableView;
    private JList list1;
    private JViewport viewport;
    private JTextField outfield;
    private ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    private ComboBoxItemListener _ComboBoxItemListener = new ComboBoxItemListener();
    private CheckBoxListener _CheckBoxListener = new CheckBoxListener();
    private TextFieldListener _TextFieldListener = new TextFieldListener();
    private JPopupMenu popup;
    private JFrame autoload;
    private Thread thread = null;
    private PatchDialog patch_panel;
    private static ClipboardOwner defaultClipboardOwner;
    private ActionListener _BoxListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            Common.getSettings().setBooleanProperty(string, jCheckBoxMenuItem.getState());
        }
    };
    private ActionListener _MenuListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("sendTo3")) {
                if (Common.isCollectionListEmpty()) {
                    return;
                }
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0) {
                    return;
                }
                try {
                    String string2 = Common.getSettings().getProperty(Keys.KEY_PostCommands_Cmd3);
                    if (string2.trim().length() > 0) {
                        Common.performCommand(string2 + " \"" + Common.getCollection().getInputFile(n).toString() + "\"");
                    }
                }
                catch (Exception exception) {
                    Common.setExceptionMessage(exception);
                }
            } else if (string.equals("add")) {
                CommonGui.getMainFileChooser().rescanCurrentDirectory();
                CommonGui.getMainFileChooser().setDialogType(0);
                CommonGui.getMainFileChooser().setMultiSelectionEnabled(true);
                int n = CommonGui.getMainFileChooser().showDialog(frame, null);
                if (n == 0) {
                    File[] fileArray = CommonGui.getMainFileChooser().getSelectedFiles();
                    if (fileArray == null) {
                        return;
                    }
                    if (fileArray.length == 0) {
                        fileArray = new File[]{CommonGui.getMainFileChooser().getSelectedFile()};
                    }
                    if (fileArray != null) {
                        Common.addCollection(false);
                        JobCollection jobCollection = Common.getCollection();
                        for (int i = 0; i < fileArray.length; ++i) {
                            if (!fileArray[i].isFile()) continue;
                            jobCollection.addInputFile(new XInputFile(fileArray[i].getAbsoluteFile()));
                        }
                        MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                    return;
                }
            } else if (string.equals("newOutName")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                JobCollection jobCollection = Common.getCollection();
                if (n < 0 || n >= jobCollection.getInputFilesCount()) {
                    return;
                }
                String string3 = ((XInputFile)jobCollection.getInputFiles()[0]).getName();
                String string4 = CommonGui.getUserInput(string3, Resource.getString("popup.newOutName") + " " + string3, jobCollection.getOutputName());
                if (string4 != null) {
                    jobCollection.setOutputName(string4);
                    MainFrame.this.updateOutputField(jobCollection);
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                }
            } else if (string.equals("remove")) {
                int[] nArray = MainFrame.this.tableView.getSelectedRows();
                if (nArray.length > 0) {
                    JobCollection jobCollection = Common.getCollection();
                    if (jobCollection == null) {
                        return;
                    }
                    jobCollection.removeInputFile(nArray);
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    MainFrame.this.tableView.clearSelection();
                }
            } else if (string.equals("rename")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                try {
                    if (((XInputFile)jobCollection.getInputFile(n)).rename()) {
                        MainFrame.this.reloadInputDirectories();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
            } else if (string.equals("changeTimestamp")) {
                int[] nArray = MainFrame.this.tableView.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                for (int i = 0; i < nArray.length; ++i) {
                    if (MainFrame.this.tableView.getValueAt(i, 0) == null) continue;
                    XInputFile xInputFile = (XInputFile)jobCollection.getInputFile(i);
                    if (!CommonGui.getUserConfirmation("really update the timestamp of '" + xInputFile.getName() + "' ?")) continue;
                    xInputFile.setLastModified();
                }
                MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
            } else if (string.equals("viewAsHex")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                XInputFile xInputFile = ((XInputFile)jobCollection.getInputFile(n)).getNewInstance();
                if (xInputFile != null && xInputFile.exists()) {
                    new HexViewer().view(xInputFile);
                }
            } else if (string.equals("fixHpAc3")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                XInputFile xInputFile = ((XInputFile)jobCollection.getInputFile(n)).getNewInstance();
                if (xInputFile != null && xInputFile.exists() && CommonGui.getUserConfirmation("really process '" + xInputFile.getName() + "' ?")) {
                    HpFix hpFix = new HpFix();
                    Common.setOSDMessage("fixing wrong Hp Ac3 File...");
                    xInputFile = hpFix.process(xInputFile);
                    jobCollection.removeInputFile(n);
                    if (xInputFile != null) {
                        jobCollection.addInputFile(n, xInputFile);
                    }
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    MainFrame.this.tableView.clearSelection();
                }
            } else if (string.equals("stripAudio")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                XInputFile xInputFile = ((XInputFile)jobCollection.getInputFile(n)).getNewInstance();
                if (xInputFile != null && xInputFile.exists() && xInputFile.getStreamInfo().getStreamType() == 14 && CommonGui.getUserConfirmation("really process '" + xInputFile.getName() + "' ?")) {
                    StripAudio stripAudio = new StripAudio();
                    Common.setOSDMessage("strip audio data...");
                    xInputFile = stripAudio.process(xInputFile);
                    jobCollection.removeInputFile(n);
                    if (xInputFile != null) {
                        jobCollection.addInputFile(n, xInputFile);
                    }
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    MainFrame.this.tableView.clearSelection();
                }
            } else if (string.equals("stripRelook")) {
                this.stripRelook(0);
            } else if (string.equals("stripRelook1")) {
                this.stripRelook(1);
            } else if (string.equals("editBasics")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                XInputFile xInputFile = (XInputFile)jobCollection.getInputFile(n);
                if (MainFrame.this.patch_panel == null) {
                    MainFrame.this.patch_panel = new PatchDialog(frame);
                }
                if (MainFrame.this.patch_panel.entry(xInputFile)) {
                    MainFrame.this.ScanInfo(xInputFile);
                }
            } else if (string.equals("clipboard")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                XInputFile xInputFile = (XInputFile)jobCollection.getInputFile(n);
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (clipboard != null) {
                        String string5 = xInputFile.getStreamInfo().getFullInfo();
                        StringSelection stringSelection = new StringSelection(string5);
                        clipboard.setContents(stringSelection, defaultClipboardOwner);
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("applyAction")) {
                Object[] objectArray = Keys.ITEMS_ConversionMode;
                String string6 = ((JMenuItem)actionEvent.getSource()).getText();
                int n = -1;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!string6.equals(objectArray[i].toString())) continue;
                    n = i;
                    break;
                }
                Common.getCollection().setActionType(n);
            } else if (string.equals("assignStreamtype")) {
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n < 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    return;
                }
                JobCollection jobCollection = Common.getCollection();
                XInputFile xInputFile = (XInputFile)jobCollection.getInputFile(n);
                Object[] objectArray = Keys.ITEMS_FileTypes;
                String string7 = ((JMenuItem)actionEvent.getSource()).getText();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!string7.equals(objectArray[i].toString())) continue;
                    if (xInputFile.getStreamInfo() == null) {
                        MainFrame.this.ScanInfo(xInputFile);
                    }
                    xInputFile.getStreamInfo().setStreamType(i);
                    MainFrame.this.ScanInfo(xInputFile, i);
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    return;
                }
                xInputFile.setStreamInfo(null);
                MainFrame.this.ScanInfo(xInputFile);
                MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
            } else if (string.equals("exit")) {
                Common.exitApplication(0);
            } else if (string.equals("url")) {
                Object object;
                String string8 = null;
                XInputFile xInputFile = null;
                URL uRL = null;
                block12: while (true) {
                    if ((string8 = CommonGui.getUserInput(Resource.getString("dialog.input.url"))) == null) {
                        return;
                    }
                    try {
                        uRL = new URL(string8);
                        object = uRL.getProtocol();
                        if (((String)object).equals("ftp")) {
                            XInputDirectory xInputDirectory = new XInputDirectory(uRL);
                            XInputFile[] xInputFileArray = xInputDirectory.getFiles();
                            for (int i = 0; i < xInputFileArray.length; ++i) {
                                if (!new URL(xInputFileArray[i].toString()).getFile().equals(uRL.getFile())) continue;
                                xInputFile = xInputFileArray[i];
                                break block12;
                            }
                            Common.setMessage("!> URL incorrect or not accessible: " + uRL.toString(), true);
                            continue;
                        }
                        if (((String)object).equals("file")) {
                            xInputFile = new XInputFile(new File(uRL.getHost() + uRL.getFile()));
                            break;
                        }
                        Common.setMessage("!> Protocol not yet supported: " + (String)object, true);
                        return;
                    }
                    catch (Exception exception) {
                        Common.setMessage("!> URL Exc: (" + string8 + ")");
                        Common.setExceptionMessage(exception);
                        continue;
                    }
                    break;
                }
                if (xInputFile == null) {
                    return;
                }
                Common.addCollection(false);
                object = Common.getCollection();
                ((JobCollection)object).addInputFile(xInputFile);
                MainFrame.this.updateCollectionTable(((JobCollection)object).getCollectionAsTable());
                MainFrame.updateCollectionPanel(Common.getActiveCollection());
                return;
            }
        }

        private void stripRelook(int n) {
            int n2 = MainFrame.this.tableView.getSelectedRow();
            if (n2 < 0 || MainFrame.this.tableView.getValueAt(n2, 0) == null) {
                return;
            }
            JobCollection jobCollection = Common.getCollection();
            XInputFile xInputFile = ((XInputFile)jobCollection.getInputFile(n2)).getNewInstance();
            if (xInputFile != null && xInputFile.exists() && xInputFile.getStreamInfo().getStreamType() == 1 && CommonGui.getUserConfirmation("really process '" + xInputFile.getName() + "' ?")) {
                StripRelook stripRelook = new StripRelook(n);
                Common.setOSDMessage("strip Relook\u00ae data, type " + n + "...");
                XInputFile[] xInputFileArray = stripRelook.process(xInputFile, jobCollection.getOutputDirectory());
                jobCollection.removeInputFile(n2);
                if (xInputFileArray != null) {
                    int n3 = n2;
                    for (int i = 0; i < xInputFileArray.length; ++i) {
                        if (xInputFileArray[i] == null) continue;
                        jobCollection.addInputFile(n3++, xInputFileArray[i]);
                    }
                }
                MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                MainFrame.updateCollectionPanel(Common.getActiveCollection());
                MainFrame.this.tableView.clearSelection();
            }
        }
    };

    public MainFrame(StartUp startUp) {
        frame.setBackground(new Color(200, 200, 200));
        CommonGui.setMainFrame(frame);
        this.initialize(startUp);
    }

    public static void addCollectionAtEnd() {
        SilentAction = true;
        comboBox_0.addItem(String.valueOf(comboBox_0.getItemCount()));
        comboBox_0.setSelectedIndex(comboBox_0.getItemCount() - 1);
        SilentAction = false;
    }

    private void updateOutputField(JobCollection jobCollection) {
        this.outfield.setText(jobCollection.getOutputDirectory());
        String string = jobCollection.getOutputName();
        if (string.length() > 0) {
            this.outfield.setText(this.outfield.getText() + " {" + string + "}");
            this.outfield.setBackground(new Color(255, 225, 255));
        } else {
            this.outfield.setBackground(new Color(225, 255, 225));
        }
    }

    private void updateCollectionTable(Object[][] objectArray) {
        FileObjectTable = objectArray == null ? new Object[5][11] : objectArray;
        this.tableView.clearSelection();
        this.tableView.revalidate();
        this.tableView.repaint();
    }

    private void updateAutoloadList(Object[] objectArray) {
        this.list1.setListData(objectArray);
    }

    private void buildGUI(StartUp startUp) {
        this.setLayout(new BoxLayout(this, 1));
        this.showStartUpProgress(startUp, 10, "Loading Menus...");
        this.buildMenus();
        this.showStartUpProgress(startUp, 20, "Loading Popup Menus...");
        this.buildPopupMenu();
        this.showStartUpProgress(startUp, 30, "Loading Quickload Panel...");
        this.buildAutoloadPanel();
        this.showStartUpProgress(startUp, 40, "Loading Control Panel...");
        this.add(this.buildMainPanel());
        this.showStartUpProgress(startUp, 50, "Loading Status Panel...");
        this.add((Component)this.buildStatusPanel(), "South");
        this.add(Box.createRigidArea(new Dimension(1, 5)));
    }

    protected void buildPopupMenu() {
        JMenuItem jMenuItem;
        this.popup = new JPopupMenu(Resource.getString("popup.what"));
        JMenuItem jMenuItem2 = this.popup.add(Resource.getString("popup.url"));
        jMenuItem2.setActionCommand("url");
        JMenuItem jMenuItem3 = this.popup.add(Resource.getString("popup.rename"));
        jMenuItem3.setActionCommand("rename");
        JMenuItem jMenuItem4 = this.popup.add(Resource.getString("popup.openhex"));
        jMenuItem4.setActionCommand("viewAsHex");
        JMenuItem jMenuItem5 = this.popup.add(Resource.getString("popup.patchbasics"));
        jMenuItem5.setActionCommand("editBasics");
        JMenuItem jMenuItem6 = this.popup.add(Resource.getString("popup.sendtocl3"));
        jMenuItem6.setActionCommand("sendTo3");
        this.popup.addSeparator();
        JMenuItem jMenuItem7 = this.popup.add(Resource.getString("popup.changeTimestamp"));
        jMenuItem7.setActionCommand("changeTimestamp");
        JMenuItem jMenuItem8 = this.popup.add(Resource.getString("popup.fixHpAc3"));
        jMenuItem8.setActionCommand("fixHpAc3");
        JMenuItem jMenuItem9 = this.popup.add(Resource.getString("popup.stripAudio"));
        jMenuItem9.setActionCommand("stripAudio");
        JMenuItem jMenuItem10 = this.popup.add("strip Relook\u00ae type 0 to separate pes..");
        jMenuItem10.setActionCommand("stripRelook");
        JMenuItem jMenuItem11 = this.popup.add("strip Relook\u00ae type 1 to separate pes..");
        jMenuItem11.setActionCommand("stripRelook1");
        this.popup.addSeparator();
        JMenuItem jMenuItem12 = this.popup.add(Resource.getString("popup.copyInfoToClipboard"));
        jMenuItem12.setActionCommand("clipboard");
        Object[] objectArray = Keys.ITEMS_FileTypes;
        JMenu jMenu = new JMenu(Resource.getString("popup.assignStreamType"));
        for (int i = 0; i <= objectArray.length; ++i) {
            jMenuItem = new JMenuItem(i == objectArray.length ? Resource.getString("popup.automatic") : objectArray[i].toString());
            jMenuItem.setActionCommand("assignStreamtype");
            jMenuItem.addActionListener(this._MenuListener);
            if (i == objectArray.length) {
                jMenu.addSeparator();
            }
            jMenu.add(jMenuItem);
        }
        this.popup.add(jMenu);
        this.popup.addSeparator();
        JMenuItem jMenuItem13 = this.popup.add(Resource.getString("popup.newOutName"));
        jMenuItem13.setActionCommand("newOutName");
        objectArray = Keys.ITEMS_ConversionMode;
        jMenuItem = new JMenu(Resource.getString("popup.assignActionType"));
        for (int i = -1; i < objectArray.length; ++i) {
            JMenuItem jMenuItem14 = new JMenuItem(i < 0 ? Resource.getString("popup.unspecified") : objectArray[i].toString());
            jMenuItem14.setActionCommand("applyAction");
            jMenuItem14.addActionListener(this._MenuListener);
            if (i == 0) {
                ((JMenu)jMenuItem).addSeparator();
            }
            ((JMenu)jMenuItem).add(jMenuItem14);
        }
        this.popup.add(jMenuItem);
        this.popup.pack();
        UIManager.addPropertyChangeListener(new UISwitchListener(this.popup));
        jMenuItem3.addActionListener(this._MenuListener);
        jMenuItem4.addActionListener(this._MenuListener);
        jMenuItem5.addActionListener(this._MenuListener);
        jMenuItem6.addActionListener(this._MenuListener);
        jMenuItem2.addActionListener(this._MenuListener);
        jMenuItem13.addActionListener(this._MenuListener);
        jMenuItem7.addActionListener(this._MenuListener);
        jMenuItem12.addActionListener(this._MenuListener);
        jMenuItem8.addActionListener(this._MenuListener);
        jMenuItem9.addActionListener(this._MenuListener);
        jMenuItem10.addActionListener(this._MenuListener);
        jMenuItem11.addActionListener(this._MenuListener);
    }

    protected void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildViewerMenu());
        jMenuBar.add(this.buildGeneralMenu());
        jMenuBar.add(this.buildPreferencesMenu());
        jMenuBar.add(this.buildLanguageMenu());
        jMenuBar.add(this.buildAddonMenu());
        jMenuBar.add(this.buildHelpMenu());
        frame.setJMenuBar(jMenuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "file.add");
        jMenuItem.setActionCommand("add");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem jMenuItem2 = new JMenuItem();
        CommonGui.localize(jMenuItem2, "file.url");
        jMenuItem2.setActionCommand("url");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        JMenuItem jMenuItem3 = new JMenuItem();
        CommonGui.localize(jMenuItem3, "file.remove");
        jMenuItem3.setActionCommand("remove");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        JMenuItem jMenuItem4 = new JMenuItem();
        CommonGui.localize(jMenuItem4, "file.rename");
        jMenuItem4.setActionCommand("rename");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        JMenuItem jMenuItem5 = new JMenuItem();
        CommonGui.localize(jMenuItem5, "Common.Exit");
        jMenuItem5.setActionCommand("exit");
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenuItem2.addActionListener(this._MenuListener);
        jMenuItem.addActionListener(this._MenuListener);
        jMenuItem3.addActionListener(this._MenuListener);
        jMenuItem4.addActionListener(this._MenuListener);
        jMenuItem5.addActionListener(this._MenuListener);
        return jMenu;
    }

    protected JMenu buildSettingsMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "settings.menu");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "settings.settings");
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected JMenu buildPreferencesMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Preferences");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.Preferences");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.getGuiInterface().showPreSettings();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Resource.getString(Keys.KEY_SaveSettingsOnExit[0]));
        jCheckBoxMenuItem.setActionCommand(Keys.KEY_SaveSettingsOnExit[0]);
        jCheckBoxMenuItem.setState(Common.getSettings().getBooleanProperty(Keys.KEY_SaveSettingsOnExit));
        jCheckBoxMenuItem.addActionListener(this._BoxListener);
        jMenu.add(jCheckBoxMenuItem);
        return jMenu;
    }

    protected JMenu buildGeneralMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "general.menu");
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        this.lf_item = new JRadioButtonMenuItem[lookAndFeelInfoArray.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                Common.getSettings().setProperty(Keys.KEY_LookAndFeel[0], string);
                MainFrame.this.setLookAndFeel(string);
            }
        };
        for (int i = 0; i < this.lf_item.length; ++i) {
            this.lf_item[i] = new JRadioButtonMenuItem(lookAndFeelInfoArray[i].getClassName());
            jMenu.add(this.lf_item[i]);
            buttonGroup.add(this.lf_item[i]);
            this.lf_item[i].addActionListener(actionListener);
        }
        this.setLookAndFeel(Common.getSettings().getProperty(Keys.KEY_LookAndFeel));
        return jMenu;
    }

    private void setLookAndFeel(String string) {
        if (string != null && !string.equals("")) {
            Component component = null;
            try {
                for (int i = 0; i < this.lf_item.length; ++i) {
                    if (!this.lf_item[i].getActionCommand().equals(string)) continue;
                    this.lf_item[i].setSelected(true);
                    component = this.lf_item[i];
                }
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(frame);
                if (CommonGui.getMainFileChooser() != null) {
                    SwingUtilities.updateComponentTreeUI(CommonGui.getMainFileChooser());
                }
            }
            catch (Exception exception) {
                component.getParent().remove(component);
                System.err.println("!> Could not load LookAndFeel: " + string);
                Common.setErrorMessage("!> Could not load LookAndFeel: " + string);
            }
        }
    }

    protected JMenu buildViewerMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "options.menu");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "options.openhexview");
        jMenuItem.setActionCommand("viewAsHex");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem();
        CommonGui.localize(jMenuItem2, "options.pachtbasics");
        jMenuItem2.setActionCommand("editBasics");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem();
        CommonGui.localize(jMenuItem3, "options.subtitlepreview");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.getGuiInterface().showSubpicture();
            }
        });
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem();
        CommonGui.localize(jMenuItem4, "options.teletext");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.getGuiInterface().showTtxPageMatrix();
            }
        });
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        jMenu.add(jMenuItem4);
        jMenuItem.addActionListener(this._MenuListener);
        jMenuItem2.addActionListener(this._MenuListener);
        return jMenu;
    }

    protected JMenu buildLanguageMenu() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("check")) {
                    new Html("http://project-x.sourceforge.net/optional/resources/").show();
                    return;
                }
                if (string.equals("system")) {
                    Resource.setChosenLanguage(null);
                } else {
                    Resource.setChosenLanguage(string);
                }
                CommonGui.showMessageDialog(Resource.getString("msg.new.language"), Resource.getString("msg.infomessage"));
            }
        };
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "language.menu");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "language.check");
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setActionCommand("check");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        CommonGui.localize(jRadioButtonMenuItem, "language.system");
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setSelected(Resource.getChosenLanguage() == null);
        jRadioButtonMenuItem.setActionCommand("system");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.addSeparator();
        Locale[] localeArray = Resource.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            Locale locale = localeArray[i];
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(locale.getLanguage());
            jRadioButtonMenuItem2.addActionListener(actionListener);
            if (Resource.getChosenLanguage() != null) {
                jRadioButtonMenuItem2.setSelected(locale.getLanguage().equals(Resource.getChosenLanguage()));
            }
            jRadioButtonMenuItem2.setActionCommand(locale.getLanguage());
            jMenu.add(jRadioButtonMenuItem2);
            buttonGroup.add(jRadioButtonMenuItem2);
        }
        return jMenu;
    }

    protected JMenu buildAddonMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Addons");
        jMenu.add(new JMenuItem("available components:"));
        jMenu.addSeparator();
        if (Common.canAccessFtp()) {
            jMenu.add(new JMenuItem("commons-net library (FTP access)"));
        }
        if (Common.canAccessRawRead()) {
            jMenu.add(new JMenuItem("rawread dll (ext. disk access)"));
        }
        if (Common.getMpvDecoderClass().isAccelerated()) {
            jMenu.add(new JMenuItem("accelerated preview (ext. IDCT)"));
        }
        if (Common.canAccessColorTable()) {
            jMenu.add(new JMenuItem("color tables (DVB subpicture)"));
        }
        if (Common.canAccessSilentAC3()) {
            jMenu.add(new JMenuItem("silent AC3 frames (replacements)"));
        }
        return jMenu;
    }

    protected JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "help.menu");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "help.about");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutBox(frame);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        CommonGui.localize(jMenuItem2, "help.help");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Html().show();
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke("F1"));
        JMenuItem jMenuItem3 = new JMenuItem();
        CommonGui.localize(jMenuItem3, "help.version");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.checkVersion();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    protected JScrollPane createTable() {
        final String[] stringArray = new String[]{"#", Resource.getString("CollectionTable.Source"), Resource.getString("CollectionTable.FileName"), Resource.getString("CollectionTable.FileLocation"), Resource.getString("CollectionTable.Size"), Resource.getString("CollectionTable.lastModified"), Resource.getString("ScanInfo.Video").substring(0, 1), Resource.getString("ScanInfo.Audio").substring(0, 1), Resource.getString("ScanInfo.Teletext").substring(0, 1), Resource.getString("ScanInfo.Subpicture").substring(0, 1), Resource.getString("CollectionTable.Streamtype")};
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return stringArray.length;
            }

            public int getRowCount() {
                return FileObjectTable.length;
            }

            public Object getValueAt(int n, int n2) {
                return FileObjectTable[n][n2];
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                Object object = this.getValueAt(0, n);
                if (object == null) {
                    return String.class;
                }
                return object.getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                FileObjectTable[n][n2] = object;
            }
        };
        this.tableView = new JTable(abstractTableModel);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        defaultTableCellRenderer2.setHorizontalAlignment(0);
        this.tableView.setRowHeight(15);
        this.tableView.setGridColor(new Color(220, 220, 220));
        this.tableView.removeEditor();
        this.tableView.setToolTipText(Resource.getString("FilePanel.DragDrop.Tip"));
        this.tableView.setSelectionMode(2);
        this.tableView.setSelectionBackground(new Color(220, 220, 255));
        this.tableView.setSelectionForeground(Color.black);
        this.tableView.getColumn("#").setCellRenderer(defaultTableCellRenderer2);
        this.tableView.getColumn("#").setMaxWidth(20);
        this.tableView.getColumn(stringArray[1]).setCellRenderer(defaultTableCellRenderer2);
        this.tableView.getColumn(stringArray[1]).setMinWidth(32);
        this.tableView.getColumn(stringArray[1]).setMaxWidth(32);
        this.tableView.getColumn(stringArray[2]).setPreferredWidth(200);
        this.tableView.getColumn(stringArray[3]).setPreferredWidth(200);
        this.tableView.getColumn(stringArray[4]).setCellRenderer(defaultTableCellRenderer);
        this.tableView.getColumn(stringArray[4]).setMinWidth(62);
        this.tableView.getColumn(stringArray[4]).setMaxWidth(62);
        this.tableView.getColumn(stringArray[5]).setCellRenderer(defaultTableCellRenderer2);
        this.tableView.getColumn(stringArray[5]).setMinWidth(96);
        this.tableView.getColumn(stringArray[5]).setMaxWidth(96);
        for (int i = 6; i < 10; ++i) {
            this.tableView.getColumn(stringArray[i]).setCellRenderer(defaultTableCellRenderer2);
            this.tableView.getColumn(stringArray[i]).setMinWidth(16);
            this.tableView.getColumn(stringArray[i]).setMaxWidth(16);
        }
        this.tableView.getColumn(stringArray[10]).setMinWidth(90);
        this.tableView.sizeColumnsToFit(3);
        this.tableView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 1) {
                    return;
                }
                int n = MainFrame.this.tableView.getSelectedRow();
                if (n >= 0 && MainFrame.this.tableView.getValueAt(n, 0) == null) {
                    n = -1;
                }
                int n2 = Common.getActiveCollection();
                if (mouseEvent.getModifiers() == 4) {
                    int n3;
                    MenuElement[] menuElementArray = MainFrame.this.popup.getSubElements();
                    if (menuElementArray == null) {
                        return;
                    }
                    for (n3 = 1; n3 < 12; ++n3) {
                        menuElementArray[n3].getComponent().setEnabled(n >= 0);
                    }
                    for (n3 = 12; n3 < menuElementArray.length; ++n3) {
                        menuElementArray[n3].getComponent().setEnabled(n2 >= 0);
                    }
                    MainFrame.this.popup.show(MainFrame.this.tableView, mouseEvent.getX(), mouseEvent.getY() - MainFrame.this.popup.getHeight());
                } else if (n >= 0) {
                    MainFrame.this.ScanInfo((XInputFile)Common.getCollection(n2).getInputFile(n));
                }
                if (mouseEvent.getClickCount() >= 2 && mouseEvent.getModifiers() == 16) {
                    Common.getGuiInterface().showPreSettings();
                }
            }
        });
        DropTargetListener dropTargetListener = new DropTargetListener(){

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    Object object;
                    int n = dropTargetDropEvent.getDropAction();
                    if (n == 0 || n > 2) {
                        dropTargetDropEvent.rejectDrop();
                        return;
                    }
                    dropTargetDropEvent.acceptDrop(n);
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                    ArrayList<Object> arrayList = null;
                    Object object2 = transferable.getTransferData(dataFlavorArray[0]);
                    try {
                        arrayList = (ArrayList<Object>)object2;
                    }
                    catch (Exception exception) {
                        try {
                            URL uRL = (URL)object2;
                            object = new File(uRL.getFile());
                            arrayList = new ArrayList();
                            arrayList.add(object);
                        }
                        catch (Exception exception2) {
                            dropTargetDropEvent.dropComplete(true);
                            return;
                        }
                    }
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        arrayList2.add(new XInputFile((File)arrayList.get(i)));
                    }
                    arrayList = arrayList2;
                    if (n == 1) {
                        Object[] objectArray = arrayList.toArray();
                        for (int i = 0; i < objectArray.length; ++i) {
                            JobCollection jobCollection = Common.addCollection();
                            jobCollection.addInputFile(objectArray[i]);
                            MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                        }
                    } else if (n == 2) {
                        Common.addCollection(false);
                        Object[] objectArray = arrayList.toArray();
                        if (objectArray.length > 0) {
                            object = Common.getCollection(comboBox_0.getSelectedIndex());
                            ((JobCollection)object).addInputFile(objectArray);
                            MainFrame.this.updateCollectionTable(((JobCollection)object).getCollectionAsTable());
                        }
                    }
                    dropTargetDropEvent.dropComplete(true);
                    if (arrayList.size() > 0) {
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                }
                catch (Exception exception) {
                    dropTargetDropEvent.dropComplete(false);
                    Common.setExceptionMessage(exception);
                }
                MainFrame.this.tableView.setBackground(Color.white);
            }

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                MainFrame.this.tableView.setBackground(Color.green);
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
                MainFrame.this.tableView.setBackground(Color.white);
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }
        };
        DropTarget dropTarget = new DropTarget(this.tableView, dropTargetListener);
        JScrollPane jScrollPane = new JScrollPane(this.tableView);
        return jScrollPane;
    }

    protected JPanel buildFilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        JButton jButton = new JButton(CommonGui.loadIcon("fwd_10.gif"));
        jButton.setPreferredSize(new Dimension(30, 22));
        jButton.setMaximumSize(new Dimension(30, 22));
        jButton.setToolTipText(Resource.getString("FilePanel.openAutoloadPanel.Tip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.autoload.setState(0);
                MainFrame.this.autoload.show();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(CommonGui.loadIcon("add.gif"));
        jButton2.setPreferredSize(new Dimension(30, 22));
        jButton2.setMaximumSize(new Dimension(30, 22));
        jButton2.setToolTipText(Resource.getString("FilePanel.FileAdd.Tip"));
        jButton2.setActionCommand("add");
        jButton2.addActionListener(this._MenuListener);
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(CommonGui.loadIcon("rem.gif"));
        jButton3.setPreferredSize(new Dimension(30, 22));
        jButton3.setMaximumSize(new Dimension(30, 22));
        jButton3.setToolTipText(Resource.getString("FilePanel.FileRemove.Tip"));
        jButton3.setActionCommand("remove");
        jButton3.addActionListener(this._MenuListener);
        jPanel.add(jButton3);
        JButton jButton4 = new JButton(CommonGui.loadIcon("up.gif"));
        jButton4.setPreferredSize(new Dimension(30, 22));
        jButton4.setMaximumSize(new Dimension(30, 22));
        jButton4.setToolTipText(Resource.getString("FilePanel.FileUp.Tip"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = MainFrame.this.tableView.getSelectedRows();
                if (nArray.length > 0) {
                    JobCollection jobCollection = Common.getCollection(comboBox_0.getSelectedIndex());
                    if (jobCollection == null) {
                        return;
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        int n = nArray[i];
                        if (n <= 0 || MainFrame.this.tableView.getValueAt(n, 0) == null) continue;
                        Object object = jobCollection.removeInputFile(n);
                        jobCollection.addInputFile(n - 1, object);
                        nArray[i] = n - 1;
                    }
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                }
            }
        });
        jPanel.add(jButton4);
        JButton jButton5 = new JButton(CommonGui.loadIcon("dn.gif"));
        jButton5.setPreferredSize(new Dimension(30, 22));
        jButton5.setMaximumSize(new Dimension(30, 22));
        jButton5.setToolTipText(Resource.getString("FilePanel.FileDown.Tip"));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = MainFrame.this.tableView.getSelectedRows();
                if (nArray.length > 0) {
                    JobCollection jobCollection = Common.getCollection(comboBox_0.getSelectedIndex());
                    if (jobCollection == null) {
                        return;
                    }
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        int n = nArray[i];
                        if (n >= jobCollection.getInputFilesCount() - 1 || MainFrame.this.tableView.getValueAt(n, 0) == null) continue;
                        Object object = jobCollection.removeInputFile(n);
                        jobCollection.addInputFile(n + 1, object);
                        nArray[i] = n + 1;
                    }
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                }
            }
        });
        jPanel.add(jButton5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel(Resource.getString("FilePanel.OutputDirectory")));
        jPanel2.add(Box.createRigidArea(new Dimension(6, 1)));
        this.outfield = new JTextField();
        this.outfield.setBackground(new Color(225, 255, 225));
        this.outfield.setMaximumSize(new Dimension(280, 20));
        this.outfield.setMinimumSize(new Dimension(280, 20));
        this.outfield.setEditable(false);
        this.outfield.setToolTipText(Resource.getString("FilePanel.OutputDirectory.Tip"));
        jPanel2.add(this.outfield);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 1)));
        jPanel2.add(new JLabel(Resource.getString("FilePanel.recentOutputDirectories")));
        jPanel2.add(Box.createRigidArea(new Dimension(6, 1)));
        final JComboBox<Object> jComboBox = new JComboBox<Object>(Common.getSettings().getOutputDirectories().toArray());
        jComboBox.setMinimumSize(new Dimension(280, 20));
        jComboBox.setMaximumSize(new Dimension(280, 20));
        jComboBox.setMaximumRowCount(8);
        jComboBox.insertItemAt(Resource.getString("working.output.std"), 0);
        jComboBox.setSelectedItem(Common.getSettings().getProperty(Keys.KEY_OutputDirectory));
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox.getItemCount() > 1) {
                    if (jComboBox.getSelectedIndex() == 0) {
                        Common.getSettings().remove(Keys.KEY_OutputDirectory[0]);
                    } else {
                        Common.getSettings().setProperty(Keys.KEY_OutputDirectory[0], jComboBox.getSelectedItem());
                    }
                    if (comboBox_0.getItemCount() > 0) {
                        Common.setActiveCollection(comboBox_0.getSelectedIndex());
                        JobCollection jobCollection = Common.getCollection();
                        jobCollection.setOutputDirectory(Common.getSettings().getProperty(Keys.KEY_OutputDirectory));
                        MainFrame.this.updateOutputField(jobCollection);
                        MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    }
                } else {
                    Common.getSettings().remove(Keys.KEY_OutputDirectory[0]);
                    if (comboBox_0.getItemCount() > 0) {
                        Common.setActiveCollection(comboBox_0.getSelectedIndex());
                        JobCollection jobCollection = Common.getCollection();
                        jobCollection.setOutputDirectory(Common.getSettings().getProperty(Keys.KEY_OutputDirectory));
                        MainFrame.this.updateOutputField(jobCollection);
                        MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    }
                }
            }
        });
        JButton jButton6 = new JButton(CommonGui.loadIcon("add.gif"));
        jButton6.setMinimumSize(new Dimension(24, 20));
        jButton6.setMaximumSize(new Dimension(24, 20));
        jButton6.setToolTipText(Resource.getString("FilePanel.addRecentOutputDirectory.Tip"));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonGui.getMainFileChooser().rescanCurrentDirectory();
                CommonGui.getMainFileChooser().setDialogType(0);
                CommonGui.getMainFileChooser().setFileSelectionMode(2);
                int n = CommonGui.getMainFileChooser().showDialog(frame, null);
                if (n == 0) {
                    File file = CommonGui.getMainFileChooser().getSelectedFile();
                    String string = "";
                    if (file != null) {
                        if (file.isFile()) {
                            string = file.getParent();
                        } else if (file.isDirectory()) {
                            string = file.getAbsolutePath();
                        }
                        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
                            if (!string.equalsIgnoreCase(jComboBox.getItemAt(i).toString())) continue;
                            return;
                        }
                        Common.getSettings().addOutputDirectory(string);
                        jComboBox.addItem(string);
                        jComboBox.setSelectedItem(string);
                    }
                }
            }
        });
        JButton jButton7 = new JButton(CommonGui.loadIcon("rem.gif"));
        jButton7.setMinimumSize(new Dimension(24, 20));
        jButton7.setMaximumSize(new Dimension(24, 20));
        jButton7.setToolTipText(Resource.getString("FilePanel.removeRecentOutputDirectory.Tip"));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox.getItemCount() > 1) {
                    int n = jComboBox.getSelectedIndex();
                    if (n > 0) {
                        Common.getSettings().removeOutputDirectory(n - 1);
                        jComboBox.removeItemAt(n);
                    } else {
                        Common.setOSDErrorMessage("Eintrag kann nicht entfernt werden..");
                    }
                }
                if (jComboBox.getItemCount() <= 1) {
                    Common.getSettings().remove(Keys.KEY_OutputDirectory[0]);
                }
            }
        });
        jPanel2.add(jButton6);
        jPanel2.add(jButton7);
        jPanel2.add(jComboBox);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setAlignmentX(0.5f);
        jPanel3.add((Component)this.createTable(), "Center");
        jPanel3.add((Component)jPanel2, "South");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setAlignmentX(0.5f);
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel, "West");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 1));
        jPanel5.setBorder(BorderFactory.createEtchedBorder());
        jPanel5.add(jPanel4);
        jPanel5.setPreferredSize(new Dimension(900, 114));
        jPanel5.setMaximumSize(new Dimension(900, 114));
        jPanel5.setMinimumSize(new Dimension(900, 114));
        return jPanel5;
    }

    private void closeAutoloadPanel() {
        this.autoload.dispose();
    }

    protected void buildAutoloadPanel() {
        this.autoload = new JFrame(Resource.getString("autoload.title"));
        this.autoload.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.closeAutoloadPanel();
            }
        });
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.closeAutoloadPanel();
            }
        });
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu();
        CommonGui.localize(jMenu2, "Common.Edit");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Resource.getString(Keys.KEY_InputDirectoriesDepth[0]));
        jCheckBoxMenuItem.setToolTipText(Resource.getString(Keys.KEY_InputDirectoriesDepth[0]) + ".Tip");
        jCheckBoxMenuItem.setActionCommand(Keys.KEY_InputDirectoriesDepth[0]);
        jCheckBoxMenuItem.setState(Common.getSettings().getBooleanProperty(Keys.KEY_InputDirectoriesDepth));
        jCheckBoxMenuItem.addActionListener(this._BoxListener);
        jMenu2.add(jCheckBoxMenuItem);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.autoload.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        final JComboBox<Object> jComboBox = new JComboBox<Object>(Common.getSettings().getListProperty("Application.InputDirectories.").toArray());
        jComboBox.setMaximumRowCount(8);
        jComboBox.setPreferredSize(new Dimension(400, 24));
        JButton jButton = new JButton(CommonGui.loadIcon("rem.gif"));
        jButton.setPreferredSize(new Dimension(50, 28));
        jButton.setMaximumSize(new Dimension(50, 28));
        jButton.setToolTipText(Resource.getString("autoload.dir.remove.tip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jComboBox.getItemCount() > 0) {
                    int n = jComboBox.getSelectedIndex();
                    Common.getSettings().removeInputDirectory(n);
                    Common.getSettings().updateInputDirectories();
                    jComboBox.removeItemAt(n);
                }
                MainFrame.this.reloadInputDirectories();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(CommonGui.loadIcon("add.gif"));
        jButton2.setPreferredSize(new Dimension(50, 28));
        jButton2.setMaximumSize(new Dimension(50, 24));
        jButton2.setToolTipText(Resource.getString("autoload.dir.add.tip"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonGui.getMainFileChooser().rescanCurrentDirectory();
                CommonGui.getMainFileChooser().setDialogType(0);
                CommonGui.getMainFileChooser().setFileSelectionMode(2);
                int n = CommonGui.getMainFileChooser().showDialog(frame, null);
                if (n == 0) {
                    File file = CommonGui.getMainFileChooser().getSelectedFile();
                    if (file != null) {
                        String string;
                        if (file.isFile()) {
                            file = file.getParentFile();
                        }
                        if ((string = Common.getSettings().addInputDirectory(file.getAbsoluteFile())) != null) {
                            Common.getSettings().updateInputDirectories();
                            jComboBox.addItem(string);
                            jComboBox.setSelectedItem(string);
                        }
                        MainFrame.this.reloadInputDirectories();
                    }
                    MainFrame.this.autoload.toFront();
                    return;
                }
                MainFrame.this.autoload.toFront();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(CommonGui.loadIcon("ftp.gif"));
        jButton3.setPreferredSize(new Dimension(50, 28));
        jButton3.setMaximumSize(new Dimension(50, 24));
        jButton3.setToolTipText(Resource.getString("autoload.ftp.add.tip"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FtpChooser ftpChooser = new FtpChooser();
                ftpChooser.pack();
                ftpChooser.show();
                XInputDirectory xInputDirectory = ftpChooser.getXInputDirectory();
                if (ftpChooser.isTested() && xInputDirectory != null) {
                    String string = Common.getSettings().addInputDirectory(xInputDirectory);
                    if (string != null) {
                        Common.getSettings().updateInputDirectories();
                        jComboBox.addItem(string);
                        jComboBox.setSelectedItem(string);
                    }
                    MainFrame.this.reloadInputDirectories();
                }
                MainFrame.this.autoload.setState(0);
                MainFrame.this.autoload.toFront();
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = new JButton(CommonGui.loadIcon("rf.gif"));
        jButton4.setPreferredSize(new Dimension(50, 28));
        jButton4.setMaximumSize(new Dimension(50, 28));
        jButton4.setToolTipText(Resource.getString("autoload.dir.refresh.tip"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.reloadInputDirectories();
            }
        });
        jPanel.add(jButton4);
        jPanel.add(new JLabel(" "));
        JButton jButton5 = new JButton(CommonGui.loadIcon("addleft.gif"));
        jButton5.setPreferredSize(new Dimension(50, 28));
        jButton5.setMaximumSize(new Dimension(50, 28));
        jButton5.setToolTipText(Resource.getString("autoload.add.coll.tip"));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = MainFrame.this.list1.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    JobCollection jobCollection = Common.addCollection();
                    jobCollection.addInputFile(objectArray[i]);
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                }
                if (objectArray.length > 0) {
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                }
                MainFrame.this.autoload.toFront();
            }
        });
        jPanel.add(jButton5);
        JButton jButton6 = new JButton(CommonGui.loadIcon("left.gif"));
        jButton6.setPreferredSize(new Dimension(50, 28));
        jButton6.setMaximumSize(new Dimension(50, 28));
        jButton6.setToolTipText(Resource.getString("autoload.add.file.tip"));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = MainFrame.this.list1.getSelectedValues();
                if (objectArray.length > 0) {
                    Common.addCollection(false);
                    JobCollection jobCollection = Common.getCollection(comboBox_0.getSelectedIndex());
                    jobCollection.addInputFile(objectArray);
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    MainFrame.this.autoload.toFront();
                }
            }
        });
        jPanel.add(jButton6);
        jPanel.add(new JLabel(" "));
        JButton jButton7 = new JButton(CommonGui.loadIcon("x.gif"));
        jButton7.setPreferredSize(new Dimension(50, 28));
        jButton7.setMaximumSize(new Dimension(50, 28));
        jButton7.setToolTipText(Resource.getString("autoload.close"));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.closeAutoloadPanel();
            }
        });
        jPanel.add(jButton7);
        this.list1 = new JList<Object>(new Object[0]);
        this.list1.setName("inl");
        this.list1.setVisibleRowCount(8);
        this.list1.setSelectionMode(2);
        this.list1.setToolTipText(Resource.getString("autoload.rename.tip"));
        this.list1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = MainFrame.this.list1.locationToIndex(mouseEvent.getPoint());
                if (mouseEvent.getClickCount() > 1) {
                    if (mouseEvent.getModifiers() == 4 && n > -1) {
                        try {
                            if (((XInputFile)MainFrame.this.list1.getSelectedValue()).rename()) {
                                MainFrame.this.reloadInputDirectories();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        MainFrame.this.autoload.toFront();
                    } else if (mouseEvent.getModifiers() == 16 && n > -1) {
                        Common.addCollection(false);
                        Object[] objectArray = MainFrame.this.list1.getSelectedValues();
                        if (objectArray.length > 0) {
                            JobCollection jobCollection = Common.getCollection(comboBox_0.getSelectedIndex());
                            jobCollection.addInputFile(objectArray);
                            MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                            MainFrame.updateCollectionPanel(Common.getActiveCollection());
                        }
                        MainFrame.this.autoload.toFront();
                    }
                } else if (mouseEvent.getClickCount() == 1 && MainFrame.this.list1.getSelectedValue() != null) {
                    MainFrame.this.ScanInfo((XInputFile)MainFrame.this.list1.getSelectedValue());
                }
            }
        });
        this.list1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    Common.addCollection(false);
                    Object[] objectArray = MainFrame.this.list1.getSelectedValues();
                    if (objectArray.length > 0) {
                        JobCollection jobCollection = Common.getCollection(comboBox_0.getSelectedIndex());
                        jobCollection.addInputFile(objectArray);
                        MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                    MainFrame.this.autoload.toFront();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.list1);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setAlignmentX(0.5f);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add(jComboBox, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setAlignmentX(0.5f);
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jPanel, "West");
        this.autoload.getContentPane().add(jPanel3);
        UIManager.addPropertyChangeListener(new UISwitchListener(jPanel3));
        this.autoload.setBounds(200, 200, 700, 350);
    }

    protected JPanel buildMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ColumnLayout());
        MemoryMonitor memoryMonitor = new MemoryMonitor();
        if (Common.showGUI()) {
            memoryMonitor.surf.start();
        }
        jPanel.add((Component)memoryMonitor, "North");
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        jPanel.add(Box.createRigidArea(new Dimension(1, 54)));
        jPanel.add(this.buildProcessControlPanel());
        jPanel.add(this.buildCollectionControlPanel());
        jPanel.setPreferredSize(new Dimension(115, 468));
        jPanel.setMaximumSize(new Dimension(115, 468));
        jPanel.setMinimumSize(new Dimension(115, 468));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add((Component)jPanel, "West");
        collection_panel = new CollectionPanel();
        jPanel2.add((Component)collection_panel, "Center");
        jPanel2.setPreferredSize(new Dimension(900, 468));
        jPanel2.setMaximumSize(new Dimension(900, 468));
        jPanel2.setMinimumSize(new Dimension(900, 468));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)this.buildFilePanel(), "South");
        return jPanel3;
    }

    protected JRootPane buildFilePanel1() {
        JRootPane jRootPane = new JRootPane();
        jRootPane.getContentPane().add(this.buildFilePanel());
        return jRootPane;
    }

    protected JPanel buildProcessControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("MainPanel.Process")));
        JButton jButton = new JButton(Resource.getString("MainPanel.QuickStart"));
        jButton.setToolTipText(Resource.getString("MainPanel.QuickStart.Tip"));
        jButton.setMnemonic('q');
        jButton.setPreferredSize(new Dimension(100, 24));
        jButton.setMaximumSize(new Dimension(100, 24));
        jButton.setMinimumSize(new Dimension(100, 24));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Common.startProcess()) {
                    Common.startMainProcess();
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        JButton jButton2 = new JButton(Resource.getString("ProcessWindowPanel.Button"));
        jButton2.setPreferredSize(new Dimension(100, 24));
        jButton2.setMaximumSize(new Dimension(100, 24));
        jButton2.setMinimumSize(new Dimension(100, 24));
        jButton2.setToolTipText(Resource.getString("MainPanel.Process") + " " + Resource.getString("ProcessWindowPanel.Button"));
        jButton2.setMnemonic('p');
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.getGuiInterface().showLogWindow();
            }
        });
        jPanel.add(jButton2);
        return jPanel;
    }

    protected JPanel buildCollectionControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("MainPanel.Collection")));
        final Color color = new Color(230, 230, 230);
        final Color color2 = new Color(245, 215, 215);
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setToolTipText(Resource.getString("FilePanel.Textfield.Tip"));
        jTextArea.setBackground(color);
        jTextArea.setFont(new Font("Tahoma", 0, 11));
        jTextArea.setEditable(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.setPreferredSize(new Dimension(100, 138));
        jPanel2.setMaximumSize(new Dimension(100, 138));
        jPanel2.setMinimumSize(new Dimension(100, 138));
        jPanel2.add(jTextArea);
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Resource.getString("FilePanel.CollectionNumber"));
        jLabel.setPreferredSize(new Dimension(50, 24));
        jLabel.setMaximumSize(new Dimension(50, 24));
        jLabel.setHorizontalAlignment(0);
        jLabel.setToolTipText(Resource.getString("FilePanel.CollectionNumber.Tip"));
        comboBox_0 = new JComboBox();
        comboBox_0.setPreferredSize(new Dimension(50, 24));
        comboBox_0.setMaximumSize(new Dimension(50, 24));
        comboBox_0.setMinimumSize(new Dimension(50, 24));
        comboBox_0.setMaximumRowCount(6);
        comboBox_0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (comboBox_0.getItemCount() > 0) {
                    Common.setActiveCollection(comboBox_0.getSelectedIndex());
                    JobCollection jobCollection = Common.getCollection();
                    MainFrame.this.updateOutputField(jobCollection);
                    MainFrame.this.updateCollectionTable(jobCollection.getCollectionAsTable());
                    if (!SilentAction) {
                        MainFrame.updateCollectionPanel(Common.getActiveCollection());
                    }
                } else {
                    Common.setActiveCollection(-1);
                    MainFrame.this.outfield.setText("");
                    MainFrame.this.updateCollectionTable(null);
                }
            }
        });
        JButton jButton = new JButton(CommonGui.loadIcon("rem.gif"));
        jButton.setPreferredSize(new Dimension(50, 24));
        jButton.setMaximumSize(new Dimension(50, 24));
        jButton.setToolTipText(Resource.getString("FilePanel.removeCollection.Tip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Common.isCollectionListEmpty()) {
                    return;
                }
                int n = comboBox_0.getSelectedIndex();
                if (!Common.removeCollection(n)) {
                    return;
                }
                comboBox_0.removeAllItems();
                for (int i = 0; i < Common.getCollectionListSize(); ++i) {
                    comboBox_0.addItem(String.valueOf(i));
                }
                if (n < comboBox_0.getItemCount()) {
                    comboBox_0.setSelectedIndex(n);
                }
                if (!Common.isCollectionListEmpty() && n >= comboBox_0.getItemCount()) {
                    comboBox_0.setSelectedIndex(comboBox_0.getItemCount() - 1);
                }
                if (Common.isCollectionListEmpty()) {
                    MainFrame.updateCollectionPanel(-1);
                }
            }
        });
        JButton jButton2 = new JButton(CommonGui.loadIcon("add.gif"));
        jButton2.setPreferredSize(new Dimension(50, 24));
        jButton2.setMaximumSize(new Dimension(50, 24));
        jButton2.setToolTipText(Resource.getString("FilePanel.addCollection.Tip"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.addCollection();
                MainFrame.updateCollectionPanel(Common.getActiveCollection());
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jButton2);
        jPanel3.add(jLabel);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jButton);
        jPanel4.add(comboBox_0);
        jPanel.add(jPanel4);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Clock
        implements Runnable {
            private Thread clockThread = null;
            private String text = "";

            Clock() {
            }

            public void start() {
                if (this.clockThread == null) {
                    this.clockThread = new Thread((Runnable)this, "Clock_3");
                    this.clockThread.setPriority(1);
                    this.clockThread.start();
                }
            }

            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                while (this.clockThread == thread) {
                    this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            private void update() {
                String string;
                JobCollection jobCollection = Common.getCollection();
                String string2 = string = jobCollection == null ? Resource.getString("JobCollection.NoInfo") : jobCollection.getShortSummary();
                if (this.text.equals(string)) {
                    return;
                }
                this.text = string;
                jTextArea.setText(this.text);
                jTextArea.setBackground(jobCollection != null && jobCollection.isActive() ? color2 : color);
            }

            public void stop() {
                this.clockThread = null;
            }
        }
        new Clock().start();
        return jPanel;
    }

    protected JPanel buildStatusPanel() {
        final JLabel jLabel = new JLabel(Resource.getString("run.status"));
        jLabel.setToolTipText("status of processing");
        final JLabel jLabel2 = new JLabel(CommonGui.loadIcon("save_yes.gif"));
        jLabel2.setToolTipText("do or don't save settings on exit");
        jLabel2.setEnabled(false);
        final JLabel jLabel3 = new JLabel();
        final JLabel jLabel4 = new JLabel();
        final JLabel jLabel5 = new JLabel("OFF");
        jLabel5.setToolTipText("WebIF online status");
        final DateFormat dateFormat = DateFormat.getDateInstance(1);
        final DateFormat dateFormat2 = DateFormat.getTimeInstance(1);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Clock
        implements Runnable {
            private Thread clockThread = null;
            private String StatusString = "";
            private String DateString = "";
            private boolean SaveSettings = false;
            private boolean WebIFisOnline = false;

            Clock() {
            }

            public void start() {
                if (this.clockThread == null) {
                    this.clockThread = new Thread((Runnable)this, "Clock_1");
                    this.clockThread.setPriority(1);
                    this.clockThread.start();
                }
            }

            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                while (this.clockThread == thread) {
                    this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            private void update() {
                this.updateStatusLabel();
                this.updateWebIFLabel();
                this.updateSettingsLabel();
                this.updateDateLabel();
                this.updateTimeLabel();
            }

            private void updateStatusLabel() {
                String string = Common.getStatusString();
                if (string.equals(this.StatusString)) {
                    return;
                }
                this.StatusString = string;
                jLabel.setText(this.StatusString);
            }

            private void updateWebIFLabel() {
                boolean bl = Common.isWebServerOnline();
                if (bl == this.WebIFisOnline) {
                    return;
                }
                this.WebIFisOnline = bl;
                jLabel5.setText(this.WebIFisOnline ? "ON" : "OFF");
            }

            private void updateSettingsLabel() {
                boolean bl = Common.getSettings().getBooleanProperty(Keys.KEY_SaveSettingsOnExit);
                if (bl == this.SaveSettings) {
                    return;
                }
                this.SaveSettings = bl;
                jLabel2.setEnabled(this.SaveSettings);
            }

            private void updateDateLabel() {
                String string = dateFormat.format(new Date());
                if (string.equals(this.DateString)) {
                    return;
                }
                this.DateString = string;
                jLabel3.setText(this.DateString);
            }

            private void updateTimeLabel() {
                jLabel4.setText(dateFormat2.format(new Date()));
            }

            public void stop() {
                this.clockThread = null;
            }
        }
        new Clock().start();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setPreferredSize(new Dimension(580, 22));
        jPanel.setMaximumSize(new Dimension(580, 22));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.setPreferredSize(new Dimension(30, 22));
        jPanel2.setMaximumSize(new Dimension(30, 22));
        jPanel2.add(jLabel5);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel3.setPreferredSize(new Dimension(30, 22));
        jPanel3.setMaximumSize(new Dimension(30, 22));
        jPanel3.add(jLabel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel4.setPreferredSize(new Dimension(130, 22));
        jPanel4.setMaximumSize(new Dimension(130, 22));
        jPanel4.add(jLabel3);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel5.setPreferredSize(new Dimension(130, 22));
        jPanel5.setMaximumSize(new Dimension(130, 22));
        jPanel5.add(jLabel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        return jPanel6;
    }

    public void ScanInfo(XInputFile xInputFile) {
        this.ScanInfo(xInputFile, -1);
    }

    public void ScanInfo(XInputFile xInputFile, int n) {
        if (xInputFile.getStreamInfo() == null || n > -1) {
            Common.getScanClass().getStreamInfo(xInputFile, n);
        }
        CommonGui.getPicturePanel().setStreamInfo(xInputFile.getStreamInfo());
    }

    public void reloadInputDirectories() {
        this.updateAutoloadList(Common.reloadInputDirectories());
    }

    private void showStartUpProgress(StartUp startUp, int n, String string) {
        if (startUp == null) {
            System.out.println(string);
        } else {
            startUp.setProgress(n, string);
        }
    }

    private void initialize(StartUp startUp) {
        String[] stringArray = Common.getVersion();
        try {
            this.showStartUpProgress(startUp, 0, "Loading GUI...");
            this.buildGUI(startUp);
            this.showStartUpProgress(startUp, 70, "Loading Input Directories...");
            this.reloadInputDirectories();
            this.showStartUpProgress(startUp, 80, "Loading Main Frame...");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Common.exitApplication(0);
                }
            });
            frame.addComponentListener(new ComponentListener(){

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentShown(ComponentEvent componentEvent) {
                }

                public void componentResized(ComponentEvent componentEvent) {
                    int n = Integer.parseInt(Keys.KEY_WindowPositionMain_Width[1]);
                    int n2 = Integer.parseInt(Keys.KEY_WindowPositionMain_Height[1]);
                    Component component = componentEvent.getComponent();
                    Dimension dimension = new Dimension(n, n2);
                    Dimension dimension2 = component.getSize();
                    double d = dimension.getHeight() > dimension2.getHeight() ? dimension.getHeight() : dimension2.getHeight();
                    double d2 = dimension.getWidth() > dimension2.getWidth() ? dimension.getWidth() : dimension2.getWidth();
                    component.setSize(new Dimension((int)d2, (int)d));
                }
            });
            frame.getContentPane().add(this);
            frame.setLocation(Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_X), Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_Y));
            frame.setSize(new Dimension(Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_Width), Common.getSettings().getIntProperty(Keys.KEY_WindowPositionMain_Height)));
            frametitle = stringArray[0] + "/" + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
            MainFrame.setFrameTitle(frametitle);
            this.showStartUpProgress(startUp, 90, "Printing Environment Settings...");
            Common.setMessage(null, false);
            Object[] objectArray = Common.getJavaEV(Common.getSettings().getInifile());
            Common.setMessage(objectArray);
            Common.setMessage("");
            CommonGui.getPicturePanel().setOSDMessage(objectArray, true);
            this.showStartUpProgress(startUp, 100, "Showing Main Frame...");
            if (startUp != null) {
                startUp.set(Common.getSettings().getBooleanProperty(Keys.KEY_Agreement));
                if (startUp.get()) {
                    MainFrame.setVisible0(true);
                    startUp.close();
                    startUp = null;
                }
            } else {
                MainFrame.setVisible0(true);
            }
        }
        catch (Exception exception) {
            if (Common.showGUI()) {
                if (startUp != null) {
                    startUp.close();
                    startUp = null;
                }
                if (frame != null) {
                    frame.setVisible(false);
                }
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                CommonGui.showErrorMessageDialog(Resource.getString("startup.error") + "\n\n" + stringWriter.toString(), Resource.getString("startup.error.title"));
            } else {
                exception.printStackTrace();
            }
            Common.exitApplication(1);
        }
    }

    public static void setVisible0(boolean bl) {
        SwingUtilities.updateComponentTreeUI(frame);
        frame.setVisible(bl);
    }

    public static void closeProgram(boolean bl) {
        if (Common.isRunningProcess() && !CommonGui.getUserConfirmation("process is running, really stop'em ?")) {
            return;
        }
        Common.exitApplication(GlobalReturnCode);
    }

    public static void setFrameTitle(String string) {
        frame.setTitle(string);
    }

    public static void resetFrameTitle() {
        MainFrame.setFrameTitle(frametitle);
    }

    public static Rectangle getFrameBounds() {
        return frame.getBounds();
    }

    public static void showFrame(boolean bl) {
        frame.setState(bl ? 0 : 1);
    }

    public static void showActiveCollection(int n) {
        if (n >= 0 && n < Common.getCollectionListSize()) {
            comboBox_0.setSelectedIndex(n);
        }
        if (Common.isCollectionListEmpty()) {
            Common.setActiveCollection(-1);
            comboBox_0.removeAllItems();
            MainFrame.updateCollectionPanel(-1);
        }
    }

    public static void updateCollectionPanel(int n) {
        collection_panel.entry(n);
    }

    static {
        frame = new JFrame();
        defaultClipboardOwner = new ClipboardObserver();
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

