/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;

class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane html;

    public HtmlPane(String string) {
        try {
            this.html = string != null ? new JEditorPane(string) : new JEditorPane(Resource.getLocalizedResourceURL("htmls", "index.html"));
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            JViewport jViewport = this.getViewport();
            jViewport.add(this.html);
        }
        catch (MalformedURLException malformedURLException) {
            Common.setMessage("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            Common.setMessage("IOException: " + iOException);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        if (uRL.getProtocol().equals("http") || uRL.getProtocol().equals("https")) {
            try {
                BrowserLauncher.openURL(uRL.toString());
            }
            catch (IOException iOException) {
                Common.setMessage(Resource.getString("msg.browser.launcher.error") + " " + iOException);
            }
        } else {
            Cursor cursor = this.html.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.html.setCursor(cursor2);
            SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
        }
    }

    private class PageLoader
    implements Runnable {
        private URL url;
        private Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container container = HtmlPane.this.html.getParent();
                container.repaint();
            } else {
                Document document = HtmlPane.this.html.getDocument();
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    HtmlPane.this.html.setDocument(document);
                    HtmlPane.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

