/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.parser.Gop;
import net.sourceforge.dvb.projectx.parser.GopArray;
import net.sourceforge.dvb.projectx.thirdparty.Chapters;
import net.sourceforge.dvb.projectx.thirdparty.D2V;

public class JobProcessing {
    private Gop gop;
    private GopArray gop_array;
    private D2V d2v;
    private Chapters chapters;
    private List TSPidlist;
    private List PVAPidlist;
    private List TSdemuxlist;
    private List PVAdemuxlist;
    private List VDRdemuxlist;
    private List PESdemuxlist;
    private List TempFileList;
    private List InfoAtEnd;
    private List CellTimesList;
    private int[] clv;
    private int SourceVideoFrameNumber;
    private int ExportedVideoFrameNumber;
    private int FileNumber;
    private int NoOfAudio;
    private int NoOfPictures;
    private int NoOfTTX;
    private int MinBitrateValue;
    private int MaxBitrateValue;
    private int SplitPartNumber;
    private boolean newvideo;
    private boolean PureVideo;
    private boolean hasSequenceHeader;
    private boolean SplitLoopActive;
    private boolean runningFromCLI;
    private String[] VBASIC;
    private String savedOutputDirectory;
    private long firstVideoPTS;
    private long CUT_BYTEPOSITION;
    private long pva_videopts;
    private long fakedPTS;
    private long LastHeader_BytePosition;
    private long NextFileStartPts;
    private long CutComparePoint;
    private long VideoExportTimeCounter;
    private long VideoExportTimeSummary;
    private long LastGopTimecode;
    private long LastGopPts;
    private long FirstAudioPts;
    private long LastSimplifiedPts;
    private long EndPtsOfGop;
    private long ProjectFileExportLength;
    private long MediaFilesExportLength;
    private long AllMediaFilesExportLength;
    private long SplitPartSize;
    private long ProjectFileSplitSize;

    public JobProcessing(JobCollection jobCollection, boolean bl, String string) {
        this.runningFromCLI = bl;
        this.savedOutputDirectory = string;
        this.startProcessing(jobCollection);
    }

    private void startProcessing(JobCollection jobCollection) {
        this.TSPidlist = new ArrayList();
        this.PVAPidlist = new ArrayList();
        this.TSdemuxlist = new ArrayList();
        this.PVAdemuxlist = new ArrayList();
        this.VDRdemuxlist = new ArrayList();
        this.PESdemuxlist = new ArrayList();
        this.TempFileList = new ArrayList();
        this.InfoAtEnd = new ArrayList();
        this.CellTimesList = new ArrayList();
        this.clv = new int[10];
        this.gop = new Gop(jobCollection);
        this.gop_array = new GopArray();
        this.d2v = new D2V();
        this.chapters = new Chapters();
        this.SourceVideoFrameNumber = 0;
        this.ExportedVideoFrameNumber = 0;
        this.FileNumber = 0;
        this.newvideo = true;
        this.firstVideoPTS = -1L;
        this.PureVideo = false;
        this.VBASIC = new String[5];
        this.CUT_BYTEPOSITION = 0L;
        this.hasSequenceHeader = true;
        this.pva_videopts = -1L;
        this.NoOfAudio = 0;
        this.NoOfPictures = 0;
        this.NoOfTTX = 0;
        this.fakedPTS = -1L;
        this.LastHeader_BytePosition = 0L;
        this.NextFileStartPts = 0L;
        this.CutComparePoint = 0L;
        this.VideoExportTimeCounter = 0L;
        this.VideoExportTimeSummary = 0L;
        this.LastGopTimecode = 0L;
        this.LastGopPts = 0L;
        this.FirstAudioPts = 0L;
        this.SplitLoopActive = true;
        this.MinBitrateValue = 262143;
        this.MaxBitrateValue = 0;
        this.LastSimplifiedPts = 0L;
        this.SplitPartNumber = 0;
        this.SplitPartSize = 0L;
        this.EndPtsOfGop = 0L;
        this.ProjectFileSplitSize = 0L;
        this.ProjectFileExportLength = 0L;
        this.MediaFilesExportLength = 0L;
        this.AllMediaFilesExportLength = 0L;
    }

    public void finishProcessing() {
        this.TSPidlist = null;
        this.PVAPidlist = null;
        this.TSdemuxlist = null;
        this.PVAdemuxlist = null;
        this.VDRdemuxlist = null;
        this.PESdemuxlist = null;
        this.TempFileList = null;
        this.InfoAtEnd = null;
        this.CellTimesList = null;
        this.clv = null;
        this.gop = null;
        this.gop_array = null;
        this.d2v = null;
        this.chapters = null;
        this.VBASIC = null;
    }

    public boolean isRunningFromCLI() {
        return this.runningFromCLI;
    }

    public List getTSPidList() {
        return this.TSPidlist;
    }

    public List getPVAPidList() {
        return this.PVAPidlist;
    }

    public List getTSDemuxList() {
        return this.TSdemuxlist;
    }

    public List getPVADemuxList() {
        return this.PVAdemuxlist;
    }

    public List getPrimaryPESDemuxList() {
        return this.PESdemuxlist;
    }

    public List getSecondaryPESDemuxList() {
        return this.PESdemuxlist;
    }

    public List getTemporaryFileList() {
        return this.TempFileList;
    }

    public List getSummaryInfo() {
        return this.InfoAtEnd;
    }

    public void clearSummaryInfo() {
        this.InfoAtEnd.clear();
    }

    public void addSummaryInfo(String string) {
        this.InfoAtEnd.add(string);
    }

    public List getCellTimes() {
        return this.CellTimesList;
    }

    public void addCellTime(String string) {
        this.CellTimesList.add(string);
    }

    public int[] getStatusVariables() {
        return this.clv;
    }

    public void clearStatusVariables() {
        Arrays.fill(this.clv, 0);
    }

    public String[] getStatusStrings() {
        return this.VBASIC;
    }

    public void clearStatusStrings() {
        Arrays.fill(this.VBASIC, null);
    }

    public Gop getGop() {
        return this.gop;
    }

    public D2V getProjectFileD2V() {
        return this.d2v;
    }

    public Chapters getChapters() {
        return this.chapters;
    }

    public void setSourceVideoFrameNumber(int n) {
        this.SourceVideoFrameNumber = n;
    }

    public int countSourceVideoFrameNumber(int n) {
        this.SourceVideoFrameNumber += n;
        return this.SourceVideoFrameNumber;
    }

    public int getSourceVideoFrameNumber() {
        return this.SourceVideoFrameNumber;
    }

    public void setFileNumber(int n) {
        this.FileNumber = n;
    }

    public int countFileNumber(int n) {
        this.FileNumber += n;
        return this.FileNumber;
    }

    public int getFileNumber() {
        return this.FileNumber;
    }

    public boolean isNewVideoStream() {
        return this.newvideo;
    }

    public void setNewVideoStream(boolean bl) {
        this.newvideo = bl;
    }

    public long get1stVideoPTS() {
        return this.firstVideoPTS;
    }

    public void set1stVideoPTS(long l) {
        this.firstVideoPTS = l;
    }

    public boolean hasElementaryVideoStream() {
        return this.PureVideo;
    }

    public void setElementaryVideoStream(boolean bl) {
        this.PureVideo = bl;
    }

    public long getCutByteposition() {
        return this.CUT_BYTEPOSITION;
    }

    public void setCutByteposition(long l) {
        this.CUT_BYTEPOSITION = l;
    }

    public boolean hasSequenceHeader() {
        return this.hasSequenceHeader;
    }

    public void setSequenceHeader(boolean bl) {
        this.hasSequenceHeader = bl;
    }

    public GopArray getGopArray() {
        return this.gop_array;
    }

    public long getPvaVideoPts() {
        return this.pva_videopts;
    }

    public void setPvaVideoPts(long l) {
        this.pva_videopts = l;
    }

    public void clearSubStreamCounters() {
        this.NoOfAudio = 0;
        this.NoOfPictures = 0;
        this.NoOfTTX = 0;
    }

    public int countAudioStream() {
        return this.NoOfAudio++;
    }

    public int countPictureStream() {
        return this.NoOfPictures++;
    }

    public int countTeletextStream() {
        return this.NoOfTTX++;
    }

    public long getBorrowedPts() {
        return this.fakedPTS;
    }

    public void setBorrowedPts(long l) {
        this.fakedPTS = l;
    }

    public long getLastHeaderBytePosition() {
        return this.LastHeader_BytePosition;
    }

    public void setLastHeaderBytePosition(long l) {
        this.LastHeader_BytePosition = l;
    }

    public long getNextFileStartPts() {
        return this.NextFileStartPts;
    }

    public void setNextFileStartPts(long l) {
        this.NextFileStartPts = l;
    }

    public long getCutComparePoint() {
        return this.CutComparePoint;
    }

    public void setCutComparePoint(long l) {
        this.CutComparePoint = l;
    }

    public void setVideoExportTime(long l) {
        this.VideoExportTimeCounter = l;
    }

    public long countVideoExportTime(long l) {
        this.VideoExportTimeCounter += l;
        return this.VideoExportTimeCounter;
    }

    public long getVideoExportTime() {
        return this.VideoExportTimeCounter;
    }

    public void setVideoExportTimeSummary(long l) {
        this.VideoExportTimeSummary = l;
    }

    public long countVideoExportTimeSummary(long l) {
        this.VideoExportTimeSummary += l;
        return this.VideoExportTimeSummary;
    }

    public long getVideoExportTimeSummary() {
        return this.VideoExportTimeSummary;
    }

    public void setLastGopTimecode(long l) {
        this.LastGopTimecode = l;
    }

    public long countLastGopTimecode(long l) {
        this.LastGopTimecode += l;
        return this.LastGopTimecode;
    }

    public long getLastGopTimecode() {
        return this.LastGopTimecode;
    }

    public void setLastGopPts(long l) {
        this.LastGopPts = l;
    }

    public long getLastGopPts() {
        return this.LastGopPts;
    }

    public void setFirstAudioPts(long l) {
        this.FirstAudioPts = l;
    }

    public long getFirstAudioPts() {
        return this.FirstAudioPts;
    }

    public void setSplitLoopActive(boolean bl) {
        this.SplitLoopActive = bl;
    }

    public boolean isSplitLoopActive() {
        return this.SplitLoopActive;
    }

    public void setMinBitrate(int n) {
        this.MinBitrateValue = n;
    }

    public int getMinBitrate() {
        return this.MinBitrateValue;
    }

    public void setMaxBitrate(int n) {
        this.MaxBitrateValue = n;
    }

    public int getMaxBitrate() {
        return this.MaxBitrateValue;
    }

    public void setLastSimplifiedPts(long l) {
        this.LastSimplifiedPts = l;
    }

    public long getLastSimplifiedPts() {
        return this.LastSimplifiedPts;
    }

    public void setSplitPart(int n) {
        this.SplitPartNumber = n;
    }

    public int getSplitPart() {
        return this.SplitPartNumber;
    }

    public void setSplitSize(long l) {
        this.SplitPartSize = l;
    }

    public long getSplitSize() {
        return this.SplitPartSize;
    }

    public void setEndPtsOfGop(long l) {
        this.EndPtsOfGop = l;
    }

    public long getEndPtsOfGop() {
        return this.EndPtsOfGop;
    }

    public void setProjectFileSplitSize(long l) {
        this.ProjectFileSplitSize = l;
    }

    public long getProjectFileSplitSize() {
        return this.ProjectFileSplitSize;
    }

    public void setProjectFileExportLength(long l) {
        this.ProjectFileExportLength = l;
    }

    public long countProjectFileExportLength(long l) {
        this.ProjectFileExportLength += l;
        return this.ProjectFileExportLength;
    }

    public long getProjectFileExportLength() {
        return this.ProjectFileExportLength;
    }

    public void setExportedVideoFrameNumber(int n) {
        this.ExportedVideoFrameNumber = n;
    }

    public int countExportedVideoFrameNumber(int n) {
        this.ExportedVideoFrameNumber += n;
        return this.ExportedVideoFrameNumber;
    }

    public int getExportedVideoFrameNumber() {
        return this.ExportedVideoFrameNumber;
    }

    public void setMediaFilesExportLength(long l) {
        this.MediaFilesExportLength = l;
    }

    public long countMediaFilesExportLength(long l) {
        this.MediaFilesExportLength += l;
        return this.MediaFilesExportLength;
    }

    public long getMediaFilesExportLength() {
        return this.MediaFilesExportLength;
    }

    public void setAllMediaFilesExportLength(long l) {
        this.AllMediaFilesExportLength = l;
    }

    public long countAllMediaFilesExportLength(long l) {
        this.AllMediaFilesExportLength += l;
        return this.AllMediaFilesExportLength;
    }

    public long getAllMediaFilesExportLength() {
        return this.AllMediaFilesExportLength;
    }

    public String getSavedOutputDirectory() {
        return this.savedOutputDirectory;
    }
}

