/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.Settings;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class JobCollection {
    private List cut_points = null;
    private List chapter_points = null;
    private List input_files = null;
    private List predefined_IDs = null;
    private String output_directory = null;
    private String output_name = null;
    private String normalLog = null;
    private String file_separator = System.getProperty("file.separator");
    private String line_separator = System.getProperty("line.separator");
    private boolean debug = false;
    private boolean progress_status = false;
    private int primaryInputFileSegments = 0;
    private int action_type = -1;
    private PrintStream logging;
    private JobProcessing job_processing;
    private Hashtable cut_images;
    private Settings settings;

    private JobCollection() {
    }

    public JobCollection(String string) {
        this.cut_points = new ArrayList();
        this.chapter_points = new ArrayList();
        this.input_files = new ArrayList();
        this.predefined_IDs = new ArrayList();
        this.init(string, "", this.action_type);
    }

    public JobCollection(String string, String string2, int n, List list, List list2, List list3, List list4) {
        this.cut_points = this.copyListElements(list);
        this.chapter_points = this.copyListElements(list2);
        this.input_files = this.copyListElements(list3);
        this.predefined_IDs = this.copyListElements(list4);
        this.init(string, string2, n);
    }

    private void init(String string, String string2, int n) {
        this.setOutputDirectory(string);
        this.setOutputName(string2);
        this.normalLog = "";
        this.action_type = n;
        this.cut_images = new Hashtable();
    }

    private List copyListElements(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public JobCollection getNewInstance() {
        return new JobCollection(this.output_directory, this.output_name, this.action_type, this.cut_points, this.chapter_points, this.input_files, this.predefined_IDs);
    }

    public void startProcessing(boolean bl) {
        this.progress_status = true;
        this.job_processing = new JobProcessing(this, bl, this.getOutputDirectory());
    }

    public void finishProcessing() {
        this.progress_status = false;
        if (this.job_processing != null) {
            this.job_processing.finishProcessing();
            this.setOutputDirectory(this.job_processing.getSavedOutputDirectory());
        }
        this.job_processing = null;
    }

    public boolean isActive() {
        return this.progress_status;
    }

    public String getFileSeparator() {
        return this.file_separator;
    }

    public JobProcessing getJobProcessing() {
        return this.job_processing;
    }

    public void addInputFile(Object object) {
        this.addInputFile(-1, object);
    }

    public void addInputFile(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.addInputFile(objectArray[i]);
        }
    }

    public void addInputFile(int n, Object object) {
        if (this.isActive()) {
            return;
        }
        if (n < 0) {
            n = this.input_files.size();
        }
        this.input_files.add(n, object);
        this.determinePrimaryFileSegments();
    }

    public Object removeInputFile(int n) {
        if (this.isActive()) {
            return null;
        }
        if (n < 0 || n >= this.getInputFilesCount()) {
            return null;
        }
        Object e = this.input_files.remove(n);
        this.determinePrimaryFileSegments();
        return e;
    }

    public Object[] removeInputFile(int[] nArray) {
        if (this.isActive()) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            objectArray[i] = this.removeInputFile(nArray[i]);
        }
        return objectArray;
    }

    public void determinePrimaryFileSegments() {
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.getInputFilesCount();
        block3: for (int i = 0; i < n4; ++i) {
            XInputFile xInputFile = (XInputFile)this.getInputFile(i);
            if (xInputFile.getStreamInfo() == null) {
                Common.getScanClass().getStreamInfo(xInputFile);
            }
            if (bl) continue;
            n3 = xInputFile.getStreamInfo().getStreamType();
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (n2 == -1 || n2 == n3) break;
                    bl = true;
                    continue block3;
                }
                default: {
                    continue block3;
                }
            }
            n2 = n3;
            ++n;
        }
        this.setPrimaryInputFileSegments(n);
    }

    public Object getInputFile(int n) {
        return this.input_files.get(n);
    }

    public Object[] getInputFiles() {
        return this.input_files.toArray();
    }

    public List getInputFilesAsList() {
        return this.input_files;
    }

    public int getInputFilesCount() {
        return this.input_files.size();
    }

    public int getCutpointCount() {
        return this.cut_points.size();
    }

    public int getChapterpointCount() {
        return this.chapter_points.size();
    }

    public int getPIDCount() {
        return this.predefined_IDs.size();
    }

    public List getCutpointList() {
        return this.cut_points;
    }

    public List getChapterpointList() {
        return this.chapter_points;
    }

    public String getOutputNameParent(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return this.getOutputDirectory() + this.getFileSeparator() + string;
        }
        return this.getOutputDirectory() + this.getFileSeparator() + string.substring(0, n);
    }

    public String getOutputDirectory() {
        return this.output_directory;
    }

    public void setOutputDirectory(String string) {
        this.output_directory = string.endsWith(this.getFileSeparator()) ? string.substring(0, string.length() - 1) : string;
    }

    public String checkOutputDirectory() {
        String string = this.output_directory;
        if (string == null || string.length() == 0) {
            if (this.input_files.size() == 0) {
                return "";
            }
            string = new File(this.input_files.get(0).toString()).getParent();
        }
        if (this.checkWriteAccess(string)) {
            this.output_directory = string;
            return null;
        }
        return string;
    }

    private boolean checkWriteAccess(String string) {
        File file = new File(string);
        String string2 = string + this.getFileSeparator() + "~$pjx$.tmp";
        if (string == null || !file.exists()) {
            return false;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
            randomAccessFile.close();
            new File(string2).delete();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public String getOutputName() {
        return this.output_name;
    }

    public String getOutputName(String string) {
        if (this.output_name.length() > 0) {
            return this.getOutputName();
        }
        return string;
    }

    public void setOutputName(String string) {
        this.output_name = string;
    }

    public void addPID(Object object) {
        if (!this.predefined_IDs.contains(object)) {
            this.predefined_IDs.add(object);
        }
    }

    public void addPID(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.addPID(objectArray[i]);
        }
    }

    public void clearPIDs() {
        this.predefined_IDs.clear();
    }

    public void removePID(Object object) {
        int n = this.predefined_IDs.indexOf(object);
        if (n < 0) {
            return;
        }
        this.predefined_IDs.remove(n);
    }

    public void removePID(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.removePID(objectArray[i]);
        }
    }

    public Object[] getPIDs() {
        return this.predefined_IDs.toArray();
    }

    public int[] getPIDsAsInteger() {
        int n = this.predefined_IDs == null ? 0 : this.predefined_IDs.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Integer.parseInt(this.predefined_IDs.get(i).toString().substring(2), 16);
        }
        return nArray;
    }

    public void addCutpoint(Object object) {
        if (!this.cut_points.contains(object)) {
            this.cut_points.add(object);
        }
    }

    public void addCutpoint(int n, Object object) {
        this.cut_points.add(n, object);
    }

    public void addCutpoint(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.addCutpoint(objectArray[i]);
        }
    }

    public void clearCutpoints() {
        this.cut_points.clear();
    }

    public Object removeCutpoint(int n) {
        if (n < 0 || n >= this.cut_points.size()) {
            return null;
        }
        Object e = this.cut_points.remove(n);
        this.removeCutImage(e);
        return e;
    }

    public Object[] getCutpoints() {
        return this.cut_points.toArray();
    }

    public void addChapterpoint(Object object) {
        if (!this.chapter_points.contains(object)) {
            this.chapter_points.add(object);
        }
    }

    public void addChapterpoint(int n, Object object) {
        this.chapter_points.add(n, object);
    }

    public void addChapterpoint(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.addChapterpoint(objectArray[i]);
        }
    }

    public void clearChapterpoints() {
        this.chapter_points.clear();
    }

    public Object removeChapterpoint(int n) {
        if (n < 0 || n >= this.chapter_points.size()) {
            return null;
        }
        Object e = this.chapter_points.remove(n);
        return e;
    }

    public Object[] getChapterpoints() {
        return this.chapter_points.toArray();
    }

    public String getFirstFileBase() {
        return this.getOutputDirectory() + this.getFirstFileName();
    }

    public String getFirstFileName() {
        String string = new File(this.getInputFiles()[0].toString()).getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public long getFirstFileDate() {
        return ((XInputFile)this.getInputFiles()[0]).lastModified();
    }

    public void setLogFiles() {
        String string = this.getOutputName(this.getFirstFileName());
        if (Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog)) {
            this.debug = true;
            this.setDebugLogStream(this.getOutputDirectory() + this.getFileSeparator() + string + "_biglog.txt");
        }
        if (Common.getSettings().getBooleanProperty(Keys.KEY_NormalLog)) {
            this.normalLog = Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createVdrIndex) && Common.getSettings().getIntProperty(Keys.KEY_ConversionMode) == 1 ? this.getOutputDirectory() + this.getFileSeparator() + "summary.vdr" : this.getOutputDirectory() + this.getFileSeparator() + string + "_log.txt";
        }
    }

    private void setDebugLogStream(String string) {
        try {
            this.logging = new PrintStream(new FileOutputStream(string));
            System.setOut(this.logging);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void closeDebugLogStream() {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog)) {
            return;
        }
        if (this.logging != null) {
            this.logging.flush();
            this.logging.close();
        }
        this.debug = false;
    }

    public void closeNormalLogStream(String string) {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_NormalLog)) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.normalLog));
            printWriter.print(string);
            printWriter.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public boolean DebugMode() {
        return this.debug;
    }

    public void setPrimaryInputFileSegments(int n) {
        this.primaryInputFileSegments = n;
    }

    public int getPrimaryInputFileSegments() {
        return this.primaryInputFileSegments;
    }

    public int[] getCutImage(Object object) {
        if (this.cut_images.containsKey(object)) {
            return (int[])this.cut_images.get(object);
        }
        return null;
    }

    public void setCutImage(String string, int[] nArray) {
        this.cut_images.put(string, nArray);
    }

    public int[] removeCutImage(Object object) {
        if (this.cut_images.containsKey(object)) {
            return (int[])this.cut_images.remove(object);
        }
        return null;
    }

    public Object[][] getCollectionAsTable() {
        int n = this.getInputFilesCount();
        Object[][] objectArray = new Object[n > 5 ? n : 5][11];
        for (int i = 0; i < n; ++i) {
            XInputFile xInputFile = (XInputFile)this.getInputFile(i);
            objectArray[i][0] = new Integer(i);
            objectArray[i][1] = xInputFile.getStreamInfo().getFileSourceBase();
            objectArray[i][2] = xInputFile.getName();
            objectArray[i][3] = xInputFile.getParent().length() > 0 ? xInputFile.getParent() : xInputFile.toString().substring(0, xInputFile.toString().indexOf(xInputFile.getName()));
            objectArray[i][4] = String.valueOf(xInputFile.length() / 0x100000L) + " MB";
            objectArray[i][5] = Common.formatTime_3(xInputFile.lastModified());
            objectArray[i][6] = new Integer(xInputFile.getStreamInfo().getVideoStreams().length);
            objectArray[i][7] = new Integer(xInputFile.getStreamInfo().getAudioStreams().length);
            objectArray[i][8] = new Integer(xInputFile.getStreamInfo().getTeletextStreams().length);
            objectArray[i][9] = new Integer(xInputFile.getStreamInfo().getSubpictureStreams().length);
            objectArray[i][10] = xInputFile.getStreamInfo().getFileType();
        }
        return objectArray;
    }

    public void setActionType(int n) {
        this.action_type = n;
    }

    public int getActionType() {
        return this.action_type;
    }

    public long getAllSizes() {
        long l = 0L;
        int n = this.getInputFilesCount();
        for (int i = 0; i < n; ++i) {
            l += ((XInputFile)this.getInputFile(i)).length();
        }
        return l / 0x100000L;
    }

    public String getShortSummary() {
        String string = this.isActive() ? Resource.getString("JobCollection.InProgress") : Resource.getString("JobCollection.Idle");
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.Action") + " " + (this.getActionType() < 0 ? Resource.getString("JobCollection.unspecified") : Keys.ITEMS_ConversionMode[this.getActionType()].toString());
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.PrimaryFileSegments") + " " + this.getPrimaryInputFileSegments();
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.SecondaryFiles") + " " + (this.getInputFilesCount() - this.getPrimaryInputFileSegments());
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.Cutpoints") + " " + this.getCutpointCount();
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.Chapters") + " " + this.getChapterpointCount();
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.PidSelection") + " " + this.getPIDCount();
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.OwnSettings") + " " + (this.settings != null ? Resource.getString("General.Yes") : Resource.getString("General.No"));
        string = string + this.line_separator;
        string = string + Resource.getString("JobCollection.AllSize") + " " + this.getAllSizes() + "MB";
        return string;
    }

    public Settings getSettings() {
        if (this.settings == null) {
            return Common.getSettings();
        }
        return this.settings;
    }

    public void setSettings(Settings settings) throws IOException {
        if (this.isActive()) {
            return;
        }
        this.settings = new Settings();
        this.settings.loadProperties(new ByteArrayInputStream(settings.storeProperties()));
    }
}

