/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatWAV
extends AudioFormat {
    private final int[] WaveChunks = new int[]{1463899717, 1668637984, 1684108385, 1717658484, 1718449184, 1768846196, 1818321516, 1818850164, 1819572340, 1852798053, 1886155636, 1936552044};
    private final String[] LSB_mode = new String[]{"F", "X"};
    private final String[] compression = new String[]{"", "PCM", "MPEG", "MPEG-L3", "AC3"};

    public int parseHeader(byte[] byArray, int n) {
        INTEL = false;
        if (byArray[n] != 82 || byArray[n + 1] != 73 || byArray[n + 2] != 70) {
            return -1;
        }
        if (byArray[n + 3] == 70) {
            INTEL = true;
        } else if (byArray[n + 3] != 88) {
            return -2;
        }
        ID = INTEL ? 0 : 1;
        Emphasis = 0;
        Protection_bit = 1;
        Arrays.sort(this.WaveChunks);
        if (this.littleEndian(byArray, n + 8, 4, false) != this.WaveChunks[0]) {
            return -3;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = n + 12; i < byArray.length - 4; ++i) {
            n2 = this.littleEndian(byArray, i, 4, false);
            if (Arrays.binarySearch(this.WaveChunks, n2) < 0) continue;
            if (n2 == this.WaveChunks[4]) {
                n3 = this.littleEndian(byArray, i + 4, 4, INTEL);
                Layer = this.littleEndian(byArray, i + 8, 2, INTEL);
                Channel = this.littleEndian(byArray, i + 10, 2, INTEL);
                Sampling_frequency = this.littleEndian(byArray, i + 12, 4, INTEL);
                Bitrate = this.littleEndian(byArray, i + 16, 4, INTEL) * 8;
                Mode = this.littleEndian(byArray, i + 20, 2, INTEL);
                Size = this.littleEndian(byArray, i + 22, 2, INTEL);
            } else if (n2 == this.WaveChunks[2]) {
                Size_base = n3 = this.littleEndian(byArray, i + 4, 4, INTEL);
                Emphasis = i + 8;
            } else {
                n3 = this.littleEndian(byArray, i + 4, 4, INTEL);
            }
            i += n3 + 3;
        }
        if (Bitrate < 1 || Sampling_frequency < 1 || Channel < 1) {
            return -4;
        }
        Padding_bit = 0;
        Private_bit = 0;
        Copyright = 0;
        Original = 0;
        Time_length = 90000.0 / (double)Sampling_frequency;
        switch (Layer) {
            case 1: {
                Mode_extension = 1;
                return 1;
            }
            case 80: {
                Mode_extension = 2;
                return 0;
            }
            case 85: {
                Mode_extension = 3;
                return 0;
            }
            case 8192: {
                Mode_extension = 4;
                return 0;
            }
        }
        Mode_extension = 0;
        return 0;
    }

    public String displayHeader() {
        return "RIF" + this.LSB_mode[lID] + ", " + (lMode_extension > 0 ? this.compression[lMode_extension] : "tag 0x" + Integer.toHexString(Layer)) + ", " + lChannel + "-ch, " + lSampling_frequency + "Hz, " + lSize + "bit, " + (double)lBitrate / 1000.0 + "kbps";
    }
}

