/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.audio.MpaDecoder;
import net.sourceforge.dvb.projectx.common.Common;

public class AudioFormatMPA
extends AudioFormat {
    private String instanced_time = "";
    private int[][][] bitrate_index = new int[][][]{new int[][]{{-1, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {-1, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {-1, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}}, new int[][]{{-1, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}, {-1, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {-1, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}}, new int[][]{{-1, 6000, 8000, 10000, 12000, 16000, 20000, 24000, 28000, 320000, 40000, 48000, 56000, 64000, 80000, 0}, {-1, 6000, 8000, 10000, 12000, 16000, 20000, 24000, 28000, 320000, 40000, 48000, 56000, 64000, 80000, 0}, {-1, 8000, 12000, 16000, 20000, 24000, 32000, 40000, 48000, 560000, 64000, 80000, 96000, 112000, 128000, 0}}};
    private int[][] frequency_index = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}, {11025, 12000, 8000, 0}};
    private double[] time_index = new double[]{0.0, 1.0368E8, 1.0368E8, 3.456E7};
    private String[] dID = new String[]{"MPEG-2", "MPEG-1", "MPEG-2.5"};
    private String[] dLayer = new String[]{"n.a.", "Layer3", "Layer2", "Layer1"};
    private String[] dCRC = new String[]{"noCRC", "CRC"};
    private String[] dMode = new String[]{"stereo", "jstereo", "dual", "mono"};
    private final int[] rpadding = new int[]{0, 1, 1, 4};
    private final int[] rlayer = new int[]{0, 4, 2, 1};
    private final int[][] rsample = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};
    private final int[] rmode = new int[]{1, 2, 4, 8};
    private final int[] rchnl = new int[]{2, 2, 2, 1};
    private final int[] rmext = new int[]{1, 2, 4, 8};
    private final int[] remph = new int[]{1, 2, 3, 4};
    private final int[][][] rbitrate = new int[][][]{new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}}};
    ArrayList _list = new ArrayList();
    ByteArrayOutputStream bo = new ByteArrayOutputStream();
    private boolean DecodeRDS = false;
    private boolean Debug = false;
    private boolean hasRawData = false;
    private String[] rds_values = new String[7];
    private final String[] pty_list = new String[]{"undefined", "News", "Current Affairs", "Information", "Sport", "Education", "Drama", "Culture", "Science", "Varied", "Pop Music", "Rock Music", "Easy Listening", "Light Classical", "Seriuos Classical", "Other Music", "Weather", "Finance", "Children", "Social Affairs", "Religion", "Phone In", "Travel", "Leisure", "Jazz Music", "Country Music", "National Music", "Oldies Music", "Folk Music", "Documentary", "Alarm Test", "Alarm"};
    private final short[] chars = new short[]{32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 32, 225, 224, 233, 232, 237, 236, 243, 242, 250, 249, 209, 199, 350, 223, 304, 306, 226, 228, 234, 235, 238, 239, 244, 246, 251, 252, 241, 231, 351, 287, 305, 307};

    public AudioFormatMPA() {
        this.instanced_time = String.valueOf(System.currentTimeMillis());
    }

    public int parseHeader(byte[] byArray, int n) {
        int n2 = 32;
        if ((0xFF & byArray[n]) != 255 || (0xF0 & byArray[n + 1]) != 240) {
            return -1;
        }
        ID = 1 & byArray[n + 1] >>> 3;
        Emphasis = 3 & byArray[n + 3];
        if (ID == 1 && Emphasis == 2) {
            ID = 2;
        }
        if ((Layer = 3 & byArray[n + 1] >>> 1) < 1) {
            return -2;
        }
        Protection_bit = 1 & byArray[n + 1] ^ 1;
        Bitrate = this.bitrate_index[ID][Layer - 1][0xF & byArray[n + 2] >>> 4];
        if (Bitrate < 1) {
            return -3;
        }
        Sampling_frequency = this.frequency_index[ID][3 & byArray[n + 2] >>> 2];
        if (Sampling_frequency == 0) {
            return -4;
        }
        Padding_bit = 1 & byArray[n + 2] >>> 1;
        Private_bit = 1 & byArray[n + 2];
        Mode = 3 & byArray[n + 3] >>> 6;
        Mode_extension = 3 & byArray[n + 3] >>> 4;
        if (Mode == 0) {
            Mode_extension = 0;
        }
        Bound = Mode == 1 ? Mode_extension + 1 << 2 : n2;
        Channel = Mode == 3 ? 1 : 2;
        Copyright = 1 & byArray[n + 3] >>> 3;
        Original = 1 & byArray[n + 3] >>> 2;
        Time_length = this.time_index[Layer] / (double)Sampling_frequency;
        if (ID == 1 && Layer == 2) {
            if (Bitrate / Channel < 32000) {
                return -5;
            }
            if (Bitrate / Channel > 192000) {
                return -6;
            }
            Sblimit = Bitrate / Channel < 56000 ? (Sampling_frequency == 32000 ? 12 : 8) : (Bitrate / Channel < 96000 ? 27 : (Sampling_frequency == 48000 ? 27 : 30));
            if (Bound > Sblimit) {
                Bound = Sblimit;
            }
        } else if (Layer == 2) {
            Sblimit = 30;
        }
        if (Layer < 3) {
            if (Bound > Sblimit) {
                Bound = Sblimit;
            }
            Size_base = 144 * Bitrate / Sampling_frequency;
            Size = Size_base + Padding_bit;
        } else {
            Sblimit = 32;
            Size_base = 12 * Bitrate / Sampling_frequency * 4;
            Size = Size_base + 4 * Padding_bit;
        }
        return Layer < 3 ? 1 : 2;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 255 || (0xF0 & byArray[n + 1]) != 240) {
            return -1;
        }
        this.nID = 1 & byArray[n + 1] >>> 3;
        this.nEmphasis = 3 & byArray[n + 3];
        if (this.nID == 1 && this.nEmphasis == 2) {
            this.nID = 2;
        }
        if ((this.nLayer = 3 & byArray[n + 1] >>> 1) < 1) {
            return -2;
        }
        this.nProtection_bit = 1 & byArray[n + 1] ^ 1;
        this.nBitrate = this.bitrate_index[this.nID][this.nLayer - 1][0xF & byArray[n + 2] >>> 4];
        if (this.nBitrate < 1) {
            return -3;
        }
        this.nSampling_frequency = this.frequency_index[this.nID][3 & byArray[n + 2] >>> 2];
        if (this.nSampling_frequency == 0) {
            return -4;
        }
        this.nPadding_bit = 1 & byArray[n + 2] >>> 1;
        this.nPrivate_bit = 1 & byArray[n + 2];
        this.nMode = 3 & byArray[n + 3] >>> 6;
        this.nMode_extension = 3 & byArray[n + 3] >>> 4;
        if (this.nMode == 0) {
            this.nMode_extension = 0;
        }
        this.nChannel = this.nMode == 3 ? 1 : 2;
        this.nCopyright = 1 & byArray[n + 3] >>> 3;
        this.nOriginal = 1 & byArray[n + 3] >>> 2;
        this.nTime_length = this.time_index[this.nLayer] / (double)this.nSampling_frequency;
        if (this.nID == 1 && this.nLayer == 2) {
            if (this.nBitrate / Channel < 32000) {
                return -5;
            }
            if (this.nBitrate / Channel > 192000) {
                return -6;
            }
        }
        if (this.nLayer < 3) {
            this.nSize_base = 144 * this.nBitrate / this.nSampling_frequency;
            this.nSize = this.nSize_base + this.nPadding_bit;
            return 1;
        }
        this.nSize_base = 12 * this.nBitrate / this.nSampling_frequency * 4;
        this.nSize = this.nSize_base + 4 * this.nPadding_bit;
        return 2;
    }

    public int compareHeader() {
        if (lID != ID) {
            return 1;
        }
        if (lLayer != Layer) {
            return 2;
        }
        if (lBitrate != Bitrate) {
            return 3;
        }
        if (lSampling_frequency != Sampling_frequency) {
            return 4;
        }
        if (lProtection_bit != Protection_bit) {
            return 5;
        }
        if (lMode != Mode) {
            if (Mode + lMode < 2) {
                return 6;
            }
            return 7;
        }
        return 0;
    }

    public String displayHeader() {
        return "" + this.dID[lID] + ", " + this.dLayer[lLayer] + ", " + lSampling_frequency + "Hz, " + this.dMode[lMode] + ", " + lBitrate / 1000 + "kbps, " + this.dCRC[lProtection_bit];
    }

    public void removeCRC(byte[] byArray) {
        if (Layer < 2) {
            return;
        }
        this.removePrivateBit(byArray);
        if ((byArray[1] & 1) == 1) {
            return;
        }
        System.arraycopy(byArray, 6, byArray, 4, byArray.length - 6);
        Arrays.fill(byArray, byArray.length - 2, byArray.length, (byte)0);
        byArray[1] = (byte)(byArray[1] | 1);
        Protection_bit = 1;
    }

    private void removePrivateBit(byte[] byArray) {
        if ((byArray[2] & 1) == 0) {
            return;
        }
        byArray[2] = (byte)(byArray[2] & 0xFFFFFFFE);
        Private_bit = 0;
    }

    public int validateCRC(byte[] byArray, int n, int n2) {
        int n3;
        Object object;
        int[] nArray;
        int n4;
        int n5;
        if (Layer < 2 || Protection_bit == 0) {
            return 0;
        }
        int n6 = (0xFF & byArray[4]) << 8 | 0xFF & byArray[5];
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        System.arraycopy(byArray, 6, byArray2, 4, byArray.length - 6);
        int n7 = 2;
        int n8 = 16;
        int[] nArray2 = new int[]{32};
        if (Layer == 3) {
            for (n5 = 0; n5 < Bound; ++n5) {
                for (n4 = 0; n4 < Channel; ++n4) {
                    n8 += 4;
                }
            }
            for (n5 = Bound; n5 < Sblimit; ++n5) {
                n8 += 4;
            }
        } else {
            int[][] nArray3 = new int[32][2];
            if (ID == 1) {
                if (Sblimit > 20) {
                    nArray = MpaDecoder.table_b2ab_nbal;
                    object = MpaDecoder.table_b2ab;
                } else {
                    nArray = MpaDecoder.table_b2cd_nbal;
                    object = MpaDecoder.table_b2cd;
                }
            } else {
                nArray = MpaDecoder.table_MPG2_nbal;
                object = MpaDecoder.table_MPG2;
            }
            for (n5 = 0; n5 < Bound; ++n5) {
                for (n4 = 0; n4 < Channel; ++n4) {
                    nArray3[n5][n4] = object[n5][this.getBits(byArray2, nArray2, nArray[n5])];
                    n8 += nArray[n5];
                }
            }
            for (n5 = Bound; n5 < Sblimit; ++n5) {
                int n9 = object[n5][this.getBits(byArray2, nArray2, nArray[n5])];
                nArray3[n5][1] = n9;
                nArray3[n5][0] = n9;
                n8 += nArray[n5];
            }
            for (n5 = 0; n5 < Sblimit; ++n5) {
                for (n4 = 0; n4 < Channel; ++n4) {
                    if (nArray3[n5][n4] <= 0) continue;
                    n8 += 2;
                }
            }
        }
        nArray = new int[]{1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
        object = new int[16];
        int n10 = 0;
        Arrays.fill((int[])object, 1);
        int n11 = 0;
        int n12 = byArray2.length;
        for (n3 = 0; n3 < n8 && n7 < n12; ++n3) {
            int n13;
            int n14 = n13 = (byArray2[n7] & 128 >>> n11++) != 0 ? 1 : 0;
            if ((n11 &= 7) == 0) {
                ++n7;
            }
            n13 ^= object[15];
            for (int i = 15; i > 0; --i) {
                object[i] = nArray[i] == 1 ? (Object)(object[i - 1] ^ n13) : object[i - 1];
            }
            object[0] = (int[])n13;
        }
        for (n3 = 0; n3 < 16; ++n3) {
            n10 = n10 << 1 | object[15 - n3];
        }
        if (n10 != n6) {
            return 1;
        }
        return 0;
    }

    private int getBits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[0] >>> 3;
        int n3 = (0xFF & byArray[n2]) << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3];
        n3 <<= nArray[0] & 7;
        nArray[0] = nArray[0] + n;
        return n3 >>>= 32 - n;
    }

    public int[] parseRiffData(byte[] byArray) {
        int[] nArray = new int[10];
        nArray[0] = (8 & byArray[1]) << 1 | (1 & byArray[1]) << 3 | 4 & byArray[3] | (8 & byArray[3]) >>> 2 | 1 & byArray[2];
        nArray[1] = this.rlayer[(6 & byArray[1]) >>> 1];
        nArray[2] = this.rsample[(8 & byArray[1]) >>> 3][(0xC & byArray[2]) >>> 2];
        nArray[3] = this.rmode[(0xC0 & byArray[3]) >>> 6];
        nArray[4] = this.rchnl[(0xC0 & byArray[3]) >>> 6];
        nArray[5] = this.rmext[(0x30 & byArray[3]) >>> 4];
        nArray[6] = this.rbitrate[(8 & byArray[1]) >>> 3][(6 & byArray[1]) >>> 1][(0xF0 & byArray[2]) >>> 4];
        nArray[7] = this.remph[3 & byArray[3]];
        nArray[8] = nArray[1] == 1 ? 4 * (12 * nArray[6] / nArray[2]) : 144 * nArray[6] / nArray[2];
        nArray[8] = nArray[8] / ((8 & byArray[1]) == 0 && (6 & byArray[1]) == 1 ? 2 : 1);
        if ((2 & byArray[2]) != 0) {
            nArray[8] = nArray[8] + this.rpadding[(6 & byArray[1]) >>> 1];
        }
        return nArray;
    }

    public void setAncillaryDataDecoder(boolean bl, boolean bl2) {
        this.DecodeRDS = bl;
        this.Debug = bl2;
        Arrays.fill(this.rds_values, null);
    }

    public void decodeAncillaryData(byte[] byArray) {
        if (!this.DecodeRDS) {
            return;
        }
        int n = Size - 1;
        if (byArray[n] != -3 && byArray[n -= 2] != -3) {
            return;
        }
        int n2 = 0xFF & byArray[n - 1];
        for (int i = n - 2; i > n - 2 - n2; --i) {
            int n3 = 0xFF & byArray[i];
            this._list.add(String.valueOf(n3));
        }
        this.decodeChunk(this._list);
    }

    private void decodeChunk(ArrayList arrayList) {
        int n;
        int n2 = arrayList.indexOf("254");
        if (n2 < 0) {
            arrayList.clear();
            return;
        }
        while (n2 > 0) {
            arrayList.remove(0);
            --n2;
        }
        int n3 = arrayList.indexOf("255");
        if (n3 < 0) {
            return;
        }
        if (n3 < 5) {
            arrayList.remove(0);
            return;
        }
        if (this.Debug) {
            String string = "";
            String string2 = "";
            for (n = 0; n <= n3; ++n) {
                string2 = Integer.toHexString(Integer.parseInt(arrayList.get(n).toString())).toUpperCase();
                string = string + " " + (string2.length() < 2 ? "0" + string2 : string2);
            }
            System.out.println("RDS:" + string);
        }
        int n4 = Integer.parseInt(arrayList.get(4).toString());
        int n5 = -1;
        n = -1;
        boolean bl = false;
        int n6 = 0;
        for (int i = 0; i <= n3; ++i) {
            int n7 = Integer.parseInt(arrayList.get(0).toString());
            if (i >= 5 && n7 <= 253) {
                if (i == 5) {
                    n = n7;
                } else if (n7 == 253) {
                    bl = true;
                } else {
                    if (bl) {
                        n7 += 253;
                        bl = false;
                    }
                    if (n6 < n4 - 1) {
                        this.bo.write(n7);
                    }
                    n5 = n6++;
                }
            }
            arrayList.remove(0);
        }
        if (n5 != n4) {
            n = -1;
        }
        switch (n) {
            case 218: {
                this.getRawData(this.bo.toByteArray());
                break;
            }
            case 10: {
                this.compareMsg(this.getRT(this.bo.toByteArray()), 0);
                break;
            }
            case 1: {
                this.compareMsg(this.getPI(this.bo.toByteArray()), 1);
                break;
            }
            case 2: {
                this.compareMsg(this.getPS(this.bo.toByteArray()), 2);
                break;
            }
            case 3: {
                this.compareMsg(this.getTP(this.bo.toByteArray()), 3);
                break;
            }
            case 5: {
                this.compareMsg(this.getMS(this.bo.toByteArray()), 4);
                break;
            }
            case 7: {
                this.compareMsg(this.getPTY(this.bo.toByteArray()), 5);
                break;
            }
            case 13: {
                this.compareMsg(this.getRTC(this.bo.toByteArray()), 6);
                break;
            }
        }
        this.bo.reset();
    }

    private void getRawData(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = byArray.length;
            int n4 = 0xFF & byArray[n += 5];
            int n5 = 0xFF & byArray[n += 3];
            ++n;
            try {
                if (!this.hasRawData) {
                    this.hasRawData = true;
                    Common.setMessage("-> exporting RDS data type 0xDA to '" + this.instanced_time + "_rawdata_0xDA_RDS'");
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(Common.getCollection().getOutputNameParent(this.instanced_time + "_rawdata@RDS"), true));
                for (int i = n; i < n3; ++i) {
                    int n6 = 0xFF & byArray[i];
                    bufferedOutputStream.write(n6);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                Common.setMessage("!> error rds1");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Common.setMessage("!> error rds2");
        }
    }

    private void compareMsg(String string, int n) {
        if (string == null || string.equals(this.rds_values[n])) {
            return;
        }
        this.rds_values[n] = string;
        Common.setMessage(string);
    }

    private String getRT(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = 0xFF & byArray[n += 2];
            int n5 = 0xFF & byArray[++n];
            String string = this.getString(byArray, ++n, n4 - 1);
            return "-> RT (" + Integer.toHexString(n5).toUpperCase() + "): '" + string.trim() + "'";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getPS(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = byArray.length >= (n += 2) + 8 ? 8 : byArray.length - n;
            String string = this.getString(byArray, n, n4);
            return "-> PS (" + n3 + "): '" + string.trim() + "'";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getPI(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = (0xFF & byArray[n += 2]) << 8 | 0xFF & byArray[n + 1];
            return "-> PI (" + n3 + "): 0x" + Integer.toHexString(n4).toUpperCase();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getTP(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            boolean bl = (2 & byArray[n += 2]) != 0;
            boolean bl2 = (1 & byArray[n]) != 0;
            return "-> TP/TA (" + n3 + "): " + (bl ? "TP" : "no TP") + " / " + (bl2 ? "TA on air" : "no TA");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getMS(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            boolean bl = (1 & byArray[n += 2]) != 0;
            return "-> MS (" + n3 + "): " + (bl ? "Speech" : "Music");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getPTY(byte[] byArray) {
        try {
            int n = 0;
            int n2 = 0xFF & byArray[n];
            int n3 = 0xFF & byArray[n + 1];
            int n4 = 0x1F & byArray[n += 2];
            return "-> PTY (" + n3 + "): " + this.pty_list[n4];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getRTC(byte[] byArray) {
        try {
            int n = 0;
            String string = "20" + Common.adaptString(Integer.toHexString(0x7F & byArray[n]), 2);
            String string2 = Common.adaptString(String.valueOf(0xF & byArray[n + 1]), 2);
            String string3 = Common.adaptString(String.valueOf(0x1F & byArray[n + 2]), 2);
            String string4 = Common.adaptString(String.valueOf(0x1F & byArray[n + 3]), 2);
            String string5 = Common.adaptString(String.valueOf(0x3F & byArray[n + 4]), 2);
            String string6 = Common.adaptString(String.valueOf(0x3F & byArray[n + 5]), 2);
            String string7 = Common.adaptString(String.valueOf(0x7F & byArray[n + 6]), 2);
            int n2 = 0xFF & byArray[n + 7];
            String string8 = n2 != 255 ? ((0x20 & n2) != 0 ? "-" + (0x1F & n2) / 2 : "+" + (0x1F & n2) / 2) : "\u00b10";
            return "-> RTC (" + string8 + "h): " + string + "." + string2 + "." + string3 + "  " + string4 + ":" + string5 + ":" + string6 + "." + string7;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private String getString(byte[] byArray, int n, int n2) {
        String string = "";
        try {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                int n4 = 0xFF & byArray[i];
                string = string + (n4 > 159 || n4 < 32 ? (char)this.chars[0] : (char)this.chars[n4 - 32]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }
}

