/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatAC3
extends AudioFormat {
    private int CRC16_POLY = 98309;
    private int[] crc_table = new int[256];
    private int[] ac3_frequency_index = new int[]{48000, 44100, 32000, 0};
    private int[] ac3_bitrate_index = new int[]{32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[][] ac3_size_table = new int[][]{{128, 160, 192, 224, 256, 320, 384, 448, 512, 640, 768, 896, 1024, 1280, 1536, 1792, 2080, 2304, 2560}, {138, 174, 208, 242, 278, 348, 416, 486, 556, 696, 834, 974, 1114, 1392, 1670, 1950, 2228, 2506, 2786}, {192, 240, 288, 336, 384, 480, 576, 672, 768, 960, 1152, 1344, 1536, 1920, 2304, 2688, 3120, 3456, 3840}};
    private String[] bsmod = new String[]{", CM", ", ME", ", K:VI", ", K:HI", ", K:D", ", K:C", ", K:E", ", K:VO"};
    private String[] cmixlev = new String[]{"", ", cm -3.0dB", ", cm -4.5dB", ", cm -6.0dB", ", cm -4.5dB"};
    private String[] surmixlev = new String[]{"", ", sm -3dB", ", sm -6dB", ", sm 0dB", ", sm -6dB"};
    private String[] dsurmod = new String[]{"", ", notDS", ", DS", ""};
    private String[] acmod = new String[]{"1+1", "1/0", "2/0", "3/0", "2/1", "3/1", "2/2", "3/2"};
    private String[][] lfe = new String[][]{{".0", ".1"}, {"", "lfe"}};
    private int[] ac3_channels = new int[]{2, 1, 2, 3, 3, 4, 4, 5};
    private final int[] armode = new int[]{0, 1, 2, 3, 3, 4, 4, 5};
    private final int[] arsample = new int[]{48000, 44100, 32000, 0};
    private final int[] arbitrate = new int[]{0, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000, 0, 0};
    private final int[][] ac3const = new int[][]{{288000000, 160, 192, 224, 256, 320, 384, 448, 512, 640, 768, 896, 1024, 1280, 1536, 1792, 2080, 2304, 2560}, {313469388, 174, 208, 242, 278, 348, 416, 486, 556, 696, 834, 974, 1114, 1392, 1670, 1950, 2228, 2506, 2786}, {432000000, 240, 288, 336, 384, 480, 576, 672, 768, 960, 1152, 1344, 1536, 1920, 2304, 2688, 3120, 3456, 3840}};

    public AudioFormatAC3() {
        this.ac3_crc_init();
    }

    public int parseHeader(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 11 || (0xFF & byArray[n + 1]) != 119) {
            return -1;
        }
        ID = 0;
        Emphasis = 0;
        Private_bit = 0;
        Protection_bit = 1;
        Sampling_frequency = this.ac3_frequency_index[3 & byArray[n + 4] >>> 6];
        if (Sampling_frequency < 1) {
            return -4;
        }
        Bitrate = this.ac3_bitrate_index[0x1F & byArray[n + 4] >>> 1];
        if (Bitrate < 1) {
            return -3;
        }
        Layer = 7 & byArray[n + 5];
        Padding_bit = 1 & byArray[n + 4];
        Mode = 7 & byArray[n + 6] >>> 5;
        Mode_extension = 0;
        int n2 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
        int n3 = 0;
        if ((Mode & 1) > 0 && Mode != 1) {
            Emphasis = 1 + (3 & byArray[n + 6] >>> 3);
            ++n3;
        }
        if ((Mode & 4) > 0) {
            Private_bit = 1 + (3 & byArray[n + 6] >>> (n3 > 0 ? 1 : 3));
            ++n3;
        }
        if (Mode == 2) {
            Mode_extension |= 6 & n2 >>> 10 - 2 * n3;
            ++n3;
        }
        if (n3 < 4) {
            Mode_extension |= 1 & n2 >>> 12 - 2 * n3;
            Original = 0x1F & n2 >>> 7 - 2 * n3;
        }
        Channel = this.ac3_channels[Mode] + (1 & Mode_extension);
        Copyright = 0;
        Time_length = 1.3824E8 / (double)Sampling_frequency;
        Size_base = this.ac3_size_table[3 & byArray[n + 4] >>> 6][0x1F & byArray[n + 4] >>> 1];
        Size = Size_base + Padding_bit * 2;
        return 1;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        if ((0xFF & byArray[n]) != 11 || (0xFF & byArray[n + 1]) != 119) {
            return -1;
        }
        this.nID = 0;
        this.nEmphasis = 0;
        this.nPrivate_bit = 0;
        this.nProtection_bit = 1;
        this.nSampling_frequency = this.ac3_frequency_index[3 & byArray[n + 4] >>> 6];
        if (this.nSampling_frequency < 1) {
            return -4;
        }
        this.nBitrate = this.ac3_bitrate_index[0x1F & byArray[n + 4] >>> 1];
        if (this.nBitrate < 1) {
            return -3;
        }
        this.nLayer = 7 & byArray[n + 5];
        this.nPadding_bit = 1 & byArray[n + 4];
        this.nMode = 7 & byArray[n + 6] >>> 5;
        int n2 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
        int n3 = 0;
        if ((this.nMode & 1) > 0 && this.nMode != 1) {
            this.nEmphasis = 1 + (3 & byArray[n + 6] >>> 3);
            ++n3;
        }
        if ((this.nMode & 4) > 0) {
            this.nPrivate_bit = 1 + (3 & byArray[n + 6] >>> (n3 > 0 ? 1 : 3));
            ++n3;
        }
        if (this.nMode == 2) {
            this.nMode_extension |= 6 & n2 >>> 10 - 2 * n3;
            ++n3;
        }
        if (n3 < 4) {
            this.nMode_extension |= 1 & n2 >>> 12 - 2 * n3;
            this.nOriginal = 0x1F & n2 >>> 7 - 2 * n3;
        }
        this.nChannel = this.ac3_channels[this.nMode] + (1 & this.nMode_extension);
        this.nCopyright = 0;
        this.nTime_length = 1.3824E8 / (double)this.nSampling_frequency;
        this.nSize_base = this.ac3_size_table[3 & byArray[n + 4] >>> 6][5 & byArray[n + 4] >>> 1];
        this.nSize = this.nSize_base + this.nPadding_bit * 2;
        return 1;
    }

    public int compareHeader() {
        if (lLayer != Layer) {
            return 1;
        }
        if (lBitrate != Bitrate) {
            return 2;
        }
        if (lSampling_frequency != Sampling_frequency) {
            return 3;
        }
        if (lMode != Mode) {
            return 4;
        }
        if (lMode_extension != Mode_extension) {
            return 5;
        }
        if (lOriginal != Original) {
            return 6;
        }
        if (lEmphasis != Emphasis) {
            return 7;
        }
        return 0;
    }

    public String displayHeader() {
        return "AC-3" + this.bsmod[lLayer] + ", " + this.acmod[lMode] + this.lfe[1][1 & lMode_extension] + "(" + this.ac3_channels[lMode] + this.lfe[0][1 & lMode_extension] + ")" + ", dn -" + lOriginal + "dB" + this.dsurmod[lMode_extension >>> 1] + this.cmixlev[lEmphasis] + this.surmixlev[lPrivate_bit] + ", " + lSampling_frequency + "Hz, " + lBitrate / 1000 + "kbps";
    }

    public int validateCRC(byte[] byArray, int n, int n2) {
        int n3 = n2 >>> 1;
        int n4 = 2 * ((n3 >>> 1) + (n3 >>> 3));
        int n5 = -1;
        n5 = this.ac3_crc(byArray, 2, n4, 0);
        if (n5 != 0) {
            return 1;
        }
        if ((n5 = this.ac3_crc(byArray, n4, n2, n5)) != 0) {
            return 2;
        }
        return 0;
    }

    public byte[] editFrame(byte[] byArray, int n, int n2) {
        if (n2 == 1) {
            this.setChannelFlags(byArray);
        }
        return byArray;
    }

    private void setChannelFlags(byte[] byArray) {
        byArray[6] = (byte)(0xF & byArray[6] | 0xE0);
    }

    private void computeCRC(byte[] byArray, int n) {
        int n2 = ((n >>>= 1) >>> 1) + (n >>> 3);
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        n3 = this.ac3_crc(byArray, 4, 2 * n2, 0);
        n5 = this.pow_poly(this.CRC16_POLY >>> 1, 16 * n2 - 16, this.CRC16_POLY);
        n3 = this.mul_poly(n5, n3, this.CRC16_POLY);
        byArray[2] = (byte)(0xFF & n3 >> 8);
        byArray[3] = (byte)(0xFF & n3);
        n4 = this.ac3_crc(byArray, 2 * n2, 2 * n - 2, 0);
        byArray[2 * n - 2] = (byte)(0xFF & n4 >> 8);
        byArray[2 * n - 1] = (byte)(0xFF & n4);
    }

    private void ac3_crc_init() {
        for (int i = 0; i < 256; ++i) {
            int n = i << 8;
            for (int j = 0; j < 8; ++j) {
                if ((n & 0x8000) != 0) {
                    n = n << 1 & 0xFFFF ^ this.CRC16_POLY & 0xFFFF;
                    continue;
                }
                n <<= 1;
            }
            this.crc_table[i] = n;
        }
    }

    private int ac3_crc(byte[] byArray, int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            n3 = (this.crc_table[0xFF & byArray[i] ^ n3 >> 8] ^ n3 << 8) & 0xFFFF;
        }
        return n3;
    }

    private int mul_poly(int n, int n2, int n3) {
        int n4 = 0;
        while (n > 0) {
            if ((n & 1) > 0) {
                n4 ^= n2;
            }
            n >>>= 1;
            if (((n2 <<= 1) & 0x10000) <= 0) continue;
            n2 ^= n3;
        }
        return n4;
    }

    private int pow_poly(int n, int n2, int n3) {
        int n4 = 1;
        while (n2 > 0) {
            if ((n2 & 1) > 0) {
                n4 = this.mul_poly(n4, n, n3);
            }
            n = this.mul_poly(n, n, n3);
            n2 >>>= 1;
        }
        return n4;
    }

    public int[] parseRiffData(byte[] byArray) {
        int[] nArray = new int[10];
        nArray[2] = this.arsample[(0xC0 & byArray[4]) >>> 6];
        nArray[4] = this.armode[(0xE0 & byArray[6]) >>> 5];
        nArray[6] = this.arbitrate[(0x3F & byArray[4]) >>> 1];
        nArray[8] = this.ac3const[(0xC0 & byArray[4]) >>> 6][(0x3E & byArray[4]) >>> 1] + ((1 & byArray[4]) != 0 ? 2 : 0);
        return nArray;
    }
}

