/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.dvb.projectx.audio.AudioFormatAC3;
import net.sourceforge.dvb.projectx.audio.AudioFormatDTS;
import net.sourceforge.dvb.projectx.audio.AudioFormatLPCM;
import net.sourceforge.dvb.projectx.audio.AudioFormatMPA;
import net.sourceforge.dvb.projectx.audio.AudioFormatWAV;
import net.sourceforge.dvb.projectx.common.Common;

public class AudioFormat {
    private AudioFormat impl = null;
    public static boolean INTEL;
    public static int ID;
    public static int Layer;
    public static int Protection_bit;
    public static int Private_bit;
    public static int Bitrate;
    public static int Sampling_frequency;
    public static int Padding_bit;
    public static int public_bit;
    public static int Mode;
    public static int Mode_extension;
    public static int Copyright;
    public static int Original;
    public static int Channel;
    public static int Emphasis;
    public static int Size;
    public static int Size_base;
    public static int Bound;
    public static int Sblimit;
    public static double Time_length;
    public int nID;
    public int nLayer;
    public int nProtection_bit;
    public int nPrivate_bit;
    public int nBitrate;
    public int nSampling_frequency;
    public int nPadding_bit;
    public int npublic_bit;
    public int nMode;
    public int nMode_extension;
    public int nCopyright;
    public int nOriginal;
    public int nChannel;
    public int nEmphasis;
    public int nSize;
    public int nSize_base;
    public double nTime_length;
    public static int lID;
    public static int lLayer;
    public static int lProtection_bit;
    public static int lPrivate_bit;
    public static int lBitrate;
    public static int lSampling_frequency;
    public static int lPadding_bit;
    public static int lpublic_bit;
    public static int lMode;
    public static int lMode_extension;
    public static int lCopyright;
    public static int lOriginal;
    public static int lChannel;
    public static int lEmphasis;
    public static int lSize;
    public static int lSize_base;
    public static double lTime_length;

    public AudioFormat(int n) {
        this.setNewType(n);
    }

    public AudioFormat(byte[] byArray) {
    }

    public AudioFormat() {
        this.init();
    }

    public void setNewType(int n) {
        switch (n) {
            case 6: {
                this.impl = new AudioFormatDTS();
                break;
            }
            case 0: {
                this.impl = new AudioFormatAC3();
                break;
            }
            case 4: {
                this.impl = new AudioFormatLPCM();
                break;
            }
            case 7: {
                this.impl = new AudioFormatWAV();
                break;
            }
            case 2: {
                this.impl = new AudioFormatMPA();
            }
        }
    }

    public void init() {
        INTEL = false;
        ID = 0;
        Layer = 0;
        Protection_bit = 0;
        Private_bit = 0;
        Bitrate = 0;
        Sampling_frequency = 0;
        Padding_bit = 0;
        Private_bit = 0;
        Mode = 0;
        Mode_extension = 0;
        Copyright = 0;
        Original = 0;
        Channel = 0;
        Emphasis = 0;
        Size = 0;
        Size_base = 0;
        Bound = 0;
        Sblimit = 32;
        Time_length = 0.0;
    }

    public int getLastModeExtension() {
        return lMode_extension;
    }

    public int getID() {
        return ID;
    }

    public int getLayer() {
        return Layer;
    }

    public int getBitrate() {
        return Bitrate;
    }

    public int getSamplingFrequency() {
        return Sampling_frequency;
    }

    public int getMode() {
        return Mode;
    }

    public int getModeExtension() {
        return Mode_extension;
    }

    public int getEmphasis() {
        return Emphasis;
    }

    public int getSize() {
        return Size;
    }

    public int getSizeBase() {
        return Size_base;
    }

    public int getChannel() {
        return Channel;
    }

    public double getFrameTimeLength() {
        return Time_length;
    }

    public int parseHeader(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.impl != null) {
            for (int i = 0; i < n2; ++i) {
                n3 = this.parseHeader(byArray, n + i);
                if (n3 >= 0) continue;
            }
        }
        return n3;
    }

    public int parseHeader(byte[] byArray, int n) {
        return this.impl == null ? 0 : this.impl.parseHeader(byArray, n);
    }

    public int parseNextHeader(byte[] byArray, int n) {
        return this.impl == null ? 0 : this.impl.parseNextHeader(byArray, n);
    }

    public void saveHeader() {
        lID = ID;
        lLayer = Layer;
        lProtection_bit = Protection_bit;
        lPrivate_bit = Private_bit;
        lBitrate = Bitrate;
        lSampling_frequency = Sampling_frequency;
        lPadding_bit = Padding_bit;
        lPrivate_bit = Private_bit;
        lMode = Mode;
        lMode_extension = Mode_extension;
        lCopyright = Copyright;
        lOriginal = Original;
        lChannel = Channel;
        lEmphasis = Emphasis;
        lSize = Size;
        lSize_base = Size_base;
        lTime_length = Time_length;
    }

    public int compareHeader() {
        return this.impl == null ? 0 : this.impl.compareHeader();
    }

    public String displayHeader() {
        return this.impl == null ? "" : this.impl.displayHeader();
    }

    public String saveAndDisplayHeader() {
        this.saveHeader();
        return this.displayHeader();
    }

    public byte[] editFrame(byte[] byArray, int n, int n2) {
        return this.impl == null ? byArray : this.impl.editFrame(byArray, n, n2);
    }

    public void removeCRC(byte[] byArray) {
        if (this.impl != null) {
            this.impl.removeCRC(byArray);
        }
    }

    public int validateCRC(byte[] byArray, int n, int n2) {
        return this.impl == null ? 0 : this.impl.validateCRC(byArray, n, n2);
    }

    public void setAncillaryDataDecoder(boolean bl, boolean bl2) {
        if (this.impl != null) {
            this.impl.setAncillaryDataDecoder(bl, bl2);
        }
    }

    public void decodeAncillaryData(byte[] byArray) {
        if (this.impl != null) {
            this.impl.decodeAncillaryData(byArray);
        }
    }

    public int[] parseRiffData(byte[] byArray) {
        return this.impl == null ? null : this.impl.parseRiffData(byArray);
    }

    public byte[] getRiffHeader() {
        return new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    }

    public void fillStdRiffHeader(String string, long l) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            int n = (int)randomAccessFile.length() - 8;
            int n2 = 1411200;
            randomAccessFile.seek(4L);
            randomAccessFile.writeInt(this.littleEndian(n, 4, true));
            randomAccessFile.seek(16L);
            randomAccessFile.writeInt(this.littleEndian(16, 4, true));
            randomAccessFile.writeShort(this.littleEndian(1, 2, true));
            randomAccessFile.writeShort((short)this.littleEndian(2, 2, true));
            randomAccessFile.writeInt(this.littleEndian(44100, 4, true));
            randomAccessFile.writeInt(this.littleEndian(n2 / 8, 4, true));
            randomAccessFile.writeShort((short)this.littleEndian(4, 2, true));
            randomAccessFile.writeShort((short)this.littleEndian(16, 2, true));
            randomAccessFile.seek(40L);
            randomAccessFile.writeInt(this.littleEndian(n - 36, 4, true));
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public long fillRiffHeader(String string) {
        long l = 0L;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            int n = (int)randomAccessFile.length() - 8;
            randomAccessFile.seek(3L);
            if (!INTEL) {
                randomAccessFile.write(88);
            }
            randomAccessFile.seek(4L);
            randomAccessFile.writeInt(this.littleEndian(n, 4));
            randomAccessFile.seek(16L);
            randomAccessFile.writeInt(this.littleEndian(16, 4));
            randomAccessFile.writeShort(this.littleEndian(1, 2));
            randomAccessFile.writeShort((short)this.littleEndian(lChannel, 2));
            randomAccessFile.writeInt(this.littleEndian(lSampling_frequency, 4));
            randomAccessFile.writeInt(this.littleEndian(lBitrate / 8, 4));
            randomAccessFile.writeShort((short)this.littleEndian(lMode, 2));
            randomAccessFile.writeShort((short)this.littleEndian(lSize, 2));
            randomAccessFile.seek(40L);
            randomAccessFile.writeInt(this.littleEndian(n - 36, 4));
            randomAccessFile.close();
            l = 8000L * (long)(n - 36) / (long)lBitrate;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return l;
    }

    public int littleEndian(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= bl ? (0xFF & byArray[n + i]) << i * 8 : (0xFF & byArray[n + i]) << (n2 - 1 - i) * 8;
        }
        return n3;
    }

    public int littleEndian(int n, int n2) {
        return this.littleEndian(n, n2, INTEL);
    }

    public int littleEndian(int n, int n2, boolean bl) {
        if (!bl) {
            return n;
        }
        if (n2 == 4) {
            return 0xFF & n >>> 24 | (0xFF & n >>> 16) << 8 | (0xFF & n >>> 8) << 16 | (0xFF & n) << 24;
        }
        return 0xFF & n >>> 8 | (0xFF & n) << 8;
    }
}

