/*
 * Created on 2004/07/27 Author aki@www.xucker.jpn.org License Apache2.0 or
 * Common Public License
 */
package org.jpn.xucker.subplayer;



import java.util.List;
import java.util.Vector;

import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.commons.audio.splitter.AudioCutter;
import org.jpn.xucker.commons.audio.splitter.JavaSoundWaveAudioCutter;
import org.jpn.xucker.commons.audio.splitter.StopperOfAudioCutter;
import org.jpn.xucker.commons.swt.ui.FileDirChoicer;
import org.jpn.xucker.mp3.JavaLayerMP3Cutter;
import org.jpn.xucker.mp3.MP3SearchTime;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.subtitle.StandardSubObject;

import java.io.File;
import java.io.IOException;

public class SubPlayExportAudioDialog implements SelectionListener ,StopperOfAudioCutter,Runnable{
    /**
     * @param shell
     */
    private Group group1;

    private FileDirChoicer baseDir;
    private FileDirChoicer secondSub;
    private FileDirChoicer firstWav;

//    private Button firstSubBrowseButton;
    //private Button secondSubBrowseButton;
    //private Button firstWavBrowseButton;
    
    public  static Log log=
        LogFactory.getLog(SubPlayExportAudioDialog.class);
    
    public String getFirstSubFilePath() {
        return baseDir.getAbsoluteFilePath();
    }
    public void setFirstSubFilePath(String firstSubFilePath) {
        baseDir.setFilePath(firstSubFilePath);
    }
    public String getFirstWavFilePath() {
        return firstWav.getAbsoluteFilePath();
    }
    public void setFirstWavFilePath(String firstWavFilePath) {
        firstWav.setFilePath(firstWavFilePath);
    }
    public String getSecondSubFilePath() {
        return secondSub.getAbsoluteFilePath();
    }
    public void setSecondSubFilePath(String secondSubFilePath) {
        secondSub.setFilePath(secondSubFilePath);
    }
    
    private Button okButton;

    private Button cancelButton;

    Shell shell;

    

  

    
    private Button freettsButton;
    public Shell getShell() {
        return shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    

    SubPlayMain main;
    SubPlayExportAudioDialog dialog;
    public SubPlayExportAudioDialog(SubPlayMain main,Shell shell) {
        this.dialog=this;
       this.main=main;
      
       
        this.shell = shell;
        
        shell.setText("̏o");
        shell.setBounds(50, 50, 370, 200);
        RowLayout layout = new RowLayout();
        shell.setLayout(layout);
        group1 = new Group(shell, SWT.NULL);
        group1.setText("o͐ x[XtH_[");
        RowData group1_data = new RowData();
        group1_data.width = 350;
        group1.setLayoutData(group1_data);
        RowLayout group1_layout = new RowLayout();
        group1.setLayout(group1_layout);

        /*
        firstSubPath = new Label(group1, SWT.NULL);
        firstSubPath.setText("");
        RowData filePath_data = new RowData();
        filePath_data.width = 300;
        firstSubPath.setLayoutData(filePath_data);

        //Q
        firstSubBrowseButton = new Button(group1, SWT.NULL);
        firstSubBrowseButton.setText("Q");
        firstSubBrowseButton.addSelectionListener(this);
        RowData browseButton_data = new RowData();
        firstSubBrowseButton.setLayoutData(browseButton_data);
        */
        baseDir=new FileDirChoicer(group1,SWT.NULL,FileDirChoicer.DIR,null,true);
        baseDir.setFilePath(SystemUtils.USER_DIR);//how to set mydocument?
        
        Group frameGroup=new Group(shell,SWT.NULL);
        frameGroup.setLayout(new RowLayout());
        frameGroup.setText("t[I");
        RowData secondSubGroup_data = new RowData();
        secondSubGroup_data.width=350;
        frameGroup.setLayoutData(secondSubGroup_data);
        
        frameAll = new Button(frameGroup,SWT.RADIO);
        frameAll.setText("ׂ");
        
        frameMark = new Button(frameGroup,SWT.RADIO);
        frameMark.setText("}[NL̂");
        
        frameUnmark = new Button(frameGroup,SWT.RADIO);
        frameUnmark.setText("}[N̂");
        
        frameAll.setSelection(true);
        
        Group repeatGroup=new Group(shell,SWT.NULL);
        repeatGroup.setLayout(new RowLayout());
        repeatGroup.setText("JԂ");
        RowData wavegroup_data = new RowData();
        wavegroup_data.width=350;
        repeatGroup.setLayoutData(wavegroup_data);
        Label r1=new Label(repeatGroup,SWT.NULL);
        r1.setText("JԂ");
        repeatCombo = new Combo(repeatGroup,SWT.READ_ONLY);
        RowData tmp=new RowData();
        tmp.width=30;
        repeatCombo.setLayoutData(tmp);
        
        repeatCombo.add("1");
        repeatCombo.add("3");
        repeatCombo.add("5");
        repeatCombo.add("10");
        repeatCombo.add("20");
        repeatCombo.add("30");
        repeatCombo.select(0);
        
        Label r2=new Label(repeatGroup,SWT.NULL);
        r2.setText("");
        
        Label r23=new Label(repeatGroup,SWT.NULL);
        r23.setText("");
        r23.setToolTipText("MP3t@C̋󔒂͌݃T|[gĂ܂");
        
        spaceCombo = new Combo(repeatGroup,SWT.READ_ONLY);
        tmp=new RowData();
        tmp.width=30;
        spaceCombo.setLayoutData(tmp);
        
        spaceCombo.add("0");
        spaceCombo.add("0.5");
        spaceCombo.add("1");
        spaceCombo.add("3");
        spaceCombo.add("5");
        spaceCombo.add("10");
        spaceCombo.select(0);
        Label r3=new Label(repeatGroup,SWT.NULL);
        
        r3.setText("b");
        
        progressBar = new ProgressBar(shell,SWT.NULL);
        //OK
        okButton = new Button(shell, SWT.NULL);
        okButton.setText("@o͊Jn@");
        okButton.addSelectionListener(this);
        RowData okButton_data = new RowData();
        okButton.setLayoutData(okButton_data);
        
        

        //LZ
        cancelButton = new Button(shell, SWT.NULL);
        cancelButton.setText("LZ");
        cancelButton.addSelectionListener(this);
        RowData cancelButton_data = new RowData();
        cancelButton.setLayoutData(cancelButton_data);
        
        
        //currentlly not support mp3's space.
        if(main.getSubPlayFileXmlObject().getFirstWavFilePath().endsWith(".mp3")){
            spaceCombo.setEnabled(false);
        }

    }

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == null) {
            //
            System.out.println("target==null");
        }
        
        
        //OK
        else if (target == okButton) {
            do_okButton();
        }
        //LZ
        else if (target == cancelButton) {
            do_cancelButton();
        }

    }

    

    public void widgetDefaultSelected(SelectionEvent arg0) {
        // TODO Auto-generated method stub

    }

   

    private boolean executing;

    private Button frameAll;

    private Button frameMark;

    private Button frameUnmark;
    
    private double spaceTime;
    public void do_okButton() {
        okButton.setEnabled(false);
        cancelButton.setText("~");
        executing=true;
        //ok
        //start export.
        
        //disable ok.
        //mode execute.
        repeatTime=Integer.parseInt(repeatCombo.getItem(repeatCombo.getSelectionIndex()));
        spaceTime=Double.parseDouble(spaceCombo.getItem(spaceCombo.getSelectionIndex()));
        List subList=main.getSublist();
        useSub = new Vector();
        if(frameMark.getSelection()){
            SubPlayMain.log.trace("frameMark selected");
            for(int i=0;i<subList.size();i++){
                if(main.getMarkControler().isMarked((StandardSubObject)subList.get(i))){
                    useSub.add(subList.get(i));
                    log.trace("add frame "+i);
                }
            }
        }else if(frameUnmark.getSelection()){
            log.trace("frameMark unselected");
            for(int i=0;i<subList.size();i++){
                if(!main.getMarkControler().isMarked((StandardSubObject)subList.get(i))){
                    useSub.add(subList.get(i));
                    log.trace("add frame "+i);
                }
            }
        }else{
            log.trace("frameMark all");
            for(int i=0;i<subList.size();i++){
                    useSub.add(subList.get(i));
                
            }
        }
        
        int totalFrameSize=useSub.size();
        progressBar.setSelection(0);
        progressBar.setMaximum(totalFrameSize);
        
        dir = baseDir.getFile();
        Thread thread=new Thread(this);
        thread.start();
        
        
        
    }

    private int repeatTime;

    public void run(){
        

        stopper=false;
        String path=main.getSubPlayFileXmlObject().getFirstWavFilePath();
        //count total.
        
        
        
        AudioCutter cutter=null;
        boolean mp3=false;
        if(path.endsWith(".mp3")){
            cutter=new JavaLayerMP3Cutter();
            mp3=true;
        }else{
            cutter=new JavaSoundWaveAudioCutter();
        }
        
        cutter.setStopper(dialog);
        
        File inputFile=new File(path);
        
       
        MP3SearchTime st=null;
        if(path.endsWith(".mp3")){
        try {
            st = new MP3SearchTime(inputFile);
            st.setStopper(this);
        } catch (IOException e2) {
            // TODO Auto-generated catch block
            e2.printStackTrace();
        }
        
        }
        
        
        for(int i=0;i<useSub.size();i++){
        if(shell.isDisposed()){
            stopper=true;
        }
        if(stopper){
            break;
        }
        String newName=createNewFileName(inputFile.getName(),i+1);
        StandardSubObject sub=(StandardSubObject)useSub.get(i);
        File tmpFile=null;
        try {
            tmpFile = File.createTempFile("tmp",newName);
            log.trace("create tmpFile:"+ tmpFile.getAbsolutePath());
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        
        
        try {
            log.trace("subtime:"+sub.getStartTime()+sub.getEndTime());
        if(mp3){
            
            //cutter.cut(inputFile,sub.getStartTime(),sub.getEndTime(),tmpFile);
            
            long times[]=new long[2];//MP3Utils.searchByteByTime(inputFile,sub.getStartTime(),sub.getEndTime());
            
            
            times[0]=st.findByte(sub.getStartTime());
            times[1]=st.findByte(sub.getEndTime());
            
            MP3Utils.copy(inputFile,tmpFile,times[0],times[1]-times[0]);
            
            WaveUtils.repeatFile(tmpFile,new File(dir,newName),repeatTime);
        }else{
            //wav
            
            
                cutter.cut(inputFile,sub.getStartTime(),sub.getEndTime(),tmpFile);
                //wav
                WaveUtils.repeatWave(tmpFile,new File(dir,newName),repeatTime,(int)(1000*spaceTime),false);
           
        }
        
        } catch (IOException e1) {
            // TODO Auto-generated catch block
            shell.getDisplay().syncExec(new ErrorAction(new File(dir,newName).getAbsolutePath()));
            log.fatal("",e1);
            return ;
        }
        
        boolean result=tmpFile.delete();
        
        if(log.isTraceEnabled() || result==false){
        if(result){
            log.trace("delete tmpFile: "+tmpFile.getAbsoluteFile()+ " "+result);
        }else{
            log.error("delete faild tmpFile: "+tmpFile.getAbsoluteFile());
        	}
        }
        
        shell.getDisplay().asyncExec(new SetProgressbar(i+1));
        
        }
        
        if(!stopper){
        shell.getDisplay().syncExec(new FinishAction());
        }else{
            shell.getDisplay().syncExec(new InitAction());
        }
//     
    }
    
 
    
    public class SetProgressbar implements Runnable{
        int value;
        public SetProgressbar(int value){
            this.value=value;
        }
        public void run(){
            progressBar.setSelection(value);
        }
    }
    
    public class InitAction implements Runnable{
        public void run(){
           progressBar.setSelection(0);
           okButton.setEnabled(true);
           cancelButton.setText("LZ");// should mix.
        }
    }
    
    public class FinishAction implements Runnable{
        public void run(){
            //show message.
            log.trace("finish output");
            MessageBox box=new MessageBox(shell);
            box.setMessage("o͂܂");
            box.open();
            //
            shell.close();
        }
    }
    
    public class ErrorAction implements Runnable{
        private String fileName;
        public ErrorAction(String fileName){
            this.fileName=fileName;
        }
        public void run(){
            //show message.
            log.trace("error output");
            MessageBox box=new MessageBox(shell,SWT.ICON_ERROR);
            box.setMessage("t@C̏o͂Ɏs܂BfBXN̗eʂȂAt@Cgp܂B\n"+fileName);
            box.open();
            //
            new InitAction().run();
        }
    }
    
    public String createNewFileName(String name,int index){
        int last=name.lastIndexOf(".");
        if(last==-1){
            log.fatal("wrong file name:"+name);
            return null;
        }
        String indexName=""+index;
        int numberSize=4;//0000 - 9999
        while(indexName.length()<numberSize){
            indexName="0"+indexName;
        }
        
        return name.substring(0,last)+indexName+name.substring(last);
    }
    //LZ
    public void do_cancelButton() {
        if(executing){
        stopper=true;
        executing=false;
        
        }else{
        shell.close();
        }
    }
    /* (non-Javadoc)
     * @see org.jpn.xucker.mp3.StopperOfMP3Cutter#isStopped()
     */
    boolean stopper;

    private ProgressBar progressBar;

    private Combo repeatCombo;

    private List useSub;

    private File dir;

    private Combo spaceCombo;
    public boolean isStopped() {
        // TODO Auto-generated method stub
        return stopper;
    }

    
}

