/*
 * Created on 2005/01/24
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.subplayer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;

import org.jpn.xucker.rcp.subplayer.compatibility.Mark;
import org.jpn.xucker.subtitle.StandardSubObject;



/**
 * 
 *
 */
public class MarkControler {
private SubPlayMain main;
private Button markButton;
Map markMap=new HashMap();

private Mark currentMark;

public MarkControler(SubPlayMain main,Button markButton){
    this.main=main;
    this.markButton=markButton;
}
public void prev(){
   int index=-1;
   Mark[] marks=getMarkArray();
   
   if(currentMark!=null){
  
   for (int i = 0; i < marks.length; i++) {
   if(marks[i].equals(currentMark)){
       	index=i-1;
       	break;
   		}
   }	
   
   if(index!=-1){
       currentMark=marks[index];
       setStatus(true);
       //return;
   }
   
   }
   
  // System.out.println("prev "+index);
   
   if(index==-1){
    if(marks.length>0){
        currentMark=marks[marks.length-1];
        setStatus(true);
    }
   }
   
   moveFrame(currentMark);
   
}

public boolean canMove(){
    return markMap.size()>1;
}

/**
 * @param currentMark2
 */
private void moveFrame(Mark mark) {

    if(mark!=null){
    main.moveFrame(mark);
    }
}

public Mark[] getMarkArray(){
    Mark[] marks=(Mark[])markMap.keySet().toArray(new Mark[markMap.size()]);
    
    Arrays.sort(marks);
    return marks;
}
public void next(){
    int index=-1;
    Mark[] marks=getMarkArray();
    for(int i=0;i<marks.length;i++){
        SubPlayMain.log.trace(marks[i]);
    }
    if(currentMark!=null){
   
    for (int i = 0; i < marks.length; i++) {
    if(marks[i].equals(currentMark)){
        	index=i+1;
        	break;
    		}
    }	
    
    if(index>=0 && index!=marks.length){
        currentMark=marks[index];
        setStatus(true);
       
    }
    
    }
    
    
    if(index==marks.length){
    index=-1;
    }
    
    //System.out.println("current "+currentMark+"next "+index);
    
    if(index==-1){
        if(marks.length>0){
            currentMark=marks[0];
            setStatus(true);
        }
    }
    
    moveFrame(currentMark);
}

public void setStatus(boolean bool){
    if(bool){
        markButton.setBackground(new Color(null,0x33,0x66,0xcc));
        markButton.setSelection(true);
    }else{
        markButton.setBackground(new Color(null,255,255,255));
        markButton.setSelection(false);
    }
}

public boolean isMarked(StandardSubObject subObject){
    return findMark(subObject)!=null;
}

public void check(StandardSubObject subObject){
    setStatus(markButton.getSelection());
   
    
    if(!markButton.getSelection()){
        markMap.remove(toMapKey(subObject));
    }else{
        Mark mark=findMark(subObject);
        if(mark==null){
            mark=new Mark(subObject);
            markMap.put(mark,mark);
            currentMark=mark;
        }
        
    }
    
}
public Mark toMapKey(StandardSubObject subObject){
 return new Mark(subObject);   
}
public Mark findMark(StandardSubObject subObject){
   return (Mark)markMap.get(toMapKey(subObject));
}



public Mark getCurrentMark() {
    return currentMark;
}
public void setCurrentMark(Mark currentMark) {
    this.currentMark = currentMark;
}
/**
 * 
 */
public void init() {
   markMap=new HashMap();
}
/**
 * @param sub
 * @param mark
 */
public void addMark(Mark mark) {
    markMap.put(mark,mark);
}
}
