package org.jpn.xucker.rcp.subplayer.views;


import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;


/**
 * This sample class demonstrates how to plug-in a new
 * workbench view. The view shows data obtained from the
 * model. The sample creates a dummy model on the fly,
 * but a real implementation would connect to the model
 * available either in this or another plug-in (e.g. the workspace).
 * The view is connected to the model using a content provider.
 * <p>
 * The view uses a label provider to define how model
 * objects should be presented in the view. Each
 * view can present the same model objects using
 * different labels and icons, if needed. Alternatively,
 * a single label provider can be shared between views
 * in order to ensure that objects of the same type are
 * presented in the same way everywhere.
 * <p>
 */

public class TranslateView extends ViewPart {
    public static Log log=LogFactory.getLog(TranslateView.class);
    public static final String ID=TranslateView.class.getName();
    private Browser browser;
    
    private String baseURL="http://www.excite.co.jp/world/english/";
    private String queryName="before";
	/**
	 * The constructor.
	 */
	public TranslateView() {
	}

	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	public void createPartControl(Composite parent) {
	    browser = new Browser(parent,SWT.NONE);
        
	    browser.setUrl(baseURL);
	}
	public void setText(String text){
	    try {
            String q=URLEncoder.encode(text,"Shift_JIS");
            log.info("query="+q);
            setUrl(baseURL+"?"+queryName+"="+q);
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
	}
	public void setUrl(String url){
	    browser.setUrl(url);
	}

	
	private void hookContextMenu() {
		
	}


	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		
	}
}