package org.jpn.xucker.rcp.subplayer.preferences;

import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;


/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class LabelPage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
   
    public static final String LABEL_COLOR_BASE="subview.color_label";
	public static final String LABEL1_COLOR = "subview.color_label1";
	public static final String LABEL2_COLOR = "subview.color_label2";
	public static final String LABEL3_COLOR = "subview.color_label3";
	public static final String LABEL4_COLOR = "subview.color_label4";
	public static final String LABEL5_COLOR = "subview.color_label5";
	public static final String LABEL6_COLOR = "subview.color_label6";
	public static final String LABEL7_COLOR = "subview.color_label7";
	public static final String LABEL8_COLOR = "subview.color_label8";
	public static final String LABEL9_COLOR = "subview.color_label9";
	
	 public static final String LABEL_BASE="subview.label";
		
	public static final String LABEL1 = "subview.label1";
	public static final String LABEL2 = "subview.label2";
	public static final String LABEL3 = "subview.label3";
	public static final String LABEL4 = "subview.label4";
	public static final String LABEL5 = "subview.label5";
	public static final String LABEL6 = "subview.label6";
	public static final String LABEL7 = "subview.label7";
	public static final String LABEL8 = "subview.label8";
	//public static final String LABEL9 = "subview.label9";
	
	public static int toIndex(String key){
	    if(key.startsWith((LABEL_COLOR_BASE))){
	        return Integer.parseInt(key.substring(LABEL_COLOR_BASE.length()));
	    }else{
	        return -1;
	    }
	}
	public LabelPage() {
		super(FLAT);
		setPreferenceStore(SubplayerPlugin.getDefault().getPreferenceStore());
		setDescription("Label setting");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		/*
		FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FONT,fontData);
		
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR,ColorConstants.white.getRGB());
		*/
		
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */
	

    protected void createFieldEditors() {
       
        Composite cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL1_COLOR,"Label1",new Composite(cp,SWT.NULL)));
        Composite ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL1,"",ch));
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL2_COLOR,"Label2",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL2,"",ch));
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL3_COLOR,"Label3",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL3,"",ch));
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL4_COLOR,"Label4",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL4,"",ch));
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL5_COLOR,"Label5",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL5,"",ch));
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL6_COLOR,"Label6",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL6,"",ch));
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL7_COLOR,"Label7",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL7,"",ch));
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL8_COLOR,"Label8",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        addField(new StringFieldEditor(LABEL8,"",ch));
        
        
        cp=getFieldEditorParent();
        cp.setLayout(new GridLayout(2,false));
        addField(new ColorFieldEditor(LABEL9_COLOR,"System",new Composite(cp,SWT.NULL)));
        ch=new Composite(cp,SWT.NULL);
        ch.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        //addField(new StringFieldEditor(LABEL9,"",ch));//system label.
        /*
        addField(new ColorFieldEditor(LABEL2_COLOR,"Label2 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL3_COLOR,"Label3 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL4_COLOR,"Label4 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL5_COLOR,"Label5 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL6_COLOR,"Label6 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL7_COLOR,"Label7 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL8_COLOR,"Label8 Color",getFieldEditorParent()));
        addField(new ColorFieldEditor(LABEL9_COLOR,"Label9 Color",getFieldEditorParent()));
        */
        
        
        
       
        /*addField(new RadioGroupFieldEditor(
		        INITIAL_ZOOM,
				"initial_zoom", //$NON-NLS-1$
				4,
				new String[][] { {"1/16","0.0625"},{"1/8","0.125"},{"1/4","0.25"},{"1/2","0.5"},{"1","1"},{"2","2"},{"4","4"},{"8","8"}
			}, getFieldEditorParent()));
        
        
        FieldEditor editor=new SliderFieldEditor(
                JPEG_QUALITY,
    			"jpeg_quality(if you use high-quality,a file will be bigger than PNG)", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),1,100,defaultJpegQuality);
        
        addField(editor);
        */
        
    }
	
	public void init(IWorkbench workbench) {
	}
}