package org.jpn.xucker.rcp.subplayer.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.subplayer.views.SubView;


/**
 * Our sample action implements workbench action delegate.
 * The action proxy will be created by the workbench and
 * shown in the UI. When the user tries to use the action,
 * this delegate will be created and execution will be 
 * delegated to it.
 * @see IWorkbenchWindowActionDelegate
 */
public class MoveSubtitleAction implements IWorkbenchWindowActionDelegate {
    public static Log log=LogFactory.getLog(MoveSubtitleAction.class);
    
    private IWorkbenchWindow window;
	public static final String MOVE_NEXT="org.jpn.xucker.rcp.subplayer.actions.movesubtitle.next";
	public static final String MOVE_PREV="org.jpn.xucker.rcp.subplayer.actions.movesubtitle.prev";
	public static final String MOVE_LABEL_NEXT="org.jpn.xucker.rcp.subplayer.actions.movesubtitle.label_next";
	public static final String MOVE_LABEL_PREV="org.jpn.xucker.rcp.subplayer.actions.movesubtitle.label_prev";
	
	/**
	 * The constructor.
	 */
	public MoveSubtitleAction() {
	}

	/**
	 * The action has been activated. The argument of the
	 * method represents the 'real' action sitting
	 * in the workbench UI.
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
	    log.info(""+action.getId());
	   //view
	    SubView view=(SubView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(SubView.ID);
		if(view!=null){
		   if(action.getId().equals(MOVE_NEXT)){
		       view.moveSubtitleNext();
		   }else if(action.getId().equals(MOVE_PREV)){
		   view.moveSubtitlePrev();
		   }else if(action.getId().equals(MOVE_LABEL_NEXT)){
			   view.moveSubtitleLabelNext();
		   }else if(action.getId().equals(MOVE_LABEL_PREV)){
			   view.moveSubtitleLabelPrev();
		   }
		}
	}

	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
}