/*
 * Created on 2003/05/24
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.jpn.xucker.rcp.subplayer;



import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Shell;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.swt.ui.StringTools;
import org.jpn.xucker.rcp.draw2d.WrapTextPainter;



/**
 * @author ak
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TextAndImageFigure extends Figure{
    public static Log log=LogFactory.getLog(TextAndImageFigure.class);
	private Image image;

	private String text;
    
	private Font font;
	
	
	private Shell shell;
	
	
	
	private int alpha=200;
	
	private boolean imageOnly;
	
	private boolean reimage;
	
	private boolean disposeImage;//for auto dispose,not use image cache.
    public String getText() {
        return text;
    }
    public void setText(String text) {
        this.text = text;
        disposeBuffer();
    }
    
    
	/**
     * 
     */
    private void disposeBuffer() {
        log.trace("call dispose buffer");
        if(bufferImage!=null){
         log.trace("dispose buffer");
        bufferImage.dispose();
        bufferImage=null;
        bufferData=null;
        
        imageGc.dispose();
        imageGc=null;
        System.gc();
        }
    }
    public TextAndImageFigure(Shell shell){
		
		this.shell=shell;
		//font=new Font(null,"MS ",24,SWT.NONE);
	}
	
    public Image getImage() {
        return image;
    }
   
    public void setImage(Image image) {
        //should self dispose image.
        if(disposeImage){
        if(this.image!=null){
            this.image.dispose();
        }
        }
        
        this.image = image;
        reimage=true;
    }
   
    public void setSize(int x,int y){
       reimage=true;
       
        super.setSize(x,y);
       // disposeBuffer(); 
        
        
    }
    
    private Image bufferImage;
    private ImageData bufferData;
    private GC imageGc;
    private WrapTextPainter wrapTextPainter;
    
    int marginX=10;
    int marginY=10;
    
    public void createImage(){
        
        if(bufferImage!=null){
           disposeBuffer();
        }
        log.trace("textandimage");
        
        bufferData=new ImageData(this.getClientArea().width,this.getClientArea().height,24,new PaletteData(0xff,0xff00,0xff0000));
        bufferData.alpha=alpha;        
        
        bufferImage = new Image(shell.getDisplay(),bufferData);
        imageGc = new GC(bufferImage);
        imageGc.setBackground(this.getBackgroundColor());
        imageGc.setForeground(this.getForegroundColor());
        imageGc.fillRectangle(0,0,getClientArea().width,getClientArea().height);
		//System.out.println(this.getBounds());
		
		if(image!=null){
		    if(image.getBounds().height>this.getClientArea().height){
		        imageGc.drawImage(image,0,this.getClientArea().height-image.getBounds().height);
		    }else{
		        imageGc.drawImage(image,0,0);
		    }
		    
		}
		
		if(!imageOnly){
		if(text!=null){
		    
		    if(font!=null){
		    imageGc.setFont(font);
		    }
		    //imageGc.setBackground(ColorConstants.red);
		    //imageGc.fillRectangle(0,0,this.getClientArea().width,this.getClientArea().height);
    	 //   System.out.println(font.getFontData()[0].getName());
		    wrapTextPainter = new WrapTextPainter(this.getClientArea().width-marginX*2,font);
            wrapTextPainter.setText(text);
		    wrapTextPainter.paint(imageGc,marginX,marginY);
		    //String newText=StringTools.wrapString(imageGc,this.getClientArea().width-dx*2,text);
		    //System.out.println(newText);
		    //imageGc.drawString(newText,dx,10);
		    //imageGc.drawText(newText,dx,10,SWT.DRAW_DELIMITER|SWT.DRAW_TRANSPARENT);
		    //imageGc.drawText(text,10,10);
		}
		
		}
		
		
		
		
    }
    
	public void paintFigure(Graphics g) {
	    
	   if(bufferImage==null ||  reimage){
	       createImage();
	   }
	   
	   g.drawImage(bufferImage,getClientArea().x,getClientArea().y);
	   
	}
	
    public int getAlpha() {
        return alpha;
    }
    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if(bufferData!=null){
            bufferData.alpha=alpha;
        }
    }
    public Font getFont() {
        return font;
    }
    public void setFont(Font font) {
        this.font = font;
        disposeBuffer();
    }
    public boolean isDisposeImage() {
        return disposeImage;
    }
    public void setDisposeImage(boolean disposeImage) {
        this.disposeImage = disposeImage;
    }
    public WrapTextPainter getWrapTextPainter() {
        return wrapTextPainter;
    }
    public int getMarginX() {
        return marginX;
    }
    public void setMarginX(int marginX) {
        this.marginX = marginX;
    }
    public int getMarginY() {
        return marginY;
    }
    public void setMarginY(int marginY) {
        this.marginY = marginY;
    }
}
