/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.MessageConsolePartition;

public class MessageConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension {
    private IDocument fDocument = null;
    private List fPartitions = new ArrayList(5);
    private MessageConsoleStream fLastStream = null;
    private int highWaterMark = 100000;
    private int lowWaterMark;
    private int maxAppendSize = this.lowWaterMark = 80000;
    private List streamEntries = new ArrayList();
    private boolean killed = false;
    private boolean updaterThreadStarted = false;
    private IConsoleManager fConsoleManager;

    public MessageConsolePartitioner() {
        Document doc = new Document();
        this.connect((IDocument)doc);
    }

    public void setWaterMarks(int low, int high) {
        if (low >= high) {
            throw new IllegalArgumentException(ConsoleMessages.getString("MessageConsolePartitioner.2"));
        }
        if (low < 1000) {
            throw new IllegalArgumentException(ConsoleMessages.getString("MessageConsolePartitioner.3"));
        }
        this.lowWaterMark = low;
        this.highWaterMark = high;
        this.maxAppendSize = Math.min(80000, low);
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public int getMaxAppendSize() {
        return this.maxAppendSize;
    }

    public void setMaxAppendSize(int maxAppendSize) {
        this.maxAppendSize = maxAppendSize;
    }

    public void connect(IDocument document) {
        this.fDocument = document;
        document.setDocumentPartitioner((IDocumentPartitioner)this);
        this.fConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
        this.killed = true;
        this.fConsoleManager = null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{MessageConsolePartition.MESSAGE_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (offset == 0 && length == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int end = offset + length;
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (offset >= partitionStart && offset <= partitionEnd || offset < partitionStart && end >= partitionStart) {
                list.add(partition);
            }
            ++i;
        }
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        String text = event.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            return new Region(0, 0);
        }
        this.addPartition(new MessageConsolePartition(this.fLastStream, event.getOffset(), text.length()));
        ITypedRegion[] affectedRegions = this.computePartitioning(event.getOffset(), text.length());
        if (affectedRegions.length == 0) {
            return null;
        }
        if (affectedRegions.length == 1) {
            return affectedRegions[0];
        }
        int affectedLength = affectedRegions[0].getLength();
        int i = 1;
        while (i < affectedRegions.length) {
            ITypedRegion region = affectedRegions[i];
            affectedLength += region.getLength();
            ++i;
        }
        return new Region(affectedRegions[0].getOffset(), affectedLength);
    }

    protected void checkOverflow() {
        if (this.highWaterMark >= 0 && this.fDocument.getLength() > this.highWaterMark) {
            int overflow = this.fDocument.getLength() - this.lowWaterMark;
            try {
                int nextLineOffset;
                int line = this.fDocument.getLineOfOffset(overflow);
                overflow = nextLineOffset = this.fDocument.getLineOffset(line + 1);
            }
            catch (BadLocationException badLocationException) {}
            ArrayList<MessageConsolePartition> newParitions = new ArrayList<MessageConsolePartition>(this.fPartitions.size());
            Iterator partitions = this.fPartitions.iterator();
            while (partitions.hasNext()) {
                ITypedRegion region = (ITypedRegion)partitions.next();
                if (!(region instanceof MessageConsolePartition)) continue;
                MessageConsolePartition messageConsolePartition = (MessageConsolePartition)region;
                MessageConsolePartition newPartition = null;
                int offset = region.getOffset();
                if (offset < overflow) {
                    int endOffset = offset + region.getLength();
                    if (endOffset >= overflow) {
                        int length = endOffset - overflow;
                        newPartition = messageConsolePartition.createNewPartition(0, length);
                    }
                } else {
                    newPartition = messageConsolePartition.createNewPartition(messageConsolePartition.getOffset() - overflow, messageConsolePartition.getLength());
                }
                if (newPartition == null) continue;
                newParitions.add(newPartition);
            }
            this.fPartitions = newParitions;
            try {
                this.fDocument.replace(0, overflow, "");
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private MessageConsolePartition addPartition(MessageConsolePartition partition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add(partition);
        } else {
            int index = this.fPartitions.size() - 1;
            MessageConsolePartition last = (MessageConsolePartition)((Object)this.fPartitions.get(index));
            if (last.canBeCombinedWith(partition)) {
                partition = last.combineWith(partition);
                this.fPartitions.set(index, partition);
            } else {
                this.fPartitions.add(partition);
            }
        }
        return partition;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    private void startUpdaterThread() {
        if (this.updaterThreadStarted) {
            return;
        }
        this.updaterThreadStarted = true;
        Runnable r = new Runnable(){

            public void run() {
                while (!MessageConsolePartitioner.this.killed && MessageConsolePartitioner.this.streamEntries.size() > 0) {
                    List list = MessageConsolePartitioner.this.streamEntries;
                    synchronized (list) {
                        StreamEntry streamEntry = (StreamEntry)MessageConsolePartitioner.this.streamEntries.get(0);
                        MessageConsolePartitioner.this.streamEntries.remove(0);
                        Runnable innerRunnable = new Runnable(this, streamEntry){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ StreamEntry val$streamEntry;
                            {
                                this.this$1 = var1_1;
                                this.val$streamEntry = streamEntry;
                            }

                            public void run() {
                                MessageConsolePartitioner.access$2(1.access$0(this.this$1), this.val$streamEntry.stream);
                                try {
                                    MessageConsolePartitioner.access$3(1.access$0(this.this$1)).replace(MessageConsolePartitioner.access$3(1.access$0(this.this$1)).getLength(), 0, this.val$streamEntry.text.toString());
                                    1.access$0(this.this$1).checkOverflow();
                                    MessageConsolePartitioner.access$4(1.access$0(this.this$1)).warnOfContentChange(this.val$streamEntry.stream.getConsole());
                                }
                                catch (BadLocationException badLocationException) {}
                            }
                        };
                        Display display = ConsolePlugin.getStandardDisplay();
                        if (display != null) {
                            display.asyncExec(innerRunnable);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                MessageConsolePartitioner.this.updaterThreadStarted = false;
            }

            static /* synthetic */ MessageConsolePartitioner access$0(1 var0) {
                return var0.MessageConsolePartitioner.this;
            }
        };
        new Thread(r, "MessageConsoleUpdaterThread").start();
    }

    public void appendToDocument(String text, MessageConsoleStream stream) {
        int offset = 0;
        int length = text.length();
        List list = this.streamEntries;
        synchronized (list) {
            if (this.streamEntries.size() > 0) {
                StreamEntry streamEntry = (StreamEntry)this.streamEntries.get(this.streamEntries.size() - 1);
                if (streamEntry.stream == stream) {
                    int emptySpace = this.maxAppendSize - streamEntry.text.length();
                    if (length <= emptySpace) {
                        streamEntry.text.append(text);
                        offset = length;
                        length = 0;
                    } else {
                        streamEntry.text.append(text.substring(offset, emptySpace));
                        offset += emptySpace;
                        length -= emptySpace;
                    }
                }
            }
            while (length > 0) {
                int toCopy = Math.min(this.maxAppendSize, length);
                String substring = text.substring(offset, offset + toCopy);
                StreamEntry streamEntry = new StreamEntry(substring, stream);
                this.streamEntries.add(streamEntry);
                offset += toCopy;
                length -= toCopy;
            }
        }
        this.startUpdaterThread();
    }

    static /* synthetic */ void access$2(MessageConsolePartitioner messageConsolePartitioner, MessageConsoleStream messageConsoleStream) {
        messageConsolePartitioner.fLastStream = messageConsoleStream;
    }

    static /* synthetic */ IDocument access$3(MessageConsolePartitioner messageConsolePartitioner) {
        return messageConsolePartitioner.fDocument;
    }

    static /* synthetic */ IConsoleManager access$4(MessageConsolePartitioner messageConsolePartitioner) {
        return messageConsolePartitioner.fConsoleManager;
    }

    private class StreamEntry {
        MessageConsoleStream stream;
        StringBuffer text;

        StreamEntry(String text, MessageConsoleStream stream) {
            this.stream = stream;
            this.text = new StringBuffer(text);
        }
    }
}

