/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.registry.NestedRegistryModelObject;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class Extension
extends NestedRegistryModelObject
implements IExtension {
    private String extensionPoint;
    private String id;
    protected Object elements;
    protected int subElementsCacheOffset;
    protected boolean fullyLoaded = true;

    public boolean equals(Object object) {
        if (object instanceof Extension) {
            Extension em = (Extension)object;
            return this.id == em.id && this.extensionPoint == em.extensionPoint;
        }
        return false;
    }

    public String getExtensionPointIdentifier() {
        return this.extensionPoint;
    }

    public String getSimpleIdentifier() {
        return this.id;
    }

    public String getUniqueIdentifier() {
        return this.id == null ? null : String.valueOf(this.getParentIdentifier()) + "." + this.id;
    }

    public String getParentIdentifier() {
        return this.getNamespace();
    }

    public String getNamespace() {
        Namespace parent = (Namespace)this.getParent();
        return parent.isFragment() ? parent.getHostIdentifier() : parent.getName();
    }

    public IConfigurationElement[] getConfigurationElements() {
        Extension extension = this;
        synchronized (extension) {
            if (!this.fullyLoaded) {
                this.fullyLoaded = true;
                RegistryCacheReader reader = this.getRegistry().getCacheReader();
                if (reader != null) {
                    this.elements = reader.loadConfigurationElements(this, this.subElementsCacheOffset);
                }
            }
            if (this.elements == null) {
                this.elements = new IConfigurationElement[0];
            }
        }
        return (IConfigurationElement[])this.elements;
    }

    public void setExtensionPointIdentifier(String value) {
        this.extensionPoint = value;
    }

    public void setSimpleIdentifier(String value) {
        this.id = value;
    }

    public void setSubElements(IConfigurationElement[] value) {
        this.elements = value;
    }

    public String getLabel() {
        String s = this.getName();
        if (s == null) {
            return "";
        }
        return s;
    }

    public String toString() {
        return String.valueOf(this.getUniqueIdentifier()) + " -> " + this.getExtensionPointIdentifier();
    }

    void setSubElementsCacheOffset(int value) {
        this.subElementsCacheOffset = value;
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean value) {
        this.fullyLoaded = value;
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        Bundle[] hosts;
        Bundle underlyingBundle;
        IPluginDescriptor result = CompatibilityHelper.getPluginDescriptor(((Namespace)this.getParent()).getName());
        if (result == null && (underlyingBundle = Platform.getBundle(((Namespace)this.getParent()).getName())) != null && (hosts = Platform.getHosts(underlyingBundle)) != null) {
            result = CompatibilityHelper.getPluginDescriptor(hosts[0].getSymbolicName());
        }
        if (CompatibilityHelper.DEBUG && result == null) {
            Policy.debug("Could not obtain plug-in descriptor for bundle " + ((Namespace)this.getParent()).getName());
        }
        return result;
    }

    public String getExtensionPointUniqueIdentifier() {
        return this.getExtensionPointIdentifier();
    }

    public void setLocalizedName(String value) {
        this.name = value;
        ((ExtensionRegistry)InternalPlatform.getDefault().getRegistry()).setDirty(true);
    }
}

