/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class DefaultUndoManager
implements IUndoManager {
    private StringBuffer fTextBuffer = new StringBuffer();
    private StringBuffer fPreservedTextBuffer = new StringBuffer();
    private PretendedUndoManagerState fPretendedState = new PretendedUndoManagerState();
    private KeyAndMouseListener fKeyAndMouseListener;
    private DocumentListener fDocumentListener;
    private TextInputListener fTextInputListener;
    private boolean fInserting = false;
    private boolean fOverwriting = false;
    private boolean fFoldingIntoCompoundChange = false;
    private ITextViewer fTextViewer;
    private int fUndoLevel;
    private List fCommandStack;
    private TextCommand fCurrent;
    private TextCommand fPreviousDelete;
    private int fCommandCounter = -1;

    public DefaultUndoManager(int undoLevel) {
        this.setMaximalUndoLevel(undoLevel);
    }

    public void beginCompoundChange() {
        this.fFoldingIntoCompoundChange = true;
        this.commit();
    }

    public void endCompoundChange() {
        this.fFoldingIntoCompoundChange = false;
        this.commit();
    }

    private void addListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            text.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            text.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.fTextInputListener = new TextInputListener();
            this.fTextViewer.addTextInputListener(this.fTextInputListener);
            this.listenToTextChanges(true);
        }
    }

    private void removeListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            if (this.fKeyAndMouseListener != null) {
                text.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
                text.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
                this.fKeyAndMouseListener = null;
            }
            if (this.fTextInputListener != null) {
                this.fTextViewer.removeTextInputListener(this.fTextInputListener);
                this.fTextInputListener = null;
            }
            this.listenToTextChanges(false);
        }
    }

    private void listenToTextChanges(boolean listen) {
        if (listen) {
            if (this.fDocumentListener == null && this.fTextViewer.getDocument() != null) {
                this.fDocumentListener = new DocumentListener();
                this.fTextViewer.getDocument().addDocumentListener((IDocumentListener)this.fDocumentListener);
            }
        } else if (!listen && this.fDocumentListener != null && this.fTextViewer.getDocument() != null) {
            this.fTextViewer.getDocument().removeDocumentListener((IDocumentListener)this.fDocumentListener);
            this.fDocumentListener = null;
        }
    }

    private void commit() {
        this.fInserting = false;
        this.fOverwriting = false;
        this.fPreviousDelete.reinitialize();
        this.fCurrent.commit();
    }

    private void internalRedo() {
        ++this.fCommandCounter;
        TextCommand cmd = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
        this.listenToTextChanges(false);
        cmd.redo();
        this.listenToTextChanges(true);
        this.fCurrent = new TextCommand();
    }

    private void internalUndo() {
        TextCommand cmd = (TextCommand)this.fCommandStack.get(this.fCommandCounter);
        --this.fCommandCounter;
        this.listenToTextChanges(false);
        cmd.undo();
        this.listenToTextChanges(true);
        this.fCurrent = new TextCommand();
    }

    private boolean isWhitespaceText(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        String[] delimiters = this.fTextViewer.getDocument().getLegalLineDelimiters();
        int index = TextUtilities.startsWith((String[])delimiters, (String)text);
        if (index > -1) {
            int length = text.length();
            int i = delimiters[index].length();
            while (i < length) {
                char c = text.charAt(i);
                if (c != ' ' && c != '\t') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private PretendedUndoManagerState pretendCommit() {
        if (this.fCurrent.fStart < 0) {
            this.fPretendedState.stackSize = this.fCommandStack.size();
            this.fPretendedState.cmdCounter = this.fCommandCounter;
        } else {
            int sz = Math.max(this.fCommandCounter, 0) + 1;
            if (sz > this.fUndoLevel) {
                sz -= this.fUndoLevel;
            }
            this.fPretendedState.stackSize = sz;
            this.fPretendedState.cmdCounter = sz - 1;
        }
        return this.fPretendedState;
    }

    private void processChange(int modelStart, int modelEnd, String insertedText, String replacedText) {
        if (insertedText == null) {
            insertedText = "";
        }
        if (replacedText == null) {
            replacedText = "";
        }
        int length = insertedText.length();
        int diff = modelEnd - modelStart;
        if (diff < 0) {
            int tmp = modelEnd;
            modelEnd = modelStart;
            modelStart = tmp;
        }
        if (modelStart == modelEnd) {
            if (length == 1 || this.isWhitespaceText(insertedText)) {
                if (!this.fInserting || modelStart != this.fCurrent.fStart + this.fTextBuffer.length()) {
                    this.commit();
                    this.fInserting = true;
                }
                if (this.fCurrent.fStart < 0) {
                    this.fCurrent.fStart = this.fCurrent.fEnd = modelStart;
                }
                if (length > 0) {
                    this.fTextBuffer.append(insertedText);
                }
            } else if (length > 0) {
                this.commit();
                this.fCurrent.fStart = this.fCurrent.fEnd = modelStart;
                this.fTextBuffer.append(insertedText);
                this.commit();
            }
        } else if (length == 0) {
            length = replacedText.length();
            String[] delimiters = this.fTextViewer.getDocument().getLegalLineDelimiters();
            if (length == 1 || TextUtilities.equals((String[])delimiters, (String)replacedText) > -1) {
                if (this.fPreviousDelete.fStart == modelStart && this.fPreviousDelete.fEnd == modelEnd) {
                    if (this.fCurrent.fStart == modelEnd && this.fCurrent.fEnd == modelStart) {
                        this.fCurrent.fStart = modelStart;
                        this.fCurrent.fEnd = modelEnd;
                    }
                    this.fPreservedTextBuffer.append(replacedText);
                    ++this.fCurrent.fEnd;
                } else if (this.fPreviousDelete.fStart == modelEnd) {
                    this.fPreservedTextBuffer.insert(0, replacedText);
                    this.fCurrent.fStart = modelStart;
                } else {
                    this.commit();
                    this.fPreservedTextBuffer.append(replacedText);
                    this.fCurrent.fStart = modelStart;
                    this.fCurrent.fEnd = modelEnd;
                }
                this.fPreviousDelete.set(modelStart, modelEnd);
            } else if (length > 0) {
                this.commit();
                this.fCurrent.fStart = modelStart;
                this.fCurrent.fEnd = modelEnd;
                this.fPreservedTextBuffer.append(replacedText);
            }
        } else {
            if (length == 1) {
                length = replacedText.length();
                String[] delimiters = this.fTextViewer.getDocument().getLegalLineDelimiters();
                if (length == 1 || TextUtilities.equals((String[])delimiters, (String)replacedText) > -1) {
                    if (!this.fOverwriting || modelStart != this.fCurrent.fStart + this.fTextBuffer.length()) {
                        this.commit();
                        this.fOverwriting = true;
                    }
                    if (this.fCurrent.fStart < 0) {
                        this.fCurrent.fStart = modelStart;
                    }
                    this.fCurrent.fEnd = modelEnd;
                    this.fTextBuffer.append(insertedText);
                    this.fPreservedTextBuffer.append(replacedText);
                    return;
                }
            }
            this.commit();
            this.fCurrent.fStart = modelStart;
            this.fCurrent.fEnd = modelEnd;
            this.fTextBuffer.append(insertedText);
            this.fPreservedTextBuffer.append(replacedText);
        }
    }

    public void setMaximalUndoLevel(int undoLevel) {
        this.fUndoLevel = undoLevel;
    }

    public void connect(ITextViewer textViewer) {
        if (this.fTextViewer == null) {
            this.fTextViewer = textViewer;
            this.fCommandStack = new ArrayList();
            this.fCurrent = new TextCommand();
            this.fPreviousDelete = new TextCommand();
            this.addListeners();
        }
    }

    public void disconnect() {
        if (this.fTextViewer != null) {
            this.removeListeners();
            this.fCurrent = null;
            if (this.fCommandStack != null) {
                this.fCommandStack.clear();
                this.fCommandStack = null;
            }
            this.fTextBuffer = null;
            this.fPreservedTextBuffer = null;
            this.fTextViewer = null;
        }
    }

    public void reset() {
        if (this.fCommandStack != null) {
            this.fCommandStack.clear();
        }
        this.fCommandCounter = -1;
        if (this.fCurrent != null) {
            this.fCurrent.reinitialize();
        }
        this.fFoldingIntoCompoundChange = false;
        this.fInserting = false;
        this.fOverwriting = false;
        this.fTextBuffer.setLength(0);
        this.fPreservedTextBuffer.setLength(0);
    }

    public boolean redoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState s = this.pretendCommit();
            return s.cmdCounter + 1 >= 0 && s.cmdCounter + 1 < s.stackSize;
        }
        return false;
    }

    public boolean undoable() {
        if (this.fCommandStack != null) {
            PretendedUndoManagerState s = this.pretendCommit();
            return s.cmdCounter >= 0 && s.cmdCounter < s.stackSize;
        }
        return false;
    }

    public void redo() {
        if (this.redoable()) {
            this.commit();
            this.internalRedo();
        }
    }

    public void undo() {
        if (this.undoable()) {
            this.fFoldingIntoCompoundChange = false;
            this.commit();
            this.internalUndo();
        }
    }

    protected void selectAndReveal(int offset, int length) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fTextViewer);
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!this.fTextViewer.overlapsWithVisibleRegion(offset, length)) {
            this.fTextViewer.resetVisibleRegion();
        }
        this.fTextViewer.setSelectedRange(offset, length);
        this.fTextViewer.revealRange(offset, length);
    }

    class TextCommand {
        protected int fStart = -1;
        protected int fEnd = -1;
        protected String fText;
        protected String fPreservedText;

        TextCommand() {
        }

        protected void reinitialize() {
            this.fEnd = -1;
            this.fStart = -1;
            this.fPreservedText = null;
            this.fText = null;
        }

        protected void set(int start, int end) {
            this.fStart = start;
            this.fEnd = end;
            this.fText = null;
            this.fPreservedText = null;
        }

        protected void undoTextChange() {
            try {
                DefaultUndoManager.this.fTextViewer.getDocument().replace(this.fStart, this.fText.length(), this.fPreservedText);
            }
            catch (BadLocationException badLocationException) {}
        }

        protected void undo() {
            this.undoTextChange();
            DefaultUndoManager.this.selectAndReveal(this.fStart, this.fPreservedText == null ? 0 : this.fPreservedText.length());
        }

        protected void redoTextChange() {
            try {
                DefaultUndoManager.this.fTextViewer.getDocument().replace(this.fStart, this.fEnd - this.fStart, this.fText);
            }
            catch (BadLocationException badLocationException) {}
        }

        protected void redo() {
            this.redoTextChange();
            DefaultUndoManager.this.selectAndReveal(this.fStart, this.fText == null ? 0 : this.fText.length());
        }

        protected void updateCommandStack() {
            int length = DefaultUndoManager.this.fCommandStack.size();
            int i = DefaultUndoManager.this.fCommandCounter + 1;
            while (i < length) {
                DefaultUndoManager.this.fCommandStack.remove(DefaultUndoManager.this.fCommandCounter + 1);
                ++i;
            }
            DefaultUndoManager.this.fCommandStack.add(this);
            while (DefaultUndoManager.this.fCommandStack.size() > DefaultUndoManager.this.fUndoLevel) {
                DefaultUndoManager.this.fCommandStack.remove(0);
            }
            DefaultUndoManager.this.fCommandCounter = DefaultUndoManager.this.fCommandStack.size() - 1;
        }

        protected TextCommand createCurrent() {
            return DefaultUndoManager.this.fFoldingIntoCompoundChange ? new CompoundTextCommand() : new TextCommand();
        }

        protected void commit() {
            if (this.fStart < 0) {
                this.reinitialize();
            } else {
                this.fText = DefaultUndoManager.this.fTextBuffer.toString();
                DefaultUndoManager.this.fTextBuffer.setLength(0);
                this.fPreservedText = DefaultUndoManager.this.fPreservedTextBuffer.toString();
                DefaultUndoManager.this.fPreservedTextBuffer.setLength(0);
                this.updateCommandStack();
            }
            DefaultUndoManager.this.fCurrent = this.createCurrent();
        }
    }

    class CompoundTextCommand
    extends TextCommand {
        private List fCommands = new ArrayList();

        CompoundTextCommand() {
        }

        protected void add(TextCommand command) {
            this.fCommands.add(command);
        }

        /*
         * Exception decompiling
         */
        protected void undo() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 130->134)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        protected void redo() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->137)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void updateCommandStack() {
            TextCommand c = new TextCommand();
            c.fStart = this.fStart;
            c.fEnd = this.fEnd;
            c.fText = this.fText;
            c.fPreservedText = this.fPreservedText;
            this.add(c);
            if (!DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                super.updateCommandStack();
            }
        }

        protected TextCommand createCurrent() {
            if (!DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                return new TextCommand();
            }
            this.reinitialize();
            return this;
        }

        protected void commit() {
            if (this.fStart < 0 && this.fCommands.size() > 0 && !DefaultUndoManager.this.fFoldingIntoCompoundChange) {
                super.updateCommandStack();
                DefaultUndoManager.this.fCurrent = this.createCurrent();
                return;
            }
            super.commit();
        }
    }

    class PretendedUndoManagerState {
        protected int cmdCounter = -1;
        protected int stackSize = -1;

        PretendedUndoManagerState() {
        }
    }

    class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                DefaultUndoManager.this.commit();
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    DefaultUndoManager.this.commit();
                }
            }
        }
    }

    class DocumentListener
    implements IDocumentListener {
        private String fReplacedText;

        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            try {
                this.fReplacedText = event.getDocument().get(event.getOffset(), event.getLength());
            }
            catch (BadLocationException badLocationException) {
                this.fReplacedText = null;
            }
        }

        public void documentChanged(DocumentEvent event) {
            DefaultUndoManager.this.processChange(event.getOffset(), event.getOffset() + event.getLength(), event.getText(), this.fReplacedText);
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null && DefaultUndoManager.this.fDocumentListener != null) {
                oldInput.removeDocumentListener((IDocumentListener)DefaultUndoManager.this.fDocumentListener);
                DefaultUndoManager.this.commit();
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                if (DefaultUndoManager.this.fDocumentListener == null) {
                    DefaultUndoManager.this.fDocumentListener = new DocumentListener();
                }
                newInput.addDocumentListener((IDocumentListener)DefaultUndoManager.this.fDocumentListener);
            }
        }
    }
}

