/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.internal.commands.AbstractCommandRegistry;
import org.eclipse.ui.internal.commands.ActiveKeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.CategoryDefinition;
import org.eclipse.ui.internal.commands.CommandDefinition;
import org.eclipse.ui.internal.commands.KeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.KeySequenceBindingDefinition;
import org.eclipse.ui.internal.commands.Persistence;
import org.eclipse.ui.internal.util.ConfigurationElementMemento;

public final class ExtensionCommandRegistry
extends AbstractCommandRegistry {
    private List activeKeyConfigurationDefinitions;
    private List categoryDefinitions;
    private List commandDefinitions;
    private IExtensionRegistry extensionRegistry;
    private List handlers;
    private List keyConfigurationDefinitions;
    private List keySequenceBindingDefinitions;

    public ExtensionCommandRegistry(IExtensionRegistry extensionRegistry) {
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        this.extensionRegistry = extensionRegistry;
        this.extensionRegistry.addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent registryChangeEvent) {
                IExtensionDelta[] extensionDeltas = registryChangeEvent.getExtensionDeltas("org.eclipse.ui", "commands");
                if (extensionDeltas.length != 0) {
                    try {
                        ExtensionCommandRegistry.this.load();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        try {
            this.load();
        }
        catch (IOException iOException) {}
    }

    private String getNamespace(IConfigurationElement configurationElement) {
        IExtension extension;
        String namespace = null;
        if (configurationElement != null && (extension = configurationElement.getDeclaringExtension()) != null) {
            namespace = extension.getNamespace();
        }
        return namespace;
    }

    private void load() throws IOException {
        String name;
        IConfigurationElement deprecatedConfigurationElement;
        if (this.activeKeyConfigurationDefinitions == null) {
            this.activeKeyConfigurationDefinitions = new ArrayList();
        } else {
            this.activeKeyConfigurationDefinitions.clear();
        }
        if (this.categoryDefinitions == null) {
            this.categoryDefinitions = new ArrayList();
        } else {
            this.categoryDefinitions.clear();
        }
        if (this.commandDefinitions == null) {
            this.commandDefinitions = new ArrayList();
        } else {
            this.commandDefinitions.clear();
        }
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        } else {
            this.handlers.clear();
        }
        if (this.imageBindingDefinitions == null) {
            this.imageBindingDefinitions = new ArrayList();
        } else {
            this.imageBindingDefinitions.clear();
        }
        if (this.keyConfigurationDefinitions == null) {
            this.keyConfigurationDefinitions = new ArrayList();
        } else {
            this.keyConfigurationDefinitions.clear();
        }
        if (this.keySequenceBindingDefinitions == null) {
            this.keySequenceBindingDefinitions = new ArrayList();
        } else {
            this.keySequenceBindingDefinitions.clear();
        }
        IConfigurationElement[] deprecatedConfigurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.acceleratorConfigurations");
        int i = 0;
        while (i < deprecatedConfigurationElements.length) {
            deprecatedConfigurationElement = deprecatedConfigurationElements[i];
            name = deprecatedConfigurationElement.getName();
            if ("acceleratorConfiguration".equals(name)) {
                this.readKeyConfigurationDefinition(deprecatedConfigurationElement);
            }
            ++i;
        }
        deprecatedConfigurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.acceleratorSets");
        i = 0;
        while (i < deprecatedConfigurationElements.length) {
            deprecatedConfigurationElement = deprecatedConfigurationElements[i];
            name = deprecatedConfigurationElement.getName();
            if ("acceleratorSet".equals(name)) {
                ConfigurationElementMemento memento = new ConfigurationElementMemento(deprecatedConfigurationElement);
                String keyConfigurationId = memento.getString("configurationId");
                String scopeId = memento.getString("scopeId");
                IConfigurationElement[] deprecatedConfigurationElements2 = deprecatedConfigurationElement.getChildren("accelerator");
                int j = 0;
                while (j < deprecatedConfigurationElements2.length) {
                    IConfigurationElement deprecatedConfigurationElement2 = deprecatedConfigurationElements2[j];
                    KeySequenceBindingDefinition keySequenceBindingDefinition = Persistence.readKeySequenceBindingDefinition(new ConfigurationElementMemento(deprecatedConfigurationElement2), this.getNamespace(deprecatedConfigurationElement2));
                    if (keySequenceBindingDefinition != null) {
                        keySequenceBindingDefinition = new KeySequenceBindingDefinition(scopeId, keySequenceBindingDefinition.getCommandId(), keyConfigurationId, keySequenceBindingDefinition.getKeySequence(), keySequenceBindingDefinition.getLocale(), keySequenceBindingDefinition.getPlatform(), keySequenceBindingDefinition.getSourceId());
                        this.keySequenceBindingDefinitions.add(keySequenceBindingDefinition);
                    }
                    ++j;
                }
            }
            ++i;
        }
        deprecatedConfigurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.actionDefinitions");
        i = 0;
        while (i < deprecatedConfigurationElements.length) {
            deprecatedConfigurationElement = deprecatedConfigurationElements[i];
            name = deprecatedConfigurationElement.getName();
            if ("actionDefinition".equals(name)) {
                this.readCommandDefinition(deprecatedConfigurationElement);
            }
            ++i;
        }
        IConfigurationElement[] configurationElements = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int i2 = 0;
        while (i2 < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[i2];
            String name2 = configurationElement.getName();
            if ("activeKeyConfiguration".equals(name2)) {
                this.readActiveKeyConfigurationDefinition(configurationElement);
            } else if ("category".equals(name2)) {
                this.readCategoryDefinition(configurationElement);
            } else if ("command".equals(name2)) {
                this.readCommandDefinition(configurationElement);
            } else if ("handlerSubmission".equals(name2)) {
                this.readHandlerSubmissionDefinition(configurationElement);
            } else if ("keyConfiguration".equals(name2)) {
                this.readKeyConfigurationDefinition(configurationElement);
            } else if ("keyBinding".equals(name2)) {
                this.readKeySequenceBindingDefinition(configurationElement);
            }
            ++i2;
        }
        boolean commandRegistryChanged = false;
        if (!this.activeKeyConfigurationDefinitions.equals(((AbstractCommandRegistry)this).activeKeyConfigurationDefinitions)) {
            ((AbstractCommandRegistry)this).activeKeyConfigurationDefinitions = Collections.unmodifiableList(this.activeKeyConfigurationDefinitions);
            commandRegistryChanged = true;
        }
        if (!this.categoryDefinitions.equals(((AbstractCommandRegistry)this).categoryDefinitions)) {
            ((AbstractCommandRegistry)this).categoryDefinitions = Collections.unmodifiableList(this.categoryDefinitions);
            commandRegistryChanged = true;
        }
        if (!this.commandDefinitions.equals(((AbstractCommandRegistry)this).commandDefinitions)) {
            ((AbstractCommandRegistry)this).commandDefinitions = Collections.unmodifiableList(this.commandDefinitions);
            commandRegistryChanged = true;
        }
        if (!this.handlers.equals(((AbstractCommandRegistry)this).handlers)) {
            ((AbstractCommandRegistry)this).handlers = Collections.unmodifiableList(this.handlers);
            commandRegistryChanged = true;
        }
        if (!this.imageBindingDefinitions.equals(this.imageBindingDefinitions)) {
            this.imageBindingDefinitions = Collections.unmodifiableList(this.imageBindingDefinitions);
            commandRegistryChanged = true;
        }
        if (!this.keyConfigurationDefinitions.equals(((AbstractCommandRegistry)this).keyConfigurationDefinitions)) {
            ((AbstractCommandRegistry)this).keyConfigurationDefinitions = Collections.unmodifiableList(this.keyConfigurationDefinitions);
            commandRegistryChanged = true;
        }
        if (!this.keySequenceBindingDefinitions.equals(((AbstractCommandRegistry)this).keySequenceBindingDefinitions)) {
            ((AbstractCommandRegistry)this).keySequenceBindingDefinitions = Collections.unmodifiableList(this.keySequenceBindingDefinitions);
            commandRegistryChanged = true;
        }
        if (commandRegistryChanged) {
            this.fireCommandRegistryChanged();
        }
    }

    private void readActiveKeyConfigurationDefinition(IConfigurationElement configurationElement) {
        ActiveKeyConfigurationDefinition activeKeyConfigurationDefinition = Persistence.readActiveKeyConfigurationDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (activeKeyConfigurationDefinition != null) {
            this.activeKeyConfigurationDefinitions.add(activeKeyConfigurationDefinition);
        }
    }

    private void readCategoryDefinition(IConfigurationElement configurationElement) {
        CategoryDefinition categoryDefinition = Persistence.readCategoryDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (categoryDefinition != null) {
            this.categoryDefinitions.add(categoryDefinition);
        }
    }

    private void readCommandDefinition(IConfigurationElement configurationElement) {
        CommandDefinition commandDefinition = Persistence.readCommandDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (commandDefinition != null) {
            this.commandDefinitions.add(commandDefinition);
        }
    }

    private final void readHandlerSubmissionDefinition(IConfigurationElement configurationElement) {
        IHandler handler = Persistence.readHandlerSubmissionDefinition(configurationElement);
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    private void readKeyConfigurationDefinition(IConfigurationElement configurationElement) {
        KeyConfigurationDefinition keyConfigurationDefinition = Persistence.readKeyConfigurationDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (keyConfigurationDefinition != null) {
            this.keyConfigurationDefinitions.add(keyConfigurationDefinition);
        }
    }

    private void readKeySequenceBindingDefinition(IConfigurationElement configurationElement) {
        KeySequenceBindingDefinition keySequenceBindingDefinition = Persistence.readKeySequenceBindingDefinition(new ConfigurationElementMemento(configurationElement), this.getNamespace(configurationElement));
        if (keySequenceBindingDefinition != null) {
            this.keySequenceBindingDefinitions.add(keySequenceBindingDefinition);
        }
    }
}

