/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.subplayer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.jpn.xucker.rcp.subplayer.compatibility.Mark;
import org.jpn.xucker.subplayer.SubPlayMain;
import org.jpn.xucker.subtitle.StandardSubObject;

public class MarkControler {
    private SubPlayMain main;
    private Button markButton;
    Map markMap = new HashMap();
    private Mark currentMark;

    public MarkControler(SubPlayMain main, Button markButton) {
        this.main = main;
        this.markButton = markButton;
    }

    public void prev() {
        int index = -1;
        Mark[] marks = this.getMarkArray();
        if (this.currentMark != null) {
            int i = 0;
            while (i < marks.length) {
                if (marks[i].equals(this.currentMark)) {
                    index = i - 1;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                this.currentMark = marks[index];
                this.setStatus(true);
            }
        }
        if (index == -1 && marks.length > 0) {
            this.currentMark = marks[marks.length - 1];
            this.setStatus(true);
        }
        this.moveFrame(this.currentMark);
    }

    public boolean canMove() {
        return this.markMap.size() > 1;
    }

    private void moveFrame(Mark mark) {
        if (mark != null) {
            this.main.moveFrame(mark);
        }
    }

    public Mark[] getMarkArray() {
        Object[] marks = this.markMap.keySet().toArray(new Mark[this.markMap.size()]);
        Arrays.sort(marks);
        return marks;
    }

    public void next() {
        int index = -1;
        Mark[] marks = this.getMarkArray();
        int i = 0;
        while (i < marks.length) {
            SubPlayMain.log.trace((Object)marks[i]);
            ++i;
        }
        if (this.currentMark != null) {
            i = 0;
            while (i < marks.length) {
                if (marks[i].equals(this.currentMark)) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (index >= 0 && index != marks.length) {
                this.currentMark = marks[index];
                this.setStatus(true);
            }
        }
        if (index == marks.length) {
            index = -1;
        }
        if (index == -1 && marks.length > 0) {
            this.currentMark = marks[0];
            this.setStatus(true);
        }
        this.moveFrame(this.currentMark);
    }

    public void setStatus(boolean bool) {
        if (bool) {
            this.markButton.setBackground(new Color(null, 51, 102, 204));
            this.markButton.setSelection(true);
        } else {
            this.markButton.setBackground(new Color(null, 255, 255, 255));
            this.markButton.setSelection(false);
        }
    }

    public boolean isMarked(StandardSubObject subObject) {
        return this.findMark(subObject) != null;
    }

    public void check(StandardSubObject subObject) {
        this.setStatus(this.markButton.getSelection());
        if (!this.markButton.getSelection()) {
            this.markMap.remove(this.toMapKey(subObject));
        } else {
            Mark mark = this.findMark(subObject);
            if (mark == null) {
                mark = new Mark(subObject);
                this.markMap.put(mark, mark);
                this.currentMark = mark;
            }
        }
    }

    public Mark toMapKey(StandardSubObject subObject) {
        return new Mark(subObject);
    }

    public Mark findMark(StandardSubObject subObject) {
        return (Mark)this.markMap.get(this.toMapKey(subObject));
    }

    public Mark getCurrentMark() {
        return this.currentMark;
    }

    public void setCurrentMark(Mark currentMark) {
        this.currentMark = currentMark;
    }

    public void init() {
        this.markMap = new HashMap();
    }

    public void addMark(Mark mark) {
        this.markMap.put(mark, mark);
    }
}

