/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.swt.ui;

import java.util.List;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class GroupCheckTreeContoler
implements SelectionListener {
    private Color selectedColor;
    private Color notSelectedColor;
    private String pathSeparater = "/";

    public Color getNotSelectedColor() {
        return this.notSelectedColor;
    }

    public void setNotSelectedColor(Color notSelectedColor) {
        this.notSelectedColor = notSelectedColor;
    }

    public String getPathSeparater() {
        return this.pathSeparater;
    }

    public void setPathSeparater(String pathSeparater) {
        this.pathSeparater = pathSeparater;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    public GroupCheckTreeContoler(Tree tree) {
        this.selectedColor = new Color((Device)tree.getDisplay(), 0, 0, 0);
        this.notSelectedColor = new Color((Device)tree.getDisplay(), 128, 128, 128);
        tree.addSelectionListener((SelectionListener)this);
        TreeItem rootItem = tree.getTopItem();
        this.setNotSelectedColor(rootItem);
        TreeItem[] selectedLeafs = this.getSelectedLeafItem(rootItem);
        int i = 0;
        while (i < selectedLeafs.length) {
            this.updateStatus(selectedLeafs[i]);
            ++i;
        }
    }

    private void updateStatus(TreeItem item) {
        TreeItem currentTreeItem = item;
        if (currentTreeItem.getItemCount() == 0) {
            if (currentTreeItem.getChecked()) {
                currentTreeItem.setForeground(this.selectedColor);
            } else {
                currentTreeItem.setForeground(this.notSelectedColor);
            }
        }
        while (currentTreeItem.getParentItem() != null) {
            currentTreeItem = currentTreeItem.getParentItem();
            int selectionCount = 0;
            TreeItem[] childrens = currentTreeItem.getItems();
            boolean hasItem = false;
            int i = 0;
            while (i < childrens.length) {
                if (childrens[i].getChecked()) {
                    ++selectionCount;
                }
                if (childrens[i].getForeground().equals((Object)this.selectedColor)) {
                    hasItem = true;
                }
                ++i;
            }
            if (selectionCount == currentTreeItem.getItemCount()) {
                currentTreeItem.setChecked(true);
                currentTreeItem.setForeground(this.selectedColor);
                continue;
            }
            if (hasItem) {
                currentTreeItem.setForeground(this.selectedColor);
                currentTreeItem.setChecked(false);
                continue;
            }
            currentTreeItem.setForeground(this.notSelectedColor);
            currentTreeItem.setChecked(false);
        }
    }

    private final void setNotSelectedColor(TreeItem currentItem) {
        currentItem.setForeground(this.notSelectedColor);
        if (currentItem.getItemCount() > 0) {
            TreeItem[] children = currentItem.getItems();
            int i = 0;
            while (i < children.length) {
                this.setNotSelectedColor(children[i]);
                ++i;
            }
        }
    }

    public TreeItem[] getSelectedLeafItem(TreeItem rootItem) {
        TreeItem[] leafs = this.getLeafItem(rootItem);
        Vector<TreeItem> selecteds = new Vector<TreeItem>();
        int i = 0;
        while (i < leafs.length) {
            if (leafs[i].getChecked()) {
                selecteds.add(leafs[i]);
            }
            ++i;
        }
        return selecteds.toArray(new TreeItem[selecteds.size()]);
    }

    public TreeItem[] getLeafItem(TreeItem rootItem) {
        Vector leafVector = new Vector();
        this.checkLeaf(leafVector, rootItem);
        TreeItem[] items = leafVector.toArray(new TreeItem[leafVector.size()]);
        return items;
    }

    public String[] getPaths(TreeItem[] items) {
        String[] paths = new String[items.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = this.getPath(items[i]);
            ++i;
        }
        return paths;
    }

    private void checkLeaf(List leafVector, TreeItem currentItem) {
        if (currentItem.getItemCount() > 0) {
            TreeItem[] children = currentItem.getItems();
            int i = 0;
            while (i < children.length) {
                this.checkLeaf(leafVector, children[i]);
                ++i;
            }
        } else if (currentItem.getChecked()) {
            leafVector.add(currentItem);
        }
    }

    public String getPath(TreeItem item) {
        String result = item.getText();
        TreeItem currentItem = item;
        while (item.getParentItem() != null) {
            currentItem = item.getParentItem();
            result = String.valueOf(currentItem.getText()) + this.pathSeparater + result;
        }
        return result;
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() instanceof Tree) {
            TreeItem selectTreeItem = (TreeItem)event.item;
            if (selectTreeItem.getItemCount() > 0) {
                if (selectTreeItem.getChecked()) {
                    this.selectAllChildren(selectTreeItem);
                } else {
                    this.unselectAllChildren(selectTreeItem);
                }
            }
            this.updateStatus(selectTreeItem);
        }
    }

    private void unselectAllChildren(TreeItem currentTreeItem) {
        currentTreeItem.setForeground(this.notSelectedColor);
        TreeItem[] childrens = currentTreeItem.getItems();
        int i = 0;
        while (i < childrens.length) {
            childrens[i].setChecked(false);
            childrens[i].setForeground(this.notSelectedColor);
            this.unselectAllChildren(childrens[i]);
            ++i;
        }
    }

    private void selectAllChildren(TreeItem currentTreeItem) {
        currentTreeItem.setForeground(this.selectedColor);
        TreeItem[] childrens = currentTreeItem.getItems();
        int i = 0;
        while (i < childrens.length) {
            childrens[i].setForeground(this.selectedColor);
            childrens[i].setChecked(true);
            this.selectAllChildren(childrens[i]);
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
}

