/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.commons.Messages;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import jp.sourceforge.akjrcp.commons.util.WildCard;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class FileDirChoicer2
extends AbstractFileDirChoicer
implements SelectionListener {
    public static Log log = LogFactory.getLog(FileDirChoicer2.class);
    public static final int FILE = 0;
    public static final int DIR = 1;
    public static final int SAVE = 2;
    public static final int FILE_DIR = 3;
    Layout gridLayout;
    GridData labelLayoutData;
    GridData textLayoutData;
    private File selectionFile;
    private List<String> selectableFileList = new ArrayList<String>();
    GridData buttonLayoutData;
    GridData buttonLayoutData2;
    private Button button;
    private Button button2;
    private Label label;
    private CCombo textCombo;
    private int type;
    private String[] filterExtensions;
    private String[] filterNames;
    AbstractFileDirChoicer.FileStatusChanger fileListChanger = new AbstractFileDirChoicer.FileStatusChanger(this){

        @Override
        protected void addFilePath(String path) {
            FileDirChoicer2.this.addFile(path);
        }

        @Override
        protected void addDirectoryPath(String path) {
            FileDirChoicer2.this.addDirectory(path);
        }
    };
    private Button resetButton;
    private GridData resetButtonLayoutData;

    public int countSelectableFileNames() {
        return this.selectableFileList.size();
    }

    public String getSelectableFileName(int index) {
        return this.selectableFileList.get(index);
    }

    public void addSelectableFileName(String path) {
        int i = 0;
        while (i < this.selectableFileList.size()) {
            if (this.selectableFileList.get(i).equals(path)) {
                log.info((Object)"same path ignore add");
                return;
            }
            ++i;
        }
        String spath = FileNameUtils.shortenFileName(path);
        this.selectableFileList.add(spath);
        this.textCombo.add(spath);
    }

    public void removeSelectableFileName(String path) {
        this.selectableFileList.remove(path);
        this.textCombo.remove(path);
    }

    public GridData getButtonLayoutData() {
        return this.buttonLayoutData;
    }

    public void setButtonLayoutData(GridData buttonLayoutData) {
        this.buttonLayoutData = buttonLayoutData;
    }

    public GridData getLabelLayoutData() {
        return this.labelLayoutData;
    }

    public void setLabelLayoutData(GridData labelLayoutData) {
        this.labelLayoutData = labelLayoutData;
    }

    public GridData getResetButtonLayoutData() {
        return this.resetButtonLayoutData;
    }

    public void setResetButtonLayoutData(GridData resetButtonLayoutData) {
        this.resetButtonLayoutData = resetButtonLayoutData;
    }

    public GridData getTextLayoutData() {
        return this.textLayoutData;
    }

    public void setTextLayoutData(GridData textLayoutData) {
        this.textLayoutData = textLayoutData;
    }

    public void setPathWidth(int width) {
        this.textLayoutData.widthHint = width;
    }

    public CCombo getCCombo() {
        return this.textCombo;
    }

    public void setEnabled(boolean bool) {
        super.setEnabled(bool);
        this.label.setEnabled(bool);
        this.textCombo.setEnabled(bool);
        this.button.setEnabled(bool);
        if (this.button2 != null) {
            this.button2.setEnabled(bool);
        }
        if (this.resetButton != null) {
            this.resetButton.setEnabled(bool);
        }
    }

    public void removeFileListChangeListener(AbstractFileDirChoicer.FileStatusChangeListener listener) {
        this.fileListChanger.removeFileListChangeListener(listener);
    }

    public void addFileListChangeListener(AbstractFileDirChoicer.FileStatusChangeListener listener) {
        this.fileListChanger.addFileListChangeListener(listener);
    }

    public FileDirChoicer2(Composite arg0, int arg1, int type, String labelText) {
        this(arg0, arg1, type, labelText, false);
    }

    public void addFile(String path) {
        if ((this.type == 0 || this.type == 3 || this.type == 2) && this.isAllowFile(path)) {
            this.setFile(new File(path));
        }
    }

    public void addDirectory(String path) {
        if (this.type == 1 || this.type == 3) {
            this.setFile(new File(path));
        }
    }

    public void setBrowseButtonText(String text) {
        this.button.setText(text);
    }

    public String getBrowseButtonText() {
        return this.button.getText();
    }

    public void setBrowseButton2Text(String text) {
        this.button2.setText(text);
    }

    public String getBrowseButton2Text() {
        return this.button2.getText();
    }

    public FileDirChoicer2(Composite arg0, int swtstyle, int type, String labelText, boolean haveReset) {
        super(arg0, swtstyle);
        this.type = type;
        if (haveReset) {
            if (type == 3) {
                this.setLayout((Layout)new GridLayout(5, false));
            } else {
                this.setLayout((Layout)new GridLayout(4, false));
            }
        } else if (type == 3) {
            this.setLayout((Layout)new GridLayout(4, false));
        } else {
            this.setLayout((Layout)new GridLayout(3, false));
        }
        this.label = new Label((Composite)this, 0);
        if (labelText != null && !labelText.equals("")) {
            this.label.setText(labelText);
            this.labelLayoutData = new GridData();
            this.labelLayoutData.minimumWidth = 50;
            this.label.setLayoutData((Object)this.labelLayoutData);
        }
        this.textCombo = new CCombo((Composite)this, 8);
        this.textLayoutData = new GridData(1808);
        this.textLayoutData.minimumWidth = 140;
        this.textCombo.setLayoutData((Object)this.textLayoutData);
        this.textCombo.setBackground(new Color((Device)this.getShell().getDisplay(), 255, 255, 255));
        this.textCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = FileDirChoicer2.this.textCombo.getSelectionIndex();
                if (index >= 0) {
                    String selectItem = FileDirChoicer2.this.textCombo.getItem(index);
                    File tmpFile = FileDirChoicer2.this.toFile(selectItem);
                    FileDirChoicer2.this.setFile(tmpFile);
                }
            }
        });
        this.button = new Button((Composite)this, 0);
        if (type == 3) {
            this.button.setText(Messages.getString("file"));
        } else {
            this.button.setText(Messages.getString("browse"));
        }
        this.buttonLayoutData = new GridData();
        this.buttonLayoutData.minimumWidth = 50;
        this.button.setLayoutData((Object)this.buttonLayoutData);
        this.button.addSelectionListener((SelectionListener)this);
        if (type == 3) {
            this.button2 = new Button((Composite)this, 0);
            this.button2.setText(Messages.getString("folder"));
            this.buttonLayoutData2 = new GridData();
            this.buttonLayoutData2.minimumWidth = 50;
            this.button2.setLayoutData((Object)this.buttonLayoutData2);
            this.button2.addSelectionListener((SelectionListener)this);
        }
        if (haveReset) {
            this.resetButton = new Button((Composite)this, 0);
            this.resetButton.setText(Messages.getString("reset"));
            this.resetButtonLayoutData = new GridData();
            this.resetButtonLayoutData.minimumWidth = 50;
            this.resetButton.setLayoutData((Object)this.resetButtonLayoutData);
            this.resetButton.addSelectionListener((SelectionListener)this);
        }
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target3 = new DropTarget((Control)this.button, operations);
        target3.setTransfer(types);
        target3.addDropListener(this.fileListChanger.getMonitor());
        DropTarget target2 = new DropTarget((Control)this.textCombo, operations);
        target2.setTransfer(types);
        target2.addDropListener(this.fileListChanger.getMonitor());
    }

    protected File toFile(String selectItem) {
        String changedPath;
        File file;
        if (selectItem == null) {
            return null;
        }
        if (selectItem.equals("")) {
            log.warn((Object)"selectItem is empty");
            return null;
        }
        if (selectItem.equals(FileNameUtils.getNameOfDesktop())) {
            file = new File(FileNameUtils.getDesktopPath());
            if (file.exists()) {
                return file;
            }
            log.warn((Object)"change desktop but not found");
        } else if (selectItem.equals(FileNameUtils.getNameOfPicture())) {
            file = new File(FileNameUtils.getMyPicturesPath());
            if (file.exists()) {
                return file;
            }
            log.warn((Object)"change my picture but not found");
        } else if (selectItem.equals(FileNameUtils.getNameOfMusic())) {
            file = new File(FileNameUtils.getMyMusicPath());
            if (file.exists()) {
                return file;
            }
            log.warn((Object)"change my music but not found");
        } else if (selectItem.equals(FileNameUtils.getNameOfVideo())) {
            file = new File(FileNameUtils.getMyVideoPath());
            if (file.exists()) {
                return file;
            }
            log.warn((Object)"change my video but not found");
        } else if (selectItem.equals(FileNameUtils.getNameOfDocument())) {
            file = new File(FileNameUtils.getMyDocumentsPath());
            if (file.exists()) {
                return file;
            }
            log.warn((Object)"change my documents but not found");
        }
        if (selectItem.startsWith(String.valueOf(FileNameUtils.getNameOfDesktop()) + "\\")) {
            changedPath = FileNameUtils.getDesktopPath();
            String newPath = StringUtils.replaceOnce((String)selectItem, (String)FileNameUtils.getNameOfDesktop(), (String)changedPath);
            File file2 = new File(newPath);
            if (file2.exists()) {
                return file2;
            }
            log.warn((Object)"change desktop but not found");
        } else if (selectItem.startsWith(String.valueOf(FileNameUtils.getNameOfPicture()) + "\\")) {
            changedPath = FileNameUtils.getMyPicturesPath();
            String newPath = StringUtils.replaceOnce((String)selectItem, (String)FileNameUtils.getNameOfPicture(), (String)changedPath);
            File file3 = new File(newPath);
            if (file3.exists()) {
                return file3;
            }
            log.warn((Object)"change my picture but not found");
        } else if (selectItem.startsWith(String.valueOf(FileNameUtils.getNameOfMusic()) + "\\")) {
            changedPath = FileNameUtils.getMyDocumentsPath();
            String newPath = StringUtils.replaceOnce((String)selectItem, (String)FileNameUtils.getNameOfMusic(), (String)changedPath);
            File file4 = new File(newPath);
            if (file4.exists()) {
                return file4;
            }
            log.warn((Object)"change  my music but not found");
        } else if (selectItem.startsWith(String.valueOf(FileNameUtils.getNameOfVideo()) + "\\")) {
            changedPath = FileNameUtils.getMyDocumentsPath();
            String newPath = StringUtils.replaceOnce((String)selectItem, (String)FileNameUtils.getNameOfVideo(), (String)changedPath);
            File file5 = new File(newPath);
            if (file5.exists()) {
                return file5;
            }
            log.warn((Object)"change  my video but not found");
        } else if (selectItem.startsWith(String.valueOf(FileNameUtils.getNameOfDocument()) + "\\")) {
            changedPath = FileNameUtils.getMyDocumentsPath();
            String newPath = StringUtils.replaceOnce((String)selectItem, (String)FileNameUtils.getNameOfDocument(), (String)changedPath);
            File file6 = new File(newPath);
            if (file6.exists()) {
                return file6;
            }
            log.warn((Object)"change  my documents but not found");
        }
        return new File(selectItem);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.button || this.button2 != null && event.getSource() == this.button2) {
            if (this.type == 0) {
                this.openFileDialog();
            } else if (this.type == 2) {
                this.openSaveDialog();
            } else if (this.type == 3) {
                if (event.getSource() == this.button) {
                    this.openFileDialog();
                } else {
                    this.openDirectoryDialog();
                }
            } else {
                this.openDirectoryDialog();
            }
        } else if (event.getSource() == this.resetButton) {
            this.resetPath();
        }
    }

    private void openDirectoryDialog() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String result = dialog.open();
        if (result != null) {
            this.setFile(new File(result));
        }
    }

    private void openFileDialog() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (this.filterExtensions != null) {
            dialog.setFilterExtensions(this.filterExtensions);
        }
        if (this.filterNames != null) {
            dialog.setFilterNames(this.filterNames);
        }
        if ((result = dialog.open()) != null && new File(result).exists()) {
            this.setFile(new File(result));
        }
    }

    private void openSaveDialog() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        if (this.filterExtensions != null) {
            dialog.setFilterExtensions(this.filterExtensions);
        }
        if (this.filterNames != null) {
            dialog.setFilterNames(this.filterNames);
        }
        if ((result = dialog.open()) != null) {
            this.setFile(new File(result));
        }
    }

    public void resetPath() {
        if (this.selectionFile != null) {
            String pre = this.selectionFile.getAbsolutePath();
            this.selectionFile = null;
            this.textCombo.setText("");
            this.fileListChanger.fireRemoveFile((Widget)this, pre);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void setFile(File file) {
        this.selectionFile = file;
        if (file != null) {
            this.textCombo.setText(FileNameUtils.shortenFileName(file.getAbsolutePath()));
            this.fileListChanger.fireAddFile((Widget)this, file.getAbsolutePath());
        } else {
            this.textCombo.setText("");
            this.fileListChanger.fireAddFile((Widget)this, "");
        }
    }

    public File getFile() {
        return this.selectionFile;
    }

    public String getAbsoluteFilePath() {
        if (this.getFile() == null) {
            return "";
        }
        return this.getFile().getAbsolutePath();
    }

    public void setFilePath(String path) {
        if (path == null || path.equals("")) {
            this.setFile(null);
        } else {
            this.setFile(new File(path));
        }
    }

    private boolean isAllowFile(String path) {
        if (this.filterExtensions == null) {
            return true;
        }
        if (this.filterExtensions != null) {
            new File(path);
            int i = 0;
            while (i < this.filterExtensions.length) {
                WildCard[] wildCards = WildCard.parseExtensions(this.filterExtensions[i]);
                int j = 0;
                while (j < wildCards.length) {
                    if (wildCards[i].match(path)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] alowExtensions) {
        this.filterExtensions = alowExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }
}

