/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.ui;

import java.io.File;
import jp.sourceforge.akjrcp.commons.Messages;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.util.WildCard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FileDirChoicer
extends AbstractFileDirChoicer
implements SelectionListener {
    public static final int FILE = 0;
    public static final int DIR = 1;
    public static final int SAVE = 2;
    public static final int FILE_DIR = 3;
    protected Layout gridLayout;
    protected GridData labelLayoutData;
    protected GridData textLayoutData;
    protected GridData buttonLayoutData;
    protected GridData buttonLayoutData2;
    protected Button button;
    protected Button button2;
    protected Label label;
    protected Text text;
    protected int type;
    protected String[] filterExtensions;
    protected String[] filterNames;
    protected AbstractFileDirChoicer.FileStatusChanger fileListChanger = new AbstractFileDirChoicer.FileStatusChanger(this){

        @Override
        protected void addFilePath(String path) {
            FileDirChoicer.this.addFile(path);
        }

        @Override
        protected void addDirectoryPath(String path) {
            FileDirChoicer.this.addDirectory(path);
        }
    };
    protected Button resetButton;
    protected GridData resetButtonLayoutData;

    public GridData getButtonLayoutData() {
        return this.buttonLayoutData;
    }

    public void setButtonLayoutData(GridData buttonLayoutData) {
        this.buttonLayoutData = buttonLayoutData;
    }

    public GridData getLabelLayoutData() {
        return this.labelLayoutData;
    }

    public void setLabelLayoutData(GridData labelLayoutData) {
        this.labelLayoutData = labelLayoutData;
    }

    public GridData getResetButtonLayoutData() {
        return this.resetButtonLayoutData;
    }

    public void setResetButtonLayoutData(GridData resetButtonLayoutData) {
        this.resetButtonLayoutData = resetButtonLayoutData;
    }

    public GridData getTextLayoutData() {
        return this.textLayoutData;
    }

    public void setTextLayoutData(GridData textLayoutData) {
        this.textLayoutData = textLayoutData;
    }

    public void setPathWidth(int width) {
        this.textLayoutData.widthHint = width;
    }

    public Text getTextComposite() {
        return this.text;
    }

    public void setEnabled(boolean bool) {
        super.setEnabled(bool);
        this.label.setEnabled(bool);
        this.text.setEnabled(bool);
        this.button.setEnabled(bool);
        if (this.button2 != null) {
            this.button2.setEnabled(bool);
        }
        if (this.resetButton != null) {
            this.resetButton.setEnabled(bool);
        }
    }

    public void removeFileListChangeListener(AbstractFileDirChoicer.FileStatusChangeListener listener) {
        this.fileListChanger.removeFileListChangeListener(listener);
    }

    public void addFileListChangeListener(AbstractFileDirChoicer.FileStatusChangeListener listener) {
        this.fileListChanger.addFileListChangeListener(listener);
    }

    public FileDirChoicer(Composite arg0, int arg1, int type, String labelText) {
        this(arg0, arg1, type, labelText, false);
    }

    public void addFile(String path) {
        if ((this.type == 0 || this.type == 2 || this.type == 3) && this.isAllowFile(path)) {
            this.inSetText(path);
        }
    }

    public void addDirectory(String path) {
        if (this.type == 1 || this.type == 3) {
            this.inSetText(path);
        }
    }

    public void setBrowseButtonText(String text) {
        this.button.setText(text);
    }

    public String getBrowseButtonText() {
        return this.button.getText();
    }

    public void setBrowseButton2Text(String text) {
        this.button2.setText(text);
    }

    public String getBrowseButton2Text() {
        return this.button2.getText();
    }

    public FileDirChoicer(Composite arg0, int swtstyle, int type, String labelText, boolean haveReset) {
        super(arg0, swtstyle);
        this.type = type;
        if (haveReset) {
            if (type == 3) {
                this.setLayout((Layout)new GridLayout(5, false));
            } else {
                this.setLayout((Layout)new GridLayout(4, false));
            }
        } else if (type == 3) {
            this.setLayout((Layout)new GridLayout(4, false));
        } else {
            this.setLayout((Layout)new GridLayout(3, false));
        }
        this.label = new Label((Composite)this, 0);
        if (labelText != null && !labelText.equals("")) {
            this.label.setText(labelText);
            this.labelLayoutData = new GridData();
            this.labelLayoutData.minimumWidth = 50;
            this.label.setLayoutData((Object)this.labelLayoutData);
        }
        this.text = new Text((Composite)this, 8);
        this.textLayoutData = new GridData(1808);
        this.textLayoutData.minimumWidth = 140;
        this.text.setLayoutData((Object)this.textLayoutData);
        this.text.setBackground(new Color((Device)this.getShell().getDisplay(), 255, 255, 255));
        this.button = new Button((Composite)this, 0);
        if (type == 3) {
            this.button.setText(Messages.getString("file"));
        } else {
            this.button.setText(Messages.getString("browse"));
        }
        this.buttonLayoutData = new GridData();
        this.buttonLayoutData.minimumWidth = 50;
        this.button.setLayoutData((Object)this.buttonLayoutData);
        this.button.addSelectionListener((SelectionListener)this);
        if (type == 3) {
            this.button2 = new Button((Composite)this, 0);
            this.button2.setText(Messages.getString("folder"));
            this.buttonLayoutData2 = new GridData();
            this.buttonLayoutData2.minimumWidth = 50;
            this.button2.setLayoutData((Object)this.buttonLayoutData2);
            this.button2.addSelectionListener((SelectionListener)this);
        }
        if (haveReset) {
            this.resetButton = new Button((Composite)this, 0);
            this.resetButton.setText(Messages.getString("reset"));
            this.resetButtonLayoutData = new GridData();
            this.resetButtonLayoutData.minimumWidth = 50;
            this.resetButton.setLayoutData((Object)this.resetButtonLayoutData);
            this.resetButton.addSelectionListener((SelectionListener)this);
        }
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target3 = new DropTarget((Control)this.button, operations);
        target3.setTransfer(types);
        target3.addDropListener(this.fileListChanger.getMonitor());
        DropTarget target2 = new DropTarget((Control)this.text, operations);
        target2.setTransfer(types);
        target2.addDropListener(this.fileListChanger.getMonitor());
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.button || this.button2 != null && event.getSource() == this.button2) {
            if (this.type == 0) {
                this.openFileDialog();
            } else if (this.type == 2) {
                this.openSaveDialog();
            } else if (this.type == 3) {
                if (event.getSource() == this.button) {
                    this.openFileDialog();
                } else {
                    this.openDirectoryDialog();
                }
            } else {
                this.openDirectoryDialog();
            }
        } else if (event.getSource() == this.resetButton) {
            String pre = this.text.getText();
            this.text.setText("");
            this.fileListChanger.fireRemoveFile((Widget)this, pre);
        }
    }

    private void openDirectoryDialog() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String result = dialog.open();
        if (result != null) {
            this.inSetText(result);
        }
    }

    public void inSetText(String path) {
        this.text.setText(path);
        this.fileListChanger.fireAddFile((Widget)this, path);
    }

    private void openFileDialog() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (this.filterExtensions != null) {
            dialog.setFilterExtensions(this.filterExtensions);
        }
        if (this.filterNames != null) {
            dialog.setFilterNames(this.filterNames);
        }
        if ((result = dialog.open()) != null && new File(result).exists()) {
            this.inSetText(result);
        }
    }

    private void openSaveDialog() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        if (this.filterExtensions != null) {
            dialog.setFilterExtensions(this.filterExtensions);
        }
        if (this.filterNames != null) {
            dialog.setFilterNames(this.filterNames);
        }
        if ((result = dialog.open()) != null) {
            this.inSetText(result);
        }
    }

    private void setFilePathLabel(String path) {
        if (path != null) {
            this.text.setText(path);
            this.fileListChanger.fireAddFile((Widget)this, path);
        }
    }

    public void removePath() {
        String path = this.text.getText();
        if (!path.equals("")) {
            this.fileListChanger.fireRemoveFile((Widget)this, path);
            this.text.setText("");
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void setFile(File file) {
        if (file != null) {
            this.text.setText(file.getAbsolutePath());
        } else {
            this.text.setText("");
        }
    }

    public File getFile() {
        File file = null;
        if (!this.text.getText().equals("")) {
            file = new File(this.text.getText());
        }
        return file;
    }

    public String getAbsoluteFilePath() {
        if (this.getFile() == null) {
            return "";
        }
        return this.getFile().getAbsolutePath();
    }

    public void setFilePath(String path) {
        if (path == null || path.equals("")) {
            this.setFile(null);
        } else {
            this.setFile(new File(path));
        }
    }

    private boolean isAllowFile(String path) {
        if (this.filterExtensions == null) {
            return true;
        }
        if (this.filterExtensions != null) {
            new File(path);
            int i = 0;
            while (i < this.filterExtensions.length) {
                WildCard wildCard = new WildCard(this.filterExtensions[i]);
                if (wildCard.match(path)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] alowExtensions) {
        this.filterExtensions = alowExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }
}

